/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.saas.codegen.java.Constants;
import org.netbeans.modules.websvc.saas.codegen.java.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.java.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.java.model.WadlSaasBean;
import org.netbeans.modules.websvc.saas.codegen.java.support.AbstractTask;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.netbeans.modules.websvc.saas.model.wadl.Application;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaasAuthenticationGenerator {
    private SaasBean bean = null;
    private String loginArgs;
    private FileObject serviceFolder;
    private Object saasAuthFile;
    private JavaSource saasAuthJS;
    private List<ParameterInfo> authMethodParams;
    private JavaSource loginJS;
    private FileObject loginFile;
    private JavaSource callbackJS;
    private FileObject callbackFile;
    private Project project;

    public SaasAuthenticationGenerator(SaasBean saasBean, Project project) throws IOException {
        this.bean = saasBean;
        this.project = project;
    }

    public SaasBean getBean() {
        return this.bean;
    }

    public Project getProject() {
        return this.project;
    }

    public String getLoginArguments() {
        return this.loginArgs;
    }

    public void setLoginArguments(String string) {
        this.loginArgs = string;
    }

    public List<ParameterInfo> getAuthenticatorMethodParameters() {
        return this.authMethodParams;
    }

    public void setAuthenticatorMethodParameters(List<ParameterInfo> list) {
        this.authMethodParams = list;
    }

    public FileObject getSaasServiceFolder() throws IOException {
        return this.serviceFolder;
    }

    public void setSaasServiceFolder(FileObject fileObject) throws IOException {
        this.serviceFolder = fileObject;
    }

    public Constants.SaasAuthenticationType getAuthenticationType() throws IOException {
        return this.getBean().getAuthenticationType();
    }

    public String getPreAuthenticationCode() {
        String string = "";
        Constants.SaasAuthenticationType saasAuthenticationType = this.getBean().getAuthenticationType();
        if (saasAuthenticationType == Constants.SaasAuthenticationType.API_KEY) {
            string = string + "        String apiKey = " + this.getBean().getAuthenticatorClassName() + ".getApiKey();";
        } else if (saasAuthenticationType == Constants.SaasAuthenticationType.SESSION_KEY) {
            SaasBean.SessionKeyAuthentication sessionKeyAuthentication = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
            string = string + "        " + this.getBean().getAuthenticatorClassName() + ".login(" + this.getLoginArguments() + ");\n";
            List<ParameterInfo> list = sessionKeyAuthentication.getParameters();
            String string2 = "";
            if (list != null && list.size() > 0) {
                string2 = Util.getSignParamDeclaration(this.getBean(), list, Collections.<ParameterInfo>emptyList());
            }
            String string3 = sessionKeyAuthentication.getSigKeyName();
            string2 = string2 + "        String " + Util.getVariableName(string3) + " = " + this.getBean().getAuthenticatorClassName() + ".sign(\n";
            string2 = string2 + "                new String[][] {\n";
            for (ParameterInfo parameterInfo : this.getBean().getInputParameters()) {
                if (parameterInfo.getName().equals(string3)) continue;
                string2 = string2 + "                    {\"" + parameterInfo.getName() + "\", " + Util.getVariableName(parameterInfo.getName()) + "},\n";
            }
            string2 = string2 + "        });\n";
            string = string + string2;
        } else if (saasAuthenticationType == Constants.SaasAuthenticationType.HTTP_BASIC) {
            SaasBean.HttpBasicAuthentication httpBasicAuthentication = (SaasBean.HttpBasicAuthentication)this.getBean().getAuthentication();
            string = string + "        " + this.getBean().getAuthenticatorClassName() + ".login(" + this.getLoginArguments() + ");\n";
        }
        return string;
    }

    public String getPostAuthenticationCode() {
        SaasBean.SignedUrlAuthentication signedUrlAuthentication;
        List<ParameterInfo> list;
        String string = "";
        Constants.SaasAuthenticationType saasAuthenticationType = this.getBean().getAuthenticationType();
        if (saasAuthenticationType == Constants.SaasAuthenticationType.SIGNED_URL && (list = (signedUrlAuthentication = (SaasBean.SignedUrlAuthentication)this.getBean().getAuthentication()).getParameters()) != null && list.size() > 0) {
            String string2 = Util.getSignParamDeclaration(this.getBean(), list, this.getBean().getInputParameters());
            string2 = string2 + "        String " + Util.getVariableName(signedUrlAuthentication.getSigKeyName()) + " = " + this.getBean().getAuthenticatorClassName() + ".sign(\n";
            string2 = string2 + "                new String[][] {\n";
            for (ParameterInfo parameterInfo : list) {
                string2 = string2 + "                    {\"" + parameterInfo.getName() + "\", " + Util.getVariableName(parameterInfo.getName()) + "},\n";
            }
            string2 = string2 + "        });\n";
            string = string + string2;
        }
        return string;
    }

    public void createAuthenticatorClass() throws IOException {
        Object object2;
        Object object3;
        FileObject fileObject;
        block25: {
            block24: {
                fileObject = this.getSaasServiceFolder();
                if (this.getBean().isUseTemplates()) break block24;
                if (this.saasAuthFile != null) break block25;
                object3 = this.getBean().getAuthenticatorClassName();
                object2 = null;
                Constants.SaasAuthenticationType object4 = this.getBean().getAuthenticationType();
                if (object4 == Constants.SaasAuthenticationType.API_KEY) {
                    object2 = "Templates/SaaSServices/" + this.getAuthenticationType().getClassIdentifier();
                } else if (object4 == Constants.SaasAuthenticationType.HTTP_BASIC) {
                    object2 = "Templates/SaaSServices/" + this.getAuthenticationType().getClassIdentifier();
                } else if (object4 == Constants.SaasAuthenticationType.SIGNED_URL) {
                    object2 = "Templates/SaaSServices/" + this.getAuthenticationType().getClassIdentifier();
                } else if (object4 == Constants.SaasAuthenticationType.SESSION_KEY) {
                    object2 = "Templates/SaaSServices/" + this.getAuthenticationType().getClassIdentifier();
                }
                if (object2 == null) break block25;
                this.saasAuthJS = JavaSourceHelper.createJavaSource((String)object2 + "Authenticator" + "." + "java", fileObject, this.getBean().getSaasServicePackageName(), (String)object3);
                HashSet exception = new HashSet(this.saasAuthJS.getFileObjects());
                if (exception == null || exception.size() <= 0) break block25;
                this.saasAuthFile = exception.iterator().next();
                break block25;
            }
            object3 = null;
            if (this.bean.getAuthentication() instanceof SaasBean.SessionKeyAuthentication) {
                object2 = (SaasBean.SessionKeyAuthentication)this.bean.getAuthentication();
                object3 = ((SaasBean.SessionKeyAuthentication)object2).getUseTemplates();
            } else if (this.bean.getAuthentication() instanceof SaasBean.HttpBasicAuthentication) {
                object2 = (SaasBean.HttpBasicAuthentication)this.bean.getAuthentication();
                object3 = ((SaasBean.HttpBasicAuthentication)object2).getUseTemplates();
            }
            if (object3 != null) {
                for (SaasBean.SaasAuthentication.UseTemplates.Template template : ((SaasBean.SaasAuthentication.UseTemplates)object3).getTemplates()) {
                    FileObject fileObject2;
                    String string = template.getId();
                    String string2 = template.getType();
                    String string3 = template.getUrl();
                    String string4 = null;
                    if (!string2.equals("auth")) continue;
                    string4 = this.getBean().getAuthenticatorClassName();
                    if (string3.endsWith(".java")) {
                        JavaSourceHelper.createJavaSource(string3, fileObject, this.getBean().getSaasServicePackageName(), string4);
                        continue;
                    }
                    if (string3.indexOf("/") != -1) {
                        string4 = this.getBean().getSaasName() + string3.substring(string3.lastIndexOf("/") + 1);
                    }
                    if (string4 == null || (fileObject2 = fileObject.getFileObject(string4)) != null) continue;
                    Util.createDataObjectFromTemplate(string3, fileObject, string4);
                }
            }
        }
        if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.PLAIN) {
            object3 = this.getBean().getAuthenticatorClassName().toLowerCase();
            object2 = null;
            String string = this.getBean().getAuthenticationProfile();
            if (string != null && !string.trim().equals("")) {
                try {
                    object2 = Util.createDataObjectFromTemplate(string, fileObject, (String)object3);
                }
                catch (Exception exception) {
                    throw new IOException("Profile file specified in saas-services/service-metadata/authentication/@profile, not found: " + string);
                }
            }
            try {
                object2 = Util.createDataObjectFromTemplate("SaaSServices/" + this.getBean().getGroupName() + "/" + this.getBean().getDisplayName() + "/profile.properties", fileObject, (String)object3);
            }
            catch (Exception exception) {
                try {
                    object2 = Util.createDataObjectFromTemplate("SaaSServices/" + this.getBean().getGroupName() + "/profile.properties", fileObject, (String)object3);
                }
                catch (Exception exception2) {
                    try {
                        object2 = Util.createDataObjectFromTemplate("Templates/SaaSServices/" + this.getBean().getAuthenticationType().value() + ".properties", fileObject, (String)object3);
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void createAuthorizationClasses() throws IOException {
        if (this.getBean().isDropTargetWeb()) {
            List<ParameterInfo> list = this.getAuthenticatorMethodParameters();
            String[] stringArray = Util.getGetParamNames(list);
            Object[] objectArray = Util.getGetParamTypes(list);
            Util.createSessionKeyAuthorizationClassesForWeb(this.getBean(), this.getProject(), this.getBean().getSaasName(), this.getBean().getSaasServicePackageName(), this.getSaasServiceFolder(), this.loginJS, this.loginFile, this.callbackJS, this.callbackFile, stringArray, objectArray, this.getBean().isUseTemplates());
        }
    }

    protected void modifyAuthenticationClass() throws IOException {
        if (this.bean.getAuthenticationType() != Constants.SaasAuthenticationType.SESSION_KEY) {
            return;
        }
        Modifier[] modifierArray = Constants.PUBLIC_STATIC;
        Object[] objectArray = null;
        SaasBean.SessionKeyAuthentication sessionKeyAuthentication = (SaasBean.SessionKeyAuthentication)this.bean.getAuthentication();
        if (sessionKeyAuthentication.getUseGenerator() != null) {
            Modifier[] modifierArray2;
            String[] stringArray;
            Object object;
            SaasBean.SaasAuthentication.UseGenerator useGenerator = sessionKeyAuthentication.getUseGenerator();
            String string = "getSessionKey";
            String string2 = "";
            String string3 = "";
            String string4 = null;
            if (sessionKeyAuthentication.getSessionKeyName() != null) {
                object = Util.getParameterName(sessionKeyAuthentication.getSessionKeyName(), true, true);
                stringArray = new ArrayList();
                stringArray.add(new ParameterInfo((String)object, String.class));
                modifierArray2 = Constants.PRIVATE_STATIC;
                Util.addInputParamFields(this.saasAuthJS, (List<ParameterInfo>)stringArray, modifierArray2);
                string = Util.getSessionKeyMethodName((String)object);
                string2 = string + "\n";
                string4 = "String";
                string3 = "return " + (String)object + ";\n";
                if (string3 != null) {
                    this.modifyAuthenticationClass(string2, modifierArray, string4, string, null, null, objectArray, string3);
                }
            }
            string4 = "void";
            string = "login";
            string2 = string + "\n";
            object = this.getAuthenticatorMethodParameters();
            stringArray = Util.getGetParamNames((List<ParameterInfo>)object);
            modifierArray2 = Util.getGetParamTypes((List<ParameterInfo>)object);
            string3 = this.getLoginBody(this.getBean(), this.getBean().getDisplayName(), "queryParams");
            if (string3 != null) {
                this.modifyAuthenticationClass(string2, modifierArray, string4, string, stringArray, (Object[])modifierArray2, objectArray, string3);
            }
            string = Util.getTokenMethodName(useGenerator);
            string2 = string + "\n";
            string4 = "String";
            string3 = this.getTokenBody(this.getBean(), this.getBean().getDisplayName(), "queryParams", this.getBean().getSaasServicePackageName());
            if (string3 != null) {
                this.modifyAuthenticationClass(string2, modifierArray, string4, string, stringArray, (Object[])modifierArray2, objectArray, string3);
            }
            string = "logout";
            string2 = string + "\n";
            string4 = "void";
            string3 = this.getLogoutBody();
            if (string3 != null) {
                this.modifyAuthenticationClass(string2, modifierArray, string4, string, stringArray, (Object[])modifierArray2, objectArray, string3);
            }
        }
    }

    protected void modifyAuthenticationClass(final String string, final Modifier[] modifierArray, final Object object, final String string2, final String[] stringArray, final Object[] objectArray, final Object[] objectArray2, final String string3) throws IOException {
        if (JavaSourceHelper.isContainsMethod(this.saasAuthJS, string2, stringArray, objectArray)) {
            return;
        }
        ModificationResult modificationResult = this.saasAuthJS.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                ClassTree classTree2 = JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, string2, object, stringArray, objectArray, null, null, objectArray2, "{ \n" + string3 + "\n }", string);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        });
        modificationResult.commit();
    }

    protected String getLoginBody(SaasBean saasBean, String string, String string2) throws IOException {
        SaasBean.SaasAuthentication.UseGenerator.Login login;
        if (this.getBean().isDropTargetWeb()) {
            if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.SESSION_KEY) {
                return null;
            }
            return Util.createSessionKeyLoginBodyForWeb(saasBean, string, string2);
        }
        String string3 = "";
        SaasBean.SessionKeyAuthentication sessionKeyAuthentication = (SaasBean.SessionKeyAuthentication)saasBean.getAuthentication();
        SaasBean.SaasAuthentication.UseGenerator useGenerator = sessionKeyAuthentication.getUseGenerator();
        if (useGenerator != null && (login = useGenerator.getLogin()) != null) {
            String string4 = Util.getTokenName(useGenerator);
            String string5 = Util.getTokenMethodName(useGenerator);
            string3 = string3 + "        if (" + Util.getVariableName(sessionKeyAuthentication.getSessionKeyName()) + " == null) {\n";
            string3 = string3 + "            String " + string4 + " = " + string5 + "(" + Util.getHeaderOrParameterUsage(this.getAuthenticatorMethodParameters()) + ");\n\n";
            string3 = string3 + "            if (" + string4 + " != null) {\n";
            string3 = string3 + "                try {\n";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            string3 = string3 + Util.getLoginBody(login, this.getBean(), string, hashMap);
            string3 = string3 + "                } catch (IOException ex) {\n";
            string3 = string3 + "                    Logger.getLogger(" + this.getBean().getAuthenticatorClassName() + ".class.getName()).log(Level.SEVERE, null, ex);\n";
            string3 = string3 + "                }\n\n";
            string3 = string3 + "            }\n";
            string3 = string3 + "        }\n";
        }
        return string3;
    }

    protected String getLogoutBody() {
        String string = "";
        return string;
    }

    /*
     * WARNING - void declaration
     */
    protected String getTokenBody(SaasBean saasBean, String string, String string2, String string3) throws IOException {
        SaasBean.SaasAuthentication.UseGenerator.Token token;
        if (this.getBean().isDropTargetWeb()) {
            if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.SESSION_KEY) {
                return null;
            }
            return Util.createSessionKeyTokenBodyForWeb(saasBean, string, string2, string3);
        }
        String string4 = this.getBean().getAuthorizationFrameClassName();
        String string5 = "";
        SaasBean.SessionKeyAuthentication sessionKeyAuthentication = (SaasBean.SessionKeyAuthentication)saasBean.getAuthentication();
        SaasBean.SaasAuthentication.UseGenerator useGenerator = sessionKeyAuthentication.getUseGenerator();
        if (useGenerator != null && (token = useGenerator.getToken()) != null) {
            Object object2;
            String string6;
            String string7;
            String string8 = Util.getTokenName(useGenerator);
            String string9 = "sig";
            if (token.getSignId() != null) {
                string9 = token.getSignId();
            }
            String string10 = null;
            SaasBean.SaasAuthentication.UseGenerator.Method method = token.getMethod();
            if (method != null) {
                string10 = method.getHref();
                if (string10 == null) {
                    return string5;
                }
                string10 = string10.startsWith("#") ? string10.substring(1) : string10;
            }
            string5 = string5 + "       String " + string8 + " = null;\n";
            string5 = string5 + "       try {\n";
            string5 = string5 + "            String method = \"" + string10 + "\";\n";
            string5 = string5 + "            String v = \"1.0\";\n\n";
            List<ParameterInfo> list = token.getParameters();
            if (list != null && list.size() > 0) {
                string7 = "";
                string7 = string7 + "        String " + string9 + " = sign(secret, \n";
                string7 = string7 + this.getSignParamUsage(list, string);
                string7 = string7 + ");\n\n";
                string5 = string5 + string7;
            }
            string7 = "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (method != null) {
                ArrayList<ParameterInfo> arrayList;
                Method method2;
                string6 = method.getId();
                if (string6 != null) {
                    object2 = string6.split(",");
                    for (String string11 : object2) {
                        String[] stringArray = string11.split("=");
                        if (stringArray.length != 2) continue;
                        hashMap.put(stringArray[0], stringArray[1]);
                    }
                }
                if ((object2 = method.getHref()) != null && saasBean instanceof WadlSaasBean && (method2 = SaasUtil.wadlMethodFromIdRef((Application)((WadlSaasBean)saasBean).getMethod().getSaas().getWadlModel(), (String)object2)) != null && (arrayList = ((WadlSaasBean)saasBean).findWadlParams(method2)) != null && arrayList.size() > 0) {
                    string7 = Util.getHeaderOrParameterDefinition(arrayList, string2, false);
                }
            }
            string5 = string5 + "        " + string7;
            string6 = "";
            if (saasBean instanceof WadlSaasBean) {
                string6 = ((WadlSaasBean)saasBean).getUrl();
            }
            string5 = string5 + "             RestConnection conn = new RestConnection(\"" + string6 + "\"";
            if (!string7.trim().equals("")) {
                string5 = string5 + ", " + string2;
            }
            string5 = string5 + ");\n";
            string5 = string5 + "            String result = conn.get();\n";
            for (Map.Entry entry : hashMap.entrySet()) {
                String string12 = Util.getVariableName((String)entry.getKey());
                String string13 = (String)entry.getValue();
                if (string13.startsWith("{")) {
                    string13 = string13.substring(1);
                }
                if (string13.endsWith("}")) {
                    string13 = string13.substring(0, string13.length() - 1);
                }
                string5 = string5 + "            " + string12 + " = result.substring(result.indexOf(\"<" + string13 + "\"),\n";
                string5 = string5 + "                            result.indexOf(\"</" + string13 + ">\"));\n\n";
                string5 = string5 + "            " + string12 + " = " + string12 + ".substring(" + string12 + ".indexOf(\">\") + 1);\n\n";
            }
            if (token.getPrompt() != null) {
                object2 = token.getPrompt();
                list = ((SaasBean.SaasAuthentication.UseGenerator.Token.Prompt)object2).getParameters();
                if (list != null && list.size() > 0) {
                    void var19_27;
                    string5 = string5 + "            String perms = \"write\";";
                    String string16 = "";
                    string16 = string16 + "        " + string9 + " = sign(\n";
                    string16 = string16 + "                new String[][] {\n";
                    for (ParameterInfo parameterInfo : list) {
                        String string17 = (String)var19_27 + "                    {\"" + parameterInfo.getName() + "\", " + Util.getParameterName(parameterInfo, true, true) + "},\n";
                    }
                    String string18 = (String)var19_27 + "        });\n\n";
                    string5 = string5 + string18;
                }
                string6 = ((SaasBean.SaasAuthentication.UseGenerator.Token.Prompt)object2).getDesktopUrl();
                string5 = string5 + "            String loginUrl = \"" + Util.getTokenPromptUrl(token, string6) + "\";\n";
            }
            string5 = string5 + "            " + string4 + " frame = new " + string4 + "(loginUrl);\n";
            string5 = string5 + "            synchronized (frame) {\n";
            string5 = string5 + "                try {\n";
            string5 = string5 + "                    frame.wait();\n";
            string5 = string5 + "                } catch (InterruptedException ex) {\n";
            string5 = string5 + "                    Logger.getLogger(" + this.getBean().getAuthenticatorClassName() + ".class.getName()).log(Level.SEVERE, null, ex);\n";
            string5 = string5 + "                }\n";
            string5 = string5 + "            }\n";
            string5 = string5 + "       } catch (IOException ex) {\n";
            string5 = string5 + "            Logger.getLogger(" + this.getBean().getAuthenticatorClassName() + ".class.getName()).log(Level.SEVERE, null, ex);\n";
            string5 = string5 + "       }\n\n";
            string5 = string5 + "       return " + string8 + ";\n";
        }
        return string5;
    }

    private String getSignParamUsage(List<ParameterInfo> list, String string) {
        return Util.getSignParamUsage(list, string, this.getBean().isDropTargetWeb());
    }
}

