/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.saas.codegen.java.AbstractGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.Constants;
import org.netbeans.modules.websvc.saas.codegen.java.GenericResourceGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.XmlOutputWrapperGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.java.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.java.support.AbstractTask;
import org.netbeans.modules.websvc.saas.codegen.java.support.Inflector;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.SourceGroupSupport;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SaasCodeGenerator
extends AbstractGenerator {
    private FileObject targetFile;
    private FileObject destDir;
    private FileObject wrapperResourceFile;
    private Project project;
    protected SaasBean bean;
    private JavaSource wrapperResourceJS;
    private JavaSource targetResourceJS;
    private JavaSource jaxbOutputWrapperJS;
    private String subresourceLocatorName;
    private String subresourceLocatorUriTemplate;
    private Collection<String> existingUriTemplates = Collections.emptyList();
    private JTextComponent targetComponent;

    public SaasCodeGenerator(JTextComponent jTextComponent, FileObject fileObject, SaasBean saasBean) {
        this.targetComponent = jTextComponent;
        this.targetFile = fileObject;
        this.destDir = fileObject.getParent();
        this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (this.project == null) {
            throw new IllegalArgumentException(fileObject.getPath() + " is not part of a project.");
        }
        this.targetResourceJS = JavaSource.forFileObject((FileObject)fileObject);
        String string = JavaSourceHelper.getPackageName(this.targetResourceJS);
        this.bean = saasBean;
        this.getBean().setPackageName(string);
        this.getBean().setPrivateFieldForQueryParam(true);
        this.wrapperResourceFile = SourceGroupSupport.findJavaSourceFile(this.project, this.getBean().getName());
    }

    protected JTextComponent getTargetComponent() {
        return this.targetComponent;
    }

    protected FileObject getTargetFile() {
        return this.targetFile;
    }

    protected FileObject getTargetFolder() {
        return this.destDir;
    }

    protected FileObject getWrapperResourceFile() {
        return this.wrapperResourceFile;
    }

    protected void setWrapperResourceFile(FileObject fileObject) {
        this.wrapperResourceFile = fileObject;
    }

    protected JavaSource getTargetSource() {
        return this.targetResourceJS;
    }

    protected JavaSource getWrapperResourceSource() {
        return this.wrapperResourceJS;
    }

    protected void setWrapperResourceSource(JavaSource javaSource) {
        this.wrapperResourceJS = javaSource;
    }

    protected JavaSource getJaxbOutputWrapperSource() {
        return this.jaxbOutputWrapperJS;
    }

    protected void setJaxbOutputWrapperSource(JavaSource javaSource) {
        this.jaxbOutputWrapperJS = javaSource;
    }

    protected Project getProject() {
        return this.project;
    }

    protected void preGenerate() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String string, File file) throws IOException {
        String string2 = string;
        if (!file.exists()) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                inputStream = this.getClass().getResourceAsStream(string2);
                outputStream = new FileOutputStream(file);
                while ((n = inputStream.read()) != -1) {
                    outputStream.write(n);
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    protected abstract String getCustomMethodBody() throws IOException;

    public SaasBean getBean() {
        return this.bean;
    }

    public boolean canShowResourceInfo() {
        return true;
    }

    public boolean canShowParam() {
        return this.wrapperResourceFile == null;
    }

    @Override
    public Set<FileObject> generate(ProgressHandle progressHandle) throws IOException {
        this.initProgressReporting(progressHandle);
        this.preGenerate();
        FileObject fileObject = this.generateJaxbOutputWrapper();
        if (fileObject != null) {
            this.jaxbOutputWrapperJS = JavaSource.forFileObject((FileObject)fileObject);
        }
        this.generateSaasServiceResourceClass();
        this.addSubresourceLocator();
        FileObject fileObject2 = (FileObject)this.getOrCreateGenericRefConverter().getFileObjects().iterator().next();
        this.modifyTargetConverter();
        FileObject[] fileObjectArray = new FileObject[]{this.targetFile, this.wrapperResourceFile, fileObject2, fileObject};
        if (fileObject == null) {
            fileObjectArray = new FileObject[]{this.targetFile, this.wrapperResourceFile, fileObject2};
        }
        JavaSourceHelper.saveSource(fileObjectArray);
        this.finishProgressReporting();
        return new HashSet<FileObject>(Arrays.asList(fileObjectArray));
    }

    protected FileObject generateJaxbOutputWrapper() throws IOException {
        Constants.MimeType mimeType = this.getBean().getMimeTypes()[0];
        if (mimeType == Constants.MimeType.JSON || mimeType == Constants.MimeType.XML) {
            FileObject fileObject = this.getConverterFolder();
            String string = SourceGroupSupport.packageForFolder(fileObject);
            this.getBean().setOutputWrapperPackageName(string);
            String[] stringArray = this.getBean().getOutputTypes();
            XmlOutputWrapperGenerator xmlOutputWrapperGenerator = new XmlOutputWrapperGenerator(fileObject, this.getBean().getOutputWrapperName(), string, stringArray);
            return xmlOutputWrapperGenerator.generate();
        }
        return null;
    }

    protected void generateSaasServiceResourceClass() throws IOException {
        if (this.wrapperResourceFile == null) {
            GenericResourceGenerator genericResourceGenerator = new GenericResourceGenerator(this.destDir, this.bean);
            genericResourceGenerator.setTemplate(this.getBean().getResourceClassTemplate());
            Set<FileObject> set = genericResourceGenerator.generate(this.getProgressHandle());
            if (set == null || set.size() == 0) {
                return;
            }
            this.wrapperResourceFile = set.iterator().next();
            this.wrapperResourceJS = JavaSource.forFileObject((FileObject)this.wrapperResourceFile);
            this.addImportsToWrapperResource();
            this.addSupportingMethods();
            this.modifyHttpMethod();
        } else {
            this.wrapperResourceJS = JavaSource.forFileObject((FileObject)this.wrapperResourceFile);
        }
    }

    protected void addImportsToWrapperResource() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("org.netbeans.saas.RestConnection");
        Util.addImportsToSource(this.wrapperResourceJS, arrayList);
    }

    protected void addSubresourceLocator() throws IOException {
        ModificationResult modificationResult = this.targetResourceJS.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                JavaSourceHelper.addImports(workingCopy, SaasCodeGenerator.this.getSubresourceLocatorImports());
                ClassTree classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                String[] stringArray = new String[]{"Path"};
                Object[] objectArray = new Object[]{SaasCodeGenerator.this.getSubresourceLocatorUriTemplate()};
                boolean bl = false;
                if (SaasCodeGenerator.this.hasGetEntityMethod(JavaSourceHelper.getTopLevelClassElement((CompilationController)workingCopy))) {
                    bl = true;
                }
                String string = "{";
                if (bl) {
                    string = string + "try {";
                }
                string = string + SaasCodeGenerator.this.getParamInitStatements(workingCopy);
                string = string + "return new $CLASS$($ARGS$);}";
                string = string.replace("$CLASS$", JavaSourceHelper.getClassName(SaasCodeGenerator.this.wrapperResourceJS));
                string = string.replace("$ARGS$", SaasCodeGenerator.this.getParamList());
                String string2 = "Returns " + SaasCodeGenerator.this.getBean().getName() + " sub-resource.\n";
                if (bl) {
                    string = string + "finally { PersistenceService.getInstance().close()";
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                JavaSourceHelper.getAvailableMethodSignature(SaasCodeGenerator.this.targetResourceJS, hashMap);
                String string3 = JavaSourceHelper.createMethodSignature(SaasCodeGenerator.this.getSubresourceLocatorName(), null);
                if (hashMap.containsKey(string3)) {
                    return;
                }
                ClassTree classTree2 = JavaSourceHelper.addMethod(workingCopy, classTree, Constants.PUBLIC, stringArray, objectArray, SaasCodeGenerator.this.getSubresourceLocatorName(), SaasCodeGenerator.this.getBean().getQualifiedClassName(), null, null, null, null, string, string2);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        });
        modificationResult.commit();
    }

    protected void addSupportingMethods() throws IOException {
    }

    protected void modifyHttpMethod() throws IOException {
        ModificationResult modificationResult = this.wrapperResourceJS.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                String string = SaasCodeGenerator.this.getConverterType();
                if (string != null) {
                    JavaSourceHelper.addImports(workingCopy, new String[]{SaasCodeGenerator.this.getConverterType()});
                }
                String string2 = "{" + SaasCodeGenerator.this.getOverridingStatements();
                string2 = string2 + SaasCodeGenerator.this.getCustomMethodBody();
                string2 = string2 + "}";
                for (Constants.MimeType mimeType : SaasCodeGenerator.this.getBean().getMimeTypes()) {
                    SaasCodeGenerator.this.getBean();
                    MethodTree methodTree = JavaSourceHelper.getMethodByName((CompilationController)workingCopy, SaasBean.getHttpMethodName(SaasCodeGenerator.this.getBean().getHttpMethod(), mimeType));
                    JavaSourceHelper.replaceMethodBody(workingCopy, methodTree, string2);
                }
            }
        });
        modificationResult.commit();
    }

    protected String getOverridingStatements() {
        String string = "";
        List<ParameterInfo> list = Util.filterParametersByAuth(this.getBean().getAuthenticationType(), this.getBean().getAuthentication(), this.getBean().getQueryParameters());
        for (ParameterInfo parameterInfo : list) {
            if (parameterInfo.isApiKey() || parameterInfo.isSessionKey() || parameterInfo.isFixed()) continue;
            String string2 = this.getParameterName(parameterInfo, true, true, true);
            string = string + "if (this." + string2 + " != null) {" + string2 + " = this." + string2 + ";" + "}\n";
        }
        return string;
    }

    protected JavaSource getOrCreateGenericRefConverter() {
        FileObject fileObject = this.getConverterFolder();
        String string = SourceGroupSupport.packageForFolder(fileObject);
        FileObject fileObject2 = fileObject.getFileObject("GenericRefConverter", "java");
        if (fileObject2 == null) {
            JavaSource javaSource = JavaSourceHelper.createJavaSource("Templates/SaaSServices/RefConverter.java", fileObject, string, "GenericRefConverter");
            return javaSource;
        }
        return JavaSource.forFileObject((FileObject)fileObject2);
    }

    protected String getConverterType() throws IOException {
        if (this.jaxbOutputWrapperJS != null) {
            return JavaSourceHelper.getClassType(this.jaxbOutputWrapperJS);
        }
        return null;
    }

    protected String getConverterName() throws IOException {
        String string = this.getConverterType();
        if (string == null) {
            return null;
        }
        return string.substring(string.lastIndexOf(46) + 1);
    }

    private String getParamInitStatements(WorkingCopy workingCopy) {
        String string = "// TODO: Assign a value to one of the following variables if you want to \n// override the corresponding default value or value from the query \n// parameter in the subresource class.\n";
        String string2 = "";
        boolean bl = false;
        for (ParameterInfo parameterInfo : this.bean.filterParametersByAuth(this.bean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}))) {
            String string3 = "null";
            String string4 = this.match(JavaSourceHelper.getTopLevelClassElement((CompilationController)workingCopy), this.getParameterName(parameterInfo, true, true, true));
            if (string4 != null) {
                string3 = string4;
                bl = true;
            }
            string2 = string2 + parameterInfo.getSimpleTypeName() + " " + this.getParameterName(parameterInfo, true, true, true) + " = " + string3 + ";";
        }
        Object object = "";
        if (bl) {
            object = this.getEntityType(JavaSourceHelper.getTopLevelClassElement((CompilationController)workingCopy)) + " entity = getEntity()";
        }
        return string + (String)object + string2;
    }

    private String getParamList() {
        List<ParameterInfo> list = this.bean.filterParametersByAuth(this.bean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            ParameterInfo parameterInfo = list.get(i);
            string = i == 0 ? string + this.getParameterName(parameterInfo, true, true, true) : string + ", " + this.getParameterName(parameterInfo, true, true, true);
        }
        return string;
    }

    private String getOutputWrapperQualifiedName() throws IOException {
        return JavaSourceHelper.getClassType(this.jaxbOutputWrapperJS);
    }

    private boolean hasGetEntityMethod(TypeElement typeElement) {
        List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        for (ExecutableElement executableElement : list) {
            if (!executableElement.getSimpleName().contentEquals("getEntity")) continue;
            return true;
        }
        return false;
    }

    private String getUriParam(TypeElement typeElement) {
        List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        boolean bl = false;
        String string = null;
        for (ExecutableElement executableElement : list) {
            if (bl && string != null) {
                return string;
            }
            if (executableElement.getSimpleName().contentEquals("getEntity")) {
                bl = true;
            }
            for (VariableElement variableElement : executableElement.getParameters()) {
                List<? extends AnnotationMirror> list2 = variableElement.getAnnotationMirrors();
                for (AnnotationMirror annotationMirror : list2) {
                    if (!JavaSourceHelper.isOfAnnotationType(annotationMirror, "PathParam")) continue;
                    Collection<? extends AnnotationValue> collection = annotationMirror.getElementValues().values();
                    for (AnnotationValue annotationValue : collection) {
                        String string2;
                        if (!(annotationValue.getValue() instanceof String)) continue;
                        string = string2 = (String)annotationValue.getValue();
                    }
                }
            }
        }
        return null;
    }

    private String getEntityType(TypeElement typeElement) {
        List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        for (ExecutableElement executableElement : list) {
            if (!executableElement.getSimpleName().contentEquals("getEntity")) continue;
            return ((Object)executableElement.getReturnType()).toString();
        }
        return null;
    }

    public String getSubresourceLocatorName() {
        if (this.subresourceLocatorName == null) {
            String string = this.getSubresourceLocatorUriTemplate();
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            this.subresourceLocatorName = "get" + Inflector.getInstance().camelize(string);
        }
        return this.subresourceLocatorName;
    }

    public void setSubresourceLocatorName(String string) {
        this.subresourceLocatorName = string;
    }

    public String getSubresourceLocatorUriTemplate() {
        if (this.subresourceLocatorUriTemplate == null) {
            this.subresourceLocatorUriTemplate = this.getAvailableUriTemplate();
        }
        if (!this.subresourceLocatorUriTemplate.endsWith("/")) {
            this.subresourceLocatorUriTemplate = this.subresourceLocatorUriTemplate + "/";
        }
        return this.subresourceLocatorUriTemplate;
    }

    public void setSubresourceLocatorUriTemplate(String string) {
        this.subresourceLocatorUriTemplate = string;
    }

    public String match(TypeElement typeElement, String string) {
        String string2 = string.toLowerCase();
        List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        for (ExecutableElement executableElement : list) {
            TypeMirror typeMirror;
            if (!"getEntity".equals(executableElement.getSimpleName().toString()) || (typeMirror = executableElement.getReturnType()).getKind() != TypeKind.DECLARED) continue;
            Element element = ((DeclaredType)typeMirror).asElement();
            List<ExecutableElement> list2 = ElementFilter.methodsIn(element.getEnclosedElements());
            for (ExecutableElement executableElement2 : list2) {
                String string3 = executableElement2.getSimpleName().toString().toLowerCase();
                if (!string3.startsWith("get") || !this.match(string3.substring(3), string2)) continue;
                return "entity." + executableElement2.getSimpleName().toString() + "()";
            }
        }
        return null;
    }

    private boolean match(String string, String string2) {
        String string3 = string.toLowerCase();
        return string3.indexOf(string2) > -1 || string2.indexOf(string3) > -1;
    }

    protected void modifyTargetConverter() throws IOException {
        TypeElement typeElement = JavaSourceHelper.getTypeElement(this.targetResourceJS);
        TypeElement typeElement2 = JavaSourceHelper.getXmlRepresentationClass(typeElement, "Converter");
        if (typeElement2 != null) {
            JavaSource javaSource = JavaSourceHelper.forTypeElement(typeElement2, this.project);
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    ClassTree classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                    ClassTree classTree2 = SaasCodeGenerator.this.addGetComponentRefMethod(workingCopy, classTree);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            });
            modificationResult.commit();
        }
    }

    private ClassTree addGetComponentRefMethod(WorkingCopy workingCopy, ClassTree classTree) {
        String[] stringArray = new String[]{"XmlElement"};
        String string = this.getSubresourceLocatorUriTemplate();
        String string2 = null;
        string2 = string.endsWith("/") ? string.substring(0, string.length() - 1) + "Ref" : string + "Ref";
        Object[] objectArray = new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "name", string2)};
        String string3 = "{ return new $CLASS$(uri.resolve(\"$URITEMPLATE$\")); }";
        string3 = string3.replace("$CLASS$", "GenericRefConverter");
        string3 = string3.replace("$URITEMPLATE$", string);
        String string4 = "Returns reference to " + this.getBean().getName() + " resource.\n";
        String string5 = this.getSubresourceLocatorName() + "Ref";
        return JavaSourceHelper.addMethod(workingCopy, classTree, Constants.PUBLIC, stringArray, objectArray, string5, "GenericRefConverter", null, null, null, null, string3, string4);
    }

    private FileObject getConverterFolder() {
        FileObject fileObject;
        FileObject fileObject2 = this.destDir;
        if (this.destDir.getParent() != null && (fileObject = this.destDir.getParent().getFileObject("converter")) != null) {
            fileObject2 = fileObject;
        }
        return fileObject2;
    }

    public Collection<String> getExistingUriTemplates() {
        if (this.existingUriTemplates == null) {
            try {
                if (this.targetFile != null && DataObject.find((FileObject)this.targetFile) != null && Util.isJava(DataObject.find((FileObject)this.targetFile))) {
                    this.existingUriTemplates = JavaSourceHelper.getAnnotationValuesForAllMethods(this.targetResourceJS, "javax.ws.rs.Path");
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return this.existingUriTemplates;
    }

    private String getAvailableUriTemplate() {
        String string;
        Collection<String> collection = this.getExistingUriTemplates();
        int n = 1;
        String string2 = string = Inflector.getInstance().camelize(this.getBean().getShortName(), true);
        while (collection.contains(string2) || collection.contains(string2 + "/")) {
            string2 = string + n++;
        }
        return string2;
    }

    private String[] getSubresourceLocatorImports() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ParameterInfo> list = this.getBean().getInputParameters();
        for (ParameterInfo parameterInfo : list) {
            if (parameterInfo.getType().getPackage().getName().equals("java.lang")) continue;
            arrayList.add(parameterInfo.getType().getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected static void insert(String string, JTextComponent jTextComponent, boolean bl) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        if (document == null) {
            return;
        }
        if (string == null) {
            return;
        }
        int n = SaasCodeGenerator.insert(string, jTextComponent, document);
    }

    protected static int insert(String string, JTextComponent jTextComponent, Document document) throws BadLocationException {
        int n = -1;
        try {
            Caret caret = jTextComponent.getCaret();
            int n2 = Math.min(caret.getDot(), caret.getMark());
            int n3 = Math.max(caret.getDot(), caret.getMark());
            document.remove(n2, n3 - n2);
            n = caret.getDot();
            document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n;
    }

    protected boolean isInBlock(JTextComponent jTextComponent) {
        Caret caret = jTextComponent.getCaret();
        int n = Math.min(caret.getDot(), caret.getMark());
        int n2 = Math.max(caret.getDot(), caret.getMark());
        return true;
    }

    public static void createRestConnectionFile(Project project) throws IOException {
        SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(project);
        String string = "org.netbeans.saas";
        FileObject fileObject = SourceGroupSupport.getFolderForPackage(sourceGroupArray[0], string, true);
        JavaSourceHelper.createJavaSource("Templates/SaaSServices/RestConnection.java", fileObject, string, "RestConnection");
        String string2 = "Templates/SaaSServices/RestResponse.java";
        JavaSource javaSource = JavaSourceHelper.createJavaSource(string2, fileObject, string, "RestResponse");
    }

    protected String[] getUriParamTypes() {
        String string = String.class.getName();
        String[] stringArray = new String[this.getBean().getUriParams().length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string;
        }
        return stringArray;
    }

    protected String[] getGetParamNames(List<ParameterInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(this.getParamNames(list)));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected String[] getGetParamTypes(List<ParameterInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(this.getParamTypeNames(list)));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected String[] getParamNames(List<ParameterInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ParameterInfo parameterInfo : list) {
            arrayList.add(this.getParameterName(parameterInfo, true, true, true));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected String[] getParamTypeNames(List<ParameterInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ParameterInfo parameterInfo : list) {
            arrayList.add(parameterInfo.getTypeName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected String getParameterName(ParameterInfo parameterInfo) {
        return Util.getParameterName(parameterInfo);
    }

    protected String getParameterName(ParameterInfo parameterInfo, boolean bl, boolean bl2) {
        return Util.getParameterName(parameterInfo, bl, bl2, false);
    }

    protected String getParameterName(ParameterInfo parameterInfo, boolean bl, boolean bl2, boolean bl3) {
        return Util.getParameterName(parameterInfo, bl, bl2, bl3);
    }

    protected String getVariableName(String string) {
        return Util.getVariableName(string, true, true, true);
    }

    protected String getVariableName(String string, boolean bl, boolean bl2, boolean bl3) {
        return Util.getVariableName(string, bl, bl2, bl3);
    }

    protected Object[] getParamValues(List<ParameterInfo> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ParameterInfo parameterInfo : list) {
            Object object = null;
            if (parameterInfo.getStyle() != ParameterInfo.ParamStyle.QUERY) {
                object = parameterInfo.getDefaultValue();
            }
            arrayList.add(object);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }
}

