/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.saas.codegen.java.Constants;
import org.netbeans.modules.websvc.saas.codegen.java.support.AbstractTask;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.openide.filesystems.FileObject;

public class XmlOutputWrapperGenerator {
    private FileObject destDir;
    private String className;
    private String packageName;
    private String wrapElementName;
    private String[] jaxbOutputClassNames;
    private JavaSource wrapperJS;

    public XmlOutputWrapperGenerator(FileObject fileObject, String string, String string2, String[] stringArray) {
        if (fileObject == null || string == null || stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.destDir = fileObject;
        this.className = string;
        this.packageName = string2;
        this.jaxbOutputClassNames = stringArray;
        this.wrapElementName = Util.lowerFirstChar(string);
        if (this.wrapElementName.endsWith("Converter")) {
            this.wrapElementName = this.wrapElementName.substring(0, this.wrapElementName.lastIndexOf("Converter"));
        }
    }

    public FileObject generate() throws IOException {
        FileObject fileObject = this.destDir.getFileObject(this.className, "java");
        if (fileObject != null) {
            return fileObject;
        }
        this.wrapperJS = JavaSourceHelper.createJavaSource(this.destDir, this.packageName, this.className);
        ModificationResult modificationResult = this.wrapperJS.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                ClassTree classTree;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                JavaSourceHelper.addImports(workingCopy, new String[]{"javax.xml.bind.annotation.XmlElement", "javax.xml.bind.annotation.XmlRootElement"});
                JavaSourceHelper.addClassAnnotation(workingCopy, new String[]{"XmlRootElement"}, new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "name", XmlOutputWrapperGenerator.this.wrapElementName)});
                ClassTree classTree2 = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                for (int i = 0; i < XmlOutputWrapperGenerator.this.jaxbOutputClassNames.length; ++i) {
                    String string = XmlOutputWrapperGenerator.this.jaxbOutputClassNames[i];
                    String string2 = XmlOutputWrapperGenerator.this.getSimpleName(string);
                    string2 = Util.lowerFirstChar(string2);
                    classTree2 = XmlOutputWrapperGenerator.this.addField(workingCopy, classTree2, string2, string);
                    classTree2 = XmlOutputWrapperGenerator.this.addGetMethod(workingCopy, classTree2, string2, string);
                    classTree2 = XmlOutputWrapperGenerator.this.addSetMethod(workingCopy, classTree2, string2, string);
                }
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        });
        modificationResult.commit();
        return (FileObject)this.wrapperJS.getFileObjects().iterator().next();
    }

    private String getSimpleName(String string) {
        String string2 = string;
        int n = string2.lastIndexOf(46);
        if (n > -1) {
            string2 = string2.substring(n + 1, string2.length());
        }
        return string2;
    }

    private ClassTree addField(WorkingCopy workingCopy, ClassTree classTree, String string, String string2) {
        return JavaSourceHelper.addField(workingCopy, classTree, Constants.PRIVATE, null, null, string, string2);
    }

    private ClassTree addGetMethod(WorkingCopy workingCopy, ClassTree classTree, String string, String string2) {
        String[] stringArray = new String[]{"XmlElement"};
        String string3 = "get" + Util.upperFirstChar(string);
        String string4 = "{ return " + string + "; }";
        String string5 = "Get method for wrapped element \n@return an instance of " + string2;
        return JavaSourceHelper.addMethod(workingCopy, classTree, Constants.PUBLIC, stringArray, null, string3, string2, null, null, null, null, string4, string5);
    }

    private ClassTree addSetMethod(WorkingCopy workingCopy, ClassTree classTree, String string, String string2) {
        String string3 = "set" + Util.upperFirstChar(string);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{string2};
        String string4 = "{ this.$FIELD$ = $FIELD$; }".replace("$FIELD$", string);
        String string5 = "Set method for wrapped element of type " + string2;
        return JavaSourceHelper.addMethod(workingCopy, classTree, Constants.PUBLIC, null, null, string3, "void", stringArray, objectArray, null, null, string4, string5);
    }
}

