/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlParameter;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.saas.codegen.java.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.java.support.JaxWsUtils;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.util.LibrariesHelper;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxwsOperationInfo {
    private WsdlSaasMethod method;
    private String categoryName;
    private String serviceName;
    private String portName;
    private String operationName;
    private String wsdlUrl;
    private Project project;
    private WsdlData webServiceData;
    private WsdlService service;
    private WsdlOperation operation;
    private WsdlPort port;
    private List<ParameterInfo> headerParams;

    public JaxwsOperationInfo(WsdlSaasMethod wsdlSaasMethod, Project project) {
        this.method = wsdlSaasMethod;
        this.categoryName = wsdlSaasMethod.getSaas().getParentGroup().getName();
        this.serviceName = wsdlSaasMethod.getSaas().getDefaultServiceName();
        this.project = project;
        this.method.getSaas().toStateReady(true);
        this.webServiceData = this.method.getSaas().getWsdlData();
        this.portName = this.method.getWsdlPort().getName();
        this.operationName = this.method.getWsdlOperation().getName();
        this.wsdlUrl = this.method.getSaas().getUrl();
        this.service = this.method.getSaas().getWsdlModel();
        this.port = this.method.getWsdlPort();
        this.operation = this.method.getWsdlOperation();
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getWsdlURL() {
        return this.wsdlUrl;
    }

    public String getWsdlLocation() {
        this.initWsdlModelInfo();
        return this.webServiceData.getWsdlFile();
    }

    public void initWsdlModelInfo() {
        LibrariesHelper.addDefaultJaxWsClientJars((Project)this.project, null, (WsdlSaas)this.method.getSaas());
    }

    public static WsdlOperation findOperationByName(WsdlPort wsdlPort, String string) {
        for (WsdlOperation wsdlOperation : wsdlPort.getOperations()) {
            if (!string.equals(wsdlOperation.getName())) continue;
            return wsdlOperation;
        }
        return null;
    }

    public WsdlPort getPort() {
        this.initWsdlModelInfo();
        return this.port;
    }

    public WsdlOperation getOperation() {
        this.initWsdlModelInfo();
        return this.operation;
    }

    public WsdlService getService() {
        this.initWsdlModelInfo();
        return this.service;
    }

    public List<WsdlParameter> getOutputParameters() {
        ArrayList<WsdlParameter> arrayList = new ArrayList<WsdlParameter>();
        for (WsdlParameter wsdlParameter : this.getOperation().getParameters()) {
            if (!wsdlParameter.isHolder()) continue;
            arrayList.add(wsdlParameter);
        }
        return arrayList;
    }

    public static String getParamType(WsdlParameter wsdlParameter) {
        if (wsdlParameter.isHolder()) {
            String string = wsdlParameter.getTypeName();
            int n = string.indexOf(60);
            int n2 = string.indexOf(62);
            if (n > 0 || n2 > 0) {
                string = string.substring(n + 1, n2).trim();
            }
            return string;
        }
        return wsdlParameter.getTypeName();
    }

    public String getOutputType() {
        String string = this.getOperation().getReturnTypeName();
        if ("void".equals(string)) {
            for (WsdlParameter wsdlParameter : this.getOperation().getParameters()) {
                if (!wsdlParameter.isHolder()) continue;
                string = JaxwsOperationInfo.getParamType(wsdlParameter);
                break;
            }
        }
        return string;
    }

    public String[] getInputParameterNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WsdlParameter wsdlParameter : this.getOperation().getParameters()) {
            if (wsdlParameter.isHolder()) continue;
            arrayList.add(wsdlParameter.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getInputParameterTypes() {
        ArrayList<Class<Object>> arrayList = new ArrayList<Class<Object>>();
        for (WsdlParameter wsdlParameter : this.getOperation().getParameters()) {
            if (wsdlParameter.isHolder()) continue;
            Class<Object> clazz = null;
            JaxwsOperationInfo jaxwsOperationInfo = this;
            synchronized (jaxwsOperationInfo) {
                try {
                    for (int i = 0; i < 60 && (clazz = Util.getType(this.project, wsdlParameter.getTypeName())) == null; ++i) {
                        this.wait(2000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = Object.class;
            }
            arrayList.add(clazz);
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    public boolean needsSoapHandler() {
        return this.getSoapHeaderParameters().size() > 0;
    }

    public List<ParameterInfo> getSoapHeaderParameters() {
        if (this.headerParams == null) {
            this.headerParams = new ArrayList<ParameterInfo>();
            Map<QName, String> map = JaxWsUtils.getSoapHandlerParameters(this.getXamWsdlModel(), this.getPort(), this.getOperation());
            for (Map.Entry<QName, String> entry : map.entrySet()) {
                Class clazz = Util.getType(this.project, entry.getValue());
                ParameterInfo parameterInfo = new ParameterInfo(entry.getKey(), clazz, entry.getValue());
                parameterInfo.setStyle(ParameterInfo.ParamStyle.UNKNOWN);
                this.headerParams.add(parameterInfo);
            }
        }
        return this.headerParams;
    }

    public WSDLModel getXamWsdlModel() {
        try {
            FileObject fileObject = FileUtil.toFileObject((File)new File(this.webServiceData.getWsdlFile()));
            return WSDLModelFactory.getDefault().getModel(Utilities.createModelSource((FileObject)fileObject, (boolean)true));
        }
        catch (CatalogModelException catalogModelException) {
            Logger.global.log(Level.INFO, "", catalogModelException);
            return null;
        }
    }
}

