/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.designpattern;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.designpattern.DefaultDesignPatternResource;
import org.netbeans.modules.uml.designpattern.DesignPatternUtilities;
import org.netbeans.modules.uml.designpattern.IDesignPatternDetails;
import org.netbeans.modules.uml.designpattern.IDesignPatternManager;
import org.netbeans.modules.uml.ui.swing.commondialogs.JCenterDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromoteDialogUI
extends JCenterDialog {
    private JButton m_OKButton;
    private JButton m_CancelButton;
    private JLabel textLabel;
    private JLabel textLabel2;
    private JComboBox m_ProjectCombo;
    private JComboBox m_NamespaceCombo;
    private JCheckBox m_RemoveCheck;
    private JPanel jPanel0;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private IProject m_Project = null;
    private IDesignPatternDetails m_Details = null;
    private IDesignPatternManager m_Manager = null;

    public PromoteDialogUI(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initDialog();
        this.center(frame);
    }

    private void initComponents() {
        this.jPanel0 = new JPanel();
        this.jPanel1 = new JPanel();
        this.textLabel = new JLabel();
        this.m_ProjectCombo = new JComboBox();
        this.textLabel2 = new JLabel();
        this.m_NamespaceCombo = new JComboBox();
        this.jPanel3 = new JPanel();
        this.m_RemoveCheck = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.m_OKButton = new JButton();
        this.m_CancelButton = new JButton();
        this.jPanel4 = new JPanel();
        this.jPanel4.setBorder(new EmptyBorder(new Insets(35, 5, 5, 5)));
        this.setTitle(DefaultDesignPatternResource.getString("IDS_PROMOTETITLE"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PromoteDialogUI.this.closeDialog(windowEvent);
            }
        });
        this.jPanel0.setLayout(new BoxLayout(this.jPanel0, 1));
        this.jPanel0.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        Font font = new Font("Dialog", 0, 11);
        this.jPanel1.setLayout(new GridBagLayout());
        this.textLabel.setFont(font);
        this.textLabel.setText(DefaultDesignPatternResource.determineText((String)DefaultDesignPatternResource.getString("IDS_PROJECT")));
        DefaultDesignPatternResource.setMnemonic((Object)this.textLabel, (String)DefaultDesignPatternResource.getString("IDS_PROJECT"));
        DefaultDesignPatternResource.setFocusAccelerator((Object)this.m_ProjectCombo, (String)DefaultDesignPatternResource.getString("IDS_PROJECT"));
        this.jPanel1.add((Component)this.textLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.m_ProjectCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 10, 0));
        this.m_ProjectCombo.setEditable(false);
        this.m_ProjectCombo.setFont(font);
        this.m_ProjectCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.jPanel1.add(this.jPanel4);
        this.textLabel2.setFont(font);
        this.textLabel2.setText(DefaultDesignPatternResource.determineText((String)DefaultDesignPatternResource.getString("IDS_NAMESPACE")));
        DefaultDesignPatternResource.setMnemonic((Object)this.textLabel2, (String)DefaultDesignPatternResource.getString("IDS_NAMESPACE"));
        DefaultDesignPatternResource.setFocusAccelerator((Object)this.m_NamespaceCombo, (String)DefaultDesignPatternResource.getString("IDS_NAMESPACE"));
        this.jPanel1.add((Component)this.textLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.m_NamespaceCombo, new GridBagConstraints(1, 1, 1, 1, 1.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 10, 0));
        this.m_NamespaceCombo.setEditable(false);
        this.m_NamespaceCombo.setFont(font);
        this.jPanel0.add(this.jPanel1);
        this.jPanel3.setLayout(new GridBagLayout());
        this.m_RemoveCheck.setFont(font);
        this.m_RemoveCheck.setText(DefaultDesignPatternResource.determineText((String)DefaultDesignPatternResource.getString("IDS_REMOVEFROMPROJECT")));
        DefaultDesignPatternResource.setMnemonic((Object)this.m_RemoveCheck, (String)DefaultDesignPatternResource.getString("IDS_REMOVEFROMPROJECT"));
        this.m_RemoveCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PromoteDialogUI.this.onRemoveCheck(actionEvent);
            }
        });
        this.jPanel3.add((Component)this.m_RemoveCheck, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel0.add(this.jPanel3);
        Dimension dimension = new Dimension(70, 25);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 0));
        this.m_OKButton.setFont(font);
        this.m_OKButton.setText(DefaultDesignPatternResource.getString("IDS_OK"));
        this.m_OKButton.setPreferredSize(dimension);
        this.m_OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PromoteDialogUI.this.onOKButton(actionEvent);
            }
        });
        this.getRootPane().setDefaultButton(this.m_OKButton);
        this.jPanel2.add(this.m_OKButton);
        this.m_CancelButton.setFont(font);
        this.m_CancelButton.setText(DefaultDesignPatternResource.getString("IDS_CANCEL"));
        this.m_CancelButton.setPreferredSize(dimension);
        this.m_CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PromoteDialogUI.this.setVisible(false);
                PromoteDialogUI.this.dispose();
            }
        });
        this.m_CancelButton.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            public void keyPressed(KeyEvent keyEvent) {
                PromoteDialogUI.this.handleKeyDownCancelButton(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                keyEvent.consume();
            }
        });
        this.jPanel2.add(Box.createHorizontalStrut(5));
        this.jPanel2.add(this.m_CancelButton);
        this.jPanel0.add(this.jPanel2);
        this.getContentPane().add((Component)this.jPanel0, "Center");
        this.addActionListeners();
        Font font2 = UIManager.getFont("controlFont");
        int n = font2 != null ? font2.getSize() : 12;
        int n2 = 300;
        int n3 = 185;
        int n4 = 2;
        if (n > 17) {
            n4 = 3;
        }
        n2 += Math.round((float)n2 * ((float)(n4 * n) / 100.0f));
        n3 += Math.round((float)n3 * ((float)(n4 * n) / 100.0f));
        this.setSize(n2, n3);
    }

    private void onRemoveCheck(ActionEvent actionEvent) {
        JCheckBox jCheckBox;
        boolean bl;
        Object object = actionEvent.getSource();
        if (!(object instanceof JCheckBox) || (bl = (jCheckBox = (JCheckBox)object).isSelected())) {
            // empty if block
        }
    }

    private void addActionListeners() {
        this.m_ProjectCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PromoteDialogUI.this.m_ProjectCombo_actionPerformed(actionEvent);
            }
        });
    }

    private void m_ProjectCombo_actionPerformed(ActionEvent actionEvent) {
        this.onSelChangeProjectList();
    }

    private void onOKButton(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            this.onOKButton();
        }
    }

    private void onOKButton() {
        if (this.storeInformation()) {
            ETList<String> eTList = this.validateInformation();
            if (eTList != null && eTList.size() == 0) {
                this.m_Manager.promotePattern(this.m_Details);
                this.setVisible(false);
                this.dispose();
            } else if (eTList != null && eTList.size() > 0) {
                String string = DesignPatternUtilities.formatErrorMessage(eTList);
                DesignPatternUtilities.displayErrorMessage((JDialog)((Object)this), string);
            }
        }
    }

    private void initDialog() {
        DesignPatternUtilities.populateProjectListWithDesignCenterProjects(this.m_ProjectCombo, true);
        this.populateProject();
    }

    private void populateProject() {
        this.m_ProjectCombo.setEnabled(true);
        this.onSelChangeProjectList();
    }

    private boolean storeInformation() {
        boolean bl = true;
        if (this.m_Details != null) {
            this.m_Details.setProject(null);
            if (this.m_Project != null) {
                this.m_Details.setProject(this.m_Project);
            }
            this.m_Details.setNamespace(null);
            INamespace iNamespace = DesignPatternUtilities.getSelectedNamespace(this.m_NamespaceCombo, this.m_Project);
            if (iNamespace != null) {
                this.m_Details.setNamespace(iNamespace);
            }
            if (this.m_RemoveCheck.isSelected()) {
                this.m_Details.setRemoveOnPromote(true);
            } else {
                this.m_Details.setRemoveOnPromote(false);
            }
        }
        return bl;
    }

    private ETList<String> validateInformation() {
        ETArrayList eTArrayList = new ETArrayList();
        if (this.m_ProjectCombo.getSelectedIndex() == -1) {
            String string = DesignPatternUtilities.translateString("IDS_SCOPE_NOSELECT");
            eTArrayList.add((Object)string);
        }
        return eTArrayList;
    }

    private void onSelChangeProjectList() {
        IProject iProject;
        this.m_Project = null;
        String string = (String)this.m_ProjectCombo.getSelectedItem();
        if (string != null && string.length() > 0 && (iProject = DesignPatternUtilities.onSelChangeProjectList(string, (JDialog)((Object)this))) != null) {
            this.m_Project = iProject;
            DesignPatternUtilities.populateNamespaceList(this.m_NamespaceCombo, iProject);
        }
    }

    public void handleKeyDownCancelButton(KeyEvent keyEvent) {
        boolean bl = true;
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            bl = false;
            this.setVisible(false);
            this.dispose();
        } else if (n == 27) {
            bl = false;
            this.setVisible(false);
            this.dispose();
        }
        if (bl && !keyEvent.isConsumed()) {
            keyEvent.consume();
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public PromoteDialogUI() {
        this.initComponents();
        this.initDialog();
    }

    public IDesignPatternDetails getDetails() {
        return this.m_Details;
    }

    public void setDetails(IDesignPatternDetails iDesignPatternDetails) {
        this.m_Details = iDesignPatternDetails;
    }

    public IDesignPatternManager getManager() {
        return this.m_Manager;
    }

    public void setManager(IDesignPatternManager iDesignPatternManager) {
        this.m_Manager = iDesignPatternManager;
    }
}

