/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.designpattern;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.metamodel.infrastructure.ICollaboration;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.designpattern.DefaultDesignPatternResource;
import org.netbeans.modules.uml.designpattern.DesignPatternUtilities;
import org.netbeans.modules.uml.designpattern.IDesignPatternDetails;
import org.netbeans.modules.uml.designpattern.Wizard;
import org.netbeans.modules.uml.ui.support.diagramsupport.ProxyDiagramManager;
import org.netbeans.modules.uml.ui.support.wizard.IWizardSheet;
import org.netbeans.modules.uml.ui.support.wizard.WizardInteriorPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardOptions
extends WizardInteriorPage {
    private static final String PG_CAPTION = DefaultDesignPatternResource.getString("IDS_WIZARDCAPTION");
    private static final String PG_TITLE = DefaultDesignPatternResource.getString("IDS_OPTIONS");
    private static final String PG_SUBTITLE = DefaultDesignPatternResource.getString("IDS_OPTIONSHELP");
    private Wizard m_Wizard = null;
    private JCheckBox m_Create = new JCheckBox();
    private JTextField m_DiagramName = new JTextField();
    private JTextArea helpCaption = new JTextArea();

    public WizardOptions(IWizardSheet iWizardSheet, String string, String string2, String string3) {
        super(iWizardSheet, string, string2, string3);
        this.createUI();
    }

    public WizardOptions(IWizardSheet iWizardSheet) {
        this(iWizardSheet, PG_CAPTION, PG_TITLE, PG_SUBTITLE);
    }

    protected void createUI() {
        super.createUI();
        this.pnlContents.setLayout(new GridBagLayout());
        this.m_Create.setText(DefaultDesignPatternResource.determineText((String)DefaultDesignPatternResource.getString("IDS_CREATECLASSDIAGRAM")));
        DefaultDesignPatternResource.setMnemonic((Object)this.m_Create, (String)DefaultDesignPatternResource.getString("IDS_CREATECLASSDIAGRAM"));
        this.m_Create.getAccessibleContext().setAccessibleDescription(DefaultDesignPatternResource.getString("ACSD_CREATE_CHECKBOX"));
        this.helpCaption.setLineWrap(true);
        this.helpCaption.setOpaque(false);
        this.helpCaption.setPreferredSize(new Dimension(300, 30));
        this.helpCaption.setMinimumSize(new Dimension(300, 30));
        this.helpCaption.setFont(new Font("SansSerif", 0, 10));
        this.helpCaption.setEditable(false);
        this.helpCaption.setFocusable(false);
        this.helpCaption.getAccessibleContext().setAccessibleName(DefaultDesignPatternResource.getString("ACSN_TEXTAREA"));
        this.helpCaption.getAccessibleContext().setAccessibleDescription(DefaultDesignPatternResource.getString("ACSD_TEXTAREA"));
        this.m_DiagramName.setEnabled(false);
        this.m_DiagramName.getAccessibleContext().setAccessibleName(DefaultDesignPatternResource.getString("ACSN_DIAGRAMNAME"));
        this.m_DiagramName.getAccessibleContext().setAccessibleDescription(DefaultDesignPatternResource.getString("ACSD_DIAGRAMNAME"));
        this.pnlContents.add((Component)this.m_Create, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 7, 3, 205), 32, 0));
        this.pnlContents.add((Component)this.m_DiagramName, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 284, 0));
        this.pnlContents.add((Component)this.helpCaption, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 20, 200, 40), 47, 1));
        this.pnlContents.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.addActionListeners();
        this.onInitDialog();
    }

    private void addActionListeners() {
        this.m_Create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WizardOptions.this.m_Create_actionPerformed(actionEvent);
            }
        });
    }

    private void m_Create_actionPerformed(ActionEvent actionEvent) {
        this.onCreateDiagram();
    }

    protected boolean onInitDialog() {
        super.onInitDialog();
        IWizardSheet iWizardSheet = this.getParentSheet();
        this.m_Wizard = (Wizard)iWizardSheet;
        return true;
    }

    public void onWizardBack() {
        if (this.m_Wizard != null) {
            this.m_Wizard.m_RefreshPages = false;
        }
        super.onWizardBack();
    }

    public void onWizardNext() {
        ETList<String> eTList = this.validatePage();
        if (eTList != null && eTList.size() == 0) {
            IDesignPatternDetails iDesignPatternDetails = this.m_Wizard.getDetails();
            if (iDesignPatternDetails != null) {
                if (this.m_Create.isSelected()) {
                    iDesignPatternDetails.setCreateDiagram(true);
                } else {
                    iDesignPatternDetails.setCreateDiagram(false);
                }
                String string = this.m_DiagramName.getText();
                iDesignPatternDetails.setDiagramName(string);
                super.onWizardNext();
            }
        } else if (eTList != null && eTList.size() > 0) {
            String string = DesignPatternUtilities.formatErrorMessage(eTList);
            DesignPatternUtilities.displayErrorMessage((JDialog)((Object)this.m_Wizard), string);
        }
    }

    private ETList<String> validatePage() {
        ETArrayList eTArrayList = new ETArrayList();
        if (this.m_Create.isSelected()) {
            boolean bl;
            ETPairT eTPairT;
            String string = this.m_DiagramName.getText();
            ProxyDiagramManager proxyDiagramManager = ProxyDiagramManager.instance();
            if (proxyDiagramManager != null && (eTPairT = proxyDiagramManager.isValidDiagramName(string)) != null && !(bl = ((Boolean)eTPairT.getParamOne()).booleanValue())) {
                String string2 = DesignPatternUtilities.translateString("IDS_INVALIDDIAGRAMNAME");
                eTArrayList.add((Object)string2);
            }
        }
        return eTArrayList;
    }

    private void onCreateDiagram() {
        if (this.m_Create.isSelected()) {
            this.m_DiagramName.setEnabled(true);
            this.populateDiagramName();
            this.m_DiagramName.requestFocus();
            this.m_DiagramName.selectAll();
        } else {
            this.m_DiagramName.setText("");
            this.m_DiagramName.setEnabled(false);
        }
    }

    private void populateDiagramName() {
        ICollaboration iCollaboration;
        IDesignPatternDetails iDesignPatternDetails;
        if (this.m_Wizard != null && (iDesignPatternDetails = this.m_Wizard.getDetails()) != null && (iCollaboration = iDesignPatternDetails.getCollaboration()) != null) {
            String string = iCollaboration.getName();
            string = string + DefaultDesignPatternResource.getString("IDS_DIAGRAM");
            this.m_DiagramName.setText(string);
        }
    }
}

