/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.compapp.casaeditor.CasaDataEditorSupport;
import org.netbeans.modules.compapp.casaeditor.CasaDataNode;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphUtilities;
import org.netbeans.modules.compapp.projects.jbi.api.JbiBuildListener;
import org.netbeans.modules.compapp.projects.jbi.api.JbiBuildTask;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.lookup.InstanceContent;

public class CasaDataObject
extends MultiDataObject {
    static final long serialVersionUID = 7527025549386876556L;
    public static final String CASA_ICON_BASE_WITH_EXT = "org/netbeans/modules/compapp/casaeditor/resources/service_composition_16.png";
    private transient CasaDataEditorSupport editorSupport;
    private transient Node.Cookie mBuildCookie = new JbiBuildCookie();
    private transient boolean mIsBuilding;
    private transient AtomicReference<InstanceContent> myServices = new AtomicReference();
    private transient AtomicBoolean isLookupInit = new AtomicBoolean(false);

    public CasaDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.editorSupport = new CasaDataEditorSupport(this);
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)this.editorSupport);
        this.getCookieSet().add(this.mBuildCookie);
    }

    public CasaDataEditorSupport getEditorSupport() {
        return this.editorSupport;
    }

    protected Node createNodeDelegate() {
        return new CasaDataNode(this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CasaDataObject.class);
    }

    protected void handleDelete() throws IOException {
        if (this.isModified()) {
            this.setModified(false);
        }
        this.getEditorSupport().getEnv().unmarkModified();
        super.handleDelete();
    }

    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        SaveCookie saveCookie;
        if (this.isModified() && (saveCookie = (SaveCookie)this.getCookie(SaveCookie.class)) != null) {
            saveCookie.save();
        }
        return super.handleMove(dataFolder);
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl) {
            this.getCookieSet().add((Node.Cookie)this.getSaveCookie());
            if (this.isLookupInit.get()) {
                this.myServices.get().add((Object)this.getSaveCookie());
            }
        } else {
            this.getCookieSet().remove((Node.Cookie)this.getSaveCookie());
            if (this.isLookupInit.get()) {
                this.myServices.get().remove((Object)this.getSaveCookie());
            }
        }
    }

    private SaveCookie getSaveCookie() {
        return new SaveCookie(){

            public void save() throws IOException {
                CasaDataObject.this.getEditorSupport().saveDocument();
            }

            public int hashCode() {
                return this.getClass().hashCode();
            }

            public boolean equals(Object object) {
                return object != null && this.getClass().equals(object.getClass());
            }
        };
    }

    public boolean isBuilding() {
        return this.mIsBuilding;
    }

    private class JbiBuildCookie
    implements Node.Cookie,
    JbiBuildListener {
        private JbiBuildCookie() {
        }

        public void buildStarted(JbiBuildTask jbiBuildTask) {
            CasaDataObject.this.mIsBuilding = true;
            if (CasaDataObject.this.editorSupport != null && CasaDataObject.this.editorSupport.getScene() != null) {
                CasaModelGraphUtilities.setSceneEnabled(CasaDataObject.this.editorSupport.getScene(), jbiBuildTask);
            }
        }

        public void buildCompleted(boolean bl) {
            CasaDataObject.this.mIsBuilding = false;
            if (!bl && CasaDataObject.this.editorSupport != null && CasaDataObject.this.editorSupport.getScene() != null) {
                CasaModelGraphUtilities.setSceneEnabled(CasaDataObject.this.editorSupport.getScene(), true);
            }
        }
    }
}

