/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaFactory;
import org.netbeans.modules.compapp.casaeditor.graph.CasaMinimizable;
import org.netbeans.modules.compapp.casaeditor.graph.RegionUtilities;
import org.netbeans.modules.compapp.casaeditor.graph.actions.EditablePropertiesAction;
import org.openide.util.Utilities;

public class CasaEngineTitleWidget
extends Widget
implements CasaMinimizable {
    private static final Image DEFAULT_ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/nodes/resources/ServiceUnitNode.png");
    private static final int TITLE_GAP = 3;
    private static final int TITLE_MINIMIZE_BUTTON_DISPLACEMENT = 27;
    private static final Image IMAGE_EXPAND = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/graph/resources/expand.png");
    private static final Image IMAGE_COLLAPSE = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/graph/resources/collapse.png");
    private static final Image IMAGE_UNCONFIGURED = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/palette/resources/question_violet.png");
    private static final Border BORDER_MINIMIZE = BorderFactory.createRoundedBorder((int)2, (int)2, null, (Color)new Color(96, 96, 96));
    private ImageWidget mDeleteWidget;
    private ImageWidget mEditWidget;
    private ImageWidget mHideWidget;
    private ImageWidget configureWidget;
    private ImageWidget minimizeWidget;
    private LabelWidget mNameWidget;
    private LabelWidget typeWidget;
    private static int GAP_BELOW_AND_ABOVE_TITLE = 4;
    private boolean mConfigurationStatus = true;
    private Widget mTitleWidget;
    private static final boolean DEBUG = false;

    public CasaEngineTitleWidget(Scene scene, StateModel stateModel) {
        super(scene);
        this.mTitleWidget = new Widget(scene);
        this.mTitleWidget.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)3));
        Widget widget = new Widget(scene);
        widget.setPreferredBounds(new Rectangle(25, 0));
        this.mTitleWidget.addChild(widget);
        this.minimizeWidget = new ImageWidget(scene, IMAGE_COLLAPSE);
        this.minimizeWidget.setCursor(Cursor.getPredefinedCursor(12));
        this.minimizeWidget.setBorder(BORDER_MINIMIZE);
        this.minimizeWidget.getActions().addAction((WidgetAction)new ToggleMinimizedAction(stateModel));
        this.mTitleWidget.addChild((Widget)this.minimizeWidget);
        this.mDeleteWidget = new ImageWidget(scene);
        this.mEditWidget = new ImageWidget(scene);
        this.mEditWidget.getActions().addAction((WidgetAction)new EditablePropertiesAction());
        this.mHideWidget = new ImageWidget(scene);
        this.mTitleWidget.addChild((Widget)this.mEditWidget);
        this.configureWidget = new ImageWidget(scene);
        this.mTitleWidget.addChild((Widget)this.configureWidget);
        this.mNameWidget = new LabelWidget(scene);
        this.mNameWidget.setFont(scene.getDefaultFont().deriveFont(1));
        this.mNameWidget.setForeground(CasaFactory.getCasaCustomizer().getCOLOR_SU_REGION_TITLE());
        this.mTitleWidget.addChild((Widget)this.mNameWidget);
        this.typeWidget = new LabelWidget(scene);
        this.mTitleWidget.addChild((Widget)this.typeWidget);
        Widget widget2 = new Widget(scene);
        widget2.setPreferredBounds(new Rectangle(25, 0));
        this.mTitleWidget.addChild(widget2);
        Widget widget3 = new Widget(scene);
        Widget widget4 = new Widget(scene);
        widget4.setPreferredBounds(new Rectangle(0, 0, 0, GAP_BELOW_AND_ABOVE_TITLE));
        Widget widget5 = new Widget(scene);
        widget5.setPreferredBounds(new Rectangle(0, 0, 0, GAP_BELOW_AND_ABOVE_TITLE));
        widget3.setLayout(LayoutFactory.createVerticalFlowLayout());
        widget3.addChild(widget4);
        widget3.addChild(this.mTitleWidget);
        widget3.addChild(widget5);
        this.addChild(widget3);
    }

    public void setTitleColor(Color color) {
        this.mNameWidget.setForeground(color);
    }

    public void setTitleFont(Font font) {
        this.mNameWidget.setFont(font);
    }

    public void setLabel(String string) {
        this.mNameWidget.setLabel(string);
    }

    public boolean getConfigurationStatus() {
        return this.mConfigurationStatus;
    }

    public void setConfigurationStatus(boolean bl) {
        this.mConfigurationStatus = bl;
        this.configureWidget.setImage(this.getConfigurationStatus() ? null : IMAGE_UNCONFIGURED);
    }

    public void setEditable(boolean bl) {
        this.mEditWidget.setImage(bl ? RegionUtilities.IMAGE_EDIT_16_ICON : null);
    }

    public void setMinimized(boolean bl) {
        this.minimizeWidget.setImage(bl ? IMAGE_EXPAND : IMAGE_COLLAPSE);
    }

    private final class ToggleMinimizedAction
    extends WidgetAction.Adapter {
        private StateModel mStateModel;

        public ToggleMinimizedAction(StateModel stateModel) {
            this.mStateModel = stateModel;
        }

        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            if (widgetMouseEvent.getButton() == 1 || widgetMouseEvent.getButton() == 2) {
                this.mStateModel.toggleBooleanState();
                return WidgetAction.State.CONSUMED;
            }
            return WidgetAction.State.REJECTED;
        }

        public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
            WidgetAction.State state = WidgetAction.State.REJECTED;
            if ((widgetKeyEvent.getModifiers() & 1) == 1 && widgetKeyEvent.getKeyCode() == 10) {
                this.mStateModel.toggleBooleanState();
                state = WidgetAction.State.CONSUMED;
            }
            return state;
        }
    }
}

