/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.graph.DependenciesRegistry;

public class LineBreakingLabelWidget
extends Widget {
    private static final int MINIMUM_WIDTH = 100;
    private static final String[] ELLIPSES = new String[]{"..."};
    private String mLabel;
    private Color mTextColor;
    private Font mFont;
    private LabelWidget[] mLabelWidgets;
    private Dimension mLastPreferredSize = new Dimension();
    private LineBreakMeasurer mLineMeasurer;
    private int mParagraphStart;
    private int mParagraphEnd;
    private DependenciesRegistry mDependenciesRegistry = new DependenciesRegistry(this);

    public LineBreakingLabelWidget(Scene scene) {
        super(scene);
        this.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)4));
    }

    protected void notifyAdded() {
        this.mDependenciesRegistry.registerDependency(new Widget.Dependency(){
            private boolean mIsIgnore;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void revalidateDependency() {
                if (this.mIsIgnore || LineBreakingLabelWidget.this.getBounds() == null) {
                    return;
                }
                if (LineBreakingLabelWidget.this.reBreak()) {
                    try {
                        this.mIsIgnore = true;
                        LineBreakingLabelWidget.this.getScene().validate();
                        Object var2_1 = null;
                        this.mIsIgnore = false;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        this.mIsIgnore = false;
                        throw throwable;
                    }
                }
            }
        });
    }

    protected void notifyRemoved() {
        this.mDependenciesRegistry.removeAllDependencies();
    }

    public void setText(String string, Color color, Font font) {
        this.mLabel = string;
        this.mTextColor = color;
        this.mFont = font;
        AttributedString attributedString = new AttributedString(string, this.mFont.getAttributes());
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        this.mParagraphStart = attributedCharacterIterator.getBeginIndex();
        this.mParagraphEnd = attributedCharacterIterator.getEndIndex();
        this.mLineMeasurer = new LineBreakMeasurer(attributedCharacterIterator, new FontRenderContext(null, false, false));
        this.reBreak();
    }

    private boolean reBreak() {
        if (this.getPreferredBounds() == null || this.getPreferredBounds().getSize().equals(this.mLastPreferredSize)) {
            return false;
        }
        this.mLastPreferredSize = this.getPreferredBounds().getSize();
        boolean bl = false;
        String[] stringArray = this.calculateLineBreaks(this.mLabel);
        if (stringArray == null) {
            return false;
        }
        if (this.mLabelWidgets != null && stringArray.length == this.mLabelWidgets.length) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.mLabelWidgets[i].setLabel(stringArray[i]);
            }
        } else {
            bl = true;
            this.removeChildren();
            this.mLabelWidgets = new LabelWidget[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.mLabelWidgets[i] = new LabelWidget(this.getScene(), stringArray[i]);
                this.mLabelWidgets[i].setAlignment(LabelWidget.Alignment.CENTER);
                this.mLabelWidgets[i].setForeground(this.mTextColor);
                this.mLabelWidgets[i].setFont(this.mFont);
                this.addChild((Widget)this.mLabelWidgets[i]);
            }
        }
        return bl;
    }

    public void animateVisible(Color color) {
        this.mTextColor = color;
        if (this.mLabelWidgets != null) {
            for (LabelWidget labelWidget : this.mLabelWidgets) {
                labelWidget.setForeground(color);
            }
        }
    }

    private String[] calculateLineBreaks(String string) {
        float f = (float)this.getPreferredBounds().width * 0.75f;
        if (f <= 0.0f) {
            return null;
        }
        if (f < 100.0f) {
            return ELLIPSES;
        }
        this.mLineMeasurer.setPosition(this.mParagraphStart);
        int n = this.mParagraphStart;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.mLineMeasurer.getPosition() < this.mParagraphEnd) {
            int n2 = this.mLineMeasurer.nextOffset(f);
            this.mLineMeasurer.setPosition(n2);
            arrayList.add(string.substring(n, n2));
            n = n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

