/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.Utilities;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphUtilities;
import org.netbeans.modules.compapp.casaeditor.graph.DependenciesRegistry;
import org.netbeans.modules.compapp.projects.jbi.api.JbiBuildTask;
import org.openide.util.NbBundle;

public class WaitMessageHandler {
    private static Widget getBuildMessageWidget(CasaModelGraphScene casaModelGraphScene) {
        for (Widget widget : casaModelGraphScene.getDragLayer().getChildren()) {
            if (!(widget instanceof WaitMessageWidget)) continue;
            return widget;
        }
        return null;
    }

    public static void addToScene(CasaModelGraphScene casaModelGraphScene, JbiBuildTask jbiBuildTask) {
        if (WaitMessageHandler.getBuildMessageWidget(casaModelGraphScene) == null) {
            WaitMessageWidget waitMessageWidget = new WaitMessageWidget((Scene)casaModelGraphScene, NbBundle.getMessage(WaitMessageHandler.class, (String)"LBL_WaitMessage3"));
            waitMessageWidget.setTask(jbiBuildTask);
            waitMessageWidget.setAnimationText(NbBundle.getMessage(WaitMessageHandler.class, (String)"LBL_WaitMessage1"), NbBundle.getMessage(WaitMessageHandler.class, (String)"LBL_WaitMessage2"), NbBundle.getMessage(WaitMessageHandler.class, (String)"LBL_WaitMessage3"));
            casaModelGraphScene.getDragLayer().addChild((Widget)waitMessageWidget);
            casaModelGraphScene.validate();
        }
    }

    public static void removeFromScene(final CasaModelGraphScene casaModelGraphScene) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Widget widget = WaitMessageHandler.getBuildMessageWidget(casaModelGraphScene);
                if (widget != null) {
                    casaModelGraphScene.getDragLayer().removeChild(widget);
                    casaModelGraphScene.validate();
                }
            }
        });
    }

    private static class WaitMessageWidget
    extends LabelWidget {
        private static final Font FONT_MESSAGE = new Font("SansSerif", 1, 16);
        private static final Border BORDER = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createLineBorder((int)2, (Color)new Color(220, 220, 200)), BorderFactory.createRoundedBorder((int)8, (int)8, null, (Color)Color.LIGHT_GRAY), BorderFactory.createLineBorder((int)4, (int)8, (int)4, (int)8, (Color)new Color(255, 255, 255, 200))});
        private DependenciesRegistry mDependenciesRegistry;
        private String[] mAnimationText;
        private boolean mIsLockPosition;
        private Runnable mCurrentAnimator;
        private JbiBuildTask mBuildTask;

        public WaitMessageWidget(Scene scene, String string) {
            super(scene);
            this.setLabel(string);
            this.setBorder(BORDER);
            this.setFont(FONT_MESSAGE);
            this.setForeground(Color.DARK_GRAY);
            this.setBackground(new Color(255, 255, 255, 200));
            this.setOpaque(true);
        }

        public void setAnimationText(String ... stringArray) {
            this.mAnimationText = stringArray;
            if (this.getParentWidget() != null) {
                throw new IllegalStateException();
            }
        }

        public void setTask(JbiBuildTask jbiBuildTask) {
            this.mBuildTask = jbiBuildTask;
        }

        protected void notifyAdded() {
            super.notifyAdded();
            this.mDependenciesRegistry = new DependenciesRegistry(this.getParentWidget());
            this.setMinimumSize(this.getPreferredBounds().getSize());
            this.center();
            Widget.Dependency dependency = new Widget.Dependency(){

                public void revalidateDependency() {
                    if (!WaitMessageWidget.this.mIsLockPosition) {
                        WaitMessageWidget.this.center();
                    }
                }
            };
            this.getRegistry().registerDependency(dependency);
            this.startAnimation();
        }

        private void startAnimation() {
            if (this.mAnimationText != null) {
                Runnable runnable;
                this.mCurrentAnimator = runnable = new Runnable(){
                    private int mAnimationIndex = 0;
                    private boolean isForcingCleanup = false;
                    private int mForcedCleanupDelay = 0;

                    public void run() {
                        do {
                            this.checkTaskFinished();
                            try {
                                this.mForcedCleanupDelay += 800;
                                Thread.sleep(800L);
                                if (WaitMessageWidget.this.mCurrentAnimator != this) continue;
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        this.updateLabel();
                                    }
                                });
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace(System.err);
                            }
                        } while (WaitMessageWidget.this.mCurrentAnimator == this);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void updateLabel() {
                        try {
                            WaitMessageWidget.this.mIsLockPosition = true;
                            WaitMessageWidget.this.setLabel(WaitMessageWidget.this.mAnimationText[this.mAnimationIndex]);
                            WaitMessageWidget.this.getScene().revalidate();
                            WaitMessageWidget.this.getScene().validate();
                            this.mAnimationIndex = (this.mAnimationIndex + 1) % WaitMessageWidget.this.mAnimationText.length;
                            Object var2_1 = null;
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            WaitMessageWidget.this.mIsLockPosition = false;
                            throw throwable;
                        }
                        WaitMessageWidget.this.mIsLockPosition = false;
                    }

                    private void checkTaskFinished() {
                        if (!this.isForcingCleanup && WaitMessageWidget.this.mBuildTask != null && WaitMessageWidget.this.mBuildTask.isFinished()) {
                            this.isForcingCleanup = true;
                            this.mForcedCleanupDelay = 0;
                        } else if (this.isForcingCleanup && this.mForcedCleanupDelay >= 5000 && WaitMessageWidget.this.mCurrentAnimator == this) {
                            CasaModelGraphUtilities.setSceneEnabled((CasaModelGraphScene)WaitMessageWidget.this.getScene(), true);
                        }
                    }
                };
                new Thread(runnable).start();
            }
        }

        protected void notifyRemoved() {
            super.notifyRemoved();
            this.mCurrentAnimator = null;
            if (this.getRegistry() != null) {
                this.getRegistry().removeAllDependencies();
            }
            this.mDependenciesRegistry = null;
        }

        private void center() {
            Rectangle rectangle = this.getPreferredBounds();
            CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)this.getScene();
            Rectangle rectangle2 = casaModelGraphScene.getView().getVisibleRect();
            if (this.getParentWidget() == casaModelGraphScene.getDragLayer() && rectangle != null && rectangle2 != null) {
                Point point = Utilities.center(rectangle, rectangle2);
                this.setPreferredLocation(point);
            }
        }

        private DependenciesRegistry getRegistry() {
            return this.mDependenciesRegistry;
        }
    }
}

