/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.compapp.casaeditor.CasaDataObject;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNodeFactory;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasaNavigatorContentPanel
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider,
Runnable,
PropertyChangeListener {
    static final long serialVersionUID = 9068382751477968023L;
    private CasaWrapperModel mCasaModel;
    private CasaDataObject mDataObject;
    private CasaNodeFactory mNodeFactory;
    private boolean isRequireRepaint;
    private ExplorerManager myExplorerManager;
    private TreeView treeView;
    private final JLabel notAvailableLabel = new JLabel(NbBundle.getMessage(CasaNavigatorContentPanel.class, (String)"MSG_NotAvailable"));

    public CasaNavigatorContentPanel() {
        this.setLayout(new BorderLayout());
        this.myExplorerManager = new ExplorerManager();
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(true);
        this.treeView.setEnabled(true);
        this.treeView.setSelectionMode(1);
        this.treeView.setDefaultActionAllowed(true);
        this.myExplorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.notAvailableLabel.setHorizontalAlignment(0);
        this.notAvailableLabel.setEnabled(false);
        Color color = UIManager.getColor("window");
        this.notAvailableLabel.setBackground(color != null ? color : Color.white);
        this.notAvailableLabel.setOpaque(true);
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    public ExplorerManager getExplorerManager() {
        return this.myExplorerManager;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx;
        Node[] nodeArray;
        if (this.myExplorerManager != null && (nodeArray = this.myExplorerManager.getSelectedNodes()) != null && nodeArray.length > 0 && (helpCtx = nodeArray[0].getHelpCtx()) != null) {
            return helpCtx;
        }
        return new HelpCtx(CasaNavigatorContentPanel.class);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                CasaNavigatorContentPanel.this.propertyUpdate(propertyChangeEvent);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void propertyUpdate(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
        if (string.equals("activatedNodes") && topComponent != null && topComponent != TopComponent.getRegistry().getActivated()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    CasaNavigatorContentPanel.this.selectActivatedNodes();
                }
            });
        } else if (string.equals("selectedNodes") && topComponent != null && topComponent == TopComponent.getRegistry().getActivated()) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray != null && nodeArray.length >= 1) {
                topComponent.setActivatedNodes(nodeArray);
            }
        } else if (string.startsWith("model_property_")) {
            this.showNavTree(true);
        }
    }

    public void navigate(CasaDataObject casaDataObject) {
        this.mDataObject = casaDataObject;
        this.mCasaModel = casaDataObject != null ? casaDataObject.getEditorSupport().getModel() : null;
        if (this.mCasaModel == null) {
            this.showError();
        } else {
            this.mNodeFactory = new CasaNodeFactory(this.mDataObject, this.mCasaModel);
            this.mCasaModel.removePropertyChangeListener(this);
            this.mCasaModel.addPropertyChangeListener(this);
            this.showNavTree(false);
        }
    }

    private void showNavTree(boolean bl) {
        this.removeAll();
        CasaNode casaNode = this.mNodeFactory.createModelNode(this.mCasaModel);
        this.myExplorerManager.setRootContext((Node)casaNode);
        this.add((Component)this.treeView, "Center");
        if (bl) {
            this.run();
        } else {
            EventQueue.invokeLater(this);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void run() {
        Node node = this.myExplorerManager.getRootContext();
        this.treeView.expandNode(node);
        CasaNavigatorContentPanel.expandNodes(this.treeView, 1, node);
        this.selectActivatedNodes();
    }

    public static void expandNodes(TreeView treeView, int n, Node node) {
        Node[] nodeArray;
        if (n == 0) {
            return;
        }
        Children children = node.getChildren();
        if (children != null && (nodeArray = children.getNodes()) != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                treeView.expandNode(nodeArray[i]);
                CasaNavigatorContentPanel.expandNodes(treeView, n - 1, nodeArray[i]);
            }
        }
    }

    private void selectActivatedNodes() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        Node node = null;
        for (Node node2 : nodeArray) {
            if (!(node2 instanceof CasaNode)) continue;
            node = node2;
            break;
        }
        if (node != null) {
            ArrayList arrayList = new ArrayList();
            this.findNavigatorNode(this.myExplorerManager.getRootContext(), ((CasaNode)node).getData(), arrayList);
            try {
                this.myExplorerManager.setSelectedNodes(arrayList.toArray(new Node[0]));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private void findNavigatorNode(Node node, Object object, List<Node> list) {
        Children children = node.getChildren();
        for (Node node2 : children.getNodes()) {
            if (!(node2 instanceof CasaNode)) continue;
            CasaNode casaNode = (CasaNode)node2;
            if (casaNode.getData() == object) {
                list.add((Node)casaNode);
                return;
            }
            if (casaNode.getChildren().getNodesCount() <= 0) continue;
            this.findNavigatorNode((Node)casaNode, object, list);
        }
    }

    private void showError() {
        if (this.notAvailableLabel.isShowing()) {
            return;
        }
        this.removeAll();
        this.add((Component)this.notAvailableLabel, "Center");
        this.revalidate();
        this.repaint();
    }
}

