/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.model.JavacElements;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfoImpl;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.PositionConverter;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.Pair;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationInfo {
    private static final boolean VERIFY_CONFINEMENT = Boolean.getBoolean(CompilationInfo.class.getName() + ".vetifyConfinement");
    final CompilationInfoImpl impl;
    private boolean invalid;
    private ElementUtilities elementUtilities;
    private TreeUtilities treeUtilities;
    private TypeUtilities typeUtilities;

    CompilationInfo(CompilationInfoImpl compilationInfoImpl) {
        assert (compilationInfoImpl != null);
        this.impl = compilationInfoImpl;
    }

    public JavaSource.Phase getPhase() {
        this.checkConfinement();
        return this.impl.getPhase();
    }

    public TreePath getChangedTree() {
        this.checkConfinement();
        if (JavaSource.Phase.PARSED.compareTo(this.impl.getPhase()) > 0) {
            return null;
        }
        Pair<JavaSource.DocPositionRegion, MethodTree> pair = this.impl.getChangedTree();
        if (pair == null) {
            return null;
        }
        CompilationUnitTree compilationUnitTree = this.impl.getCompilationUnit();
        if (compilationUnitTree == null) {
            return null;
        }
        return TreePath.getPath(compilationUnitTree, (Tree)pair.second);
    }

    public CompilationUnitTree getCompilationUnit() {
        this.checkConfinement();
        return this.impl.getCompilationUnit();
    }

    public String getText() {
        this.checkConfinement();
        return this.impl.getText();
    }

    public TokenHierarchy<?> getTokenHierarchy() {
        this.checkConfinement();
        return this.impl.getTokenHierarchy();
    }

    public List<Diagnostic> getDiagnostics() {
        this.checkConfinement();
        return this.impl.getDiagnostics();
    }

    public List<? extends TypeElement> getTopLevelElements() throws IllegalStateException {
        this.checkConfinement();
        if (this.impl.getPositionConverter() == null) {
            throw new IllegalStateException();
        }
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
        JavaSource javaSource = this.impl.getJavaSource();
        if (javaSource.isClassFile()) {
            Elements elements = this.getElements();
            assert (elements != null);
            assert (javaSource.rootFo != null);
            String string = FileObjects.convertFolder2Package(FileObjects.stripExtension(FileUtil.getRelativePath((FileObject)javaSource.rootFo, (FileObject)this.getFileObject())));
            Symbol.ClassSymbol classSymbol = ((JavacElements)elements).getTypeElementByBinaryName(string);
            if (classSymbol != null) {
                arrayList.add(classSymbol);
            }
        } else {
            CompilationUnitTree compilationUnitTree = this.getCompilationUnit();
            if (compilationUnitTree == null) {
                return null;
            }
            Trees trees = this.getTrees();
            assert (trees != null);
            List<? extends Tree> list = compilationUnitTree.getTypeDecls();
            TreePath treePath = new TreePath(compilationUnitTree);
            for (Tree tree : list) {
                TreePath treePath2 = new TreePath(treePath, tree);
                Element element = trees.getElement(treePath2);
                if (element == null || !element.getKind().isClass() && !element.getKind().isInterface()) continue;
                arrayList.add((TypeElement)element);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Trees getTrees() {
        this.checkConfinement();
        return Trees.instance(this.impl.getJavacTask());
    }

    public Types getTypes() {
        this.checkConfinement();
        return this.impl.getJavacTask().getTypes();
    }

    public Elements getElements() {
        this.checkConfinement();
        return this.impl.getJavacTask().getElements();
    }

    public JavaSource getJavaSource() {
        this.checkConfinement();
        return this.impl.getJavaSource();
    }

    public ClasspathInfo getClasspathInfo() {
        this.checkConfinement();
        return this.impl.getClasspathInfo();
    }

    public FileObject getFileObject() {
        this.checkConfinement();
        return this.impl.getFileObject();
    }

    public PositionConverter getPositionConverter() {
        this.checkConfinement();
        return this.impl.getPositionConverter();
    }

    public Document getDocument() throws IOException {
        this.checkConfinement();
        return this.impl.getDocument();
    }

    public synchronized TreeUtilities getTreeUtilities() {
        this.checkConfinement();
        if (this.treeUtilities == null) {
            this.treeUtilities = new TreeUtilities(this);
        }
        return this.treeUtilities;
    }

    public synchronized ElementUtilities getElementUtilities() {
        this.checkConfinement();
        if (this.elementUtilities == null) {
            this.elementUtilities = new ElementUtilities(this);
        }
        return this.elementUtilities;
    }

    public synchronized TypeUtilities getTypeUtilities() {
        this.checkConfinement();
        if (this.typeUtilities == null) {
            this.typeUtilities = new TypeUtilities(this);
        }
        return this.typeUtilities;
    }

    final void invalidate() {
        this.invalid = true;
    }

    final void checkConfinement() throws IllegalStateException {
        if (VERIFY_CONFINEMENT && this.invalid) {
            throw new IllegalStateException(String.format("Access to the shared %s outside a guarded run method.", this.getClass().getSimpleName()));
        }
    }
}

