/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.TranslateIdentifier;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneratorUtilities {
    private WorkingCopy copy;

    private GeneratorUtilities(WorkingCopy workingCopy) {
        this.copy = workingCopy;
    }

    public static GeneratorUtilities get(WorkingCopy workingCopy) {
        return new GeneratorUtilities(workingCopy);
    }

    public ClassTree insertClassMember(ClassTree classTree, Tree tree) {
        Object object;
        assert (classTree != null && tree != null);
        int n = 0;
        GuardedDocument guardedDocument = null;
        SourcePositions sourcePositions = null;
        try {
            object = this.copy.getDocument();
            if (object != null && object instanceof GuardedDocument) {
                guardedDocument = (GuardedDocument)object;
                sourcePositions = this.copy.getTrees().getSourcePositions();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = this.copy.getTreeUtilities();
        CompilationUnitTree compilationUnitTree = this.copy.getCompilationUnit();
        Tree tree2 = null;
        for (Tree tree3 : classTree.getMembers()) {
            TreePath treePath = TreePath.getPath(compilationUnitTree, tree3);
            if (!(treePath != null && ((TreeUtilities)object).isSynthetic(treePath) || ClassMemberComparator.compare(tree, tree3) >= 0)) {
                if (guardedDocument == null) break;
                int n2 = (int)(tree2 != null ? sourcePositions.getEndPosition(compilationUnitTree, tree2) : sourcePositions.getStartPosition(compilationUnitTree, classTree));
                n2 = guardedDocument.getGuardedBlockChain().adjustToBlockEnd(n2);
                if ((long)n2 <= sourcePositions.getStartPosition(compilationUnitTree, tree3)) break;
            }
            ++n;
            tree2 = tree3;
        }
        return this.copy.getTreeMaker().insertClassMember(classTree, n, tree);
    }

    public ClassTree insertClassMembers(ClassTree classTree, Iterable<? extends Tree> iterable) {
        assert (iterable != null);
        for (Tree tree : iterable) {
            classTree = this.insertClassMember(classTree, tree);
        }
        return classTree;
    }

    public List<? extends MethodTree> createAllAbstractMethodImplementations(TypeElement typeElement) {
        return this.createAbstractMethodImplementations(typeElement, this.copy.getElementUtilities().findUnimplementedMethods(typeElement));
    }

    public List<? extends MethodTree> createAbstractMethodImplementations(TypeElement typeElement, Iterable<? extends ExecutableElement> iterable) {
        assert (iterable != null);
        ArrayList<MethodTree> arrayList = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : iterable) {
            arrayList.add(this.createAbstractMethodImplementation(typeElement, executableElement));
        }
        return arrayList;
    }

    public MethodTree createAbstractMethodImplementation(TypeElement typeElement, ExecutableElement executableElement) {
        assert (typeElement != null && executableElement != null);
        return this.createMethod(executableElement, (DeclaredType)typeElement.asType());
    }

    public List<? extends MethodTree> createOverridingMethods(TypeElement typeElement, Iterable<? extends ExecutableElement> iterable) {
        assert (iterable != null);
        ArrayList<MethodTree> arrayList = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : iterable) {
            arrayList.add(this.createOverridingMethod(typeElement, executableElement));
        }
        return arrayList;
    }

    public MethodTree createOverridingMethod(TypeElement typeElement, ExecutableElement executableElement) {
        assert (typeElement != null && executableElement != null);
        return this.createMethod(executableElement, (DeclaredType)typeElement.asType());
    }

    public MethodTree createMethod(DeclaredType declaredType, ExecutableElement executableElement) {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        TreeMaker treeMaker = this.copy.getTreeMaker();
        Set<Modifier> set = executableElement.getModifiers();
        EnumSet<Modifier> enumSet = set.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(set);
        enumSet.remove((Object)Modifier.ABSTRACT);
        enumSet.remove((Object)Modifier.NATIVE);
        ExecutableType executableType = (ExecutableType)executableElement.asType();
        try {
            executableType = (ExecutableType)this.copy.getTypes().asMemberOf(declaredType, executableElement);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArrayList<TypeParameterTree> arrayList = new ArrayList<TypeParameterTree>();
        for (TypeVariable object52 : executableType.getTypeVariables()) {
            ArrayList<ExpressionTree> bl = new ArrayList<ExpressionTree>();
            object4 = object52.getUpperBound();
            if (object4.getKind() != TypeKind.NULL) {
                if (object4.getKind() == TypeKind.DECLARED) {
                    object3 = (Symbol.ClassSymbol)((DeclaredType)object4).asElement();
                    if (((Symbol.ClassSymbol)object3).getSimpleName().length() == 0 && (((Symbol.ClassSymbol)object3).flags() & 0x1000000L) != 0L) {
                        bl.add((ExpressionTree)treeMaker.Type(((Symbol.ClassSymbol)object3).getSuperclass()));
                        for (Object object22 : ((Symbol.ClassSymbol)object3).getInterfaces()) {
                            bl.add((ExpressionTree)treeMaker.Type((TypeMirror)object22));
                        }
                    } else if (!((Symbol.ClassSymbol)object3).getQualifiedName().contentEquals("java.lang.Object")) {
                        bl.add((ExpressionTree)treeMaker.Type((TypeMirror)object4));
                    }
                } else {
                    bl.add((ExpressionTree)treeMaker.Type((TypeMirror)object4));
                }
            }
            arrayList.add(treeMaker.TypeParameter(object52.asElement().getSimpleName(), bl));
        }
        Tree tree = treeMaker.Type(executableType.getReturnType());
        ArrayList<VariableTree> arrayList2 = new ArrayList<VariableTree>();
        boolean bl = executableElement.isVarArgs();
        object4 = executableElement.getParameters().iterator();
        object3 = executableType.getParameterTypes().iterator();
        Object object5 = treeMaker.Modifiers(EnumSet.noneOf(Modifier.class));
        while (object4.hasNext() && object3.hasNext()) {
            object22 = (VariableElement)object4.next();
            object = (TypeMirror)object3.next();
            if (bl && !object4.hasNext()) {
                object5 = treeMaker.Modifiers(0x400000000L, Collections.emptyList());
            }
            arrayList2.add(treeMaker.Variable((ModifiersTree)object5, object22.getSimpleName(), treeMaker.Type((TypeMirror)object), null));
        }
        object22 = new ArrayList();
        for (TypeMirror typeMirror : executableType.getThrownTypes()) {
            object22.add((ExpressionTree)treeMaker.Type(typeMirror));
        }
        object = treeMaker.Modifiers(enumSet, Collections.emptyList());
        return treeMaker.Method((ModifiersTree)object, (CharSequence)executableElement.getSimpleName(), tree, arrayList, arrayList2, (List<? extends ExpressionTree>)object22, "{}", null);
    }

    public MethodTree createConstructor(TypeElement typeElement, Iterable<? extends VariableElement> iterable, ExecutableElement executableElement) {
        Object object;
        Object object2;
        assert (typeElement != null && iterable != null);
        TreeMaker treeMaker = this.copy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(typeElement.getKind() == ElementKind.ENUM ? Modifier.PRIVATE : Modifier.PUBLIC);
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        ArrayList<ExpressionStatementTree> arrayList2 = new ArrayList<ExpressionStatementTree>();
        ModifiersTree modifiersTree = treeMaker.Modifiers(EnumSet.noneOf(Modifier.class));
        if (executableElement != null && !executableElement.getParameters().isEmpty()) {
            Iterator<? extends TypeMirror> iterator;
            object2 = typeElement.getSuperclass().getKind() == TypeKind.DECLARED ? (ExecutableType)this.copy.getTypes().asMemberOf((DeclaredType)typeElement.getSuperclass(), executableElement) : null;
            ArrayList<IdentifierTree> object3 = new ArrayList<IdentifierTree>();
            object = executableElement.getParameters().iterator();
            Iterator<? extends TypeMirror> iterator2 = iterator = object2 != null ? object2.getParameterTypes().iterator() : null;
            while (object.hasNext()) {
                VariableElement variableElement = (VariableElement)object.next();
                Name name = variableElement.getSimpleName();
                TypeMirror typeMirror = iterator != null ? iterator.next() : variableElement.asType();
                arrayList.add(treeMaker.Variable(modifiersTree, name, treeMaker.Type(typeMirror), null));
                object3.add(treeMaker.Identifier(name));
            }
            arrayList2.add(treeMaker.ExpressionStatement(treeMaker.MethodInvocation(Collections.emptyList(), treeMaker.Identifier("super"), object3)));
        }
        for (VariableElement variableElement : iterable) {
            object = this.copy.getTypes().asMemberOf((DeclaredType)typeElement.asType(), variableElement);
            arrayList.add(treeMaker.Variable(modifiersTree, variableElement.getSimpleName(), treeMaker.Type((TypeMirror)object), null));
            arrayList2.add(treeMaker.ExpressionStatement(treeMaker.Assignment(treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier("this"), variableElement.getSimpleName()), treeMaker.Identifier(variableElement.getSimpleName()))));
        }
        object2 = treeMaker.Block(arrayList2, false);
        return treeMaker.Method(treeMaker.Modifiers(enumSet), (CharSequence)"<init>", null, Collections.emptyList(), arrayList, Collections.emptyList(), (BlockTree)object2, null);
    }

    public MethodTree createConstructor(ClassTree classTree, Iterable<? extends VariableTree> iterable) {
        assert (classTree != null && iterable != null);
        TreeMaker treeMaker = this.copy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(this.copy.getTreeUtilities().isEnum(classTree) ? Modifier.PRIVATE : Modifier.PUBLIC);
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        ArrayList<ExpressionStatementTree> arrayList2 = new ArrayList<ExpressionStatementTree>();
        ModifiersTree modifiersTree = treeMaker.Modifiers(EnumSet.noneOf(Modifier.class));
        for (VariableTree variableTree : iterable) {
            arrayList.add(treeMaker.Variable(modifiersTree, variableTree.getName(), variableTree.getType(), null));
            arrayList2.add(treeMaker.ExpressionStatement(treeMaker.Assignment(treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier("this"), variableTree.getName()), treeMaker.Identifier(variableTree.getName()))));
        }
        BlockTree blockTree = treeMaker.Block(arrayList2, false);
        return treeMaker.Method(treeMaker.Modifiers(enumSet), (CharSequence)"<init>", null, Collections.emptyList(), arrayList, Collections.emptyList(), blockTree, null);
    }

    public MethodTree createGetter(TypeElement typeElement, VariableElement variableElement) {
        assert (typeElement != null && variableElement != null);
        TreeMaker treeMaker = this.copy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
        if (variableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            enumSet.add(Modifier.STATIC);
        }
        Name name = variableElement.getSimpleName();
        assert (name.length() > 0);
        TypeMirror typeMirror = this.copy.getTypes().asMemberOf((DeclaredType)typeElement.asType(), variableElement);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(typeMirror.getKind() == TypeKind.BOOLEAN ? "is" : "get").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        BlockTree blockTree = treeMaker.Block(Collections.singletonList(treeMaker.Return(treeMaker.Identifier(name))), false);
        return treeMaker.Method(treeMaker.Modifiers(enumSet), (CharSequence)stringBuilder, treeMaker.Type(typeMirror), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), blockTree, null);
    }

    public MethodTree createGetter(VariableTree variableTree) {
        assert (variableTree != null);
        TreeMaker treeMaker = this.copy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
        if (variableTree.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
            enumSet.add(Modifier.STATIC);
        }
        Name name = variableTree.getName();
        assert (name.length() > 0);
        Tree tree = variableTree.getType();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tree.getKind() == Tree.Kind.PRIMITIVE_TYPE && ((PrimitiveTypeTree)tree).getPrimitiveTypeKind() == TypeKind.BOOLEAN ? "is" : "get").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        BlockTree blockTree = treeMaker.Block(Collections.singletonList(treeMaker.Return(treeMaker.Identifier(name))), false);
        return treeMaker.Method(treeMaker.Modifiers(enumSet), (CharSequence)stringBuilder, tree, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), blockTree, null);
    }

    public MethodTree createSetter(TypeElement typeElement, VariableElement variableElement) {
        assert (typeElement != null && variableElement != null);
        TreeMaker treeMaker = this.copy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
        boolean bl = variableElement.getModifiers().contains((Object)Modifier.STATIC);
        if (bl) {
            enumSet.add(Modifier.STATIC);
        }
        Name name = variableElement.getSimpleName();
        assert (name.length() > 0);
        TypeMirror typeMirror = this.copy.getTypes().asMemberOf((DeclaredType)typeElement.asType(), variableElement);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("set").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        List<VariableTree> list = Collections.singletonList(treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), name, treeMaker.Type(typeMirror), null));
        BlockTree blockTree = treeMaker.Block(Collections.singletonList(treeMaker.ExpressionStatement(treeMaker.Assignment(treeMaker.MemberSelect((ExpressionTree)(bl ? treeMaker.Identifier(variableElement.getEnclosingElement().getSimpleName()) : treeMaker.Identifier("this")), name), treeMaker.Identifier(name)))), false);
        return treeMaker.Method(treeMaker.Modifiers(enumSet), (CharSequence)stringBuilder, treeMaker.Type(this.copy.getTypes().getNoType(TypeKind.VOID)), Collections.emptyList(), list, Collections.emptyList(), blockTree, null);
    }

    public MethodTree createSetter(ClassTree classTree, VariableTree variableTree) {
        assert (classTree != null && variableTree != null);
        TreeMaker treeMaker = this.copy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
        boolean bl = variableTree.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        if (bl) {
            enumSet.add(Modifier.STATIC);
        }
        Name name = variableTree.getName();
        assert (name.length() > 0);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("set").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        List<VariableTree> list = Collections.singletonList(treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), name, variableTree.getType(), null));
        BlockTree blockTree = treeMaker.Block(Collections.singletonList(treeMaker.ExpressionStatement(treeMaker.Assignment(treeMaker.MemberSelect((ExpressionTree)(bl ? treeMaker.Identifier(classTree.getSimpleName()) : treeMaker.Identifier("this")), name), treeMaker.Identifier(name)))), false);
        return treeMaker.Method(treeMaker.Modifiers(enumSet), (CharSequence)stringBuilder, treeMaker.Type(this.copy.getTypes().getNoType(TypeKind.VOID)), Collections.emptyList(), list, Collections.emptyList(), blockTree, null);
    }

    public <T extends Tree> T importFQNs(T t) {
        TranslateIdentifier translateIdentifier = new TranslateIdentifier(this.copy, false, true, null);
        return (T)translateIdentifier.translate(t);
    }

    public <T extends Tree> T importComments(T t, CompilationUnitTree compilationUnitTree) {
        try {
            JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
            TokenSequence tokenSequence = ((SourceFileObject)jCCompilationUnit.getSourceFile()).getTokenHierarchy().tokenSequence(JavaTokenId.language());
            TranslateIdentifier translateIdentifier = new TranslateIdentifier(this.copy, true, false, (TokenSequence<JavaTokenId>)tokenSequence);
            return (T)translateIdentifier.translate(t);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return t;
        }
    }

    private MethodTree createMethod(ExecutableElement executableElement, DeclaredType declaredType) {
        BlockTree blockTree;
        Object object2;
        Object object3;
        TreeMaker treeMaker = this.copy.getTreeMaker();
        boolean bl = executableElement.getModifiers().contains((Object)Modifier.ABSTRACT);
        if (bl) {
            object3 = new ArrayList<IdentifierTree>();
            object2 = this.copy.getElements().getTypeElement("java.lang.UnsupportedOperationException");
            if (object2 != null) {
                NewClassTree object4 = treeMaker.NewClass(null, Collections.emptyList(), treeMaker.QualIdent((Element)object2), Collections.singletonList(treeMaker.Literal("Not supported yet.")), null);
                object3.add(treeMaker.Throw(object4));
            }
            blockTree = treeMaker.Block((List<? extends StatementTree>)object3, false);
        } else {
            object3 = new ArrayList();
            for (VariableElement variableElement : executableElement.getParameters()) {
                object3.add(treeMaker.Identifier(variableElement.getSimpleName()));
            }
            object2 = treeMaker.MethodInvocation(Collections.emptyList(), treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier("super"), executableElement.getSimpleName()), (List<? extends ExpressionTree>)object3);
            StatementTree statementTree = this.copy.getTypes().getNoType(TypeKind.VOID) == executableElement.getReturnType() ? treeMaker.ExpressionStatement((ExpressionTree)object2) : treeMaker.Return((ExpressionTree)object2);
            blockTree = treeMaker.Block(Collections.singletonList(statementTree), false);
        }
        object3 = this.createMethod(declaredType, executableElement);
        object2 = object3.getModifiers();
        SpecificationVersion specificationVersion = new SpecificationVersion(SourceLevelQuery.getSourceLevel((FileObject)this.copy.getFileObject()));
        SpecificationVersion specificationVersion2 = new SpecificationVersion("1.5");
        if (specificationVersion.compareTo((Object)specificationVersion2) >= 0) {
            boolean bl2 = true;
            if (specificationVersion.compareTo((Object)specificationVersion2) == 0) {
                boolean bl3 = bl2 = !executableElement.getEnclosingElement().getKind().isInterface();
            }
            if (bl2) {
                object2 = treeMaker.addModifiersAnnotation(object3.getModifiers(), treeMaker.Annotation(treeMaker.Identifier("Override"), Collections.emptyList()));
            }
        }
        return treeMaker.Method((ModifiersTree)object2, (CharSequence)object3.getName(), object3.getReturnType(), object3.getTypeParameters(), object3.getParameters(), object3.getThrows(), blockTree, null);
    }

    private static class ClassMemberComparator {
        private ClassMemberComparator() {
        }

        public static int compare(Tree tree, Tree tree2) {
            if (tree == tree2) {
                return 0;
            }
            return ClassMemberComparator.getSortPriority(tree) - ClassMemberComparator.getSortPriority(tree2);
        }

        private static int getSortPriority(Tree tree) {
            int n = 0;
            ModifiersTree modifiersTree = null;
            switch (tree.getKind()) {
                case CLASS: {
                    n = 4000;
                    modifiersTree = ((ClassTree)tree).getModifiers();
                    break;
                }
                case METHOD: {
                    MethodTree methodTree = (MethodTree)tree;
                    n = methodTree.getName().contentEquals("<init>") ? 200 : 300;
                    modifiersTree = methodTree.getModifiers();
                    break;
                }
                case VARIABLE: {
                    n = 100;
                    modifiersTree = ((VariableTree)tree).getModifiers();
                }
            }
            if (modifiersTree != null && !modifiersTree.getFlags().contains((Object)Modifier.STATIC)) {
                n += 1000;
            }
            return n;
        }
    }
}

