/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.java.source.JavaSourceSupportAccessor;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModificationResult {
    private JavaSource js;
    Map<FileObject, List<Difference>> diffs = new HashMap<FileObject, List<Difference>>();

    ModificationResult(JavaSource javaSource) {
        this.js = javaSource;
    }

    public Set<? extends FileObject> getModifiedFileObjects() {
        return this.diffs.keySet();
    }

    public List<? extends Difference> getDifferences(FileObject fileObject) {
        return this.diffs.get(fileObject);
    }

    public Set<File> getNewFiles() {
        HashSet<File> hashSet = new HashSet<File>();
        for (List<Difference> list : this.diffs.values()) {
            for (Difference difference : list) {
                if (difference.getKind() != Difference.Kind.CREATE) continue;
                hashSet.add(new File(((CreateChange)difference).getFileObject().toUri()));
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        HashSet<FileObject> hashSet;
        block6: {
            try {
                RepositoryUpdater.getDefault().lockRU();
                for (Map.Entry<FileObject, List<Difference>> entry : this.diffs.entrySet()) {
                    this.commit(entry.getKey(), entry.getValue(), null);
                }
                Object var4_3 = null;
                RepositoryUpdater.getDefault().unlockRU();
                hashSet = new HashSet<FileObject>();
                if (this.js == null) break block6;
                this.js.revalidate();
                hashSet.addAll(this.js.getFileObjects());
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                RepositoryUpdater.getDefault().unlockRU();
                HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
                if (this.js != null) {
                    this.js.revalidate();
                    hashSet2.addAll(this.js.getFileObjects());
                }
                for (FileObject fileObject : JavaSourceSupportAccessor.ACCESSOR.getVisibleEditorsFiles()) {
                    JavaSource javaSource;
                    if (hashSet2.contains(fileObject) || (javaSource = JavaSource.forFileObject(fileObject)) == null) continue;
                    javaSource.revalidate();
                }
                throw throwable;
            }
        }
        for (FileObject fileObject : JavaSourceSupportAccessor.ACCESSOR.getVisibleEditorsFiles()) {
            JavaSource javaSource;
            if (hashSet.contains(fileObject) || (javaSource = JavaSource.forFileObject(fileObject)) == null) continue;
            javaSource.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(FileObject fileObject, List<Difference> list, Writer writer) throws IOException {
        Reader reader;
        ByteArrayOutputStream byteArrayOutputStream;
        block31: {
            Object object;
            block32: {
                EditorCookie editorCookie;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie2 = editorCookie = dataObject != null ? (EditorCookie)dataObject.getCookie(EditorCookie.class) : null;
                if (editorCookie == null || writer != null || (object = editorCookie.getDocument()) == null) break block32;
                if (object instanceof BaseDocument) {
                    ((BaseDocument)object).atomicLock();
                }
                boolean bl = false;
                try {
                    for (Difference difference : list) {
                        if (difference.isExcluded()) continue;
                        switch (difference.getKind()) {
                            case INSERT: 
                            case REMOVE: 
                            case CHANGE: {
                                this.processDocument((StyledDocument)object, difference);
                                break;
                            }
                            case CREATE: {
                                this.createUnit(difference, writer);
                            }
                        }
                    }
                    bl = true;
                    Object var11_13 = null;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (object instanceof BaseDocument) {
                        if (!bl) {
                            ((BaseDocument)object).atomicUndo();
                        }
                        ((BaseDocument)object).atomicUnlock();
                    }
                    throw throwable;
                }
                if (object instanceof BaseDocument) {
                    if (!bl) {
                        ((BaseDocument)object).atomicUndo();
                    }
                    ((BaseDocument)object).atomicUnlock();
                }
                return;
            }
            object = null;
            byteArrayOutputStream = null;
            reader = null;
            try {
                int n;
                boolean bl;
                Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
                object = fileObject.getInputStream();
                byteArrayOutputStream = new ByteArrayOutputStream();
                FileUtil.copy((InputStream)object, (OutputStream)byteArrayOutputStream);
                ((InputStream)object).close();
                object = null;
                byte[] byArray = byteArrayOutputStream.toByteArray();
                int n2 = this.convertToLF(byArray);
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
                reader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 0, n2), charset);
                boolean bl2 = bl = writer != null;
                if (writer == null) {
                    writer = new OutputStreamWriter(fileObject.getOutputStream(), charset);
                }
                int n3 = 0;
                for (Difference difference : list) {
                    int n4;
                    if (difference.isExcluded()) continue;
                    if (Difference.Kind.CREATE == difference.getKind()) {
                        if (bl) continue;
                        this.createUnit(difference, null);
                        continue;
                    }
                    int n5 = difference.getStartPosition().getOffset();
                    int n6 = n5 - n3;
                    char[] cArray = new char[n6];
                    int n7 = 0;
                    while ((n4 = reader.read(cArray, 0, n6 - n7)) > 0 && n7 < n6) {
                        writer.write(cArray, 0, n4);
                        n7 += n4;
                        n3 += n4;
                    }
                    switch (difference.getKind()) {
                        case INSERT: {
                            writer.write(difference.getNewText());
                            break;
                        }
                        case REMOVE: {
                            int n8 = difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset();
                            reader.skip(n8);
                            n3 += n8;
                            break;
                        }
                        case CHANGE: {
                            int n8 = difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset();
                            reader.skip(n8);
                            n3 += n8;
                            writer.write(difference.getNewText());
                        }
                    }
                }
                Object object2 = new char[1024];
                while ((n = reader.read((char[])object2)) > 0) {
                    writer.write((char[])object2, 0, n);
                }
                Object var23_29 = null;
                if (object == null) break block31;
            }
            catch (Throwable throwable) {
                Object var23_30 = null;
                if (object != null) {
                    ((InputStream)object).close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
            ((InputStream)object).close();
        }
        if (byteArrayOutputStream != null) {
            byteArrayOutputStream.close();
        }
        if (reader != null) {
            reader.close();
        }
        if (writer != null) {
            writer.close();
        }
    }

    private void processDocument(final StyledDocument styledDocument, final Difference difference) throws IOException {
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ModificationResult.this.processDocumentLocked(styledDocument, difference);
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        };
        if (difference.isCommitToGuards()) {
            NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
        } else {
            try {
                NbDocument.runAtomicAsUser((StyledDocument)styledDocument, (Runnable)runnable);
            }
            catch (BadLocationException badLocationException) {
                badLocationExceptionArray[0] = badLocationException;
            }
        }
        if (badLocationExceptionArray[0] != null) {
            IOException iOException = new IOException();
            iOException.initCause(badLocationExceptionArray[0]);
            throw iOException;
        }
    }

    private void processDocumentLocked(Document document, Difference difference) throws BadLocationException {
        switch (difference.getKind()) {
            case INSERT: {
                document.insertString(difference.getStartPosition().getOffset(), difference.getNewText(), null);
                break;
            }
            case REMOVE: {
                document.remove(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset());
                break;
            }
            case CHANGE: {
                document.remove(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset());
                document.insertString(difference.getStartPosition().getOffset(), difference.getNewText(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createUnit(Difference difference, Writer writer) {
        CreateChange createChange = (CreateChange)difference;
        Writer writer2 = writer;
        if (writer2 == null) {
            createChange.getFileObject().openOutputStream();
            writer2 = createChange.getFileObject().openWriter();
        }
        writer2.append(createChange.getNewText());
        Object var7_5 = null;
        if (writer2 == null) return;
        try {
            writer2.close();
            return;
        }
        catch (IOException iOException) {
            Logger.getLogger(WorkingCopy.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return;
        {
            catch (IOException iOException) {
                Logger.getLogger(WorkingCopy.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
                Object var7_6 = null;
                if (writer2 == null) return;
                try {
                    writer2.close();
                    return;
                }
                catch (IOException iOException2) {
                    Logger.getLogger(WorkingCopy.class.getName()).log(Level.SEVERE, iOException2.getMessage(), iOException2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (writer2 == null) throw throwable;
            try {
                writer2.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Logger.getLogger(WorkingCopy.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
            }
            throw throwable;
        }
    }

    private int convertToLF(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 13) continue;
            byArray[n++] = byArray[i];
        }
        return n;
    }

    public String getResultingSource(FileObject fileObject) throws IOException {
        assert (fileObject != null) : "Provided fileObject is null";
        StringWriter stringWriter = new StringWriter();
        this.commit(fileObject, this.diffs.get(fileObject), stringWriter);
        return stringWriter.toString();
    }

    static class CreateChange
    extends Difference {
        JavaFileObject fileObject;

        CreateChange(JavaFileObject javaFileObject, String string) {
            super(Difference.Kind.CREATE, null, null, null, string, "Create file " + javaFileObject.getName());
            this.fileObject = javaFileObject;
        }

        public JavaFileObject getFileObject() {
            return this.fileObject;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "Create File: " + this.fileObject.getName() + "; contents = \"\n" + this.newText + "\"";
        }
    }

    public static class Difference {
        Kind kind;
        PositionRef startPos;
        PositionRef endPos;
        String oldText;
        String newText;
        String description;
        private boolean excluded;
        private boolean ignoreGuards = false;

        Difference(Kind kind, PositionRef positionRef, PositionRef positionRef2, String string, String string2, String string3) {
            this.kind = kind;
            this.startPos = positionRef;
            this.endPos = positionRef2;
            this.oldText = string;
            this.newText = string2;
            this.description = string3;
            this.excluded = false;
        }

        Difference(Kind kind, PositionRef positionRef, PositionRef positionRef2, String string, String string2) {
            this(kind, positionRef, positionRef2, string, string2, null);
        }

        public Kind getKind() {
            return this.kind;
        }

        public PositionRef getStartPosition() {
            return this.startPos;
        }

        public PositionRef getEndPosition() {
            return this.endPos;
        }

        public String getOldText() {
            return this.oldText;
        }

        public String getNewText() {
            return this.newText;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void exclude(boolean bl) {
            this.excluded = bl;
        }

        public boolean isCommitToGuards() {
            return this.ignoreGuards;
        }

        public void setCommitToGuards(boolean bl) {
            this.ignoreGuards = bl;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "<" + this.startPos.getOffset() + ", " + this.endPos.getOffset() + ">: " + this.oldText + " -> " + this.newText;
        }

        public String getDescription() {
            return this.description;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            INSERT,
            REMOVE,
            CHANGE,
            CREATE;

        }
    }
}

