/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.save.PositionEstimator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TranslateIdentifier
implements TreeVisitor<Tree, Void> {
    private final CompilationInfo info;
    private final TreeMaker make;
    private final CompilationUnitTree unit;
    private final boolean copyComments;
    private final boolean resolveImports;
    private final TokenSequence<JavaTokenId> seq;
    private final CommentHandlerService commentService;
    private int tokenIndexAlreadyAdded = -1;
    private Element rootElement;

    public TranslateIdentifier(CompilationInfo compilationInfo, boolean bl, boolean bl2, TokenSequence<JavaTokenId> tokenSequence) {
        this.info = compilationInfo;
        this.make = compilationInfo instanceof WorkingCopy ? ((WorkingCopy)compilationInfo).getTreeMaker() : null;
        this.unit = compilationInfo.getCompilationUnit();
        this.seq = tokenSequence;
        this.copyComments = bl;
        this.resolveImports = bl2;
        this.commentService = CommentHandlerService.instance(compilationInfo.impl.getJavacTask().getContext());
    }

    @Override
    public Tree visitAnnotation(AnnotationTree annotationTree, Void void_) {
        Tree tree = this.translateTree(annotationTree.getAnnotationType());
        List<? extends ExpressionTree> list = this.translateTree(annotationTree.getArguments());
        if (this.make == null) {
            return annotationTree;
        }
        if (tree != annotationTree.getAnnotationType() || list != annotationTree.getArguments()) {
            annotationTree = this.make.Annotation(tree, list);
        }
        return annotationTree;
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void void_) {
        List<? extends ExpressionTree> list = this.translateTree(methodInvocationTree.getArguments());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(methodInvocationTree.getMethodSelect());
        List<? extends Tree> list2 = this.translateTree(methodInvocationTree.getTypeArguments());
        if (this.make == null) {
            return methodInvocationTree;
        }
        if (list != methodInvocationTree.getArguments() || expressionTree != methodInvocationTree.getMethodSelect() || list2 != methodInvocationTree.getTypeArguments()) {
            methodInvocationTree = this.make.MethodInvocation(list2, expressionTree, list);
        }
        return methodInvocationTree;
    }

    @Override
    public Tree visitAssert(AssertTree assertTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(assertTree.getCondition());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(assertTree.getDetail());
        if (this.make == null) {
            return assertTree;
        }
        if (expressionTree != assertTree.getCondition() || expressionTree2 != assertTree.getDetail()) {
            assertTree = this.make.Assert(expressionTree, expressionTree2);
        }
        return assertTree;
    }

    @Override
    public Tree visitAssignment(AssignmentTree assignmentTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(assignmentTree.getExpression());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(assignmentTree.getVariable());
        if (this.make == null) {
            return assignmentTree;
        }
        if (expressionTree != assignmentTree.getExpression() || expressionTree2 != assignmentTree.getVariable()) {
            assignmentTree = this.make.Assignment(expressionTree2, expressionTree);
        }
        return assignmentTree;
    }

    @Override
    public Tree visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(compoundAssignmentTree.getExpression());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(compoundAssignmentTree.getVariable());
        if (this.make == null) {
            return compoundAssignmentTree;
        }
        if (expressionTree != compoundAssignmentTree.getExpression() || expressionTree2 != compoundAssignmentTree.getVariable()) {
            compoundAssignmentTree = this.make.CompoundAssignment(compoundAssignmentTree.getKind(), expressionTree2, expressionTree);
        }
        return compoundAssignmentTree;
    }

    @Override
    public Tree visitBinary(BinaryTree binaryTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(binaryTree.getLeftOperand());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(binaryTree.getRightOperand());
        if (this.make == null) {
            return binaryTree;
        }
        if (expressionTree != binaryTree.getLeftOperand() || expressionTree2 != binaryTree.getRightOperand()) {
            binaryTree = this.make.Binary(binaryTree.getKind(), expressionTree, expressionTree2);
        }
        return binaryTree;
    }

    @Override
    public Tree visitBlock(BlockTree blockTree, Void void_) {
        List<? extends StatementTree> list = this.translateTree(blockTree.getStatements());
        if (this.make == null) {
            return blockTree;
        }
        if (list != blockTree.getStatements()) {
            blockTree = this.make.Block(list, blockTree.isStatic());
        }
        return blockTree;
    }

    @Override
    public Tree visitBreak(BreakTree breakTree, Void void_) {
        return breakTree;
    }

    @Override
    public Tree visitCase(CaseTree caseTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(caseTree.getExpression());
        List<? extends StatementTree> list = this.translateTree(caseTree.getStatements());
        if (this.make == null) {
            return caseTree;
        }
        if (expressionTree != caseTree.getExpression() || list != caseTree.getStatements()) {
            caseTree = this.make.Case(expressionTree, list);
        }
        return caseTree;
    }

    @Override
    public Tree visitCatch(CatchTree catchTree, Void void_) {
        BlockTree blockTree = (BlockTree)this.translateTree(catchTree.getBlock());
        VariableTree variableTree = (VariableTree)this.translateTree(catchTree.getParameter());
        if (this.make == null) {
            return catchTree;
        }
        if (blockTree != catchTree.getBlock() || variableTree != catchTree.getParameter()) {
            catchTree = this.make.Catch(variableTree, blockTree);
        }
        return catchTree;
    }

    @Override
    public Tree visitClass(ClassTree classTree, Void void_) {
        Tree tree = this.translateTree(classTree.getExtendsClause());
        List<? extends Tree> list = this.translateTree(classTree.getImplementsClause());
        List<? extends Tree> list2 = this.translateTree(classTree.getMembers());
        ModifiersTree modifiersTree = (ModifiersTree)this.translateTree(classTree.getModifiers());
        List<? extends TypeParameterTree> list3 = this.translateTree(classTree.getTypeParameters());
        if (this.make == null) {
            return classTree;
        }
        if (tree != classTree.getExtendsClause() || list != classTree.getImplementsClause() || list2 != classTree.getMembers() || modifiersTree != classTree.getModifiers() || list3 != classTree.getTypeParameters()) {
            classTree = this.make.Class(modifiersTree, classTree.getSimpleName(), list3, tree, list, list2);
        }
        return classTree;
    }

    @Override
    public Tree visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(conditionalExpressionTree.getCondition());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(conditionalExpressionTree.getFalseExpression());
        ExpressionTree expressionTree3 = (ExpressionTree)this.translateTree(conditionalExpressionTree.getTrueExpression());
        if (this.make == null) {
            return conditionalExpressionTree;
        }
        if (expressionTree != conditionalExpressionTree.getCondition() || expressionTree2 != conditionalExpressionTree.getFalseExpression() || expressionTree3 != conditionalExpressionTree.getTrueExpression()) {
            conditionalExpressionTree = this.make.ConditionalExpression(expressionTree, expressionTree3, expressionTree2);
        }
        return conditionalExpressionTree;
    }

    @Override
    public Tree visitContinue(ContinueTree continueTree, Void void_) {
        return continueTree;
    }

    @Override
    public Tree visitDoWhileLoop(DoWhileLoopTree doWhileLoopTree, Void void_) {
        StatementTree statementTree = (StatementTree)this.translateTree(doWhileLoopTree.getStatement());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(doWhileLoopTree.getCondition());
        if (this.make == null) {
            return doWhileLoopTree;
        }
        if (expressionTree != doWhileLoopTree.getCondition() || statementTree != doWhileLoopTree.getStatement()) {
            doWhileLoopTree = this.make.DoWhileLoop(expressionTree, statementTree);
        }
        return doWhileLoopTree;
    }

    @Override
    public Tree visitErroneous(ErroneousTree erroneousTree, Void void_) {
        List<? extends Tree> list = this.translateTree(erroneousTree.getErrorTrees());
        if (this.make == null) {
            return erroneousTree;
        }
        if (list != erroneousTree.getErrorTrees()) {
            erroneousTree = this.make.Erroneous(list);
        }
        return erroneousTree;
    }

    @Override
    public Tree visitExpressionStatement(ExpressionStatementTree expressionStatementTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(expressionStatementTree.getExpression());
        if (this.make == null) {
            return expressionStatementTree;
        }
        if (expressionTree != expressionStatementTree.getExpression()) {
            expressionStatementTree = this.make.ExpressionStatement(expressionTree);
        }
        return expressionStatementTree;
    }

    @Override
    public Tree visitEnhancedForLoop(EnhancedForLoopTree enhancedForLoopTree, Void void_) {
        StatementTree statementTree = (StatementTree)this.translateTree(enhancedForLoopTree.getStatement());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(enhancedForLoopTree.getExpression());
        VariableTree variableTree = (VariableTree)this.translateTree(enhancedForLoopTree.getVariable());
        if (this.make == null) {
            return enhancedForLoopTree;
        }
        if (statementTree != enhancedForLoopTree.getStatement() || expressionTree != enhancedForLoopTree.getExpression() || variableTree != enhancedForLoopTree.getVariable()) {
            enhancedForLoopTree = this.make.EnhancedForLoop(variableTree, expressionTree, statementTree);
        }
        return enhancedForLoopTree;
    }

    @Override
    public Tree visitForLoop(ForLoopTree forLoopTree, Void void_) {
        StatementTree statementTree = (StatementTree)this.translateTree(forLoopTree.getStatement());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(forLoopTree.getCondition());
        List<? extends StatementTree> list = this.translateTree(forLoopTree.getInitializer());
        List<? extends ExpressionStatementTree> list2 = this.translateTree(forLoopTree.getUpdate());
        if (this.make == null) {
            return forLoopTree;
        }
        if (statementTree != forLoopTree.getStatement() || expressionTree != forLoopTree.getCondition() || list != forLoopTree.getInitializer() || list2 != forLoopTree.getUpdate()) {
            forLoopTree = this.make.ForLoop(list, expressionTree, list2, statementTree);
        }
        return forLoopTree;
    }

    @Override
    public Tree visitIdentifier(IdentifierTree identifierTree, Void void_) {
        if (!this.resolveImports) {
            return identifierTree;
        }
        if (this.make == null) {
            return identifierTree;
        }
        TreePath treePath = this.info.getTrees().getPath(this.unit, identifierTree);
        Element element = treePath == null ? ((JCTree.JCIdent)identifierTree).sym : this.info.getTrees().getElement(treePath);
        if (element != null && element != null && (element.getKind().isClass() || element.getKind().isInterface())) {
            if (element == this.rootElement) {
                return this.make.Identifier(element.getSimpleName());
            }
            return this.make.QualIdent(element);
        }
        return identifierTree;
    }

    @Override
    public Tree visitIf(IfTree ifTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(ifTree.getCondition());
        StatementTree statementTree = (StatementTree)this.translateTree(ifTree.getElseStatement());
        StatementTree statementTree2 = (StatementTree)this.translateTree(ifTree.getThenStatement());
        if (this.make == null) {
            return ifTree;
        }
        if (expressionTree != ifTree.getCondition() || statementTree != ifTree.getElseStatement() || statementTree2 != ifTree.getThenStatement()) {
            ifTree = this.make.If(expressionTree, statementTree2, statementTree);
        }
        return ifTree;
    }

    @Override
    public Tree visitImport(ImportTree importTree, Void void_) {
        return importTree;
    }

    @Override
    public Tree visitArrayAccess(ArrayAccessTree arrayAccessTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(arrayAccessTree.getExpression());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(arrayAccessTree.getIndex());
        if (this.make == null) {
            return arrayAccessTree;
        }
        if (expressionTree != arrayAccessTree.getExpression() || expressionTree2 != arrayAccessTree.getIndex()) {
            arrayAccessTree = this.make.ArrayAccess(expressionTree, expressionTree2);
        }
        return arrayAccessTree;
    }

    @Override
    public Tree visitLabeledStatement(LabeledStatementTree labeledStatementTree, Void void_) {
        StatementTree statementTree = (StatementTree)this.translateTree(labeledStatementTree.getStatement());
        if (this.make == null) {
            return labeledStatementTree;
        }
        if (statementTree != labeledStatementTree.getStatement()) {
            labeledStatementTree = this.make.LabeledStatement(labeledStatementTree.getLabel(), statementTree);
        }
        return labeledStatementTree;
    }

    @Override
    public Tree visitLiteral(LiteralTree literalTree, Void void_) {
        return literalTree;
    }

    @Override
    public Tree visitMethod(MethodTree methodTree, Void void_) {
        BlockTree blockTree = (BlockTree)this.translateTree(methodTree.getBody());
        Tree tree = this.translateTree(methodTree.getDefaultValue());
        List<? extends VariableTree> list = this.translateTree(methodTree.getParameters());
        ModifiersTree modifiersTree = (ModifiersTree)this.translateTree(methodTree.getModifiers());
        Tree tree2 = this.translateTree(methodTree.getReturnType());
        List<? extends ExpressionTree> list2 = this.translateTree(methodTree.getThrows());
        List<? extends TypeParameterTree> list3 = this.translateTree(methodTree.getTypeParameters());
        if (this.make == null) {
            return methodTree;
        }
        if (blockTree != methodTree.getBody() || tree != methodTree.getDefaultValue() || list != methodTree.getParameters() || modifiersTree != methodTree.getModifiers() || tree2 != methodTree.getReturnType() || list2 != methodTree.getThrows() || list3 != methodTree.getTypeParameters()) {
            methodTree = this.make.Method(modifiersTree, (CharSequence)methodTree.getName(), tree2, list3, list, list2, blockTree, (ExpressionTree)tree);
        }
        return methodTree;
    }

    @Override
    public Tree visitModifiers(ModifiersTree modifiersTree, Void void_) {
        List<? extends AnnotationTree> list = this.translateTree(modifiersTree.getAnnotations());
        if (this.make == null) {
            return modifiersTree;
        }
        if (list != modifiersTree.getAnnotations()) {
            modifiersTree = this.make.Modifiers(modifiersTree.getFlags(), list);
        }
        return modifiersTree;
    }

    @Override
    public Tree visitNewArray(NewArrayTree newArrayTree, Void void_) {
        List<? extends ExpressionTree> list = this.translateTree(newArrayTree.getInitializers());
        List<? extends ExpressionTree> list2 = this.translateTree(newArrayTree.getDimensions());
        Tree tree = this.translateTree(newArrayTree.getType());
        if (this.make == null) {
            return newArrayTree;
        }
        if (list != newArrayTree.getInitializers() || list2 != newArrayTree.getDimensions() || tree != newArrayTree.getType()) {
            newArrayTree = this.make.NewArray(tree, list2, list);
        }
        return newArrayTree;
    }

    @Override
    public Tree visitNewClass(NewClassTree newClassTree, Void void_) {
        List<? extends ExpressionTree> list = this.translateTree(newClassTree.getArguments());
        ClassTree classTree = (ClassTree)this.translateTree(newClassTree.getClassBody());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(newClassTree.getEnclosingExpression());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translateTree(newClassTree.getIdentifier());
        List<? extends Tree> list2 = this.translateTree(newClassTree.getTypeArguments());
        if (this.make == null) {
            return newClassTree;
        }
        if (list != newClassTree.getArguments() || classTree != newClassTree.getClassBody() || expressionTree != newClassTree.getEnclosingExpression() || expressionTree2 != newClassTree.getIdentifier() || list2 != newClassTree.getTypeArguments()) {
            newClassTree = this.make.NewClass(expressionTree, list2, expressionTree2, list, classTree);
        }
        return newClassTree;
    }

    @Override
    public Tree visitParenthesized(ParenthesizedTree parenthesizedTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(parenthesizedTree.getExpression());
        if (this.make == null) {
            return parenthesizedTree;
        }
        if (expressionTree != parenthesizedTree.getExpression()) {
            parenthesizedTree = this.make.Parenthesized(expressionTree);
        }
        return parenthesizedTree;
    }

    @Override
    public Tree visitReturn(ReturnTree returnTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(returnTree.getExpression());
        if (this.make == null) {
            return returnTree;
        }
        if (expressionTree != returnTree.getExpression()) {
            returnTree = this.make.Return(expressionTree);
        }
        return returnTree;
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Void void_) {
        if (this.make == null) {
            return memberSelectTree;
        }
        TypeElement typeElement = this.info.getElements().getTypeElement(memberSelectTree.toString());
        if (typeElement != null) {
            return this.make.QualIdent(typeElement);
        }
        return memberSelectTree;
    }

    @Override
    public Tree visitEmptyStatement(EmptyStatementTree emptyStatementTree, Void void_) {
        return emptyStatementTree;
    }

    @Override
    public Tree visitSwitch(SwitchTree switchTree, Void void_) {
        List<? extends CaseTree> list = this.translateTree(switchTree.getCases());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(switchTree.getExpression());
        if (this.make == null) {
            return switchTree;
        }
        if (list != switchTree.getCases() || expressionTree != switchTree.getExpression()) {
            switchTree = this.make.Switch(expressionTree, list);
        }
        return switchTree;
    }

    @Override
    public Tree visitSynchronized(SynchronizedTree synchronizedTree, Void void_) {
        BlockTree blockTree = (BlockTree)this.translateTree(synchronizedTree.getBlock());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(synchronizedTree.getExpression());
        if (this.make == null) {
            return synchronizedTree;
        }
        if (blockTree != synchronizedTree.getBlock() || expressionTree != synchronizedTree.getExpression()) {
            synchronizedTree = this.make.Synchronized(expressionTree, blockTree);
        }
        return synchronizedTree;
    }

    @Override
    public Tree visitThrow(ThrowTree throwTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(throwTree.getExpression());
        if (this.make == null) {
            return throwTree;
        }
        if (expressionTree != throwTree.getExpression()) {
            throwTree = this.make.Throw(expressionTree);
        }
        return throwTree;
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree compilationUnitTree, Void void_) {
        List<? extends Tree> list = this.translateTree(compilationUnitTree.getTypeDecls());
        if (this.make == null) {
            return compilationUnitTree;
        }
        if (list != compilationUnitTree.getTypeDecls()) {
            compilationUnitTree = this.make.CompilationUnit(compilationUnitTree.getPackageName(), compilationUnitTree.getImports(), list, compilationUnitTree.getSourceFile());
        }
        return compilationUnitTree;
    }

    @Override
    public Tree visitTry(TryTree tryTree, Void void_) {
        BlockTree blockTree = (BlockTree)this.translateTree(tryTree.getBlock());
        List<? extends CatchTree> list = this.translateTree(tryTree.getCatches());
        BlockTree blockTree2 = (BlockTree)this.translateTree(tryTree.getFinallyBlock());
        if (this.make == null) {
            return tryTree;
        }
        if (blockTree != tryTree.getBlock() || list != tryTree.getCatches() || blockTree2 != tryTree.getFinallyBlock()) {
            tryTree = this.make.Try(blockTree, list, blockTree2);
        }
        return tryTree;
    }

    @Override
    public Tree visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, Void void_) {
        Tree tree = this.translateTree(parameterizedTypeTree.getType());
        List<? extends Tree> list = this.translateTree(parameterizedTypeTree.getTypeArguments());
        if (this.make == null) {
            return parameterizedTypeTree;
        }
        if (tree != parameterizedTypeTree.getType() || list != parameterizedTypeTree.getTypeArguments()) {
            parameterizedTypeTree = this.make.ParameterizedType(tree, list);
        }
        return parameterizedTypeTree;
    }

    @Override
    public Tree visitArrayType(ArrayTypeTree arrayTypeTree, Void void_) {
        Tree tree = this.translateTree(arrayTypeTree.getType());
        if (this.make == null) {
            return arrayTypeTree;
        }
        if (tree != arrayTypeTree.getType()) {
            arrayTypeTree = this.make.ArrayType(tree);
        }
        return arrayTypeTree;
    }

    @Override
    public Tree visitTypeCast(TypeCastTree typeCastTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(typeCastTree.getExpression());
        Tree tree = this.translateTree(typeCastTree.getType());
        if (this.make == null) {
            return typeCastTree;
        }
        if (expressionTree != typeCastTree.getExpression() || tree != typeCastTree.getType()) {
            typeCastTree = this.make.TypeCast(tree, expressionTree);
        }
        return typeCastTree;
    }

    @Override
    public Tree visitPrimitiveType(PrimitiveTypeTree primitiveTypeTree, Void void_) {
        return primitiveTypeTree;
    }

    @Override
    public Tree visitTypeParameter(TypeParameterTree typeParameterTree, Void void_) {
        List<? extends Tree> list = this.translateTree(typeParameterTree.getBounds());
        if (this.make == null) {
            return typeParameterTree;
        }
        if (list != typeParameterTree.getBounds()) {
            typeParameterTree = this.make.TypeParameter(typeParameterTree.getName(), list);
        }
        return typeParameterTree;
    }

    @Override
    public Tree visitInstanceOf(InstanceOfTree instanceOfTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(instanceOfTree.getExpression());
        Tree tree = this.translateTree(instanceOfTree.getType());
        if (this.make == null) {
            return instanceOfTree;
        }
        if (expressionTree != instanceOfTree.getExpression() || tree != instanceOfTree.getType()) {
            instanceOfTree = this.make.InstanceOf(expressionTree, tree);
        }
        return instanceOfTree;
    }

    @Override
    public Tree visitUnary(UnaryTree unaryTree, Void void_) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(unaryTree.getExpression());
        if (this.make == null) {
            return unaryTree;
        }
        if (expressionTree != unaryTree.getExpression()) {
            unaryTree = this.make.Unary(unaryTree.getKind(), expressionTree);
        }
        return unaryTree;
    }

    @Override
    public Tree visitVariable(VariableTree variableTree, Void void_) {
        ModifiersTree modifiersTree = (ModifiersTree)this.translateTree(variableTree.getModifiers());
        Tree tree = this.translateTree(variableTree.getType());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(variableTree.getInitializer());
        if (this.make == null) {
            return variableTree;
        }
        if (modifiersTree != variableTree.getModifiers() || tree != variableTree.getType() || expressionTree != variableTree.getInitializer()) {
            variableTree = this.make.Variable(modifiersTree, variableTree.getName(), tree, expressionTree);
        }
        return variableTree;
    }

    @Override
    public Tree visitWhileLoop(WhileLoopTree whileLoopTree, Void void_) {
        StatementTree statementTree = (StatementTree)this.translateTree(whileLoopTree.getStatement());
        ExpressionTree expressionTree = (ExpressionTree)this.translateTree(whileLoopTree.getCondition());
        if (this.make == null) {
            return whileLoopTree;
        }
        if (expressionTree != whileLoopTree.getCondition() || statementTree != whileLoopTree.getStatement()) {
            whileLoopTree = this.make.WhileLoop(expressionTree, statementTree);
        }
        return whileLoopTree;
    }

    @Override
    public Tree visitWildcard(WildcardTree wildcardTree, Void void_) {
        Tree tree = this.translateTree(wildcardTree.getBound());
        if (this.make == null) {
            return wildcardTree;
        }
        if (tree != wildcardTree.getBound()) {
            wildcardTree = this.make.Wildcard(wildcardTree.getKind(), tree);
        }
        return wildcardTree;
    }

    @Override
    public Tree visitOther(Tree tree, Void void_) {
        return tree;
    }

    public Tree translate(Tree tree) {
        TreePath treePath;
        if (tree == null) {
            return null;
        }
        if (this.copyComments) {
            this.mapComments(tree);
        }
        if ((treePath = this.info.getTrees().getPath(this.unit, tree)) == null) {
            if (tree instanceof JCTree.JCClassDecl) {
                this.rootElement = ((JCTree.JCClassDecl)tree).sym;
            }
        } else {
            this.rootElement = this.info.getTrees().getElement(treePath);
        }
        return tree.accept(this, null);
    }

    private <T extends Tree> List<T> translateTree(List<T> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        boolean bl = false;
        for (Tree tree : list) {
            Tree tree2 = this.translateTree(tree);
            if (tree2 != tree) {
                bl = true;
            }
            if (tree2 == null) continue;
            arrayList.add(tree2);
        }
        return bl ? arrayList : list;
    }

    private Tree translateTree(Tree tree) {
        if (tree == null) {
            return null;
        }
        if (this.copyComments) {
            this.mapComments(tree);
        }
        return tree.accept(this, null);
    }

    private void mapComments(Tree tree) {
        Token token;
        if (((JCTree)tree).pos <= 0) {
            return;
        }
        this.commentService.getComments(tree).commentsMapped();
        SourcePositions sourcePositions = this.info.getTrees().getSourcePositions();
        this.seq.move((int)sourcePositions.getStartPosition(null, tree));
        PositionEstimator.moveToSrcRelevant(this.seq, PositionEstimator.Direction.BACKWARD);
        int n = -2;
        boolean bl = false;
        while (this.seq.moveNext() && PositionEstimator.nonRelevant.contains((token = this.seq.token()).id())) {
            if (this.seq.index() <= this.tokenIndexAlreadyAdded) {
                return;
            }
            if (!bl) {
                this.tokenIndexAlreadyAdded = this.seq.index();
                bl = true;
            }
            switch ((JavaTokenId)token.id()) {
                case LINE_COMMENT: {
                    this.commentService.addComment(tree, Comment.create(Comment.Style.LINE, -2, -2, n, token.toString()));
                    n = 0;
                    break;
                }
                case BLOCK_COMMENT: {
                    this.commentService.addComment(tree, Comment.create(Comment.Style.BLOCK, -2, -2, n, token.toString()));
                    n = -2;
                    break;
                }
                case JAVADOC_COMMENT: {
                    this.commentService.addComment(tree, Comment.create(Comment.Style.JAVADOC, -2, -2, n, token.toString()));
                    n = -2;
                    break;
                }
                case WHITESPACE: {
                    String string = token.toString();
                    this.commentService.addComment(tree, Comment.create(Comment.Style.WHITESPACE, -2, -2, -2, string));
                    int n2 = string.lastIndexOf(10);
                    if (n2 < 0) {
                        if (n < 0) break;
                        n += string.length();
                        break;
                    }
                    n = string.length() - n2 - 1;
                }
            }
        }
    }
}

