/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Context;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.query.CommentHandler;

public class CommentHandlerService
implements CommentHandler {
    private static final Context.Key<CommentHandlerService> commentHandlerKey = new Context.Key();
    private Map<Tree, CommentSetImpl> map = new WeakHashMap<Tree, CommentSetImpl>();

    public static CommentHandlerService instance(Context context) {
        CommentHandlerService commentHandlerService = context.get(commentHandlerKey);
        if (commentHandlerService == null) {
            commentHandlerService = new CommentHandlerService(context);
            CommentHandlerService.setCommentHandler(context, commentHandlerService);
        }
        return commentHandlerService;
    }

    public static void setCommentHandler(Context context, CommentHandlerService commentHandlerService) {
        assert (context.get(commentHandlerKey) == null);
        context.put(commentHandlerKey, commentHandlerService);
    }

    private CommentHandlerService(Context context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasComments(Tree tree) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            return this.map.containsKey(tree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommentSetImpl getComments(Tree tree) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl commentSetImpl = this.map.get(tree);
            if (commentSetImpl == null) {
                commentSetImpl = new CommentSetImpl();
                this.map.put(tree, commentSetImpl);
            }
            return commentSetImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyComments(Tree tree, Tree tree2) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl commentSetImpl = this.map.get(tree);
            if (commentSetImpl != null) {
                CommentSetImpl commentSetImpl2 = this.map.get(tree2);
                if (commentSetImpl2 == null) {
                    commentSetImpl2 = (CommentSetImpl)commentSetImpl.clone();
                    this.map.put(tree2, commentSetImpl2);
                } else {
                    commentSetImpl2.addPrecedingComments(commentSetImpl.getPrecedingComments());
                    commentSetImpl2.addTrailingComments(commentSetImpl.getTrailingComments());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComment(Tree tree, Comment comment) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl commentSetImpl = this.map.get(tree);
            if (commentSetImpl == null) {
                commentSetImpl = new CommentSetImpl();
                this.map.put(tree, commentSetImpl);
            }
            commentSetImpl.addPrecedingComment(comment);
        }
    }
}

