/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.DocumentProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFileObject
implements JavaFileObject,
DocumentProvider {
    final FileObject file;
    final FileObject root;
    private final JavaFileObject.Kind kind;
    private URI uri;
    private String text;
    private TokenHierarchy<?> tokens;
    private final JavaFileFilterImplementation filter;

    public static SourceFileObject create(FileObject fileObject, FileObject fileObject2) {
        try {
            return new SourceFileObject(fileObject, fileObject2, null, false);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public SourceFileObject(FileObject fileObject, FileObject fileObject2, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl) throws IOException {
        assert (fileObject != null);
        this.file = fileObject;
        this.root = fileObject2;
        this.filter = javaFileFilterImplementation;
        String string = this.file.getExt();
        this.kind = FileObjects.getKind(string);
        if (bl && this.kind != JavaFileObject.Kind.CLASS) {
            this.getCharContentImpl(true);
        }
    }

    public void update() throws IOException {
        if (this.kind != JavaFileObject.Kind.CLASS) {
            this.getCharContentImpl(true);
        }
    }

    @Override
    public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
        assert (string != null);
        return this.kind == kind && this.getNameWithoutExtension().equals(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharBuffer getCharContent(boolean bl) throws IOException {
        String string;
        SourceFileObject sourceFileObject = this;
        synchronized (sourceFileObject) {
            string = this.text;
        }
        if (string != null) {
            return CharBuffer.wrap(string);
        }
        return this.getCharContentImpl(false);
    }

    public TokenHierarchy<?> getTokenHierarchy() throws IOException {
        if (this.tokens == null) {
            this.getCharContentImpl(false);
        }
        return this.tokens;
    }

    @Override
    public Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream(), FileEncodingQuery.getEncoding((FileObject)this.file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader openReader(boolean bl) throws IOException {
        String string;
        Object object = this;
        synchronized (object) {
            string = this.text;
        }
        if (string != null) {
            return new StringReader(string);
        }
        object = SourceFileObject.getDocument(this.isOpened());
        if (object == null) {
            Reader reader = new InputStreamReader((InputStream)new BufferedInputStream(this.file.getInputStream()), FileEncodingQuery.getEncoding((FileObject)this.file));
            if (this.filter != null) {
                reader = this.filter.filterReader(reader);
            }
            return reader;
        }
        final StringBuilder stringBuilder = new StringBuilder();
        object.render(new Runnable((Document)object){
            final /* synthetic */ Document val$doc;
            {
                this.val$doc = document;
            }

            public void run() {
                try {
                    stringBuilder.append(this.val$doc.getText(0, this.val$doc.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
        });
        return new StringReader(stringBuilder.toString());
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        StyledDocument styledDocument = SourceFileObject.getDocument(this.isOpened());
        if (styledDocument == null) {
            return new LckStream(this.file);
        }
        return new DocumentStream(styledDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream openInputStream() throws IOException {
        String string;
        Object object = this;
        synchronized (object) {
            string = this.text;
        }
        if (string != null) {
            return new ByteArrayInputStream(string.getBytes());
        }
        object = SourceFileObject.getDocument(this.isOpened());
        if (object == null) {
            return this.file.getInputStream();
        }
        final StringBuilder stringBuilder = new StringBuilder();
        object.render(new Runnable((Document)object){
            final /* synthetic */ Document val$doc;
            {
                this.val$doc = document;
            }

            public void run() {
                try {
                    stringBuilder.append(this.val$doc.getText(0, this.val$doc.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
        });
        return new ByteArrayInputStream(stringBuilder.toString().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete() {
        if (this.isModified() != null) {
            return false;
        }
        try {
            boolean bl;
            FileLock fileLock = this.file.lock();
            try {
                this.file.delete(fileLock);
                bl = true;
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        return this.file.getNameExt();
    }

    public String getNameWithoutExtension() {
        return this.file.getName();
    }

    @Override
    public synchronized URI toUri() {
        if (this.uri == null) {
            try {
                this.uri = URI.create(this.file.getURL().toExternalForm());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
        return this.uri;
    }

    @Override
    public long getLastModified() {
        if (this.isModified() == null) {
            try {
                if (this.file.getFileSystem() instanceof JarFileSystem) {
                    return 0L;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return this.file.lastModified().getTime();
        }
        return System.currentTimeMillis();
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    public String toString() {
        return this.file.getPath();
    }

    public boolean equals(Object object) {
        if (object instanceof SourceFileObject) {
            SourceFileObject sourceFileObject = (SourceFileObject)object;
            return this.file.equals(sourceFileObject.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public StyledDocument getDocument() {
        EditorCookie editorCookie = this.isOpened();
        return editorCookie != null ? SourceFileObject.getDocument(editorCookie) : null;
    }

    @Override
    public void runAtomic(Runnable runnable) {
        assert (runnable != null);
        StyledDocument styledDocument = this.getDocument();
        if (styledDocument == null) {
            throw new IllegalStateException();
        }
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
    }

    private EditorCookie isModified() {
        DataObject.Registry registry = DataObject.getRegistry();
        Set set = registry.getModifiedSet();
        for (DataObject dataObject : set) {
            if (!this.file.equals(dataObject.getPrimaryFile())) continue;
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            return editorCookie;
        }
        return null;
    }

    public EditorCookie isOpened() {
        try {
            if (this.kind == JavaFileObject.Kind.CLASS) {
                return null;
            }
            DataObject dataObject = DataObject.find((FileObject)this.file);
            return (EditorCookie)dataObject.getCookie(EditorCookie.class);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharBuffer getCharContentImpl(boolean bl) throws IOException {
        int n;
        Object object;
        StyledDocument styledDocument = SourceFileObject.getDocument(this.isOpened());
        char[] cArray = null;
        int n2 = 0;
        if (styledDocument == null) {
            int n3;
            object = this.openReader(true);
            n = 0;
            try {
                int n4;
                n3 = (int)this.file.getSize();
                cArray = new char[n3 + 1];
                while ((n4 = ((Reader)object).read(cArray, n, n3 - n)) > 0 && (n += n4) < n3) {
                }
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                ((Reader)object).close();
                throw throwable;
            }
            ((Reader)object).close();
            n3 = 0;
            for (int i = 0; i < n; ++i) {
                if (cArray[i] == '\r') {
                    if (i + 1 < n && cArray[i + 1] == '\n') continue;
                    cArray[n3++] = 10;
                    continue;
                }
                cArray[n3++] = cArray[i];
            }
            n2 = n3;
        } else {
            object = new CharSequence[1];
            styledDocument.render(new Runnable((CharSequence[])object, styledDocument){
                final /* synthetic */ CharSequence[] val$_text;
                final /* synthetic */ Document val$doc;
                {
                    this.val$_text = charSequenceArray;
                    this.val$doc = document;
                }

                public void run() {
                    try {
                        this.val$_text[0] = this.val$doc.getText(0, this.val$doc.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify((Throwable)badLocationException);
                    }
                }
            });
            if (object[0] != null) {
                if (this.filter != null) {
                    object[0] = this.filter.filterCharSequence(object[0]);
                }
                n = object[0].length();
                cArray = new char[n + 1];
                ((Object)object[0]).toString().getChars(0, n, cArray, 0);
                n2 = n;
            }
        }
        cArray[n2] = 10;
        object = new String(cArray, 0, n2);
        CharBuffer charBuffer = CharBuffer.wrap((CharSequence)object);
        this.tokens = TokenHierarchy.create((CharSequence)charBuffer, (boolean)false, (Language)JavaTokenId.language(), null, null);
        if (bl) {
            this.text = object;
        }
        return charBuffer;
    }

    private static StyledDocument getDocument(EditorCookie editorCookie) {
        return editorCookie == null ? null : editorCookie.getDocument();
    }

    private class DocumentStream
    extends OutputStream {
        private static final int BUF_SIZ = 2048;
        private final StyledDocument doc;
        private byte[] data;
        private int pos;

        public DocumentStream(StyledDocument styledDocument) {
            assert (styledDocument != null);
            this.doc = styledDocument;
            this.data = new byte[2048];
            this.pos = 0;
        }

        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            this.ensureSize(n2);
            System.arraycopy(byArray, n, this.data, this.pos, n2);
            this.pos += n2;
        }

        public synchronized void write(byte[] byArray) throws IOException {
            this.ensureSize(byArray.length);
            System.arraycopy(byArray, 0, this.data, this.pos, byArray.length);
            this.pos += byArray.length;
        }

        public synchronized void write(int n) throws IOException {
            this.ensureSize(1);
            this.data[this.pos++] = (byte)(n & 0xFF);
        }

        private void ensureSize(int n) {
            int n2 = this.pos + n;
            if (this.data.length < n2) {
                int n3;
                for (n3 = this.data.length + 2048; n3 < n2; n3 += 2048) {
                }
                byte[] byArray = new byte[n3];
                System.arraycopy(this.data, 0, byArray, 0, this.pos);
                this.data = byArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() throws IOException {
            SourceFileObject sourceFileObject;
            try {
                NbDocument.runAtomic((StyledDocument)this.doc, (Runnable)new Runnable(){

                    public void run() {
                        try {
                            DocumentStream.this.doc.remove(0, DocumentStream.this.doc.getLength());
                            DocumentStream.this.doc.insertString(0, new String(DocumentStream.this.data, 0, DocumentStream.this.pos, FileEncodingQuery.getEncoding((FileObject)SourceFileObject.this.file).name()), null);
                        }
                        catch (BadLocationException badLocationException) {
                            ErrorManager.getDefault().notify((Throwable)badLocationException);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            ErrorManager.getDefault().notify((Throwable)unsupportedEncodingException);
                        }
                    }
                });
                Object var2_1 = null;
                sourceFileObject = SourceFileObject.this;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                SourceFileObject sourceFileObject2 = SourceFileObject.this;
                synchronized (sourceFileObject2) {
                    SourceFileObject.this.text = null;
                }
                throw throwable;
            }
            synchronized (sourceFileObject) {
                SourceFileObject.this.text = null;
            }
        }
    }

    private class LckStream
    extends OutputStream {
        private final OutputStream delegate;
        private final FileLock lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public LckStream(FileObject fileObject) throws IOException {
            assert (fileObject != null);
            this.lock = fileObject.lock();
            try {
                this.delegate = fileObject.getOutputStream(this.lock);
                Object var4_3 = null;
                if (this.delegate != null) return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (this.delegate != null) throw throwable;
                this.lock.releaseLock();
                throw throwable;
            }
            this.lock.releaseLock();
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.delegate.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.delegate.write(byArray);
        }

        public void write(int n) throws IOException {
            this.delegate.write(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.delegate.close();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.lock.releaseLock();
                SourceFileObject sourceFileObject = SourceFileObject.this;
                synchronized (sourceFileObject) {
                    SourceFileObject.this.text = null;
                }
                throw throwable;
            }
            this.lock.releaseLock();
            SourceFileObject sourceFileObject = SourceFileObject.this;
            synchronized (sourceFileObject) {
                SourceFileObject.this.text = null;
            }
        }
    }
}

