/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.api.java.source.JavaSource;
import org.openide.util.NbPreferences;

public class CompilerSettings {
    public static final String ENABLE_LINT = "enable_lint";
    public static final String ENABLE_LINT_DEPRECATION = "enable_lint_deprecation";
    public static final String ENABLE_LINT_UNCHECKED = "enable_lint_unchecked";
    public static final String ENABLE_LINT_FALLTHROUGH = "enable_lint_fallthrough";
    public static final String ENABLE_LINT_SERIAL = "enable_lint_serial";
    public static final String ENABLE_LINT_FINALLY = "enable_lint_finally";
    public static final String ENABLE_LINT_CAST = "enable_lint_cast";
    public static final String ENABLE_LINT_DIVZERO = "enable_lint_dvizero";
    public static final String ENABLE_LINT_EMPTY = "enable_lint_empty";
    public static final String ENABLE_LINT_OVERRIDES = "enable_lint_overrides";
    private static final Map<String, Boolean> DEFAULTS = new HashMap<String, Boolean>();

    private CompilerSettings() {
    }

    public static Preferences getNode() {
        return NbPreferences.forModule(JavaSource.class).node("compiler_settings");
    }

    public static String getCommandLine() {
        Preferences preferences = CompilerSettings.getNode();
        StringBuilder stringBuilder = new StringBuilder();
        if (CompilerSettings.get(preferences, ENABLE_LINT_DEPRECATION)) {
            stringBuilder.append("-Xlint:deprecation ");
        }
        if (CompilerSettings.get(preferences, ENABLE_LINT_UNCHECKED)) {
            stringBuilder.append("-Xlint:unchecked ");
        }
        if (CompilerSettings.get(preferences, ENABLE_LINT_FALLTHROUGH)) {
            stringBuilder.append("-Xlint:fallthrough ");
        }
        if (CompilerSettings.get(preferences, ENABLE_LINT_SERIAL)) {
            stringBuilder.append("-Xlint:serial ");
        }
        if (CompilerSettings.get(preferences, ENABLE_LINT_FINALLY)) {
            stringBuilder.append("-Xlint:finally ");
        }
        if (CompilerSettings.get(preferences, ENABLE_LINT_CAST)) {
            stringBuilder.append("-Xlint:cast ");
        }
        if (CompilerSettings.get(preferences, ENABLE_LINT_DIVZERO)) {
            stringBuilder.append("-Xlint:divzero ");
        }
        if (CompilerSettings.get(preferences, ENABLE_LINT_EMPTY)) {
            stringBuilder.append("-Xlint:empty ");
        }
        if (CompilerSettings.get(preferences, ENABLE_LINT_OVERRIDES)) {
            stringBuilder.append("-Xlint:overrides ");
        }
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ' ') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static boolean get(Preferences preferences, String string) {
        return preferences.getBoolean(string, DEFAULTS.get(string));
    }

    static {
        DEFAULTS.put(ENABLE_LINT, false);
        DEFAULTS.put(ENABLE_LINT_DEPRECATION, false);
        DEFAULTS.put(ENABLE_LINT_UNCHECKED, false);
        DEFAULTS.put(ENABLE_LINT_FALLTHROUGH, false);
        DEFAULTS.put(ENABLE_LINT_SERIAL, false);
        DEFAULTS.put(ENABLE_LINT_FINALLY, false);
        DEFAULTS.put(ENABLE_LINT_CAST, false);
        DEFAULTS.put(ENABLE_LINT_DIVZERO, false);
        DEFAULTS.put(ENABLE_LINT_EMPTY, false);
        DEFAULTS.put(ENABLE_LINT_OVERRIDES, false);
    }
}

