/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.Project;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmRefactoringUtils {
    private CsmRefactoringUtils() {
    }

    public static CsmProject getContextCsmProject(CsmObject csmObject) {
        CsmFile csmFile = null;
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            csmFile = ((CsmOffsetable)csmObject).getContainingFile();
        } else if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            csmFile = (CsmFile)csmObject;
        }
        CsmProject csmProject = null;
        if (csmFile != null) {
            csmProject = csmFile.getProject();
        } else if (CsmKindUtilities.isNamespace((CsmObject)csmObject)) {
            csmProject = ((CsmNamespace)csmObject).getProject();
        }
        return csmProject;
    }

    public static Collection<CsmProject> getRelatedCsmProjects(CsmObject csmObject, boolean bl) {
        List<CsmProject> list = Collections.emptyList();
        if (!bl) {
            CsmProject csmProject = CsmRefactoringUtils.getContextCsmProject(csmObject);
            list = Collections.singleton(csmProject);
        } else {
            Collection collection = CsmModelAccessor.getModel().projects();
            list = collection;
        }
        return list;
    }

    public static Project getContextProject(CsmObject csmObject) {
        CsmProject csmProject = CsmRefactoringUtils.getContextCsmProject(csmObject);
        Project project = null;
        if (csmProject != null) {
            Object object = csmProject.getPlatformProject();
            if (object instanceof NativeProject) {
                object = ((NativeProject)object).getProject();
            }
            if (object instanceof Project) {
                project = (Project)object;
            }
        }
        return project;
    }

    public static CsmObject getReferencedElement(CsmObject csmObject) {
        if (csmObject instanceof CsmReference) {
            return CsmRefactoringUtils.getReferencedElement(((CsmReference)csmObject).getReferencedObject());
        }
        return csmObject;
    }

    public static String getSimpleText(CsmObject csmObject) {
        String string = "";
        if (csmObject != null) {
            if (CsmKindUtilities.isNamedElement((CsmObject)csmObject)) {
                string = ((Object)((CsmNamedElement)csmObject).getName()).toString();
            } else if (CsmKindUtilities.isStatement((CsmObject)csmObject)) {
                string = ((Object)((CsmStatement)csmObject).getText()).toString();
            } else if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
                string = ((Object)((CsmOffsetable)csmObject).getText()).toString();
            }
        }
        return string;
    }

    public static FileObject getFileObject(CsmObject csmObject) {
        CsmFile csmFile = null;
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            csmFile = (CsmFile)csmObject;
        } else if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            csmFile = ((CsmOffsetable)csmObject).getContainingFile();
        }
        return csmFile == null ? null : CsmUtilities.getFileObject((CsmFile)csmFile);
    }

    public static CsmReference findReference(Lookup lookup) {
        Node node;
        CsmReference csmReference = (CsmReference)lookup.lookup(CsmReference.class);
        if (csmReference == null && (node = (Node)lookup.lookup(Node.class)) != null) {
            csmReference = CsmReferenceResolver.getDefault().findReference(node);
        }
        return csmReference;
    }

    public static <T> CsmUID<T> getHandler(T t) {
        SelfUID<T> selfUID = null;
        if (CsmKindUtilities.isIdentifiable(t)) {
            selfUID = ((CsmIdentifiable)t).getUID();
            boolean bl = true;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (bl && selfUID.getObject() == null) {
                System.err.println("UID " + selfUID + "can't return object " + t);
                selfUID = null;
            }
        }
        if (selfUID == null) {
            selfUID = new SelfUID<T>(t);
        }
        return selfUID;
    }

    public static <T> T getObject(CsmUID<T> csmUID) {
        return (T)(csmUID == null ? null : csmUID.getObject());
    }

    public static boolean isSupportedReference(CsmReference csmReference) {
        return csmReference != null;
    }

    public static String getHtml(CsmObject csmObject) {
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return CsmRefactoringUtils.getHtml((CsmOffsetable)csmObject);
        }
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            return CsmRefactoringUtils.htmlize(((Object)((CsmFile)csmObject).getName()).toString());
        }
        return csmObject.toString();
    }

    public static CsmObject getEnclosingElement(CsmObject csmObject) {
        CsmObject csmObject2;
        assert (csmObject != null);
        if (csmObject instanceof CsmReference) {
            csmObject = ((CsmReference)csmObject).getOwner();
        }
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return CsmRefactoringUtils.findInnerFileObject((CsmOffsetable)csmObject);
        }
        CsmObject csmObject3 = csmObject2 = csmObject instanceof CsmReference ? ((CsmReference)csmObject).getOwner() : csmObject;
        while (CsmKindUtilities.isScopeElement((CsmObject)csmObject2)) {
            CsmScope csmScope = ((CsmScopeElement)csmObject2).getScope();
            if (CsmRefactoringUtils.isLangContainerFeature((CsmObject)csmScope)) {
                return csmScope;
            }
            if (CsmKindUtilities.isScopeElement((CsmObject)csmScope)) {
                csmObject2 = (CsmScopeElement)csmScope;
                continue;
            }
            if (csmScope != null) break;
            System.err.println("scope element without scope " + csmObject2);
            break;
        }
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return ((CsmOffsetable)csmObject).getContainingFile();
        }
        return null;
    }

    static boolean isLangContainerFeature(CsmObject csmObject) {
        assert (csmObject != null);
        return CsmKindUtilities.isFunction((CsmObject)csmObject) || CsmKindUtilities.isClass((CsmObject)csmObject) || CsmKindUtilities.isEnum((CsmObject)csmObject) || CsmKindUtilities.isNamespaceDefinition((CsmObject)csmObject) || CsmKindUtilities.isFile((CsmObject)csmObject);
    }

    private static String getHtml(CsmOffsetable csmOffsetable) {
        CsmFile csmFile = csmOffsetable.getContainingFile();
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
        BaseDocument baseDocument = null;
        String string = null;
        if (cloneableEditorSupport != null && cloneableEditorSupport.getDocument() instanceof BaseDocument) {
            baseDocument = (BaseDocument)cloneableEditorSupport.getDocument();
            try {
                int n = csmOffsetable.getStartOffset();
                int n2 = csmOffsetable.getEndOffset();
                int n3 = 1;
                if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetable) || CsmKindUtilities.isEnum((CsmObject)csmOffsetable)) {
                    n2 = n;
                    n3 = 0;
                } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetable)) {
                    n2 = ((CsmFunctionDefinition)csmOffsetable).getBody().getStartOffset() - 1;
                } else if (CsmKindUtilities.isClass((CsmObject)csmOffsetable)) {
                    n2 = ((CsmClass)csmOffsetable).getLeftBracketOffset() - 1;
                }
                int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                int n5 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n2) + n3;
                string = CsmRefactoringUtils.getHtml(n4, n5, -1, -1, baseDocument);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = CsmRefactoringUtils.htmlize(((Object)csmOffsetable.getText()).toString());
        }
        return string;
    }

    public static String getHtml(int n, int n2, int n3, int n4, BaseDocument baseDocument) throws BadLocationException {
        int n5 = n3 - n;
        int n6 = n4 - n;
        String string = baseDocument.getText(n, n2 - n);
        String string2 = (String)baseDocument.getProperty((Object)"mimeType");
        if (n5 >= 0 && n6 >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CsmRefactoringUtils.getHtml(string2, CsmRefactoringUtils.trimStart(string.substring(0, n5))));
            stringBuilder.append("<b>");
            stringBuilder.append(CsmRefactoringUtils.getHtml(string2, string.substring(n5, n6)));
            stringBuilder.append("</b>");
            stringBuilder.append(CsmRefactoringUtils.getHtml(string2, CsmRefactoringUtils.trimEnd(string.substring(n6))));
            return stringBuilder.toString();
        }
        return CsmRefactoringUtils.getHtml(string2, string);
    }

    public static String getHtml(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        Language language = CndLexerUtilities.getLanguage((String)string);
        if (language == null) {
            return string2;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string2, (Language)language);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        CsmRefactoringUtils.appendHtml(stringBuilder, tokenSequence);
        return stringBuilder.toString();
    }

    private static void appendHtml(StringBuilder stringBuilder, TokenSequence<?> tokenSequence) {
        Lookup lookup;
        String string;
        FontColorSettings fontColorSettings = null;
        LanguagePath languagePath = tokenSequence.languagePath();
        while (languagePath != null && fontColorSettings == null) {
            string = languagePath.mimePath();
            lookup = MimeLookup.getLookup((String)string);
            fontColorSettings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        }
        while (tokenSequence.moveNext()) {
            string = tokenSequence.token();
            lookup = tokenSequence.embedded();
            if (lookup != null && lookup.language() == CppTokenId.languagePreproc()) {
                CsmRefactoringUtils.appendHtml(stringBuilder, lookup);
                continue;
            }
            String string2 = string.id().primaryCategory();
            if (string2 == null) {
                string2 = "whitespace";
            }
            String string3 = "whitespace".equals(string2) ? " " : ((Object)string.text()).toString();
            if (fontColorSettings != null) {
                AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string2);
                stringBuilder.append(CsmRefactoringUtils.color(CsmRefactoringUtils.htmlize(string3), attributeSet));
                continue;
            }
            stringBuilder.append(string3);
        }
    }

    public static String htmlize(String string) {
        String string2 = org.openide.util.Utilities.replaceString((String)string, (String)"<", (String)"&lt;");
        string2 = org.openide.util.Utilities.replaceString((String)string2, (String)">", (String)"&gt;");
        return string2;
    }

    private static String color(String string, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return org.openide.util.Utilities.replaceString((String)org.openide.util.Utilities.replaceString((String)string, (String)" ", (String)"&nbsp;"), (String)"\n", (String)"<br>");
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (StyleConstants.isBold(attributeSet)) {
            stringBuilder.insert(0, "<b>");
            stringBuilder.append("</b>");
        }
        if (StyleConstants.isItalic(attributeSet)) {
            stringBuilder.insert(0, "<i>");
            stringBuilder.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(attributeSet)) {
            stringBuilder.insert(0, "<s>");
            stringBuilder.append("</s>");
        }
        stringBuilder.insert(0, "<font color=" + CsmRefactoringUtils.getHTMLColor(StyleConstants.getForeground(attributeSet)) + ">");
        stringBuilder.append("</font>");
        return stringBuilder.toString();
    }

    private static String getHTMLColor(Color color) {
        String string = "0" + Integer.toHexString(color.getRed());
        string = string.substring(string.length() - 2);
        String string2 = "0" + Integer.toHexString(color.getGreen());
        string2 = string2.substring(string2.length() - 2);
        String string3 = "0" + Integer.toHexString(color.getBlue());
        string3 = string3.substring(string3.length() - 2);
        String string4 = "#" + string + string2 + string3;
        return string4;
    }

    private static boolean isInObject(CsmObject csmObject, int n) {
        if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return false;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        return csmOffsetable.getStartOffset() <= n && n <= csmOffsetable.getEndOffset();
    }

    public static boolean isBeforeObject(CsmObject csmObject, int n) {
        if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return false;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        return n < csmOffsetable.getStartOffset();
    }

    public static CsmObject findInnerFileObject(CsmFile csmFile, int n) {
        assert (csmFile != null) : "can't be null file in findInnerFileObject";
        CsmDeclaration csmDeclaration = CsmRefactoringUtils.findInnerDeclaration(csmFile.getDeclarations().iterator(), n);
        return csmDeclaration;
    }

    private static CsmDeclaration findInnerDeclaration(Iterator<? extends CsmDeclaration> iterator, int n) {
        CsmDeclaration csmDeclaration = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                CsmDeclaration csmDeclaration2 = iterator.next();
                assert (csmDeclaration2 != null) : "can't be null declaration";
                if (CsmRefactoringUtils.isInObject((CsmObject)csmDeclaration2, n) && CsmRefactoringUtils.isLangContainerFeature((CsmObject)csmDeclaration2)) {
                    csmDeclaration = CsmRefactoringUtils.findInnerDeclaration(csmDeclaration2, n);
                    if (csmDeclaration != null) {
                        return csmDeclaration;
                    }
                    return csmDeclaration2;
                }
                if (!CsmRefactoringUtils.isBeforeObject((CsmObject)csmDeclaration2, n)) continue;
                break;
            }
        }
        return csmDeclaration;
    }

    private static CsmDeclaration findInnerDeclaration(CsmDeclaration csmDeclaration, int n) {
        assert (CsmRefactoringUtils.isInObject((CsmObject)csmDeclaration, n)) : "must be in outDecl object!";
        Iterator iterator = null;
        if (CsmKindUtilities.isNamespace((CsmObject)csmDeclaration)) {
            CsmNamespace csmNamespace = (CsmNamespace)csmDeclaration;
            iterator = csmNamespace.getDeclarations().iterator();
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmDeclaration)) {
            iterator = ((CsmNamespaceDefinition)csmDeclaration).getDeclarations().iterator();
        } else if (CsmKindUtilities.isClass((CsmObject)csmDeclaration)) {
            CsmClass csmClass = (CsmClass)csmDeclaration;
            iterator = csmClass.getMembers().iterator();
        } else if (CsmKindUtilities.isEnum((CsmObject)csmDeclaration)) {
            CsmEnum csmEnum = (CsmEnum)csmDeclaration;
            iterator = csmEnum.getEnumerators().iterator();
        }
        return CsmRefactoringUtils.findInnerDeclaration(iterator, n);
    }

    private static CsmObject findInnerFileObject(CsmOffsetable csmOffsetable) {
        CsmObject csmObject = CsmRefactoringUtils.findInnerFileObject(csmOffsetable.getContainingFile(), csmOffsetable.getStartOffset() - 1);
        if (csmObject == null) {
            csmObject = csmOffsetable.getContainingFile();
        }
        return csmObject;
    }

    private static String trimStart(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return string.substring(i, string.length());
        }
        return "";
    }

    private static String trimEnd(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return string.substring(0, i + 1);
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelfUID<T>
    implements CsmUID<T> {
        private final T element;

        SelfUID(T t) {
            this.element = t;
        }

        public T getObject() {
            return this.element;
        }
    }
}

