/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.LineBoxGroup;
import org.netbeans.modules.visualweb.css2.PageBox;
import org.netbeans.modules.visualweb.css2.TextBox;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.SelectionManager;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.openide.ErrorManager;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomInspector
extends TopComponent
implements TreeSelectionListener {
    private WebForm webform;
    private JTree tree;
    private JScrollPane scrollPane;
    private DefaultTreeModel treeModel;
    protected DefaultTreeSelectionModel treeSelectionModel;
    private boolean ignoreSelectionEvents;

    public DomInspector(WebForm webForm) {
        this.webform = webForm;
        this.setName("LayoutInspector");
        this.setDisplayName(DomInspector.getBundleString("LBL_DomInspector"));
        this.setToolTipText(this.getDisplayName());
    }

    public static void show(CssBox cssBox) {
        WebForm webForm = cssBox.getWebForm();
        DomInspector domInspector = DomInspector.createWindowIfNecessary(webForm);
        domInspector.selectBox(cssBox);
        SelectionManager selectionManager = webForm.getSelection();
        ArrayList<BoxNode> arrayList = new ArrayList<BoxNode>(selectionManager.getNumSelected());
        BoxNode boxNode = new BoxNode(cssBox);
        arrayList.add(boxNode);
        Node[] nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        DesignerUtils.setActivatedNodes(domInspector, nodeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectBox(CssBox cssBox) {
        TreePath treePath = this.getPath(cssBox);
        if (treePath != null) {
            this.ignoreSelectionEvents = true;
            try {
                this.tree.setSelectionPath(treePath);
                this.tree.makeVisible(treePath);
                this.tree.scrollPathToVisible(treePath);
            }
            finally {
                this.ignoreSelectionEvents = false;
            }
        }
    }

    private static DomInspector createWindowIfNecessary(WebForm webForm) {
        Mode mode;
        Object object2;
        Set set = WindowManager.getDefault().getModes();
        for (Object object2 : set) {
            mode = object2.getTopComponents();
            if (mode == null) continue;
            for (int i = 0; i < ((Mode)mode).length; ++i) {
                if (!(mode[i] instanceof DomInspector)) continue;
                DomInspector domInspector = (DomInspector)mode[i];
                if (domInspector.webform != webForm) continue;
                if (domInspector.treeModel != null && domInspector.treeModel.getRoot() instanceof BoxTreeNode && webForm.getPane() != null && ((BoxTreeNode)domInspector.treeModel.getRoot()).getBox() != webForm.getPane().getPageBox()) {
                    domInspector.refresh();
                }
                if (!domInspector.isShowing()) {
                    domInspector.requestVisible();
                }
                return domInspector;
            }
        }
        object2 = new DomInspector(webForm);
        mode = WindowManager.getDefault().findMode("explorer");
        if (mode != null) {
            mode.dockInto((TopComponent)object2);
        }
        object2.open();
        object2.requestActive();
        return object2;
    }

    private TreePath getPath(CssBox cssBox) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (this.treeModel == null) {
            return null;
        }
        BoxTreeNode boxTreeNode = (BoxTreeNode)this.treeModel.getRoot();
        boolean bl = this.findBox(cssBox, boxTreeNode, linkedList);
        if (bl && linkedList.size() > 0) {
            return new TreePath(linkedList.toArray(new Object[linkedList.size()]));
        }
        return null;
    }

    private boolean findBox(CssBox cssBox, BoxTreeNode boxTreeNode, LinkedList<Object> linkedList) {
        boolean bl = false;
        for (int i = 0; i < boxTreeNode.getChildCount(); ++i) {
            BoxTreeNode boxTreeNode2 = (BoxTreeNode)boxTreeNode.getChildAt(i);
            bl |= this.findBox(cssBox, boxTreeNode2, linkedList);
        }
        if (bl || boxTreeNode.getBox() == cssBox) {
            linkedList.addFirst(boxTreeNode);
            return true;
        }
        return false;
    }

    public void refresh() {
        PageBox pageBox = this.webform.getPane().getPageBox();
        BoxTreeNode boxTreeNode = new BoxTreeNode(pageBox, null);
        this.treeModel = new DefaultTreeModel(boxTreeNode);
        this.treeSelectionModel = new DefaultTreeSelectionModel();
        this.treeSelectionModel.addTreeSelectionListener(this);
        this.tree.setSelectionModel(this.treeSelectionModel);
        this.tree.setModel(this.treeModel);
    }

    protected void componentClosed() {
        this.remove(this.scrollPane);
        this.scrollPane = null;
        this.tree = null;
        this.treeModel = null;
        this.treeSelectionModel = null;
        super.componentClosed();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.tree = new JTree();
        this.tree.setRootVisible(true);
        this.scrollPane = new JScrollPane(this.tree);
        this.refresh();
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane, "Center");
    }

    public int getPersistenceType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.ignoreSelectionEvents) {
            return;
        }
        try {
            this.ignoreSelectionEvents = true;
            TreePath[] treePathArray = this.tree.getSelectionPaths();
            if (treePathArray == null || treePathArray.length == 0) {
                return;
            }
            for (int i = 0; i < treePathArray.length; ++i) {
                TreePath treePath = treePathArray[i];
                Object object = treePath.getLastPathComponent();
                if (!(object instanceof BoxTreeNode)) continue;
                BoxTreeNode boxTreeNode = (BoxTreeNode)object;
                CssBox cssBox = boxTreeNode.getBox();
                SelectionManager selectionManager = this.webform.getSelection();
                ArrayList<BoxNode> arrayList = new ArrayList<BoxNode>(selectionManager.getNumSelected());
                BoxNode boxNode = new BoxNode(cssBox);
                arrayList.add(boxNode);
                Node[] nodeArray = arrayList.toArray(new Node[arrayList.size()]);
                this.requestActive();
                DesignerUtils.setActivatedNodes(this, nodeArray);
                this.webform.getPane().getPageBox().setSelected(cssBox);
                break;
            }
        }
        finally {
            this.ignoreSelectionEvents = false;
        }
    }

    protected String preferredID() {
        return "dom-inspector";
    }

    private static Node.Property getElementNameProperty(final CssBox cssBox) {
        return new PropertySupport.ReadOnly<String>("elementName", String.class, "elementName", DomInspector.getBundleString("LBL_NameElement")){

            public String getValue() {
                Element element = cssBox.getElement();
                if (element != null) {
                    return element.getTagName();
                }
                if (cssBox.getBoxType() == BoxType.TEXT) {
                    return ((TextBox)cssBox).getText();
                }
                if (cssBox.getBoxType() == BoxType.SPACE) {
                    return DomInspector.getBundleString("TXT_Whitespace");
                }
                return DomInspector.getBundleString("TXT_NotElement");
            }
        };
    }

    private static Node.Property getElementIdProperty(final CssBox cssBox) {
        return new PropertySupport.ReadOnly<String>("elementId", String.class, "elementId", DomInspector.getBundleString("LBL_IdElement")){

            public String getValue() {
                Element element = cssBox.getElement();
                if (element != null) {
                    String string = element.getAttribute("id");
                    if (string != null) {
                        return string;
                    }
                    string = element.getAttribute("name");
                    if (string != null) {
                        return string;
                    }
                }
                return "";
            }
        };
    }

    private static Node.Property getAttributesProperty(final CssBox cssBox) {
        return new PropertySupport.ReadOnly<String>("attributes", String.class, "attributes", DomInspector.getBundleString("LBL_AttributesElement")){

            public String getValue() {
                Element element = cssBox.getElement();
                if (element != null) {
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    StringBuffer stringBuffer = new StringBuffer(200);
                    int n = namedNodeMap.getLength();
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuffer.append(',');
                            stringBuffer.append(' ');
                        }
                        org.w3c.dom.Node node = namedNodeMap.item(i);
                        stringBuffer.append(node.getNodeName());
                        stringBuffer.append('=');
                        stringBuffer.append('\"');
                        stringBuffer.append(node.getNodeValue());
                        stringBuffer.append('\"');
                    }
                    return stringBuffer.toString();
                }
                return "";
            }
        };
    }

    private static Node.Property getBeanNameDebugProperty(final CssBox cssBox) {
        return new PropertySupport.ReadOnly<String>("beanNameDebug", String.class, "beanNameDebug", DomInspector.getBundleString("LBL_BeanNameDebug")){

            public String getValue() {
                Element element;
                WebForm webForm = cssBox == null ? null : cssBox.getWebForm();
                String string = DomInspector.getComponentName(webForm, element = CssBox.getElementForComponentRootCssBox(cssBox));
                if (string == null) {
                    return "";
                }
                return string;
            }
        };
    }

    private static String getComponentName(WebForm webForm, Element element) {
        if (webForm == null) {
            return null;
        }
        if (element != null) {
            return "<" + webForm.getDomProviderService().getInstanceName(element) + ">";
        }
        return null;
    }

    private static Node.Property getRenderStreamProperty(final CssBox cssBox) {
        return new PropertySupport.ReadOnly<String>("renderStream", String.class, "renderStream", DomInspector.getBundleString("LBL_RenderStream")){

            public String getValue() {
                WebForm webForm;
                Element element = CssBox.getElementForComponentRootCssBox(cssBox);
                if (element == null) {
                    return "";
                }
                WebForm webForm2 = webForm = cssBox == null ? null : cssBox.getWebForm();
                if (webForm == null) {
                    return "";
                }
                return webForm.getDomProviderService().getHtmlStream(element);
            }
        };
    }

    private static Node.Property getLocalStylesProperty(final CssBox cssBox) {
        return new PropertySupport.ReadOnly<String>("localStyles", String.class, "localStyles", DomInspector.getBundleString("LBL_LocalStyles")){

            public String getValue() {
                String string;
                Element element = cssBox.getElement();
                if (element != null && (string = element.getAttribute("style")) != null) {
                    return string;
                }
                return "";
            }
        };
    }

    private static String getBundleString(String string) {
        return NbBundle.getMessage(DomInspector.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BoxNode
    extends AbstractNode {
        public static final String GENERAL = "general";
        private CssBox box;

        public BoxNode(CssBox cssBox) {
            super(Children.LEAF);
            this.box = cssBox;
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get(PropertiesAction.class)};
        }

        protected Sheet createSheet() {
            Node.Property property;
            Sheet sheet = Sheet.createDefault();
            Sheet.Set set = sheet.get(GENERAL);
            if (set == null) {
                set = new Sheet.Set();
                set.setName(GENERAL);
                set.setDisplayName(DomInspector.getBundleString("LBL_General"));
                set.setShortDescription(DomInspector.getBundleString("HINT_General"));
                sheet.put(set);
            }
            if (this.box instanceof TextBox) {
                property = DomInspector.getElementNameProperty(this.box);
                property.setName("Text");
                property.setDisplayName(DomInspector.getBundleString("LBL_Text"));
                set.put(property);
            } else {
                property = DomInspector.getElementNameProperty(this.box);
                property.setName("ElementName");
                property.setDisplayName(DomInspector.getBundleString("LBL_Element"));
                set.put(property);
                property = DomInspector.getElementIdProperty(this.box);
                property.setName("ElementId");
                property.setDisplayName(DomInspector.getBundleString("LBL_Id"));
                set.put(property);
                property = DomInspector.getAttributesProperty(this.box);
                property.setName("attributes");
                property.setDisplayName(DomInspector.getBundleString("LBL_Attributes"));
                set.put(property);
                property = DomInspector.getBeanNameDebugProperty(this.box);
                property.setName("BeanName");
                property.setDisplayName(DomInspector.getBundleString("LBL_BeanName"));
                set.put(property);
            }
            if (CssBox.getElementForComponentRootCssBox(this.box) != null) {
                set = sheet.get("jsf");
                if (set == null) {
                    set = new Sheet.Set();
                    set.setName("jsf");
                    set.setDisplayName(DomInspector.getBundleString("LBL_Jsf"));
                    sheet.put(set);
                }
                property = DomInspector.getRenderStreamProperty(this.box);
                property.setName("renderStream");
                property.setDisplayName(DomInspector.getBundleString("LBL_RenderedHtml"));
                set.put(property);
            }
            if ((set = sheet.get("css")) == null) {
                set = new Sheet.Set();
                set.setName("css");
                set.setDisplayName(DomInspector.getBundleString("LBL_CssStyles"));
                sheet.put(set);
            }
            try {
                property = DomInspector.getLocalStylesProperty(this.box);
                property.setName("localStyles");
                property.setDisplayName(DomInspector.getBundleString("LBL_LocalStyles"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, String.class, "getStyles", null);
                property.setName("styles");
                property.setDisplayName(DomInspector.getBundleString("LBL_Styles"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, String.class, "getComputedStyles", null);
                property.setName("compstyles");
                property.setDisplayName(DomInspector.getBundleString("LBL_ComputedStyles"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, String.class, "getRules", null);
                property.setName("rules");
                property.setDisplayName(DomInspector.getBundleString("LBL_Rules"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Color.class, "getBg", null);
                property.setName("bg");
                property.setDisplayName(DomInspector.getBundleString("LBL_Background"));
                set.put(property);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            set = sheet.get("boxmodel");
            if (set == null) {
                set = new Sheet.Set();
                set.setName("boxmodel");
                set.setDisplayName(DomInspector.getBundleString("LBL_BoxModel"));
                sheet.put(set);
            }
            try {
                property = new PropertySupport.Reflection((Object)this.box, Point.class, "getPosition", null);
                property.setName("position");
                property.setDisplayName(DomInspector.getBundleString("LBL_Position"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Point.class, "getRelPosition", null);
                property.setName("relposition");
                property.setDisplayName(DomInspector.getBundleString("LBL_RelPosition"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Dimension.class, "getSize", null);
                property.setName("size");
                property.setDisplayName(DomInspector.getBundleString("LBL_Size"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Dimension.class, "getContentSize", null);
                property.setName("contentsize");
                property.setDisplayName(DomInspector.getBundleString("LBL_ContentSize"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, String.class, "getBoxTypeName", null);
                property.setName("boxtype");
                property.setDisplayName(DomInspector.getBundleString("LBL_Positioning"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Rectangle.class, "getPositionRect", null);
                property.setName("positionrect");
                property.setDisplayName(DomInspector.getBundleString("LBL_PosConstraints"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Rectangle.class, "getMarginRectangle", null);
                property.setName("marginrectangle");
                property.setDisplayName(DomInspector.getBundleString("LBL_Margins"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Rectangle.class, "getCBRectangle", null);
                property.setName("cbrectangle");
                property.setDisplayName(DomInspector.getBundleString("LBL_ContainingBlock"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Rectangle.class, "getExtentsRectangle", null);
                property.setName("extentsrectangle");
                property.setDisplayName(DomInspector.getBundleString("LBL_Extents"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Rectangle.class, "getPaddingRectangle", null);
                property.setName("paddingrectangle");
                property.setDisplayName(DomInspector.getBundleString("LBL_Padding"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Rectangle.class, "getBorderWidthRectangle", null);
                property.setName("borderWidthrectangle");
                property.setDisplayName(DomInspector.getBundleString("LBL_BorderWidths"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Boolean.TYPE, "isInlineBox", null);
                property.setName("inline");
                property.setDisplayName(DomInspector.getBundleString("LBL_Inline"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Boolean.TYPE, "isReplacedBox", null);
                property.setName("replaced");
                property.setDisplayName(DomInspector.getBundleString("LBL_Replaced"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Integer.TYPE, "getBoxCount", null);
                property.setName("boxcount");
                property.setDisplayName(DomInspector.getBundleString("LBL_Children"));
                set.put(property);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
            set = sheet.get("csspainting");
            if (set == null) {
                set = new Sheet.Set();
                set.setName("csspainting");
                set.setDisplayName(DomInspector.getBundleString("LBL_BoxPainting"));
                sheet.put(set);
            }
            try {
                property = new PropertySupport.Reflection((Object)this.box, Boolean.TYPE, "getPaintPositions", "setPaintPositions");
                property.setName("paintpos");
                property.setDisplayName(DomInspector.getBundleString("LBL_PaintPositioning"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Boolean.TYPE, "getPaintText", "setPaintText");
                property.setName("painttext");
                property.setDisplayName(DomInspector.getBundleString("LBL_PaintText"));
                set.put(property);
                property = new PropertySupport.Reflection((Object)this.box, Boolean.TYPE, "getPaintSpaces", "setPaintSpaces");
                property.setName("paintspaces");
                property.setDisplayName(DomInspector.getBundleString("LBL_PaintSpaces"));
                set.put(property);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
            return sheet;
        }

        public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
            Node.Cookie cookie = super.getCookie(clazz);
            if (cookie != null) {
                return (T)cookie;
            }
            return null;
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        protected void createPasteTypes(Transferable transferable, List list) {
        }

        public final String getDisplayName() {
            return DomInspector.getBundleString("LBL_SelectedBox");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BoxTreeNode
    implements TreeNode {
        private CssBox box;
        private BoxTreeNode parent;
        private List<TreeNode> children;

        private BoxTreeNode(CssBox cssBox, BoxTreeNode boxTreeNode) {
            this.box = cssBox;
            this.parent = boxTreeNode;
        }

        @Override
        public TreeNode getChildAt(int n) {
            this.initializeChildren();
            return this.children.get(n);
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            this.initializeChildren();
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                if (this.children.get(i) != treeNode) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean isLeaf() {
            return this.box.getBoxCount() == 0;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getChildCount() {
            this.initializeChildren();
            return this.children.size();
        }

        @Override
        public boolean getAllowsChildren() {
            return this.isLeaf();
        }

        public Enumeration<TreeNode> children() {
            this.initializeChildren();
            return Collections.enumeration(this.children);
        }

        private void initializeChildren() {
            if (this.children != null) {
                return;
            }
            int n = this.box.getBoxCount();
            this.children = new ArrayList<TreeNode>(n);
            for (int i = 0; i < n; ++i) {
                this.children.add(new BoxTreeNode(this.box.getBox(i), this));
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(40);
            stringBuffer.append("<html>");
            Element element = this.box.getElement();
            if (this.box instanceof LineBoxGroup) {
                stringBuffer.append("<i>" + DomInspector.getBundleString("TXT_LineboxGroup") + "</i>");
            } else if (this.box.getBoxType() == BoxType.LINEBOX) {
                stringBuffer.append("<i>" + DomInspector.getBundleString("TXT_Linebox") + "</i>");
            } else if (this.box.getBoxType() == BoxType.TEXT) {
                stringBuffer.append("<b>");
                stringBuffer.append(((TextBox)this.box).getText());
                stringBuffer.append("</b>");
            } else if (this.box.getBoxType() == BoxType.SPACE) {
                stringBuffer.append(DomInspector.getBundleString("TXT_Space"));
            } else if (element != null) {
                stringBuffer.append("&lt;");
                stringBuffer.append(element.getTagName());
                stringBuffer.append("&gt;");
                stringBuffer.append(' ');
                WebForm webForm = this.box.getWebForm();
                if (element != null && (this.box.getParent() == null || element != CssBox.getElementForComponentRootCssBox(this.box))) {
                    stringBuffer.append("<i>");
                    stringBuffer.append(webForm.getDomProviderService().getInstanceName(element));
                    stringBuffer.append("</i>");
                }
            }
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }

        public CssBox getBox() {
            return this.box;
        }
    }
}

