/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.CustomButtonBox;
import org.netbeans.modules.visualweb.css2.FormComponentBox;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.InlineEditor;
import org.netbeans.modules.visualweb.designer.InteractionManager;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class FormComponentEditor
extends InlineEditor {
    private static final boolean EDIT_ADJACENT = Boolean.getBoolean("rave.edit-adjacent");
    protected JComponent inlineEditor;
    protected JTextComponent inlineTextEditor;
    private final Handler handler = new Handler();
    private CssBox box;
    private boolean hasBeenEdited = false;

    private FormComponentEditor(WebForm webForm, CssBox cssBox, DomProvider.InlineEditorSupport inlineEditorSupport) {
        super(webForm, inlineEditorSupport);
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + "()");
        }
        if (cssBox == null) {
            throw new IllegalArgumentException("Null CSS box.");
        }
        this.box = cssBox;
    }

    public static FormComponentEditor get(WebForm webForm, CssBox cssBox, Element element, DomProvider.InlineEditorSupport inlineEditorSupport) {
        CssBox cssBox2;
        Element element2;
        HtmlTag htmlTag;
        Node node = inlineEditorSupport.findXPathNodeForComponentRootElement(element);
        if (node != null && node.getNodeType() == 1 && (htmlTag = HtmlTag.getTag((String)(element2 = (Element)node).getTagName())) != null && htmlTag.isFormMemberTag() && (cssBox2 = webForm.findCssBoxForElement(element2)) != null) {
            cssBox = cssBox2;
        }
        if (!(cssBox instanceof FormComponentBox) && !(cssBox instanceof CustomButtonBox)) {
            return null;
        }
        if (cssBox instanceof FormComponentBox && ((FormComponentBox)cssBox).getComponent() == null) {
            return null;
        }
        if (!inlineEditorSupport.isEditingAllowed()) {
            return null;
        }
        return new FormComponentEditor(webForm, cssBox, inlineEditorSupport);
    }

    public void start(boolean bl, String string) {
        Serializable serializable;
        Serializable serializable2;
        int n;
        int n2;
        Serializable serializable3;
        Object object;
        Object object2;
        this.finish(true);
        JComponent jComponent = null;
        Element element = null;
        if (this.box instanceof FormComponentBox) {
            FormComponentBox formComponentBox = (FormComponentBox)this.box;
            jComponent = formComponentBox.getComponent();
            element = formComponentBox.getElement();
        } else if (this.box instanceof CustomButtonBox) {
            element = this.box.getElement();
        } else {
            FormComponentEditor.info(new IllegalStateException("Unsupported box type used, box=" + this.box));
            return;
        }
        boolean bl2 = EDIT_ADJACENT;
        float f = CssProvider.getValueService().getFontSizeForElement(element, this.webform.getDefaultFontSize());
        if (jComponent instanceof JTextField) {
            object2 = (JTextField)jComponent;
            object = FormComponentBox.createTextField(((JTextComponent)object2).getText(), ((JTextField)object2).getColumns());
            serializable3 = UIManager.getFont("TextField.font");
            ((JTextField)object).setFont(((Font)serializable3).deriveFont(f));
            this.inlineTextEditor = object;
            this.inlineEditor = this.inlineTextEditor;
            bl2 = false;
            n2 = jComponent.getWidth();
            n = jComponent.getHeight();
            serializable2 = this.inlineEditor.getPreferredSize();
            if (n2 < 10) {
                n2 = ((Dimension)serializable2).width;
            }
            if (n < 8) {
                n = ((Dimension)serializable2).height;
            }
        } else if (jComponent instanceof JScrollPane && ((JScrollPane)jComponent).getViewport().getView() instanceof JTextArea) {
            object2 = (JScrollPane)jComponent;
            object = (JTextArea)((JScrollPane)jComponent).getViewport().getView();
            serializable3 = FormComponentBox.createTextArea(((JTextComponent)object).getText(), ((JTextArea)object).getRows(), ((JTextArea)object).getColumns());
            serializable2 = new JScrollPane((Component)serializable3, ((JScrollPane)object2).getVerticalScrollBarPolicy(), ((JScrollPane)object2).getHorizontalScrollBarPolicy());
            serializable = UIManager.getFont("TextArea.font");
            ((JTextArea)serializable3).setFont(serializable.deriveFont(f));
            this.inlineEditor = serializable2;
            this.inlineTextEditor = serializable3;
            bl2 = false;
            n2 = jComponent.getWidth();
            n = jComponent.getHeight();
            Dimension dimension = this.inlineEditor.getPreferredSize();
            if (n2 < 10) {
                n2 = dimension.width;
            }
            if (n < 8) {
                n = dimension.height;
            }
        } else {
            object2 = FormComponentBox.createTextField();
            ((JTextField)object2).setColumns(9);
            this.inlineTextEditor = object2;
            this.inlineEditor = this.inlineTextEditor;
            if (!bl2) {
                object = CssProvider.getValueService().getColorForElement(element, 0);
                serializable3 = CssProvider.getValueService().getColorForElement(element, 20);
                if (object != null) {
                    this.inlineEditor.setBackground((Color)object);
                }
                if (serializable3 != null) {
                    this.inlineEditor.setForeground((Color)serializable3);
                }
                serializable2 = this.inlineEditor.getFont();
                this.inlineEditor.setFont(((Font)serializable2).deriveFont(f));
            }
            object = this.inlineEditor.getPreferredSize();
            if (this.box != null) {
                n2 = this.box.getWidth();
                n = this.box.getHeight();
            } else {
                n2 = CssUtilities.getCssLength(element, 58);
                n = CssUtilities.getCssLength(element, 31);
            }
            if (n2 == 0x7FFFFFFE) {
                n2 = ((Dimension)object).width;
            }
            if (bl2 || n == 0x7FFFFFFE) {
                n = ((Dimension)object).height;
            }
        }
        object2 = this.inlineEditorSupport.getValueSource();
        if (string != null && string.length() > 0) {
            object2 = bl ? string : (object2 == null ? string : (String)object2 + string);
            this.inlineTextEditor.setText((String)object2);
        } else if (object2 != null) {
            this.inlineTextEditor.setText((String)object2);
            if (bl) {
                this.inlineTextEditor.selectAll();
            }
        } else {
            object = element.getTagName();
            if (((String)object).equals(HtmlTag.INPUT.name) || ((String)object).equals(HtmlTag.TEXTAREA.name)) {
                this.inlineTextEditor.setText(element.getAttribute("value"));
                this.hasBeenEdited = true;
                if (bl) {
                    this.inlineTextEditor.selectAll();
                }
            } else {
                this.inlineTextEditor.setText("");
            }
        }
        if (this.inlineTextEditor instanceof JTextField) {
            ((JTextField)this.inlineTextEditor).addActionListener(this.handler);
        } else if (this.inlineTextEditor instanceof JTextArea) {
            ((JTextArea)this.inlineTextEditor).getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), new EnterAction());
            ((JTextArea)this.inlineTextEditor).getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(10, 2), new FinishAction());
            ((JTextArea)this.inlineTextEditor).getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(10, 1), new FinishAction());
        }
        this.inlineTextEditor.addFocusListener(this.handler);
        this.inlineTextEditor.getDocument().addDocumentListener(this.handler);
        this.inlineTextEditor.addMouseListener(this.handler);
        object = this.webform.getPane();
        ((Container)object).add(this.inlineEditor);
        int n3 = this.box.getAbsoluteX();
        int n4 = this.box.getAbsoluteY();
        if (bl2) {
            n4 += this.box.getHeight();
        }
        serializable = new Rectangle(n3, n4, n2, n);
        this.inlineEditor.setBounds((Rectangle)serializable);
        this.inlineEditor.validate();
        ((JComponent)object).scrollRectToVisible(new Rectangle((Rectangle)serializable));
        ((DesignerPane)object).repaint();
        if (this.webform.getSelection().isNodeUpdatePending()) {
            this.webform.getSelection().updateNodesImmediate();
        }
        this.inlineTextEditor.requestFocus();
    }

    public void finish(boolean bl) {
        Object object;
        if (this.inlineEditor == null) {
            return;
        }
        JComponent jComponent = this.inlineEditor;
        JTextComponent jTextComponent = this.inlineTextEditor;
        if (this.hasBeenEdited && !bl) {
            object = this.getText();
            if (object != null && ((String)object).length() == 0) {
                this.inlineEditorSupport.unset();
            } else {
                this.inlineEditorSupport.setValue((String)object);
            }
        }
        object = this.webform.getPane();
        boolean bl2 = this.inlineTextEditor != null && this.inlineTextEditor.hasFocus() || ((Component)object).hasFocus();
        this.inlineEditor = null;
        this.inlineTextEditor = null;
        ((DesignerPane)object).repaint();
        ((Container)object).remove(jComponent);
        if (jTextComponent instanceof JTextField) {
            ((JTextField)jTextComponent).removeActionListener(this.handler);
        } else if (jTextComponent instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)jTextComponent;
            jTextArea.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
            jTextArea.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 1));
            jTextArea.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 2));
        }
        if (jTextComponent != null) {
            jTextComponent.removeMouseListener(this.handler);
            jTextComponent.removeFocusListener(this.handler);
            jTextComponent.getDocument().removeDocumentListener(this.handler);
        }
        if (bl2) {
            ((JComponent)object).requestFocus();
        }
    }

    public boolean isDocumentEditor() {
        return false;
    }

    public boolean isEscaped() {
        return true;
    }

    public boolean isMultiLine() {
        return !this.isEscaped();
    }

    public boolean checkPosition(DomProvider.DomPosition domPosition) {
        return true;
    }

    private String getText() {
        String string = this.inlineTextEditor.getText();
        if (this.isEscaped()) {
            string = this.inlineEditorSupport.expandHtmlEntities(string, false);
        }
        return string;
    }

    public Transferable copyText(boolean bl) {
        String string = this.inlineTextEditor.getSelectedText();
        StringSelection stringSelection = new StringSelection(string);
        if (bl) {
            this.inlineTextEditor.replaceSelection("");
        }
        return stringSelection;
    }

    public void invokeDeleteNextCharAction(ActionEvent actionEvent) {
        JTextComponent jTextComponent = this.inlineEditor instanceof JTextComponent ? (JTextComponent)this.inlineEditor : (this.inlineEditor instanceof JScrollPane && ((JScrollPane)this.inlineEditor).getViewport().getView() instanceof JTextComponent ? (JTextComponent)((JScrollPane)this.inlineEditor).getViewport().getView() : null);
        if (jTextComponent == null) {
            return;
        }
        Action action = jTextComponent.getActionMap().get("delete-next");
        if (action != null) {
            action.actionPerformed(actionEvent);
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(FormComponentEditor.class.getName());
    }

    private static void info(Exception exception) {
        FormComponentEditor.getLogger().log(Level.INFO, null, exception);
    }

    class EnterAction
    extends AbstractAction {
        EnterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FormComponentEditor.this.inlineTextEditor == null) {
                return;
            }
            Document document = FormComponentEditor.this.inlineTextEditor.getDocument();
            try {
                int n = FormComponentEditor.this.inlineTextEditor.getCaretPosition();
                document.insertString(n, "\n", null);
            }
            catch (BadLocationException badLocationException) {
                FormComponentEditor.info(badLocationException);
            }
        }
    }

    class FinishAction
    extends AbstractAction {
        FinishAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FormComponentEditor.this.webform.getManager().finishInlineEditing(false);
        }
    }

    class Handler
    extends MouseInputAdapter
    implements FocusListener,
    ActionListener,
    DocumentListener {
        Handler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FormComponentEditor.this.webform.getManager().finishInlineEditing(false);
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            Component component;
            if (!focusEvent.isTemporary() || focusEvent.getComponent() instanceof JRootPane) {
                FormComponentEditor.this.webform.getManager().finishInlineEditing(false);
                focusEvent.getComponent().removeFocusListener(this);
                return;
            }
            if (focusEvent.isTemporary() && (component = focusEvent.getOppositeComponent()) instanceof JRootPane) {
                component.addFocusListener(this);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            FormComponentEditor.this.hasBeenEdited = true;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            FormComponentEditor.this.hasBeenEdited = true;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            FormComponentEditor.this.checkInitialDoubleClick(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            }
        }

        public void doPopup(MouseEvent mouseEvent) {
            FormComponentEditor.this.webform.fireUserPopupActionPerformed(new InteractionManager.DefaultDesignerPopupEvent(FormComponentEditor.this.webform, mouseEvent.getComponent(), null, null, mouseEvent.getX(), mouseEvent.getY()));
        }
    }
}

