/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.EnumeratorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumImpl
extends ClassEnumBase<CsmEnum>
implements CsmEnum,
CsmMember<CsmEnum> {
    private final List<CsmUID<CsmEnumerator>> enumerators = new ArrayList<CsmUID<CsmEnumerator>>();

    private EnumImpl(AST aST, CsmFile csmFile) {
        super(EnumImpl.findName(aST), csmFile, aST);
    }

    @Override
    protected void init(CsmScope csmScope, AST aST) {
        super.init(csmScope, aST);
        RepositoryUtils.hang(this);
        this.initEnumeratorList(aST);
        this.register(csmScope, true);
    }

    public static EnumImpl create(AST aST, CsmScope csmScope, CsmFile csmFile) {
        EnumImpl enumImpl = new EnumImpl(aST, csmFile);
        enumImpl.init(csmScope, aST);
        return enumImpl;
    }

    private static String findName(AST aST) {
        AST aST2;
        String string = AstUtil.findId(aST, 141);
        if ((string == null || string.length() == 0) && (aST2 = aST.getNextSibling()) != null && aST2.getType() == 203) {
            string = aST2.getText();
        }
        return string;
    }

    private void initEnumeratorList(AST aST) {
        AST aST2;
        for (aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (aST2.getType() != 275) continue;
            this.addList(aST2);
            return;
        }
        aST2 = aST.getNextSibling();
        if (aST2 != null) {
            if (aST2.getType() == 275) {
                this.addList(aST2);
                return;
            }
            if (aST2.getType() == 203 && (aST2 = aST2.getNextSibling()) != null && aST2.getType() == 275) {
                this.addList(aST2);
                return;
            }
        }
    }

    private void addList(AST aST) {
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (aST2.getType() != 203) continue;
            EnumeratorImpl enumeratorImpl = new EnumeratorImpl(aST2, this);
        }
    }

    public Collection<CsmEnumerator> getEnumerators() {
        Collection<CsmEnumerator> collection = UIDCsmConverter.UIDsToDeclarations(this.enumerators);
        return collection;
    }

    public void addEnumerator(CsmEnumerator csmEnumerator) {
        CsmUID csmUID = RepositoryUtils.put((CsmIdentifiable)csmEnumerator);
        this.enumerators.add((CsmUID<CsmEnumerator>)csmUID);
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return this.getEnumerators();
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.ENUM;
    }

    @Override
    public void dispose() {
        this._clearEnumerators();
        super.dispose();
    }

    private void _clearEnumerators() {
        Collection<CsmEnumerator> collection = this.getEnumerators();
        Utils.disposeAll(collection);
        RepositoryUtils.remove(this.enumerators);
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.enumerators, dataOutput, false);
    }

    public EnumImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.enumerators, dataInput);
    }
}

