/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

public class InheritanceImpl
extends OffsetableBase
implements CsmInheritance {
    private CsmVisibility visibility;
    private boolean virtual;
    private CsmUID<CsmClass> resolvedAncestorClassCacheUID;
    private CsmUID<CsmClassifier> classifierCacheUID;
    private CharSequence ancestorName;

    public InheritanceImpl(AST aST, CsmFile csmFile) {
        super(aST, csmFile);
        this.render(aST);
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public CsmClass getCsmClass() {
        return this.getCsmClass(null);
    }

    public CsmClass getCsmClass(Resolver resolver) {
        CsmClass csmClass = this._getAncestorCache();
        if (csmClass == null || !csmClass.isValid()) {
            csmClass = null;
            CsmClassifier csmClassifier = this.getCsmClassifier(resolver);
            if (CsmKindUtilities.isClass((CsmObject)(csmClassifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)csmClassifier)))) {
                csmClass = (CsmClass)csmClassifier;
            }
            this._setAncestorCache(csmClass);
        }
        return csmClass;
    }

    public CsmClassifier getCsmClassifier() {
        return this.getCsmClassifier(null);
    }

    public CsmClassifier getCsmClassifier(Resolver resolver) {
        CsmClassifier csmClassifier = this._getClassifierCache();
        if (csmClassifier == null || csmClassifier instanceof CsmValidable && !((CsmValidable)csmClassifier).isValid()) {
            csmClassifier = this.renderClassifier(this.ancestorName, resolver);
            this._setClassifierCache(csmClassifier);
        }
        return csmClassifier;
    }

    private void render(AST aST) {
        this.visibility = CsmVisibility.PRIVATE;
        block11: for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            switch (aST2.getType()) {
                case 81: {
                    this.visibility = CsmVisibility.PRIVATE;
                    continue block11;
                }
                case 79: {
                    this.visibility = CsmVisibility.PUBLIC;
                    continue block11;
                }
                case 80: {
                    this.visibility = CsmVisibility.PROTECTED;
                    continue block11;
                }
                case 40: {
                    this.virtual = true;
                    continue block11;
                }
                case 203: {
                    StringBuilder stringBuilder = new StringBuilder();
                    int n = 0;
                    while (aST2 != null) {
                        switch (aST2.getType()) {
                            case 203: {
                                stringBuilder.append(aST2.getText());
                                break;
                            }
                            case 176: {
                                stringBuilder.append("::");
                                ++n;
                                break;
                            }
                        }
                        aST2 = aST2.getNextSibling();
                    }
                    this.ancestorName = stringBuilder.toString();
                    this.ancestorName = n == 0 ? NameCache.getManager().getString(this.ancestorName) : QualifiedNameCache.getManager().getString(this.ancestorName);
                    return;
                }
            }
        }
    }

    private CsmClassifier renderClassifier(CharSequence charSequence, Resolver resolver) {
        CsmClassifier csmClassifier = null;
        CsmObject csmObject = ResolverFactory.createResolver(this, resolver).resolve(charSequence, 2);
        if (CsmKindUtilities.isClassifier((CsmObject)csmObject)) {
            csmClassifier = (CsmClassifier)csmObject;
        }
        return csmClassifier;
    }

    public CsmClass _getAncestorCache() {
        return UIDCsmConverter.UIDtoDeclaration(this.resolvedAncestorClassCacheUID);
    }

    public void _setAncestorCache(CsmClass csmClass) {
        this.resolvedAncestorClassCacheUID = UIDCsmConverter.declarationToUID(csmClass);
        assert (this.resolvedAncestorClassCacheUID != null || csmClass == null);
    }

    private CsmClassifier _getClassifierCache() {
        CsmClassifier csmClassifier = UIDCsmConverter.UIDtoDeclaration(this.classifierCacheUID);
        return csmClassifier;
    }

    private void _setClassifierCache(CsmClassifier csmClassifier) {
        this.classifierCacheUID = UIDCsmConverter.declarationToUID(csmClassifier);
        assert (this.classifierCacheUID != null || this.classifierCacheUID == null);
    }

    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeVisibility(this.visibility, dataOutput);
        dataOutput.writeBoolean(this.virtual);
        assert (this.ancestorName != null);
        dataOutput.writeUTF(((Object)this.ancestorName).toString());
        UIDObjectFactory.getDefaultFactory().writeUID(this.classifierCacheUID, dataOutput);
        boolean bl = this.resolvedAncestorClassCacheUID == this.classifierCacheUID;
        dataOutput.writeBoolean(bl);
        if (!bl) {
            UIDObjectFactory.getDefaultFactory().writeUID(this.resolvedAncestorClassCacheUID, dataOutput);
        }
    }

    public InheritanceImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.visibility = PersistentUtils.readVisibility(dataInput);
        this.virtual = dataInput.readBoolean();
        this.ancestorName = dataInput.readUTF();
        CharSequence charSequence = this.ancestorName = ((Object)this.ancestorName).toString().indexOf("::") == -1 ? NameCache.getManager().getString(this.ancestorName) : QualifiedNameCache.getManager().getString(this.ancestorName);
        assert (this.ancestorName != null);
        this.classifierCacheUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        boolean bl = dataInput.readBoolean();
        this.resolvedAncestorClassCacheUID = !bl ? UIDObjectFactory.getDefaultFactory().readUID(dataInput) : this.classifierCacheUID;
    }

    public String toString() {
        return "INHERITANCE " + this.visibility + " " + (this.isVirtual() ? "virtual " : "") + this.ancestorName + this.getOffsetString();
    }
}

