/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsingDeclarationImpl
extends OffsetableDeclarationBase<CsmUsingDeclaration>
implements CsmUsingDeclaration,
RawNamable {
    private final CharSequence name;
    private final int startOffset;
    private final CharSequence[] rawName;
    private CsmUID<CsmDeclaration> referencedDeclarationUID = null;

    public UsingDeclarationImpl(AST aST, CsmFile csmFile) {
        super(aST, csmFile);
        this.name = NameCache.getManager().getString((CharSequence)aST.getText());
        this.startOffset = ((CsmAST)aST.getFirstChild()).getOffset();
        this.rawName = AstUtil.getRawNameInChildren(aST);
    }

    public CsmDeclaration getReferencedDeclaration() {
        return this.getReferencedDeclaration(null);
    }

    public CsmDeclaration getReferencedDeclaration(Resolver resolver) {
        CsmDeclaration csmDeclaration = this._getReferencedDeclaration();
        if (csmDeclaration == null) {
            this._setReferencedDeclaration(null);
            ProjectBase projectBase = (ProjectBase)this.getProject();
            csmDeclaration = projectBase.findClassifier(this.name, true);
            if (csmDeclaration == null && this.rawName != null && this.rawName.length > 1) {
                CharSequence[] charSequenceArray = new CharSequence[this.rawName.length - 1];
                System.arraycopy(this.rawName, 0, charSequenceArray, 0, this.rawName.length - 1);
                CsmObject csmObject = ResolverFactory.createResolver(this.getContainingFile(), this.startOffset, resolver).resolve(charSequenceArray, 1);
                if (CsmKindUtilities.isNamespace((CsmObject)csmObject)) {
                    CharSequence charSequence = this.rawName[this.rawName.length - 1];
                    CsmDeclaration csmDeclaration2 = null;
                    for (CsmOffsetableDeclaration csmOffsetableDeclaration : ((CsmNamespace)csmObject).getDeclarations()) {
                        if (CharSequenceKey.Comparator.compare(charSequence, csmOffsetableDeclaration.getName()) != 0) continue;
                        if (!CsmKindUtilities.isExternVariable((CsmDeclaration)csmOffsetableDeclaration)) {
                            csmDeclaration = csmOffsetableDeclaration;
                            break;
                        }
                        csmDeclaration2 = csmOffsetableDeclaration;
                    }
                    csmDeclaration = csmDeclaration == null ? csmDeclaration2 : csmDeclaration;
                }
            }
            this._setReferencedDeclaration(csmDeclaration);
        }
        return csmDeclaration;
    }

    private CsmDeclaration _getReferencedDeclaration() {
        CsmDeclaration csmDeclaration = UIDCsmConverter.UIDtoDeclaration(this.referencedDeclarationUID);
        return csmDeclaration;
    }

    private void _setReferencedDeclaration(CsmDeclaration csmDeclaration) {
        this.referencedDeclarationUID = UIDCsmConverter.declarationToUID(csmDeclaration);
        assert (this.referencedDeclarationUID != null || csmDeclaration == null);
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.USING_DECLARATION;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        return this.getName();
    }

    @Override
    public CharSequence[] getRawName() {
        return this.rawName;
    }

    public CsmScope getScope() {
        return null;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
        dataOutput.writeInt(this.startOffset);
        PersistentUtils.writeStrings(this.rawName, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.referencedDeclarationUID, dataOutput);
    }

    public UsingDeclarationImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null);
        this.startOffset = dataInput.readInt();
        this.rawName = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.referencedDeclarationUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

