/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VariableDefinitionImpl
extends VariableImpl<CsmVariableDefinition>
implements CsmVariableDefinition {
    private CsmUID<CsmVariable> declarationUID;
    private CharSequence qualifiedName;
    private final CharSequence[] classOrNspNames;

    public VariableDefinitionImpl(AST aST, CsmFile csmFile, CsmType csmType, String string) {
        super(aST, csmFile, csmType, VariableDefinitionImpl.getLastname(string), false);
        this.classOrNspNames = VariableDefinitionImpl.getClassOrNspNames(aST);
        this.registerInProject();
    }

    private static String getLastname(String string) {
        int n = string.lastIndexOf("::");
        if (n >= 0) {
            string = string.substring(n + 2);
        }
        return string;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.VARIABLE_DEFINITION;
    }

    public CsmVariable getDeclaration() {
        CsmVariable csmVariable = this._getDeclaration();
        if (csmVariable == null) {
            this._setDeclaration(null);
            csmVariable = this.findDeclaration();
            this._setDeclaration(csmVariable);
        }
        return csmVariable;
    }

    private CsmVariable _getDeclaration() {
        return UIDCsmConverter.UIDtoDeclaration(this.declarationUID);
    }

    private void _setDeclaration(CsmVariable csmVariable) {
        this.declarationUID = UIDCsmConverter.declarationToUID(csmVariable);
        assert (this.declarationUID != null || csmVariable == null);
    }

    @Override
    public CharSequence getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = QualifiedNameCache.getManager().getString((CharSequence)this.findQualifiedName());
        }
        return this.qualifiedName;
    }

    private String findQualifiedName() {
        CsmVariable csmVariable = this._getDeclaration();
        if (csmVariable != null) {
            return ((Object)csmVariable.getQualifiedName()).toString();
        }
        CsmObject csmObject = this.findOwner();
        if (csmObject instanceof CsmQualifiedNamedElement) {
            return ((CsmQualifiedNamedElement)csmObject).getQualifiedName() + "::" + this.getQualifiedNamePostfix();
        }
        CharSequence[] charSequenceArray = this.classOrNspNames;
        CsmNamespaceDefinition csmNamespaceDefinition = this.findNamespaceDefinition();
        StringBuilder stringBuilder = new StringBuilder();
        if (csmNamespaceDefinition != null) {
            stringBuilder.append(csmNamespaceDefinition.getQualifiedName());
        }
        if (charSequenceArray != null) {
            for (int i = 0; i < charSequenceArray.length; ++i) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("::");
                }
                stringBuilder.append(charSequenceArray[i]);
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("unknown>");
        }
        stringBuilder.append("::");
        stringBuilder.append(this.getQualifiedNamePostfix());
        return stringBuilder.toString();
    }

    private CsmNamespaceDefinition findNamespaceDefinition() {
        return this.findNamespaceDefinition(this.getContainingFile().getDeclarations());
    }

    private CsmNamespaceDefinition findNamespaceDefinition(Collection collection) {
        CsmOffsetableDeclaration csmOffsetableDeclaration;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && (csmOffsetableDeclaration = (CsmOffsetableDeclaration)iterator.next()).getStartOffset() <= this.getStartOffset()) {
            if (csmOffsetableDeclaration.getKind() != CsmDeclaration.Kind.NAMESPACE_DEFINITION || this.getEndOffset() >= csmOffsetableDeclaration.getEndOffset()) continue;
            CsmNamespaceDefinition csmNamespaceDefinition = (CsmNamespaceDefinition)csmOffsetableDeclaration;
            CsmNamespaceDefinition csmNamespaceDefinition2 = this.findNamespaceDefinition(csmNamespaceDefinition.getDeclarations());
            return csmNamespaceDefinition2 == null ? csmNamespaceDefinition : csmNamespaceDefinition2;
        }
        return null;
    }

    private CsmVariable findDeclaration() {
        String string = CsmDeclaration.Kind.VARIABLE.toString() + ':' + this.getQualifiedName();
        CsmDeclaration csmDeclaration = this.getContainingFile().getProject().findDeclaration((CharSequence)string);
        if (csmDeclaration == null) {
            CsmObject csmObject = this.findOwner();
            if (csmObject instanceof CsmClass) {
                csmDeclaration = this.findByName(((CsmClass)csmObject).getMembers(), this.getName());
            } else if (csmObject instanceof CsmNamespace) {
                csmDeclaration = this.findByName(((CsmNamespace)csmObject).getDeclarations(), this.getName());
            }
        }
        return (CsmVariable)csmDeclaration;
    }

    private CsmVariable findByName(Collection collection, CharSequence charSequence) {
        for (CsmDeclaration csmDeclaration : collection) {
            if (!csmDeclaration.getName().equals(charSequence) || !(csmDeclaration instanceof CsmVariable)) continue;
            return (CsmVariable)csmDeclaration;
        }
        return null;
    }

    private CsmObject findOwner() {
        CharSequence[] charSequenceArray = this.classOrNspNames;
        if (charSequenceArray != null) {
            CsmObject csmObject = ResolverFactory.createResolver(this).resolve(charSequenceArray, 3);
            if (csmObject instanceof CsmClass) {
                if (!(csmObject instanceof Unresolved.UnresolvedClass)) {
                    return (CsmClass)csmObject;
                }
            } else if (csmObject instanceof CsmNamespace) {
                return (CsmNamespace)csmObject;
            }
        }
        return null;
    }

    private static String[] getClassOrNspNames(AST aST) {
        AST aST2 = VariableDefinitionImpl.getQialifiedId(aST);
        if (aST2 == null) {
            return null;
        }
        int n = aST2.getNumberOfChildren();
        if (n >= 1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (AST aST3 = aST2.getFirstChild(); aST3 != null; aST3 = aST3.getNextSibling()) {
                if (aST3.getType() != 203 || aST3.getNextSibling() == null) continue;
                arrayList.add(aST3.getText());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    private static AST getQialifiedId(AST aST) {
        AST aST2 = aST;
        for (AST aST3 = aST2.getFirstChild(); aST3 != null; aST3 = aST3.getNextSibling()) {
            switch (aST3.getType()) {
                case 313: 
                case 314: {
                    aST3 = aST3.getFirstChild();
                    return aST3;
                }
                case 203: 
                case 281: {
                    return aST3;
                }
            }
        }
        return null;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeUTF(this.qualifiedName, dataOutput);
        PersistentUtils.writeStrings(this.classOrNspNames, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.declarationUID, dataOutput);
    }

    public VariableDefinitionImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.qualifiedName = PersistentUtils.readUTF(dataInput);
        if (this.qualifiedName != null) {
            this.qualifiedName = QualifiedNameCache.getManager().getString(this.qualifiedName);
        }
        this.classOrNspNames = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.declarationUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

