/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.ChangeEventImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ListenersImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.PersistentKey;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Notificator {
    private static ThreadLocal<Notificator> instance = new ThreadLocal<Notificator>(){

        @Override
        protected Notificator initialValue() {
            return new Notificator();
        }
    };
    private int transactionLevel = 0;
    private ChangeEventImpl currEvent;
    private ModelImpl model;

    private Notificator() {
        if (CsmModelAccessor.getModel() instanceof ModelImpl) {
            this.model = (ModelImpl)CsmModelAccessor.getModel();
        }
    }

    public static Notificator instance() {
        return instance.get();
    }

    private String getCurrThreadString() {
        Thread thread = Thread.currentThread();
        return thread.getName() + ' ' + thread.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransaction() {
        Notificator notificator = this;
        synchronized (notificator) {
            ++this.transactionLevel;
            if (TraceFlags.DEBUG) {
                Diagnostic.trace("    > " + this.transactionLevel + ' ' + this.getCurrThreadString());
            }
            this.resetEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        Notificator notificator = this;
        synchronized (notificator) {
            --this.transactionLevel;
            if (TraceFlags.DEBUG) {
                Diagnostic.trace("    < " + this.transactionLevel + ' ' + this.getCurrThreadString());
            }
            if (this.transactionLevel <= 0) {
                this.flush();
            }
        }
    }

    private ChangeEventImpl getEvent() {
        if (this.currEvent == null) {
            ChangeEventImpl changeEventImpl;
            this.currEvent = changeEventImpl = new ChangeEventImpl(this);
        }
        return this.currEvent;
    }

    private void resetEvent() {
        this.currEvent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Notificator notificator = this;
        synchronized (notificator) {
            this.resetEvent();
        }
    }

    private boolean isEventEmpty() {
        return this.currEvent == null || this.currEvent.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNewFile(CsmFile csmFile) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addNewFile(csmFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemovedFile(CsmFile csmFile) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addRemovedFile(csmFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangedFile(CsmFile csmFile) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addChangedFile(csmFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNewDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addNewDeclaration(csmOffsetableDeclaration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemovedDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addRemovedDeclaration(csmOffsetableDeclaration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangedDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmOffsetableDeclaration csmOffsetableDeclaration2) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addChangedDeclaration(csmOffsetableDeclaration, csmOffsetableDeclaration2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNewNamespace(CsmNamespace csmNamespace) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addNewNamespace(csmNamespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemovedNamespace(CsmNamespace csmNamespace) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addRemovedNamespace(csmNamespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ChangeEventImpl changeEventImpl;
        Object object = this;
        synchronized (object) {
            this.transactionLevel = 0;
            if (this.isEventEmpty()) {
                return;
            }
            changeEventImpl = this.getEvent();
            this.resetEvent();
        }
        object = new IdMaker(){

            public Object id(Object object) {
                return ((CsmFile)object).getAbsolutePath();
            }
        };
        Notificator.processFiles((IdMaker)object, changeEventImpl.getNewFiles(), changeEventImpl.getRemovedFiles(), changeEventImpl.getChangedFiles());
        object = new IdMaker(){

            public Object id(Object object) {
                return PersistentKey.createKey((CsmOffsetableDeclaration)object);
            }
        };
        Notificator.processDeclarations((IdMaker)object, changeEventImpl.getNewDeclarations(), changeEventImpl.getRemovedDeclarations(), changeEventImpl.getChangedDeclarations());
        Notificator.gatherProjects(changeEventImpl);
        ListenersImpl.getImpl().fireModelChanged(changeEventImpl);
    }

    private static void gatherProjects(ChangeEventImpl changeEventImpl) {
        Collection<CsmProject> collection = changeEventImpl.getChangedProjects();
        Collection[] collectionArray = new Collection[]{changeEventImpl.getNewFiles(), changeEventImpl.getChangedFiles(), changeEventImpl.getRemovedFiles()};
        for (int i = 0; i < collectionArray.length; ++i) {
            Iterator iterator = collectionArray[i].iterator();
            while (iterator.hasNext()) {
                collection.add(((CsmFile)iterator.next()).getProject());
            }
        }
        Collection[] collectionArray2 = new Collection[]{changeEventImpl.getNewDeclarations(), changeEventImpl.getChangedDeclarations().values(), changeEventImpl.getRemovedDeclarations()};
        for (int i = 0; i < collectionArray2.length; ++i) {
            for (Object e : collectionArray2[i]) {
                if (!(e instanceof CsmOffsetableDeclaration)) continue;
                collection.add(((CsmOffsetableDeclaration)e).getContainingFile().getProject());
            }
        }
    }

    private static void processFiles(IdMaker idMaker, Collection collection, Collection collection2, Collection collection3) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            hashSet.add(idMaker.id(object2.next()));
        }
        object2 = new HashSet();
        Object object3 = collection2.iterator();
        while (object3.hasNext()) {
            object2.add(idMaker.id(object3.next()));
        }
        object3 = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (Object e : collection2) {
            object = idMaker.id(e);
            if (hashSet.contains(object)) {
                collection3.add(e);
                continue;
            }
            hashSet2.add(e);
        }
        for (Object e : collection) {
            object = idMaker.id(e);
            if (object2.contains(object)) continue;
            object3.add(e);
        }
        collection.clear();
        collection.addAll(object3);
        collection2.clear();
        collection2.addAll(hashSet2);
    }

    private static void processDeclarations(IdMaker idMaker, Collection<CsmOffsetableDeclaration> collection, Collection<CsmOffsetableDeclaration> collection2, Map<CsmOffsetableDeclaration, CsmOffsetableDeclaration> map) {
        Object object;
        HashMap<Object, CsmOffsetableDeclaration> hashMap = new HashMap<Object, CsmOffsetableDeclaration>();
        for (CsmOffsetableDeclaration object32 : collection) {
            hashMap.put(idMaker.id(object32), object32);
        }
        HashMap hashMap2 = new HashMap();
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : collection2) {
            hashMap2.put(idMaker.id(csmOffsetableDeclaration), csmOffsetableDeclaration);
        }
        HashSet<CsmOffsetableDeclaration> hashSet = new HashSet<CsmOffsetableDeclaration>();
        HashSet<CsmOffsetableDeclaration> hashSet2 = new HashSet<CsmOffsetableDeclaration>();
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : collection2) {
            object = idMaker.id(csmOffsetableDeclaration);
            if (hashMap.containsKey(object)) {
                map.put(csmOffsetableDeclaration, (CsmOffsetableDeclaration)hashMap.get(object));
                continue;
            }
            hashSet2.add(csmOffsetableDeclaration);
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : collection) {
            object = idMaker.id(csmOffsetableDeclaration);
            if (hashMap2.containsKey(object)) continue;
            hashSet.add(csmOffsetableDeclaration);
        }
        collection.clear();
        collection.addAll(hashSet);
        collection2.clear();
        if (hashSet2.size() > 0) {
            for (CsmOffsetableDeclaration csmOffsetableDeclaration : hashSet2) {
                object = csmOffsetableDeclaration.getUniqueName();
                CsmProject csmProject = csmOffsetableDeclaration.getContainingFile().getProject();
                CsmOffsetableDeclaration csmOffsetableDeclaration2 = (CsmOffsetableDeclaration)csmProject.findDeclaration((CharSequence)object);
                if (csmOffsetableDeclaration2 != null) {
                    map.put(csmOffsetableDeclaration, csmOffsetableDeclaration2);
                    continue;
                }
                collection2.add(csmOffsetableDeclaration);
            }
        }
    }

    private static interface IdMaker {
        public Object id(Object var1);
    }
}

