/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThread;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.openide.util.RequestProcessor;

public class ParserThreadManager {
    private static ParserThreadManager instance;
    private static final String threadNameBase = "Code Model Parser";
    private RequestProcessor processor;
    private Set<Wrapper> wrappers = new CopyOnWriteArraySet<Wrapper>();
    private int currThread = 0;

    private ParserThreadManager() {
    }

    public static synchronized ParserThreadManager instance() {
        if (instance == null) {
            instance = new ParserThreadManager();
        }
        return instance;
    }

    public boolean isStandalone() {
        return this.processor == null;
    }

    void startup(boolean bl) {
        ParserQueue.instance().startup();
        int n = Integer.getInteger("cnd.modelimpl.parser.threads", Runtime.getRuntime().availableProcessors());
        n = Math.min(n, 4);
        n = Math.max(n, 1);
        if (!bl) {
            this.processor = new RequestProcessor(threadNameBase, n);
        }
        for (int i = 0; i < n; ++i) {
            Wrapper wrapper = new Wrapper(new ParserThread());
            if (bl) {
                new Thread(wrapper).start();
                continue;
            }
            this.processor.post((Runnable)wrapper);
        }
    }

    void shutdown() {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("=== ParserThreadManager.shutdown");
        }
        for (Wrapper wrapper : this.wrappers) {
            wrapper.stop();
        }
        ParserQueue.instance().shutdown();
    }

    public boolean isParserThread() {
        if (this.isStandalone()) {
            Thread thread = Thread.currentThread();
            for (Wrapper wrapper : this.wrappers) {
                if (wrapper.thread != thread) continue;
                return true;
            }
            return false;
        }
        return this.processor.isRequestProcessorThread();
    }

    public void waitEmptyProjectQueue(ProjectBase projectBase) {
        ParserQueue.instance().waitEmpty(projectBase);
    }

    private class Wrapper
    implements Runnable {
        private ParserThread delegate;
        private Thread thread;

        public Wrapper(ParserThread parserThread) {
            this.delegate = parserThread;
        }

        public void stop() {
            assert (this.delegate != null);
            this.delegate.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.thread = Thread.currentThread();
                this.thread.setName("Code Model Parser " + ParserThreadManager.this.currThread++);
                ParserThreadManager.this.wrappers.add(this);
                this.delegate.run();
            }
            catch (Throwable throwable) {
                DiagnosticExceptoins.register(throwable);
            }
            finally {
                ParserThreadManager.this.wrappers.remove(this);
            }
        }
    }
}

