/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

public class ExpressionBase
extends OffsetableBase
implements CsmExpression {
    private CsmExpression.Kind kind;
    private final CsmExpression parent;
    private List<CsmExpression> operands;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;

    public ExpressionBase(AST aST, CsmFile csmFile, CsmExpression csmExpression, CsmScope csmScope) {
        super(aST, csmFile);
        this.parent = csmExpression;
        if (csmScope != null) {
            this.setScope(csmScope);
        }
    }

    public CsmExpression.Kind getKind() {
        return this.kind;
    }

    public CsmScope getScope() {
        CsmScope csmScope = this.scopeRef;
        if (csmScope == null) {
            csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (csmScope != null || this.scopeUID == null) : "null object for UID " + this.scopeUID;
        }
        return csmScope;
    }

    protected void setScope(CsmScope csmScope) {
        if (csmScope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
            assert (this.scopeUID != null || csmScope == null);
        } else {
            this.scopeRef = csmScope;
        }
    }

    public List getOperands() {
        if (this.operands == null) {
            this.operands = new ArrayList<CsmExpression>();
        }
        return this.operands;
    }

    public CsmExpression getParent() {
        return this.parent;
    }

    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeExpression(this.parent, dataOutput);
        PersistentUtils.writeExpressionKind(this.kind, dataOutput);
        PersistentUtils.writeExpressions(this.operands, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
    }

    public ExpressionBase(DataInput dataInput) throws IOException {
        super(dataInput);
        this.parent = PersistentUtils.readExpression(dataInput);
        this.kind = PersistentUtils.readExpressionKind(dataInput);
        this.operands = PersistentUtils.readExpressions(new ArrayList(), dataInput);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

