/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileElementsCollector {
    private final CsmFile destFile;
    private int destOffset;
    private final CsmProject onlyInProject;
    private Set<CsmFile> visitedFiles = new HashSet<CsmFile>();
    private final ProjectBase project;
    private LinkedHashSet<CsmNamespace> directVisibleNamespaces = new LinkedHashSet();
    private LinkedHashSet<CsmUsingDirective> usingNamespaces = new LinkedHashSet();
    private LinkedHashSet<CsmNamespaceAlias> namespaceAliases = new LinkedHashSet();
    private LinkedHashSet<CsmUsingDeclaration> usingDeclarations = new LinkedHashSet();
    private CsmTypedef currTypedef;
    private String[] names;
    private int currNamIdx;
    private CsmNamespace containingNamespace;
    private CsmClass containingClass;
    private Collection<CsmDeclaration> visibleUsedDeclarations = null;
    private Collection<CsmNamespace> visibleNamespaces = null;
    private boolean contextFound = false;
    private boolean mapsGathered = false;

    public FileElementsCollector(CsmFile csmFile, int n, CsmProject csmProject) {
        this.destFile = csmFile;
        this.project = (ProjectBase)csmFile.getProject();
        this.destOffset = n;
        this.onlyInProject = csmProject;
    }

    private String currName() {
        return this.names != null && this.currNamIdx < this.names.length ? this.names[this.currNamIdx] : "";
    }

    private CsmNamespace getContainingNamespace() {
        this.initContext();
        return this.containingNamespace;
    }

    private CsmClass getContainingClass() {
        this.initContext();
        return this.containingClass;
    }

    public Collection<CsmUsingDeclaration> getUsingDeclarations() {
        this.initMaps();
        return Collections.unmodifiableCollection(this.usingDeclarations);
    }

    public Collection<CsmUsingDirective> getUsingDirectives() {
        this.initMaps();
        return Collections.unmodifiableCollection(this.usingNamespaces);
    }

    public Collection<CsmNamespaceAlias> getNamespaceAliases() {
        this.initMaps();
        return Collections.unmodifiableCollection(this.namespaceAliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmDeclaration> getUsedDeclarations() {
        this.initMaps();
        LinkedHashSet<CsmUsingDeclaration> linkedHashSet = this.usingDeclarations;
        synchronized (linkedHashSet) {
            if (this.visibleUsedDeclarations == null) {
                this.visibleUsedDeclarations = CsmUsingResolver.extractDeclarations(this.usingDeclarations);
            }
        }
        return Collections.unmodifiableCollection(this.visibleUsedDeclarations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmNamespace> getVisibleNamespaces() {
        this.initMaps();
        LinkedHashSet<CsmUsingDirective> linkedHashSet = this.usingNamespaces;
        synchronized (linkedHashSet) {
            if (this.visibleNamespaces == null) {
                this.visibleNamespaces = CsmUsingResolver.extractNamespaces(this.usingNamespaces);
                this.visibleNamespaces.addAll(this.directVisibleNamespaces);
            }
        }
        return Collections.unmodifiableCollection(this.visibleNamespaces);
    }

    private synchronized void initContext() {
        if (this.contextFound) {
            return;
        }
        this.contextFound = true;
        this.findContext(this.destFile.getDeclarations());
    }

    private synchronized void initMaps() {
        if (this.mapsGathered) {
            return;
        }
        this.mapsGathered = true;
        this.gatherFileMaps(this.destFile);
    }

    private boolean isInside(CsmOffsetable csmOffsetable, int n) {
        return csmOffsetable.getStartOffset() < n && n < csmOffsetable.getEndOffset();
    }

    private void findContext(Iterable iterable) {
        for (CsmDeclaration csmDeclaration : iterable) {
            CsmFunction csmFunction;
            Object object;
            CsmNamespaceDefinition csmNamespaceDefinition;
            if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmDeclaration)) {
                csmNamespaceDefinition = (CsmNamespaceDefinition)csmDeclaration;
                if (!this.isInside((CsmOffsetable)csmNamespaceDefinition, this.destOffset)) continue;
                this.containingNamespace = csmNamespaceDefinition.getNamespace();
                this.findContext(csmNamespaceDefinition.getDeclarations());
                continue;
            }
            if (CsmKindUtilities.isClass((CsmObject)csmDeclaration)) {
                csmNamespaceDefinition = (CsmClass)csmDeclaration;
                if (!this.isInside((CsmOffsetable)csmNamespaceDefinition, this.destOffset)) continue;
                this.containingClass = csmNamespaceDefinition;
                if (csmNamespaceDefinition.getFriends().size() > 0) {
                    object = new TreeSet<CsmOffsetable>(FileImpl.START_OFFSET_COMPARATOR);
                    object.addAll(csmNamespaceDefinition.getMembers());
                    object.addAll(csmNamespaceDefinition.getFriends());
                } else {
                    object = csmNamespaceDefinition.getMembers();
                }
                this.findContext((Iterable)object);
                continue;
            }
            if (!CsmKindUtilities.isFunctionDefinition((CsmObject)csmDeclaration) || !this.isInside((CsmOffsetable)(csmNamespaceDefinition = (CsmFunctionDefinition)csmDeclaration), this.destOffset)) continue;
            object = this.getFunctionDefinitionNamespace((CsmFunctionDefinition)csmNamespaceDefinition);
            if (object != null && !object.isGlobal()) {
                this.containingNamespace = object;
            }
            if ((csmFunction = this.getFunctionDeclaration((CsmFunctionDefinition)csmNamespaceDefinition)) == null || !CsmKindUtilities.isMethodDeclaration((CsmObject)csmFunction)) continue;
            this.containingClass = ((CsmMethod)csmFunction).getContainingClass();
        }
    }

    private CsmFunction getFunctionDeclaration(CsmFunctionDefinition csmFunctionDefinition) {
        return csmFunctionDefinition.getDeclaration();
    }

    private CsmNamespace getFunctionDefinitionNamespace(CsmFunctionDefinition csmFunctionDefinition) {
        CsmFunction csmFunction = this.getFunctionDeclaration(csmFunctionDefinition);
        if (csmFunction != null) {
            CsmScope csmScope = csmFunction.getScope();
            if (CsmKindUtilities.isNamespace((CsmObject)csmScope)) {
                CsmNamespace csmNamespace = (CsmNamespace)csmScope;
                return csmNamespace;
            }
            if (CsmKindUtilities.isClass((CsmObject)csmScope)) {
                return this.getClassNamespace((CsmClass)csmScope);
            }
        }
        return null;
    }

    private CsmNamespace getClassNamespace(CsmClass csmClass) {
        CsmScope csmScope = csmClass.getScope();
        while (csmScope != null) {
            if (CsmKindUtilities.isNamespace((CsmObject)csmScope)) {
                return (CsmNamespace)csmScope;
            }
            if (!CsmKindUtilities.isScopeElement((CsmObject)csmScope)) break;
            csmScope = ((CsmScopeElement)csmScope).getScope();
        }
        return null;
    }

    protected void gatherFileMaps(CsmFile csmFile) {
        if (this.visitedFiles.contains(csmFile)) {
            return;
        }
        this.visitedFiles.add(csmFile);
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            CsmFile csmFile2;
            if (csmInclude.getEndOffset() >= this.destOffset || (csmFile2 = csmInclude.getIncludeFile()) == null || this.onlyInProject != null && csmFile2.getProject() != this.onlyInProject) continue;
            int n = this.destOffset;
            this.destOffset = Integer.MAX_VALUE;
            this.gatherFileMaps(csmFile2);
            this.destOffset = n;
        }
        this.gatherDeclarationsMaps(csmFile.getDeclarations());
    }

    protected void gatherDeclarationsMaps(Iterable iterable) {
        for (CsmOffsetable csmOffsetable : iterable) {
            try {
                int n = csmOffsetable.getStartOffset();
                int n2 = csmOffsetable.getEndOffset();
                if (n >= this.destOffset) break;
                if (CsmKindUtilities.isScopeElement((CsmObject)csmOffsetable)) {
                    this.gatherScopeElementMaps((CsmScopeElement)csmOffsetable, n2);
                    continue;
                }
                if (!FileImpl.reportErrors) continue;
                System.err.println("Expected CsmScopeElement, got " + csmOffsetable);
            }
            catch (NullPointerException nullPointerException) {
                if (!FileImpl.reportErrors) continue;
                System.err.println("Unexpected NULL element in declarations collection");
                DiagnosticExceptoins.register(nullPointerException);
            }
        }
    }

    private void doProcessTypedefsInUpperNamespaces(CsmNamespaceDefinition csmNamespaceDefinition) {
        for (CsmDeclaration csmDeclaration : csmNamespaceDefinition.getDeclarations()) {
            if (csmDeclaration.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
                this.processTypedefsInUpperNamespaces((CsmNamespaceDefinition)csmDeclaration);
                continue;
            }
            if (csmDeclaration.getKind() != CsmDeclaration.Kind.TYPEDEF) continue;
            CsmTypedef csmTypedef = (CsmTypedef)csmDeclaration;
            if (!this.currName().equals(csmTypedef.getName())) continue;
            this.currTypedef = csmTypedef;
        }
    }

    private void processTypedefsInUpperNamespaces(CsmNamespaceDefinition csmNamespaceDefinition) {
        if (csmNamespaceDefinition.getName().equals(this.currName())) {
            ++this.currNamIdx;
            this.doProcessTypedefsInUpperNamespaces(csmNamespaceDefinition);
        } else {
            CsmNamespace csmNamespace = this.getContainingNamespace();
            if (csmNamespace != null && csmNamespace.equals(csmNamespaceDefinition.getNamespace())) {
                this.doProcessTypedefsInUpperNamespaces(csmNamespaceDefinition);
            }
        }
    }

    protected void gatherScopeElementMaps(CsmScopeElement csmScopeElement, int n) {
        CsmDeclaration.Kind kind;
        CsmDeclaration.Kind kind2 = kind = CsmKindUtilities.isDeclaration((CsmObject)csmScopeElement) ? ((CsmDeclaration)csmScopeElement).getKind() : null;
        if (kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            CsmNamespaceDefinition csmNamespaceDefinition = (CsmNamespaceDefinition)csmScopeElement;
            if (csmNamespaceDefinition.getName().length() == 0) {
                this.directVisibleNamespaces.add(csmNamespaceDefinition.getNamespace());
            }
            if (this.destOffset < n) {
                this.directVisibleNamespaces.remove(csmNamespaceDefinition.getNamespace());
                this.directVisibleNamespaces.add(csmNamespaceDefinition.getNamespace());
                this.gatherDeclarationsMaps(csmNamespaceDefinition.getDeclarations());
            }
        } else if (kind == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            CsmNamespaceAlias csmNamespaceAlias = (CsmNamespaceAlias)csmScopeElement;
            this.namespaceAliases.add(csmNamespaceAlias);
        } else if (kind == CsmDeclaration.Kind.USING_DECLARATION) {
            CsmUsingDeclaration csmUsingDeclaration = (CsmUsingDeclaration)csmScopeElement;
            this.usingDeclarations.add(csmUsingDeclaration);
        } else if (kind == CsmDeclaration.Kind.USING_DIRECTIVE) {
            CsmUsingDirective csmUsingDirective = (CsmUsingDirective)csmScopeElement;
            this.usingNamespaces.add(csmUsingDirective);
        } else if (CsmKindUtilities.isDeclarationStatement((CsmObject)csmScopeElement)) {
            CsmDeclarationStatement csmDeclarationStatement = (CsmDeclarationStatement)csmScopeElement;
            if (csmDeclarationStatement.getStartOffset() < this.destOffset) {
                this.gatherDeclarationsMaps(((CsmDeclarationStatement)csmScopeElement).getDeclarators());
            }
        } else if (CsmKindUtilities.isScope((CsmObject)csmScopeElement)) {
            if (this.destOffset < n) {
                this.gatherDeclarationsMaps(((CsmScope)csmScopeElement).getScopeElements());
            }
        } else if (kind == CsmDeclaration.Kind.TYPEDEF) {
            CsmTypedef csmTypedef = (CsmTypedef)csmScopeElement;
            if (this.currName().equals(csmTypedef.getName())) {
                this.currTypedef = csmTypedef;
            }
        }
    }
}

