/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.modelimpl.cache.CacheManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.AbstractFileBuffer;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

public class FileBufferDoc
extends AbstractFileBuffer {
    private Document doc;
    private EventListenerList listeners = new EventListenerList();
    private DocumentListener docListener;
    private long lastModified;

    public FileBufferDoc(File file, Document document) {
        super(file);
        this.doc = document;
        this.resetLastModified();
    }

    private void resetLastModified() {
        this.lastModified = System.currentTimeMillis();
    }

    private void fireDocumentChanged() {
        this.resetLastModified();
        EventListener[] eventListenerArray = this.listeners.getListeners(ChangeListener.class);
        if (eventListenerArray.length > 0) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = 0; i < eventListenerArray.length; ++i) {
                ((ChangeListener)eventListenerArray[i]).stateChanged(changeEvent);
            }
        }
        if (TraceFlags.USE_AST_CACHE) {
            CacheManager.getInstance().invalidate(this.getFile().getAbsolutePath());
        } else {
            APTDriver.getInstance().invalidateAPT((APTFileBuffer)this);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners.getListenerCount() == 0) {
            this.docListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    FileBufferDoc.this.fireDocumentChanged();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    FileBufferDoc.this.fireDocumentChanged();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }
            };
            this.doc.addDocumentListener(this.docListener);
        }
        this.listeners.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(ChangeListener.class, changeListener);
        if (this.listeners.getListenerCount() == 0) {
            this.doc.removeDocumentListener(this.docListener);
            this.docListener = null;
        }
    }

    private IOException convert(BadLocationException badLocationException) {
        IOException iOException = new IOException(badLocationException.getMessage());
        iOException.setStackTrace(badLocationException.getStackTrace());
        return iOException;
    }

    public InputStream getInputStream() throws IOException {
        try {
            String string = this.doc.getText(0, this.doc.getLength());
            return new ByteArrayInputStream(string.getBytes());
        }
        catch (BadLocationException badLocationException) {
            throw this.convert(badLocationException);
        }
    }

    public String getText() throws IOException {
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw this.convert(badLocationException);
        }
    }

    public String getText(int n, int n2) throws IOException {
        try {
            return this.doc.getText(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            throw this.convert(badLocationException);
        }
    }

    public int getLength() {
        return this.doc.getLength();
    }

    public boolean isFileBased() {
        return false;
    }

    public long lastModified() {
        return this.lastModified;
    }
}

