/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.netbeans.modules.cnd.modelimpl.repository.DeclarationContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileKey;
import org.netbeans.modules.cnd.modelimpl.repository.GraphContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.IncludeKey;
import org.netbeans.modules.cnd.modelimpl.repository.MacroKey;
import org.netbeans.modules.cnd.modelimpl.repository.NamespaceKey;
import org.netbeans.modules.cnd.modelimpl.repository.OffsetableDeclarationKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectNameBasedKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectSettingsValidatorKey;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.support.KeyFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyObjectFactory
extends KeyFactory {
    private static final int FIRST_INDEX = 1;
    public static final int KEY_PROJECT_KEY = 1;
    public static final int KEY_NAMESPACE_KEY = 2;
    public static final int KEY_FILE_KEY = 3;
    public static final int KEY_MACRO_KEY = 4;
    public static final int KEY_INCLUDE_KEY = 5;
    public static final int KEY_DECLARATION_KEY = 6;
    public static final int KEY_PRJ_VALIDATOR_KEY = 7;
    public static final int KEY_DECLARATION_CONTAINER_KEY = 8;
    public static final int KEY_FILE_CONTAINER_KEY = 9;
    public static final int KEY_GRAPH_CONTAINER_KEY = 10;
    public static final int LAST_INDEX = 10;

    public void writeKey(Key key, DataOutput dataOutput) throws IOException {
        assert (key instanceof SelfPersistent);
        super.writeSelfPersistent((SelfPersistent)key, dataOutput);
    }

    public Key readKey(DataInput dataInput) throws IOException {
        assert (dataInput != null);
        SelfPersistent selfPersistent = super.readSelfPersistent(dataInput);
        assert (selfPersistent instanceof Key);
        return (Key)selfPersistent;
    }

    public void writeKeyCollection(Collection<Key> collection, DataOutput dataOutput) throws IOException {
        assert (collection != null);
        assert (dataOutput != null);
        int n = collection.size();
        dataOutput.writeInt(n);
        for (Key key : collection) {
            assert (key != null);
            this.writeKey(key, dataOutput);
        }
    }

    public void readKeyCollection(Collection<Key> collection, DataInput dataInput) throws IOException {
        assert (collection != null);
        assert (dataInput != null);
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            Key key = this.readKey(dataInput);
            assert (key != null);
            collection.add(key);
        }
    }

    protected int getHandler(Object object) {
        int n;
        if (object instanceof ProjectKey) {
            n = 1;
        } else if (object instanceof NamespaceKey) {
            n = 2;
        } else if (object instanceof FileKey) {
            n = 3;
        } else if (object instanceof MacroKey) {
            n = 4;
        } else if (object instanceof IncludeKey) {
            n = 5;
        } else if (object instanceof OffsetableDeclarationKey) {
            n = 6;
        } else if (object instanceof ProjectSettingsValidatorKey) {
            n = 7;
        } else if (object instanceof DeclarationContainerKey) {
            n = 8;
        } else if (object instanceof FileContainerKey) {
            n = 9;
        } else if (object instanceof GraphContainerKey) {
            n = 10;
        } else {
            throw new IllegalArgumentException("The Key is an instance of the unknown final class " + object.getClass().getName());
        }
        return n;
    }

    protected SelfPersistent createObject(int n, DataInput dataInput) throws IOException {
        ProjectNameBasedKey projectNameBasedKey;
        switch (n) {
            case 1: {
                projectNameBasedKey = new ProjectKey(dataInput);
                break;
            }
            case 2: {
                projectNameBasedKey = new NamespaceKey(dataInput);
                break;
            }
            case 3: {
                projectNameBasedKey = new FileKey(dataInput);
                break;
            }
            case 4: {
                projectNameBasedKey = new MacroKey(dataInput);
                break;
            }
            case 5: {
                projectNameBasedKey = new IncludeKey(dataInput);
                break;
            }
            case 6: {
                projectNameBasedKey = new OffsetableDeclarationKey(dataInput);
                break;
            }
            case 7: {
                projectNameBasedKey = new ProjectSettingsValidatorKey(dataInput);
                break;
            }
            case 8: {
                projectNameBasedKey = new DeclarationContainerKey(dataInput);
                break;
            }
            case 9: {
                projectNameBasedKey = new FileContainerKey(dataInput);
                break;
            }
            case 10: {
                projectNameBasedKey = new GraphContainerKey(dataInput);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown hander was provided: " + n);
            }
        }
        return projectNameBasedKey;
    }
}

