/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.repository.AbstractKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;

abstract class ProjectNameBasedKey
extends AbstractKey {
    protected final int unitIndex;

    protected ProjectNameBasedKey(String string) {
        assert (string != null);
        this.unitIndex = KeyUtilities.getUnitId(string);
    }

    public String toString() {
        return ((Object)this.getProjectName()).toString();
    }

    public int hashCode() {
        return this.unitIndex;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ProjectNameBasedKey projectNameBasedKey = (ProjectNameBasedKey)object;
        return this.unitIndex == projectNameBasedKey.unitIndex;
    }

    protected CharSequence getProjectName() {
        return this.getUnit();
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.unitIndex);
    }

    protected ProjectNameBasedKey(DataInput dataInput) throws IOException {
        this.unitIndex = dataInput.readInt();
    }

    public int getDepth() {
        return 0;
    }

    public CharSequence getAt(int n) {
        throw new UnsupportedOperationException();
    }

    public CharSequence getUnit() {
        return KeyUtilities.getUnitName(this.unitIndex);
    }
}

