/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.debug.DebugUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.FileKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyHolder;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryListenerImpl;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.api.RepositoryAccessor;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryUtils {
    private static final boolean TRACE_REPOSITORY_ACCESS = DebugUtils.getBoolean((String)"cnd.modelimpl.trace.repository", (boolean)false);
    private static int CURRENT_VERSION_OF_PERSISTENCY = 27;
    private static volatile int counter = 0;

    private RepositoryUtils() {
    }

    public static <T extends CsmIdentifiable> T get(CsmUID<T> csmUID) {
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        Persistent persistent = RepositoryUtils.get(key);
        assert (persistent == null || persistent instanceof CsmIdentifiable);
        return (T)((CsmIdentifiable)persistent);
    }

    public static Persistent tryGet(Key key) {
        assert (key != null);
        Persistent persistent = RepositoryAccessor.getRepository().tryGet(key);
        if (TRACE_REPOSITORY_ACCESS) {
            System.err.printf("%d:trying key %s got %s", RepositoryUtils.nextIndex(), key, persistent);
        }
        return persistent;
    }

    public static Persistent get(Key key) {
        assert (key != null);
        long l = 0L;
        int n = 0;
        if (TRACE_REPOSITORY_ACCESS) {
            n = RepositoryUtils.nextIndex();
            l = System.currentTimeMillis();
            System.err.println(n + ":getting key " + key);
        }
        Persistent persistent = RepositoryAccessor.getRepository().get(key);
        if (TRACE_REPOSITORY_ACCESS) {
            l = System.currentTimeMillis() - l;
            System.err.println(n + ":got in " + l + "ms the key " + key);
        }
        return persistent;
    }

    private static synchronized int nextIndex() {
        return counter++;
    }

    public static void remove(CsmUID csmUID) {
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        if (key != null) {
            long l = 0L;
            int n = 0;
            if (TRACE_REPOSITORY_ACCESS) {
                n = RepositoryUtils.nextIndex();
                l = System.currentTimeMillis();
                System.err.println(n + ":removing key " + key);
            }
            if (!TraceFlags.SAFE_REPOSITORY_ACCESS) {
                RepositoryAccessor.getRepository().remove(key);
            }
            if (TRACE_REPOSITORY_ACCESS) {
                l = System.currentTimeMillis() - l;
                System.err.println(n + ":removed in " + l + "ms the key " + key);
            }
        }
    }

    public static void remove(Collection<? extends CsmUID> collection) {
        if (collection != null) {
            for (CsmUID csmUID : collection) {
                RepositoryUtils.remove(csmUID);
            }
        }
    }

    public static CsmUID put(CsmIdentifiable csmIdentifiable) {
        CsmUID csmUID = null;
        if (csmIdentifiable != null) {
            csmUID = csmIdentifiable.getUID();
            assert (csmUID != null);
            Key key = RepositoryUtils.UIDtoKey(csmUID);
            RepositoryUtils.put(key, (Persistent)csmIdentifiable);
        }
        return csmUID;
    }

    public static void put(Key key, Persistent persistent) {
        if (key != null) {
            long l = 0L;
            int n = 0;
            if (TRACE_REPOSITORY_ACCESS) {
                n = RepositoryUtils.nextIndex();
                l = System.currentTimeMillis();
                System.err.println(n + ":putting key " + key);
            }
            RepositoryAccessor.getRepository().put(key, persistent);
            if (key instanceof FileKey) {
                RepositoryAccessor.getRepository().hang(key, persistent);
            }
            if (TRACE_REPOSITORY_ACCESS) {
                l = System.currentTimeMillis() - l;
                System.err.println(n + ":put in " + l + "ms the key " + key);
            }
        }
    }

    public static void hang(CsmIdentifiable csmIdentifiable) {
        CsmUID csmUID = null;
        if (csmIdentifiable != null) {
            csmUID = csmIdentifiable.getUID();
            assert (csmUID != null);
            Key key = RepositoryUtils.UIDtoKey(csmUID);
            RepositoryUtils.hang(key, (Persistent)csmIdentifiable);
        }
    }

    public static void hang(Key key, Persistent persistent) {
        if (key != null) {
            long l = 0L;
            int n = 0;
            if (TRACE_REPOSITORY_ACCESS) {
                n = RepositoryUtils.nextIndex();
                l = System.currentTimeMillis();
                System.err.println(n + ":hanging key " + key);
            }
            RepositoryAccessor.getRepository().hang(key, persistent);
            if (TRACE_REPOSITORY_ACCESS) {
                l = System.currentTimeMillis() - l;
                System.err.println(n + ":hung in " + l + "ms the key " + key);
            }
        }
    }

    public static <T extends CsmOffsetableDeclaration> List<CsmUID<T>> put(List<T> list) {
        assert (list != null);
        ArrayList<CsmUID<T>> arrayList = new ArrayList<CsmUID<T>>(list.size());
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : list) {
            CsmUID csmUID = RepositoryUtils.put((CsmIdentifiable)csmOffsetableDeclaration);
            arrayList.add(csmUID);
        }
        return arrayList;
    }

    public static Key UIDtoKey(CsmUID csmUID) {
        if (csmUID instanceof KeyHolder) {
            return ((KeyHolder)csmUID).getKey();
        }
        return null;
    }

    public static CharSequence getUnitName(CsmUID csmUID) {
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        assert (key != null);
        CharSequence charSequence = key.getUnit();
        return charSequence;
    }

    public static void startup() {
        Repository repository = RepositoryAccessor.getRepository();
        repository.startup(CURRENT_VERSION_OF_PERSISTENCY);
        repository.unregisterRepositoryListener((RepositoryListener)RepositoryListenerImpl.instance());
        repository.registerRepositoryListener((RepositoryListener)RepositoryListenerImpl.instance());
    }

    public static void shutdown() {
        RepositoryAccessor.getRepository().shutdown();
    }

    public static void cleanCashes() {
        RepositoryAccessor.getRepository().cleanCaches();
    }

    public static void closeUnit(CsmUID csmUID, Set<String> set, boolean bl) {
        RepositoryUtils.closeUnit(RepositoryUtils.UIDtoKey(csmUID), set, bl);
    }

    public static void closeUnit(String string, Set<String> set) {
        RepositoryUtils.closeUnit(string, set, !TraceFlags.PERSISTENT_REPOSITORY);
    }

    public static void closeUnit(String string, Set<String> set, boolean bl) {
        RepositoryListenerImpl.instance().onExplicitClose(string);
        RepositoryAccessor.getRepository().closeUnit(string, bl, set);
    }

    public static void closeUnit(Key key, Set<String> set) {
        RepositoryUtils.closeUnit(key, set, !TraceFlags.PERSISTENT_REPOSITORY);
    }

    public static void closeUnit(Key key, Set<String> set, boolean bl) {
        assert (key != null);
        RepositoryAccessor.getRepository().closeUnit(((Object)key.getUnit()).toString(), bl, set);
    }

    public static void onProjectDeleted(NativeProject nativeProject) {
        Key key = KeyUtilities.createProjectKey(nativeProject);
        RepositoryAccessor.getRepository().removeUnit(((Object)key.getUnit()).toString());
    }

    public static void openUnit(ProjectBase projectBase) {
        CsmUID<CsmProject> csmUID = projectBase.getUID();
        assert (csmUID != null);
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        RepositoryUtils.openUnit(key);
    }

    public static void openUnit(Key key) {
        RepositoryUtils.openUnit(((Object)key.getUnit()).toString());
    }

    private static void openUnit(String string) {
        RepositoryListenerImpl.instance().onExplicitOpen(string);
        RepositoryAccessor.getRepository().openUnit(string);
    }

    public static void unregisterRepositoryListener(RepositoryListener repositoryListener) {
        RepositoryAccessor.getRepository().unregisterRepositoryListener(repositoryListener);
    }

    static int getUnitId(String string) {
        return RepositoryAccessor.getTranslator().getUnitId(string);
    }

    static String getUnitName(int n) {
        return RepositoryAccessor.getTranslator().getUnitName(n);
    }

    static int getFileIdByName(int n, String string) {
        return RepositoryAccessor.getTranslator().getFileIdByName(n, string);
    }

    static String getFileNameByIdSafe(int n, int n2) {
        return RepositoryAccessor.getTranslator().getFileNameByIdSafe(n, n2);
    }

    static String getFileNameById(int n, int n2) {
        return RepositoryAccessor.getTranslator().getFileNameById(n, n2);
    }
}

