/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.diff;

import java.io.Serializable;

public class Difference
implements Serializable {
    public static final int DELETE = 0;
    public static final int ADD = 1;
    public static final int CHANGE = 2;
    private int type = 0;
    private int firstStart = 0;
    private int firstEnd = 0;
    private int secondStart = 0;
    private int secondEnd = 0;
    private Part[] firstLineDiffs;
    private Part[] secondLineDiffs;
    private String firstText;
    private String secondText;
    private static final long serialVersionUID = 7638201981188907148L;

    public Difference(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, null, null, null, null);
    }

    public Difference(int n, int n2, int n3, int n4, int n5, String string, String string2) {
        this(n, n2, n3, n4, n5, string, string2, null, null);
    }

    public Difference(int n, int n2, int n3, int n4, int n5, String string, String string2, Part[] partArray, Part[] partArray2) {
        if (n > 2 || n < 0) {
            throw new IllegalArgumentException("Bad Difference type = " + n);
        }
        this.type = n;
        this.firstStart = n2;
        this.firstEnd = n3;
        this.secondStart = n4;
        this.secondEnd = n5;
        this.firstText = string;
        this.secondText = string2;
        this.firstLineDiffs = partArray;
        this.secondLineDiffs = partArray2;
    }

    public int getType() {
        return this.type;
    }

    public int getFirstStart() {
        return this.firstStart;
    }

    public int getFirstEnd() {
        return this.firstEnd;
    }

    public int getSecondStart() {
        return this.secondStart;
    }

    public int getSecondEnd() {
        return this.secondEnd;
    }

    public Part[] getFirstLineDiffs() {
        return this.firstLineDiffs;
    }

    public Part[] getSecondLineDiffs() {
        return this.secondLineDiffs;
    }

    public String getFirstText() {
        return this.firstText;
    }

    public String getSecondText() {
        return this.secondText;
    }

    public String toString() {
        return "Difference(" + (this.type == 1 ? "ADD" : (this.type == 0 ? "DELETE" : "CHANGE")) + ", " + this.firstStart + ", " + this.firstEnd + ", " + this.secondStart + ", " + this.secondEnd + ")";
    }

    public static final class Part
    implements Serializable {
        private int type;
        private int line;
        private int pos1;
        private int pos2;
        private String text;
        private static final long serialVersionUID = 7638201981188907149L;

        public Part(int n, int n2, int n3, int n4) {
            if (n > 2 || n < 0) {
                throw new IllegalArgumentException("Bad Difference type = " + n);
            }
            this.type = n;
            this.line = n2;
            this.pos1 = n3;
            this.pos2 = n4;
        }

        public int getType() {
            return this.type;
        }

        public int getLine() {
            return this.line;
        }

        public int getStartPosition() {
            return this.pos1;
        }

        public int getEndPosition() {
            return this.pos2;
        }
    }
}

