/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.AddServerInstanceAction;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ServerRegistryNode
extends AbstractNode
implements ServerRegistry.PluginListener,
InstanceListener {
    static final String SERVERS_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/Servers.png";
    private transient HelpCtx helpCtx;
    private static ServerRegistryNode instance;

    private ServerRegistryNode() {
        super((Children)new ServerChildren());
        this.setName("");
        this.setDisplayName(NbBundle.getMessage(ServerRegistryNode.class, (String)"SERVER_REGISTRY_NODE"));
        this.setShortDescription(NbBundle.getMessage(ServerRegistryNode.class, (String)"SERVER_REGISTRY_SHORT_DESCRIPTION"));
        this.setIconBaseWithExtension(SERVERS_ICON);
    }

    public void serverAdded(Server server) {
        this.updateKeys();
    }

    public void serverRemoved(Server server) {
        this.updateKeys();
    }

    public void instanceAdded(String string) {
        this.updateKeys();
    }

    public void instanceRemoved(String string) {
        this.updateKeys();
    }

    public void changeDefaultInstance(String string, String string2) {
    }

    private void updateKeys() {
        ((ServerChildren)this.getChildren()).updateKeys();
    }

    public Action[] getActions(boolean bl) {
        return new SystemAction[]{SystemAction.get(AddServerInstanceAction.class)};
    }

    public HelpCtx getHelpCtx() {
        if (this.helpCtx == null) {
            this.helpCtx = new HelpCtx(NbBundle.getBundle(ServerRegistryNode.class).getString("nodes_server_registry_node_html"));
        }
        return this.helpCtx;
    }

    public static synchronized ServerRegistryNode getServerRegistryNode() {
        assert (false) : "This shouldn't be invoked anymore";
        if (instance == null) {
            instance = new ServerRegistryNode();
        }
        return instance;
    }

    private static class ServerChildren
    extends Children.Keys {
        private boolean listenersAdded = false;

        protected void addNotify() {
            this.updateKeys();
            if (!this.listenersAdded) {
                ServerRegistryNode serverRegistryNode = (ServerRegistryNode)this.getNode();
                ServerRegistry.getInstance().addPluginListener(serverRegistryNode);
                ServerRegistry.getInstance().addInstanceListener(serverRegistryNode);
                this.listenersAdded = true;
            }
        }

        protected Node[] createNodes(Object object) {
            ServerInstance serverInstance = (ServerInstance)object;
            if (serverInstance == null) {
                return new Node[0];
            }
            StartServer startServer = serverInstance.getStartServer();
            if (startServer == null) {
                return new Node[0];
            }
            Node node = startServer.isAlsoTargetServer(null) ? serverInstance.getServer().getNodeProvider().createInstanceTargetNode(serverInstance) : serverInstance.getServer().getNodeProvider().createInstanceNode(serverInstance);
            serverInstance.refresh();
            return new Node[]{node};
        }

        public void updateKeys() {
            ArrayList<ServerInstance> arrayList = new ArrayList<ServerInstance>();
            for (Server server : ServerRegistry.getInstance().getServers()) {
                ServerInstance[] serverInstanceArray = server.getInstances();
                for (int i = 0; i < serverInstanceArray.length; ++i) {
                    arrayList.add(serverInstanceArray[i]);
                }
            }
            Collections.sort(arrayList);
            this.setKeys(arrayList);
        }
    }
}

