/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.DebugAction;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;

public class RefreshAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(DebugAction.class, (String)"LBL_Refresh");
    }

    protected void performAction(Node[] nodeArray) {
        RefreshAction.performActionImpl(nodeArray);
    }

    protected boolean enable(Node[] nodeArray) {
        return RefreshAction.enableImpl(nodeArray);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static void performActionImpl(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            ServerInstance serverInstance = (ServerInstance)nodeArray[i].getCookie(ServerInstance.class);
            RefreshAction.performActionImpl(serverInstance);
        }
    }

    private static void performActionImpl(ServerInstance serverInstance) {
        if (serverInstance != null) {
            serverInstance.refresh();
        }
    }

    private static boolean enableImpl(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            ServerInstance serverInstance = (ServerInstance)nodeArray[i].getCookie(ServerInstance.class);
            if (RefreshAction.enableImpl(serverInstance)) continue;
            return false;
        }
        return true;
    }

    private static boolean enableImpl(ServerInstance serverInstance) {
        return serverInstance != null && serverInstance.getServerState() != 1;
    }

    public static class OutputAction
    extends AbstractAction
    implements ServerInstance.StateListener {
        private static final String ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/refresh.png";
        private static final String PROP_ENABLED = "enabled";
        private final ServerInstance instance;

        public OutputAction(ServerInstance serverInstance) {
            super(NbBundle.getMessage(DebugAction.class, (String)"LBL_RefreshOutput"), new ImageIcon(Utilities.loadImage((String)ICON)));
            this.putValue("ShortDescription", NbBundle.getMessage(DebugAction.class, (String)"LBL_RefreshOutputDesc"));
            this.instance = serverInstance;
            serverInstance.addStateListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RefreshAction.performActionImpl(this.instance);
        }

        public boolean isEnabled() {
            return RefreshAction.enableImpl(this.instance);
        }

        public void stateChanged(int n, int n2) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    OutputAction.this.firePropertyChange(OutputAction.PROP_ENABLED, null, OutputAction.this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                }
            });
        }
    }
}

