/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.core;

import java.awt.EventQueue;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.StyledDocument;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.ValidateXMLCookie;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.modules.bpel.core.BPELDataObject;
import org.netbeans.modules.bpel.core.multiview.BpelMultiViewSupport;
import org.netbeans.modules.bpel.core.util.BPELValidationController;
import org.netbeans.modules.bpel.core.util.SelectBpelElement;
import org.netbeans.modules.bpel.core.util.ValidationUtil;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.spi.BpelModelFactory;
import org.netbeans.modules.soa.ui.UndoRedoManagerProvider;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.validation.ValidationOutputWindowController;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserCancelException;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELDataEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
ShowCookie,
ValidateXMLCookie,
UndoRedoManagerProvider {
    private transient Task prepareTask;

    public BPELDataEditorSupport(BPELDataObject bPELDataObject) {
        super((DataObject)bPELDataObject, (CloneableEditorSupport.Env)new BPELEnv(bPELDataObject));
        this.setMIMEType("text/x-bpel+xml");
    }

    public QuietUndoManager getUndoManager() {
        return (QuietUndoManager)this.getUndoRedo();
    }

    public UndoRedo.Manager getUndoRedoManager() {
        return this.getUndoManager();
    }

    public BpelModel getBpelModel() {
        BPELDataObject bPELDataObject = this.getEnv().getBpelDataObject();
        ModelSource modelSource = Utilities.getModelSource((FileObject)bPELDataObject.getPrimaryFile(), (boolean)true);
        return this.getModelFactory().getModel(modelSource);
    }

    public void saveDocument() throws IOException {
        super.saveDocument();
        this.syncModel();
        this.getDataObject().setModified(false);
    }

    public void syncModel() {
        try {
            BpelModel bpelModel = this.getBpelModel();
            if (bpelModel != null) {
                bpelModel.sync();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        super.initializeCloneableEditor(cloneableEditor);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                BPELDataEditorSupport.this.updateTitles();
            }
        });
        this.getValidationController().attach();
    }

    public JEditorPane[] getOpenedPanes() {
        if (SwingUtilities.isEventDispatchThread()) {
            return super.getOpenedPanes();
        }
        try {
            class SafeGetOpenedPanes
            implements Runnable {
                private JEditorPane[] myResult;

                SafeGetOpenedPanes() {
                }

                public void run() {
                    this.myResult = BPELDataEditorSupport.super.getOpenedPanes();
                }

                public JEditorPane[] getResult() {
                    return this.myResult;
                }
            }
            SafeGetOpenedPanes safeGetOpenedPanes = new SafeGetOpenedPanes();
            SwingUtilities.invokeAndWait(safeGetOpenedPanes);
            return safeGetOpenedPanes.getResult();
        }
        catch (InterruptedException interruptedException) {
            ErrorManager.getDefault().notify(4096, (Throwable)interruptedException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(4096, (Throwable)invocationTargetException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task prepareDocument() {
        QuietUndoManager quietUndoManager = (QuietUndoManager)this.getUndoRedo();
        Task task = super.prepareDocument();
        if (task == this.prepareTask) {
            return task;
        }
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            task.addTaskListener(new TaskListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(Task task) {
                    QuietUndoManager quietUndoManager = (QuietUndoManager)BPELDataEditorSupport.this.getUndoRedo();
                    StyledDocument styledDocument = BPELDataEditorSupport.this.getDocument();
                    QuietUndoManager quietUndoManager2 = quietUndoManager;
                    synchronized (quietUndoManager2) {
                        quietUndoManager.setDocument((AbstractDocument)((Object)styledDocument));
                        if (!quietUndoManager.isCompound()) {
                            styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                            BPELDataEditorSupport.this.addUndoManagerToModel(quietUndoManager);
                        }
                    }
                }
            });
            this.prepareTask = task;
        }
        return task;
    }

    public Task reloadDocument() {
        Task task = super.reloadDocument();
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        QuietUndoManager quietUndoManager = BPELDataEditorSupport.this.getUndoManager();
                        StyledDocument styledDocument = BPELDataEditorSupport.this.getDocument();
                        QuietUndoManager quietUndoManager2 = quietUndoManager;
                        synchronized (quietUndoManager2) {
                            if (!quietUndoManager.isCompound()) {
                                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                            }
                        }
                    }
                });
            }
        });
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUndoManagerToDocument() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            this.removeUndoManagerFromModel();
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                styledDocument.addUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.beginCompound();
            }
        }
    }

    public void addUndoManagerToModel(QuietUndoManager quietUndoManager) {
        BpelModel bpelModel = this.getBpelModel();
        if (bpelModel != null) {
            this.removeUndoManagerFromModel();
            bpelModel.addUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.setModel((Model)bpelModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUndoManagerFromDocument() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.endCompound();
            }
            this.addUndoManagerToModel(quietUndoManager);
        }
    }

    public boolean silentClose() {
        return super.close(false);
    }

    public void show(final Validator.ResultItem resultItem) {
        if (!(resultItem.getModel() instanceof BpelModel)) {
            return;
        }
        final BpelEntity bpelEntity = (BpelEntity)resultItem.getComponents();
        DataObject dataObject = this.getDataObject();
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        final EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        if (lineCookie == null || editCookie == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Line line;
                MultiViewPerspective multiViewPerspective;
                editCookie.edit();
                TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
                MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
                if (multiViewHandler == null) {
                    return;
                }
                if (resultItem.getModel().getState().equals((Object)Model.State.NOT_WELL_FORMED) || resultItem.getComponents() == null) {
                    for (int i = 0; i < multiViewHandler.getPerspectives().length; ++i) {
                        if (!multiViewHandler.getPerspectives()[i].preferredID().equals("bpelsource")) continue;
                        multiViewHandler.requestActive(multiViewHandler.getPerspectives()[i]);
                    }
                }
                if ((multiViewPerspective = multiViewHandler.getSelectedPerspective()).preferredID().equals("orch-designer")) {
                    List list = BPELDataEditorSupport.this.getAssociatedTopComponents();
                    for (TopComponent topComponent2 : list) {
                        MultiViewHandler multiViewHandler2 = MultiViews.findMultiViewHandler((TopComponent)topComponent2);
                        if (multiViewHandler2 == null || topComponent2 == null) continue;
                        SelectBpelElement selectBpelElement = (SelectBpelElement)topComponent2.getLookup().lookup(SelectBpelElement.class);
                        if (selectBpelElement == null) {
                            return;
                        }
                        selectBpelElement.select(bpelEntity);
                    }
                } else if (multiViewPerspective.preferredID().equals("bpelsource") && (line = ValidationUtil.getLine(resultItem)) != null) {
                    line.show(2);
                }
            }
        });
    }

    public boolean validateXML(CookieObserver cookieObserver) {
        ValidationOutputWindowController validationOutputWindowController = new ValidationOutputWindowController();
        List list = validationOutputWindowController.validate((Model)((BPELDataObject)this.getDataObject()).getLookup().lookup(Model.class));
        BPELValidationController bPELValidationController = (BPELValidationController)((Object)((BPELDataObject)this.getDataObject()).getLookup().lookup(BPELValidationController.class));
        if (bPELValidationController != null) {
            bPELValidationController.notifyCompleteValidationResults(list);
        }
        return true;
    }

    protected CloneableEditorSupport.Pane createPane() {
        CloneableTopComponent cloneableTopComponent = BpelMultiViewSupport.createMultiView((BPELDataObject)this.getDataObject());
        Mode mode = WindowManager.getDefault().findMode("editor");
        if (mode != null) {
            mode.dockInto((TopComponent)cloneableTopComponent);
        }
        return (CloneableEditorSupport.Pane)cloneableTopComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClosed() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            BpelModel bpelModel;
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.endCompound();
                quietUndoManager.setDocument(null);
            }
            if ((bpelModel = this.getBpelModel()) != null) {
                bpelModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            }
            quietUndoManager.setModel(null);
        }
        super.notifyClosed();
        this.getUndoManager().discardAllEdits();
        this.prepareTask = null;
        this.getValidationController().detach();
    }

    protected boolean notifyModified() {
        boolean bl = super.notifyModified();
        if (!bl) {
            return false;
        }
        BPELDataObject bPELDataObject = this.getEnv().getBpelDataObject();
        if (bPELDataObject.getCookie(SaveCookie.class) == null) {
            bPELDataObject.addSaveCookie(new SaveCookie(){

                public void save() throws IOException {
                    try {
                        BPELDataEditorSupport.this.saveDocument();
                    }
                    catch (UserCancelException userCancelException) {
                        // empty catch block
                    }
                }
            });
        }
        return true;
    }

    protected void updateTitles() {
        super.updateTitles();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                List list = BPELDataEditorSupport.this.getAssociatedTopComponents();
                for (TopComponent topComponent : list) {
                    MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
                    if (multiViewHandler == null || topComponent == null) continue;
                    topComponent.setHtmlDisplayName(BPELDataEditorSupport.this.messageHtmlName());
                    String string = BPELDataEditorSupport.this.messageName();
                    topComponent.setDisplayName(string);
                    topComponent.setName(string);
                    topComponent.setToolTipText(BPELDataEditorSupport.this.messageToolTip());
                }
            }
        });
    }

    protected BPELEnv getEnv() {
        return (BPELEnv)this.env;
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new QuietUndoManager(super.createUndoRedoManager());
    }

    public BPELValidationController getValidationController() {
        BPELValidationController bPELValidationController = (BPELValidationController)((Object)this.getEnv().getBpelDataObject().getLookup().lookup(BPELValidationController.class));
        return bPELValidationController;
    }

    private void removeUndoManagerFromModel() {
        BpelModel bpelModel = this.getBpelModel();
        if (bpelModel != null) {
            QuietUndoManager quietUndoManager = this.getUndoManager();
            bpelModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.setModel(null);
        }
    }

    private List<TopComponent> getAssociatedTopComponents() {
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        DataObject dataObject = this.getDataObject();
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null && dataObject == (DataObject)topComponent.getLookup().lookup(DataObject.class)) {
            arrayList.add(topComponent);
        }
        Set set = TopComponent.getRegistry().getOpened();
        for (Object e : set) {
            TopComponent topComponent2 = (TopComponent)e;
            if (dataObject != (DataObject)topComponent2.getLookup().lookup(DataObject.class)) continue;
            arrayList.add(topComponent2);
        }
        return arrayList;
    }

    private BpelModelFactory getModelFactory() {
        BpelModelFactory bpelModelFactory = (BpelModelFactory)Lookup.getDefault().lookup(BpelModelFactory.class);
        return bpelModelFactory;
    }

    public static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -4621077799099893176L;
        private BPELDataObject myDataObject;

        private CloseHandler() {
        }

        public CloseHandler(BPELDataObject bPELDataObject) {
            this.myDataObject = bPELDataObject;
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            BPELDataEditorSupport bPELDataEditorSupport;
            BPELDataEditorSupport bPELDataEditorSupport2 = bPELDataEditorSupport = this.myDataObject == null ? null : (BPELDataEditorSupport)this.myDataObject.getCookie(BPELDataEditorSupport.class);
            if (bPELDataEditorSupport == null) {
                return true;
            }
            boolean bl = bPELDataEditorSupport.canClose();
            if (bl) {
                this.myDataObject.setModified(false);
            }
            return bl;
        }
    }

    private static class BPELEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 835762240381036211L;

        public BPELEnv(BPELDataObject bPELDataObject) {
            super((DataObject)bPELDataObject);
        }

        public BPELDataObject getBpelDataObject() {
            return (BPELDataObject)this.getDataObject();
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }
    }
}

