/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.core.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationUtil {
    private ValidationUtil() {
    }

    public static List<Validator.ResultItem> filterBpelResultItems(List<Validator.ResultItem> list) {
        ArrayList<Validator.ResultItem> arrayList = new ArrayList<Validator.ResultItem>();
        for (Validator.ResultItem resultItem : list) {
            Component component = resultItem.getComponents();
            if (!(component instanceof BpelEntity)) continue;
            Validator.ResultItem resultItem2 = new Validator.ResultItem(resultItem.getValidator(), resultItem.getType(), component, resultItem.getDescription());
            arrayList.add(resultItem2);
        }
        return arrayList;
    }

    public static boolean equals(Validator.ResultItem resultItem, Validator.ResultItem resultItem2) {
        Component component;
        if (resultItem == resultItem2) {
            return true;
        }
        if (!resultItem.getDescription().equals(resultItem2.getDescription())) {
            return false;
        }
        if (!resultItem.getType().equals((Object)resultItem2.getType())) {
            return false;
        }
        Component component2 = resultItem.getComponents();
        return component2 == (component = resultItem2.getComponents());
    }

    private static boolean contains(List<Validator.ResultItem> list, Validator.ResultItem resultItem) {
        assert (list != null);
        for (Validator.ResultItem resultItem2 : list) {
            if (!ValidationUtil.equals(resultItem2, resultItem)) continue;
            return true;
        }
        return false;
    }

    public static Line getLine(Validator.ResultItem resultItem) {
        DataObject dataObject;
        int n;
        Component component = resultItem.getComponents();
        if (component != null) {
            n = -1;
            if (component instanceof DocumentComponent) {
                n = ValidationUtil.getLineNumber((DocumentComponent)resultItem.getComponents());
            }
        } else {
            n = resultItem.getLineNumber() - 1;
        }
        if (n < 1) {
            return null;
        }
        FileObject fileObject = ValidationUtil.getFileObjectByModel(component == null ? resultItem.getModel() : component.getModel());
        if (fileObject == null) {
            return null;
        }
        LineCookie lineCookie = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
        if (lineCookie == null) {
            return null;
        }
        dataObject = lineCookie.getLineSet().getCurrent(n);
        if (dataObject == null) {
            return null;
        }
        return lineCookie.getLineSet().getCurrent(n);
    }

    public static Line.Part getLinePart(Validator.ResultItem resultItem) {
        Line line = ValidationUtil.getLine(resultItem);
        if (line == null) {
            return null;
        }
        int n = ValidationUtil.getColumn(resultItem.getComponents());
        if (n == -1) {
            n = 0;
        }
        int n2 = line.getText().length() - n;
        return line.createPart(n, n2);
    }

    private static int getColumn(Component component) {
        AbstractDocument abstractDocument = ValidationUtil.getAbstractDocument(component);
        if (abstractDocument == null) {
            return -1;
        }
        int n = ValidationUtil.findPosition((AbstractDocumentModel)component.getModel(), ((AbstractDocumentComponent)component).getPeer());
        return ValidationUtil.findColumn(abstractDocument, n);
    }

    private static AbstractDocument getAbstractDocument(Component component) {
        if (component == null) {
            return null;
        }
        Model model = component.getModel();
        if (model == null) {
            return null;
        }
        ModelSource modelSource = model.getModelSource();
        if (modelSource == null) {
            return null;
        }
        return (AbstractDocument)modelSource.getLookup().lookup(AbstractDocument.class);
    }

    private static int findColumn(AbstractDocument abstractDocument, int n) {
        javax.swing.text.Element element = ValidationUtil.findLineRootElement(abstractDocument);
        int n2 = element.getElementIndex(n);
        return n - element.getElement(n2).getStartOffset();
    }

    private static javax.swing.text.Element findLineRootElement(AbstractDocument abstractDocument) {
        javax.swing.text.Element element = abstractDocument.getParagraphElement(0).getParentElement();
        if (element == null) {
            element = abstractDocument.getDefaultRootElement();
        }
        return element;
    }

    private static int findPosition(AbstractDocumentModel abstractDocumentModel, Node node) {
        Element element = abstractDocumentModel.getRootComponent().getPeer();
        Document document = abstractDocumentModel.getBaseDocument();
        try {
            String string = document.getText(0, document.getLength());
            if (node instanceof Element) {
                return ValidationUtil.findPosition((Element)node, string, element, ValidationUtil.getRootElementPosition(string, element));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    private static int getRootElementPosition(String string, Element element) {
        Node node;
        NodeList nodeList = element.getOwnerDocument().getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength() && (node = nodeList.item(i)) != element; ++i) {
            String string2 = node.getNodeValue();
            if (string2 == null) continue;
            n += string2.length();
        }
        return string.indexOf(element.getTagName(), n);
    }

    private static int findPosition(Element element, String string, Element element2, Integer n) {
        if (element == element2) {
            return n;
        }
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) {
                object = node.getNodeValue();
                if (object == null) {
                    object = node.getTextContent();
                }
                if (object == null) continue;
                n = n + ((String)object).length();
                continue;
            }
            object = (Element)nodeList.item(i);
            String string2 = "<" + object.getTagName();
            n = string.indexOf(string2, (int)n);
            if (object == element) {
                return n;
            }
            int n2 = ValidationUtil.findPosition(element, string, (Element)object, n);
            if (n2 <= -1) continue;
            return n2;
        }
        return -1;
    }

    private static int getLineNumber(DocumentComponent documentComponent) {
        if (documentComponent == null) {
            return -1;
        }
        Model model = documentComponent.getModel();
        if (model == null) {
            return -1;
        }
        ModelSource modelSource = model.getModelSource();
        if (modelSource == null) {
            return -1;
        }
        Lookup lookup = modelSource.getLookup();
        if (lookup == null) {
            return -1;
        }
        StyledDocument styledDocument = (StyledDocument)lookup.lookup(StyledDocument.class);
        if (styledDocument == null) {
            return -1;
        }
        return NbDocument.findLineNumber((StyledDocument)styledDocument, (int)documentComponent.findPosition());
    }

    private static FileObject getFileObjectByModel(Model model) {
        if (model == null) {
            return null;
        }
        ModelSource modelSource = model.getModelSource();
        if (modelSource == null) {
            return null;
        }
        Lookup lookup = modelSource.getLookup();
        if (lookup == null) {
            return null;
        }
        return (FileObject)lookup.lookup(FileObject.class);
    }
}

