/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.ui;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.SwingWorker;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JCheckTree;
import org.netbeans.lib.profiler.ui.components.tree.CheckTreeNode;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.netbeans.modules.profiler.selector.ui.ProgressDisplayer;
import org.netbeans.modules.profiler.selector.ui.RootSelectorNode;
import org.netbeans.modules.profiler.selector.ui.SelectionTreeView;
import org.netbeans.modules.profiler.utilities.trees.TreeDecimator;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootSelectorTree
extends JCheckTree {
    public static TreeDecimator.NodeFilter<RootSelectorNode> DEFAULT_FILTER = new TreeDecimator.NodeFilter<RootSelectorNode>(){

        public boolean match(RootSelectorNode rootSelectorNode) {
            return true;
        }

        public boolean maymatch(RootSelectorNode rootSelectorNode) {
            return true;
        }
    };
    private static TreeDecimator.NodeFilter<SelectorNode> DEFAULT_FILTER_INNER = new TreeDecimator.NodeFilter<SelectorNode>(){

        public boolean match(SelectorNode selectorNode) {
            return true;
        }

        public boolean maymatch(SelectorNode selectorNode) {
            return true;
        }
    };
    private static final String EMPTY_STRING = NbBundle.getMessage(RootSelectorTree.class, (String)"RootSelectorTree_EmptyString");
    private static final String LOADING_STRING = NbBundle.getMessage(RootSelectorTree.class, (String)"RootSelectorTree_LoadingString");
    private static final String ROOT_STRING = NbBundle.getMessage(RootSelectorTree.class, (String)"RootSelectorTree_RootString");
    private static final String NO_PROJECT_STRING = NbBundle.getMessage(RootSelectorTree.class, (String)"RootSelectorTree_NoProjectString");
    private static final TreeModel DEFAULTMODEL = new DefaultTreeModel(new DefaultMutableTreeNode(EMPTY_STRING));
    public static final String SELECTION_TREE_VIEW_LIST_PROPERTY = "SELECTION_TREE_VIEW_LIST";
    private final Set<ClientUtils.SourceCodeSelection> currentSelectionSet = new HashSet<ClientUtils.SourceCodeSelection>();
    private TreeDecimator.NodeFilter<SelectorNode> nodeFilter = DEFAULT_FILTER_INNER;
    private ProgressDisplayer progress = ProgressDisplayer.DEFAULT;
    private SelectionTreeBuilder currentTreeBuilder = SelectionTreeBuilder.NULL;
    private TreeDecimator<SelectorNode> treeDecimator = new TreeDecimator<SelectorNode>(){

        protected List<SelectorNode> getChildren(SelectorNode selectorNode) {
            selectorNode.getChildCount(true);
            Enumeration enumeration = selectorNode.children();
            ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>();
            while (enumeration.hasMoreElements()) {
                arrayList.add((SelectorNode)enumeration.nextElement());
            }
            return arrayList;
        }

        protected void attachChildren(SelectorNode selectorNode, List<SelectorNode> list) {
            for (SelectorNode selectorNode2 : list) {
                selectorNode2.setParent((MutableTreeNode)selectorNode);
            }
        }

        protected void detachChild(SelectorNode selectorNode, SelectorNode selectorNode2) {
            selectorNode2.setParent(null);
        }

        protected void detachChildren(SelectorNode selectorNode) {
            selectorNode.removeAllChildren();
        }
    };
    private Project[] relevantProjects;
    private boolean showInheritedMethods = false;

    public RootSelectorTree() {
        this.init();
    }

    public RootSelectorTree(ProgressDisplayer progressDisplayer) {
        this.progress = progressDisplayer;
        this.init();
    }

    public void setNodeFilter(final TreeDecimator.NodeFilter<RootSelectorNode> nodeFilter) {
        this.nodeFilter = new TreeDecimator.NodeFilter<SelectorNode>(){

            public boolean match(SelectorNode selectorNode) {
                return nodeFilter.match((Object)new RootSelectorNode(selectorNode));
            }

            public boolean maymatch(SelectorNode selectorNode) {
                return nodeFilter.maymatch((Object)new RootSelectorNode(selectorNode));
            }
        };
    }

    public void setProjects(Project[] projectArray) {
        this.relevantProjects = projectArray;
        this.firePropertyChange(SELECTION_TREE_VIEW_LIST_PROPERTY, null, null);
    }

    public void setSelection(final ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        new SwingWorker(false){

            protected void doInBackground() {
                RootSelectorTree.this.applySelection(sourceCodeSelectionArray);
            }

            protected void done() {
                RootSelectorTree.this.treeDidChange();
            }
        }.execute();
    }

    public ClientUtils.SourceCodeSelection[] getSelection() {
        return this.currentSelectionSet.toArray(new ClientUtils.SourceCodeSelection[this.currentSelectionSet.size()]);
    }

    public void setSelectionTreeView(SelectionTreeView selectionTreeView) {
        if (selectionTreeView instanceof SelectionTreeViewWrapper) {
            this.currentTreeBuilder = ((SelectionTreeViewWrapper)selectionTreeView).getBuilder();
            this.refreshTree();
        }
    }

    public List<SelectionTreeView> getSelectionTreeViewList() {
        ArrayList<SelectionTreeView> arrayList = new ArrayList<SelectionTreeView>();
        Map<SelectionTreeBuilder, Integer> map = this.calculateBuilderUsageFrequency();
        SelectionTreeViewWrapper selectionTreeViewWrapper = null;
        int n = 0;
        Iterator<Map.Entry<SelectionTreeBuilder, Integer>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SelectionTreeBuilder, Integer> entry;
            SelectionTreeViewWrapper selectionTreeViewWrapper2 = new SelectionTreeViewWrapper(entry.getKey(), false, (entry = iterator.next()).getValue() > 0);
            if (entry.getValue() > n) {
                n = entry.getValue();
                selectionTreeViewWrapper = selectionTreeViewWrapper2;
            }
            arrayList.add(selectionTreeViewWrapper2);
        }
        if (selectionTreeViewWrapper != null) {
            selectionTreeViewWrapper.setPreferred(true);
        }
        return arrayList;
    }

    public void setShowingInheritedMethods(boolean bl) {
        this.showInheritedMethods = bl;
    }

    public boolean isShowingInheritedMethods() {
        return this.showInheritedMethods;
    }

    public static boolean canBeShown() {
        return Lookup.getDefault().lookup(SelectionTreeBuilder.class) != null;
    }

    public void reset() {
        this.setModel(DEFAULTMODEL);
        this.currentSelectionSet.clear();
        this.relevantProjects = new Project[0];
    }

    public void setup(Project[] projectArray, ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        if (this.currentSelectionSet != null) {
            this.currentSelectionSet.clear();
        }
        this.setCursor(new Cursor(0));
        this.setProjects(projectArray);
        this.applySelection(sourceCodeSelectionArray);
    }

    protected SelectionTreeBuilder getBuilder() {
        return this.currentTreeBuilder;
    }

    private static void addRequiredPackages(Collection<ClientUtils.SourceCodeSelection> collection, Collection<ClientUtils.SourceCodeSelection> collection2) {
        for (ClientUtils.SourceCodeSelection sourceCodeSelection : collection) {
            boolean bl = true;
            for (ClientUtils.SourceCodeSelection sourceCodeSelection2 : collection2) {
                bl = bl && !sourceCodeSelection.contains(sourceCodeSelection2);
            }
            if (!bl) continue;
            collection2.add(sourceCodeSelection);
        }
    }

    private Map<SelectionTreeBuilder, Integer> calculateBuilderUsageFrequency() {
        Collection collection = Lookup.getDefault().lookupAll(SelectionTreeBuilder.class);
        HashMap<SelectionTreeBuilder, Integer> hashMap = new HashMap<SelectionTreeBuilder, Integer>();
        SelectionTreeBuilder selectionTreeBuilder = SelectionTreeBuilder.NULL;
        for (Project project : this.relevantProjects) {
            boolean bl = true;
            for (SelectionTreeBuilder selectionTreeBuilder2 : collection) {
                if (selectionTreeBuilder2.isDefault()) {
                    selectionTreeBuilder = selectionTreeBuilder2;
                    continue;
                }
                if (!selectionTreeBuilder2.supports(project) || !selectionTreeBuilder2.isPreferred(project)) continue;
                bl = false;
                if (!hashMap.containsKey(selectionTreeBuilder2)) {
                    hashMap.put(selectionTreeBuilder2, 1);
                    continue;
                }
                hashMap.put(selectionTreeBuilder2, (Integer)hashMap.get(selectionTreeBuilder2) + 1);
            }
            if (!bl) continue;
            if (!hashMap.containsKey(selectionTreeBuilder)) {
                hashMap.put(selectionTreeBuilder, 1);
                continue;
            }
            hashMap.put(selectionTreeBuilder, (Integer)hashMap.get(selectionTreeBuilder) + 1);
        }
        return hashMap;
    }

    private static void calculateInflatedSelection(SelectorNode selectorNode, SelectorNode selectorNode2, Collection<ClientUtils.SourceCodeSelection> collection, Collection<ClientUtils.SourceCodeSelection> collection2) {
        if (selectorNode == null || selectorNode2 == null || collection == null || collection2 == null) {
            return;
        }
        if (selectorNode2.isFullyChecked() || selectorNode2.isPartiallyChecked()) {
            if (selectorNode2.getSignature() != null && !collection2.contains(selectorNode2.getSignature())) {
                collection.add(selectorNode2.getSignature());
            }
            if (selectorNode2.getSignature() == null || selectorNode.getSignature() == null || selectorNode2.getSignature().contains(selectorNode.getSignature())) {
                int n = selectorNode2.getChildCount();
                for (int i = 0; i < n; ++i) {
                    SelectorNode selectorNode3 = (SelectorNode)selectorNode2.getChildAt(i);
                    RootSelectorTree.calculateInflatedSelection(selectorNode, selectorNode3, collection, collection2);
                }
            }
        }
    }

    private static void checkNodeChildren(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        RootSelectorTree.checkNodeChildren(defaultMutableTreeNode, bl, null);
    }

    private static void checkNodeChildren(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl, CancellableController cancellableController) {
        if (cancellableController != null && cancellableController.isCancelled()) {
            return;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        if (defaultMutableTreeNode instanceof CheckTreeNode && ((CheckTreeNode)defaultMutableTreeNode).isFullyChecked()) {
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = enumeration.nextElement();
                if (!(treeNode instanceof CheckTreeNode)) continue;
                ((CheckTreeNode)treeNode).setChecked(true);
                if (!bl) continue;
                RootSelectorTree.checkNodeChildren((DefaultMutableTreeNode)((CheckTreeNode)treeNode), bl, cancellableController);
            }
        }
    }

    private boolean isSingleSelection() {
        return this.relevantProjects != null && this.relevantProjects.length < 2;
    }

    private DefaultMutableTreeNode getTreeRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ROOT_STRING);
        if (this.relevantProjects != null) {
            for (Project project : this.relevantProjects) {
                if (!this.getBuilder().supports(project)) continue;
                for (SelectorNode selectorNode : this.getBuilder().buildSelectionTree(project, this.isSingleSelection())) {
                    if (!selectorNode.isValid() || (selectorNode = this.customizeTree(selectorNode)) == null) continue;
                    defaultMutableTreeNode.add((MutableTreeNode)selectorNode);
                }
            }
        } else {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(NO_PROJECT_STRING));
        }
        return defaultMutableTreeNode;
    }

    private void applySelection(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        TreeNode treeNode = (TreeNode)this.getModel().getRoot();
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            if (!(treeNode2 instanceof SelectorNode)) continue;
            for (ClientUtils.SourceCodeSelection sourceCodeSelection : sourceCodeSelectionArray) {
                this.applySelection((SelectorNode)treeNode2, sourceCodeSelection);
            }
        }
        this.currentSelectionSet.addAll(Arrays.asList(sourceCodeSelectionArray));
    }

    private void applySelection(SelectorNode selectorNode, ClientUtils.SourceCodeSelection sourceCodeSelection) {
        ClientUtils.SourceCodeSelection sourceCodeSelection2 = selectorNode.getSignature();
        if (sourceCodeSelection2 != null) {
            if (sourceCodeSelection2.equals((Object)sourceCodeSelection)) {
                selectorNode.setChecked(true);
                return;
            }
            if (!sourceCodeSelection2.contains(sourceCodeSelection)) {
                return;
            }
        }
        Enumeration enumeration = selectorNode.children();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof SelectorNode)) continue;
            this.applySelection((SelectorNode)e, sourceCodeSelection);
        }
    }

    private SelectorNode customizeTree(SelectorNode selectorNode) {
        if (selectorNode == null) {
            return null;
        }
        return (SelectorNode)this.treeDecimator.decimate((Object)selectorNode, this.nodeFilter);
    }

    private void init() {
        UIUtils.makeTreeAutoExpandable((JTree)((Object)this), (boolean)true);
        this.addCheckTreeListener(new JCheckTree.CheckTreeListener(){

            public void checkTreeChanged(Collection<CheckTreeNode> collection) {
            }

            public void checkNodeToggled(TreePath treePath, boolean bl) {
                if (!bl) {
                    SelectorNode selectorNode = (SelectorNode)treePath.getLastPathComponent();
                    Collection collection = selectorNode.getRootMethods(true);
                    if (selectorNode.isFullyChecked()) {
                        ArrayList<ClientUtils.SourceCodeSelection> arrayList = new ArrayList<ClientUtils.SourceCodeSelection>();
                        for (ClientUtils.SourceCodeSelection sourceCodeSelection : collection) {
                            for (ClientUtils.SourceCodeSelection sourceCodeSelection2 : RootSelectorTree.this.currentSelectionSet) {
                                if (!sourceCodeSelection.contains(sourceCodeSelection2)) continue;
                                arrayList.add(sourceCodeSelection2);
                            }
                        }
                        RootSelectorTree.this.removeSelection(arrayList.toArray(new ClientUtils.SourceCodeSelection[arrayList.size()]));
                        RootSelectorTree.this.applySelection(collection.toArray(new ClientUtils.SourceCodeSelection[collection.size()]));
                    } else {
                        Object object4;
                        Object object2;
                        Object object3;
                        ContainerNode containerNode = selectorNode.getParent();
                        ArrayList arrayList = new ArrayList();
                        if (containerNode != null) {
                            object3 = containerNode.children();
                            while (object3.hasMoreElements()) {
                                object2 = (SelectorNode)object3.nextElement();
                                if (object2 == selectorNode || !object2.isFullyChecked()) continue;
                                arrayList.addAll(object2.getRootMethods(true));
                            }
                        }
                        object3 = new ArrayList();
                        for (Object object4 : collection) {
                            for (ClientUtils.SourceCodeSelection sourceCodeSelection : RootSelectorTree.this.currentSelectionSet) {
                                if (!sourceCodeSelection.contains(object4) && !object4.contains(sourceCodeSelection)) continue;
                                object3.add(sourceCodeSelection);
                            }
                        }
                        object3.addAll(collection);
                        object2 = (TreeNode)RootSelectorTree.this.getModel().getRoot();
                        object4 = new ArrayList();
                        int n = object2.getChildCount();
                        for (int i = 0; i < n; ++i) {
                            RootSelectorTree.calculateInflatedSelection((SelectorNode)containerNode, (SelectorNode)object2.getChildAt(i), (Collection)object4, (Collection)object3);
                        }
                        RootSelectorTree.addRequiredPackages((Collection)object4, arrayList);
                        RootSelectorTree.this.removeSelection(object3.toArray(new ClientUtils.SourceCodeSelection[object3.size()]));
                        RootSelectorTree.this.applySelection(arrayList.toArray(new ClientUtils.SourceCodeSelection[arrayList.size()]));
                    }
                }
            }
        });
        this.addTreeWillExpandListener(new TreeWillExpandListener(){
            private volatile boolean openingSubtree = false;

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            public void treeWillExpand(final TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                if (!(treeNode instanceof DefaultMutableTreeNode)) {
                    return;
                }
                final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
                if (defaultMutableTreeNode.getChildCount() == -1) {
                    if (this.openingSubtree) {
                        throw new ExpandVetoException(treeExpansionEvent);
                    }
                    this.openingSubtree = true;
                    new SwingWorker(){

                        protected void doInBackground() {
                            RootSelectorTree.checkNodeChildren(defaultMutableTreeNode, false);
                        }

                        protected void nonResponding() {
                            RootSelectorTree.this.progress.showProgress(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"NodeLoadingMessage"));
                        }

                        protected void done() {
                            RootSelectorTree.this.progress.close();
                            RootSelectorTree.this.expandPath(treeExpansionEvent.getPath());
                            RootSelectorTree.this.doLayout();
                            openingSubtree = false;
                        }
                    }.execute();
                    throw new ExpandVetoException(treeExpansionEvent);
                }
                RootSelectorTree.checkNodeChildren(defaultMutableTreeNode, false);
            }
        });
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setModel(DEFAULTMODEL);
    }

    private void refreshTree() {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(LOADING_STRING)));
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setModel(new DefaultTreeModel(this.getTreeRoot()));
        this.treeDidChange();
    }

    private void removeSelection(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        TreeNode treeNode = (TreeNode)this.getModel().getRoot();
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            if (!(treeNode2 instanceof SelectorNode)) continue;
            for (ClientUtils.SourceCodeSelection sourceCodeSelection : sourceCodeSelectionArray) {
                this.removeSelection((SelectorNode)treeNode2, sourceCodeSelection);
            }
        }
        this.currentSelectionSet.removeAll(Arrays.asList(sourceCodeSelectionArray));
    }

    private void removeSelection(SelectorNode selectorNode, ClientUtils.SourceCodeSelection sourceCodeSelection) {
        ClientUtils.SourceCodeSelection sourceCodeSelection2 = selectorNode.getSignature();
        if (sourceCodeSelection2 != null) {
            if (sourceCodeSelection2.equals((Object)sourceCodeSelection)) {
                selectorNode.setChecked(false);
                return;
            }
            if (!sourceCodeSelection2.contains(sourceCodeSelection)) {
                return;
            }
        }
        Enumeration enumeration = selectorNode.children();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof SelectorNode)) continue;
            this.removeSelection((SelectorNode)e, sourceCodeSelection);
        }
    }

    private class SelectionTreeViewWrapper
    implements SelectionTreeView {
        private SelectionTreeBuilder wrappedBuilder;
        private boolean enabled;
        private boolean preferred;

        public SelectionTreeViewWrapper(SelectionTreeBuilder selectionTreeBuilder, boolean bl, boolean bl2) {
            this.wrappedBuilder = selectionTreeBuilder;
            this.preferred = bl;
            this.enabled = bl2;
        }

        public SelectionTreeBuilder getBuilder() {
            return this.wrappedBuilder;
        }

        public String getDisplayName() {
            return this.wrappedBuilder.getDisplayName();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setPreferred(boolean bl) {
            this.preferred = bl;
        }

        public boolean isPreferred() {
            return this.preferred;
        }

        public String toString() {
            return this.wrappedBuilder.toString();
        }
    }

    private static class CancellableController
    implements ProgressDisplayer.ProgressController {
        private volatile boolean cancelled = false;

        private CancellableController() {
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public boolean cancel() {
            this.cancelled = true;
            return true;
        }
    }
}

