/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.text.MessageFormat;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.lib.editor.bookmarks.spi.BookmarkImplementation;
import org.netbeans.modules.editor.bookmarks.NbBookmarkManager;
import org.openide.ErrorManager;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public final class NbBookmarkImplementation
extends Annotation
implements BookmarkImplementation {
    static final String BOOKMARK_ANNOTATION_TYPE = "editor-bookmark";
    private final NbBookmarkManager manager;
    private Position pos;

    NbBookmarkImplementation(NbBookmarkManager nbBookmarkManager, int n) {
        this.manager = nbBookmarkManager;
        Document document = nbBookmarkManager.getDocument();
        try {
            this.pos = document.createPosition(n);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            this.pos = document.getStartPosition();
        }
        if (document instanceof StyledDocument) {
            NbDocument.addAnnotation((StyledDocument)((StyledDocument)document), (Position)this.pos, (int)-1, (Annotation)this);
        }
    }

    public String getAnnotationType() {
        return BOOKMARK_ANNOTATION_TYPE;
    }

    public String getShortDescription() {
        String string = NbBundle.getBundle((Class)NbBookmarkImplementation.class).getString("Bookmark_Tooltip");
        int n = this.getLineIndex();
        return MessageFormat.format(string, new Integer(n + 1));
    }

    public int getOffset() {
        return this.pos.getOffset();
    }

    public int getLineIndex() {
        return this.manager.getDocument().getDefaultRootElement().getElementIndex(this.getOffset());
    }

    public void release() {
        Document document = this.manager.getDocument();
        if (document instanceof StyledDocument) {
            NbDocument.removeAnnotation((StyledDocument)((StyledDocument)document), (Annotation)this);
        }
    }

    public String toString() {
        return this.getShortDescription();
    }
}

