/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui;

import java.io.File;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class FoldersListSettings {
    private static final FoldersListSettings INSTANCE = new FoldersListSettings();
    private static final String NEW_PROJECT_COUNT = "newProjectCount";
    private static final String NEW_APP_COUNT = "newApplicationCount";
    private static final String NEW_LIB_COUNT = "newLibraryCount";
    private static final String LAST_USED_CP_FOLDER = "lastUsedClassPathFolder";
    private static final String LAST_USED_ARTIFACT_FOLDER = "lastUsedArtifactFolder";

    public static FoldersListSettings getDefault() {
        return INSTANCE;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(FoldersListSettings.class);
    }

    public String displayName() {
        return NbBundle.getMessage(FoldersListSettings.class, (String)"TXT_J2SEProjectFolderList");
    }

    public int getNewProjectCount() {
        return FoldersListSettings.getPreferences().getInt(NEW_PROJECT_COUNT, 0);
    }

    public void setNewProjectCount(int n) {
        FoldersListSettings.getPreferences().putInt(NEW_PROJECT_COUNT, n);
    }

    public int getNewApplicationCount() {
        return FoldersListSettings.getPreferences().getInt(NEW_APP_COUNT, 0);
    }

    public void setNewApplicationCount(int n) {
        FoldersListSettings.getPreferences().putInt(NEW_APP_COUNT, n);
    }

    public int getNewLibraryCount() {
        return FoldersListSettings.getPreferences().getInt(NEW_LIB_COUNT, 0);
    }

    public void setNewLibraryCount(int n) {
        FoldersListSettings.getPreferences().putInt(NEW_LIB_COUNT, n);
    }

    public File getLastUsedClassPathFolder() {
        return new File(FoldersListSettings.getPreferences().get(LAST_USED_CP_FOLDER, System.getProperty("user.home")));
    }

    public void setLastUsedClassPathFolder(File file) {
        assert (file != null) : "ClassPath root can not be null";
        String string = file.getAbsolutePath();
        FoldersListSettings.getPreferences().put(LAST_USED_CP_FOLDER, string);
    }

    public File getLastUsedArtifactFolder(File file) {
        String string = FoldersListSettings.getPreferences().get(LAST_USED_ARTIFACT_FOLDER, null);
        if (string != null) {
            return FileUtil.normalizeFile((File)new File(string));
        }
        if (file != null) {
            return file;
        }
        return FileUtil.normalizeFile((File)new File(System.getProperty("user.home")));
    }

    public void setLastUsedArtifactFolder(File file) {
        assert (file != null) : "Folder can not be null";
        String string = file.getAbsolutePath();
        FoldersListSettings.getPreferences().put(LAST_USED_ARTIFACT_FOLDER, string);
    }
}

