/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class J2SELogicalViewProvider
implements LogicalViewProvider {
    private static final RequestProcessor RP = new RequestProcessor("J2SEPhysicalViewProvider.RP");
    private final J2SEProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final SubprojectProvider spp;
    private final ReferenceHelper resolver;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "run.classpath", "debug.classpath", "run.test.classpath", "debug.test.classpath", "javac.test.classpath"};
    private static Image brokenProjectBadge = Utilities.loadImage((String)"org/netbeans/modules/java/j2seproject/ui/resources/brokenProjectBadge.gif", (boolean)true);

    public J2SELogicalViewProvider(J2SEProject j2SEProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, SubprojectProvider subprojectProvider, ReferenceHelper referenceHelper) {
        this.project = j2SEProject;
        assert (j2SEProject != null);
        this.helper = updateHelper;
        assert (updateHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.spp = subprojectProvider;
        assert (subprojectProvider != null);
        this.resolver = referenceHelper;
        assert (referenceHelper != null);
    }

    public Node createLogicalView() {
        return new J2SELogicalViewRootNode();
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public ReferenceHelper getRefHelper() {
        return this.resolver;
    }

    public UpdateHelper getUpdateHelper() {
        return this.helper;
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            for (Node node2 : node.getChildren().getNodes(true)) {
                Node node3 = PackageView.findPath((Node)node2, (Object)object);
                if (node3 == null) continue;
                return node3;
            }
        }
        return null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void testBroken() {
        this.changeSupport.fireChange();
    }

    private static Lookup createLookup(Project project) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        return Lookups.fixed((Object[])new Object[]{project, dataFolder});
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper.getAntProjectHelper(), (ReferenceHelper)this.resolver, (String[])this.getBreakableProperties(), (String[])new String[]{"platform.active"});
    }

    public boolean hasInvalidJdkVersion() {
        String string = this.evaluator.getProperty("javac.source");
        String string2 = this.evaluator.getProperty("javac.target");
        if (string == null && string2 == null) {
            return false;
        }
        String string3 = this.evaluator.getProperty("platform.active");
        JavaPlatform javaPlatform = J2SEProjectUtil.getActivePlatform(string3);
        if (javaPlatform == null) {
            return true;
        }
        SpecificationVersion specificationVersion = javaPlatform.getSpecification().getVersion();
        try {
            return string != null && new SpecificationVersion(string).compareTo((Object)specificationVersion) > 0 || string2 != null && new SpecificationVersion(string2).compareTo((Object)specificationVersion) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorManager.getDefault().log("Invalid javac.source: " + string + " or javac.target: " + string2 + " of project:" + this.project.getProjectDirectory().getPath());
            return true;
        }
    }

    private String[] getBreakableProperties() {
        SourceRoots sourceRoots = this.project.getSourceRoots();
        String[] stringArray = sourceRoots.getRootProperties();
        sourceRoots = this.project.getTestSourceRoots();
        String[] stringArray2 = sourceRoots.getRootProperties();
        String[] stringArray3 = new String[BREAKABLE_PROPERTIES.length + stringArray.length + stringArray2.length];
        System.arraycopy(BREAKABLE_PROPERTIES, 0, stringArray3, 0, BREAKABLE_PROPERTIES.length);
        System.arraycopy(stringArray, 0, stringArray3, BREAKABLE_PROPERTIES.length, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, BREAKABLE_PROPERTIES.length + stringArray.length, stringArray2.length);
        return stringArray3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class J2SELogicalViewRootNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private Image icon;
        private Lookup lookup;
        private Action brokenLinksAction;
        private boolean broken;
        private boolean illegalState;
        private Set<FileObject> files;
        private Map<FileSystem, FileStatusListener> fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock;
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;

        public J2SELogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)J2SELogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-java-j2seproject/Nodes"), Lookups.singleton((Object)J2SELogicalViewProvider.this.project));
            this.privateLock = new Object();
            this.setIconBaseWithExtension("org/netbeans/modules/java/j2seproject/ui/resources/j2seProject.png");
            super.setName(ProjectUtils.getInformation((Project)J2SELogicalViewProvider.this.project).getDisplayName());
            if (J2SELogicalViewProvider.this.hasBrokenLinks()) {
                this.broken = true;
            } else if (J2SELogicalViewProvider.this.hasInvalidJdkVersion()) {
                this.illegalState = true;
            }
            this.brokenLinksAction = new BrokenLinksAction();
            this.setProjectFiles(J2SELogicalViewProvider.this.project);
        }

        public String getShortDescription() {
            String string = FileUtil.getFileDisplayName((FileObject)J2SELogicalViewProvider.this.project.getProjectDirectory());
            return NbBundle.getMessage(J2SELogicalViewProvider.class, (String)"HINT_project_root_node", (Object)string);
        }

        protected final void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private final void setGroups(Collection<SourceGroup> collection) {
            if (this.groupsListeners != null) {
                for (Map.Entry<SourceGroup, PropertyChangeListener> object : this.groupsListeners.entrySet()) {
                    object.getKey().removePropertyChangeListener(object.getValue());
                }
            }
            this.groupsListeners = new HashMap<SourceGroup, PropertyChangeListener>();
            HashSet hashSet = new HashSet();
            for (SourceGroup sourceGroup : collection) {
                PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceGroup);
                this.groupsListeners.put(sourceGroup, propertyChangeListener);
                sourceGroup.addPropertyChangeListener(propertyChangeListener);
                FileObject fileObject = sourceGroup.getRootFolder();
                hashSet.add(fileObject);
            }
            this.setFiles(hashSet);
        }

        protected final void setFiles(Set<FileObject> set) {
            if (this.fileSystemListeners != null) {
                for (Map.Entry<FileSystem, FileStatusListener> object : this.fileSystemListeners.entrySet()) {
                    object.getKey().removeFileStatusListener(object.getValue());
                }
            }
            this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
            this.files = set;
            if (set == null) {
                return;
            }
            HashSet hashSet = new HashSet();
            for (FileObject fileObject : set) {
                ErrorManager errorManager;
                try {
                    FileSystem fileStateInvalidException = fileObject.getFileSystem();
                    if (hashSet.contains(fileStateInvalidException)) continue;
                    hashSet.add(fileStateInvalidException);
                    errorManager = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileStateInvalidException);
                    fileStateInvalidException.addFileStatusListener((FileStatusListener)errorManager);
                    this.fileSystemListeners.put(fileStateInvalidException, (FileStatusListener)errorManager);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)fileStateInvalidException, 0, "Cannot get " + fileObject + " filesystem, ignoring...", null, null, null);
                    errorManager.notify(1, (Throwable)fileStateInvalidException);
                }
            }
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return string;
            }
            return this.broken || this.illegalState ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Image getIcon(int n) {
            Image image = this.getMyIcon(n);
            if (this.files != null && !this.files.isEmpty()) {
                try {
                    FileObject fileObject = this.files.iterator().next();
                    image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            }
            return image;
        }

        private Image getMyIcon(int n) {
            Image image = super.getIcon(n);
            return this.broken || this.illegalState ? Utilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0) : image;
        }

        public Image getOpenedIcon(int n) {
            Image image = this.getMyOpenedIcon(n);
            if (this.files != null && !this.files.isEmpty()) {
                try {
                    FileObject fileObject = this.files.iterator().next();
                    image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            }
            return image;
        }

        private Image getMyOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            return this.broken || this.illegalState ? Utilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0) : image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl;
            boolean bl2;
            Object object = this.privateLock;
            synchronized (object) {
                bl2 = this.iconChange;
                bl = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (bl2) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (bl) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
                    for (FileObject fileObject : this.files) {
                        if (!fileStatusEvent.hasChanged(fileObject)) continue;
                        this.iconChange |= fileStatusEvent.isIconChange();
                        this.nameChange |= fileStatusEvent.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            RP.post(new Runnable(){

                public void run() {
                    J2SELogicalViewRootNode.this.setProjectFiles(J2SELogicalViewProvider.this.project);
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setProjectFiles(J2SELogicalViewProvider.this.project);
        }

        public Action[] getActions(boolean bl) {
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)J2SELogicalViewProvider.this.project, (String)string);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(J2SELogicalViewRootNode.class);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(J2SELogicalViewProvider.class);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)resourceBundle.getString("LBL_JavadocAction_Name"), null));
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null));
            this.addFromLayers(arrayList, "Projects/Debugger_Actions_temporary");
            this.addFromLayers(arrayList, "Projects/Profiler_Actions_temporary");
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)resourceBundle.getString("LBL_TestAction_Name"), null));
            arrayList.add(CommonProjectActions.setProjectConfigurationAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            this.addFromLayers(arrayList, "Projects/Actions");
            arrayList.add(null);
            if (this.broken) {
                arrayList.add(this.brokenLinksAction);
            }
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private void addFromLayers(List<Action> list, String string) {
            Lookup lookup = Lookups.forPath((String)string);
            for (Object e : lookup.lookupAll(Object.class)) {
                if (e instanceof Action) {
                    list.add((Action)e);
                    continue;
                }
                if (!(e instanceof JSeparator)) continue;
                list.add(null);
            }
        }

        private boolean isBroken() {
            return this.broken;
        }

        private void setBroken(boolean bl) {
            this.broken = bl;
            this.brokenLinksAction.setEnabled(bl);
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        private void setIllegalState(boolean bl) {
            this.illegalState = bl;
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener,
        ChangeListener,
        Runnable {
            private RequestProcessor.Task task = null;
            private PropertyChangeListener weakPCL;

            public BrokenLinksAction() {
                this.putValue("Name", NbBundle.getMessage(J2SELogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
                this.setEnabled(J2SELogicalViewRootNode.this.broken);
                J2SELogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.weakPCL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavaPlatformManager.getDefault());
                JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakPCL);
                J2SELogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)J2SELogicalViewProvider.this));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    J2SELogicalViewProvider.this.helper.requestUpdate();
                    BrokenReferencesSupport.showCustomizer((AntProjectHelper)J2SELogicalViewProvider.this.helper.getAntProjectHelper(), (ReferenceHelper)J2SELogicalViewProvider.this.resolver, (String[])J2SELogicalViewProvider.this.getBreakableProperties(), (String[])new String[]{"platform.active"});
                    this.run();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.refsMayChanged();
            }

            public void stateChanged(ChangeEvent changeEvent) {
                this.refsMayChanged();
            }

            public synchronized void run() {
                boolean bl;
                boolean bl2 = J2SELogicalViewRootNode.this.broken;
                if (bl2 != (bl = J2SELogicalViewProvider.this.hasBrokenLinks())) {
                    J2SELogicalViewRootNode.this.setBroken(bl);
                }
                if ((bl2 = J2SELogicalViewRootNode.this.illegalState) != (bl = J2SELogicalViewProvider.this.hasInvalidJdkVersion())) {
                    J2SELogicalViewRootNode.this.setIllegalState(bl);
                }
            }

            private void refsMayChanged() {
                if (this.task == null) {
                    this.task = RP.create((Runnable)this);
                }
                this.task.schedule(100);
            }
        }
    }
}

