/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.ui.FoldersListSettings;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders;
import org.netbeans.modules.java.j2seproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PanelProjectLocationExtSrc
extends SettingsPanel {
    private PanelConfigureProject firer;
    private WizardDescriptor wizardDescriptor;
    private boolean calculatePF;
    private static final String DEFAULT_BUILD_SCRIPT_NAME = "build.xml";
    private static final String NB_BUILD_SCRIPT_NAME = "nbbuild.xml";
    private JTextField buildScriptName;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField projectLocation;
    private JTextField projectName;

    public PanelProjectLocationExtSrc(PanelConfigureProject panelConfigureProject) {
        this.firer = panelConfigureProject;
        this.initComponents();
        this.projectName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
                PanelProjectLocationExtSrc.this.firePropertyChange("projectName", null, PanelProjectLocationExtSrc.this.projectName.getText());
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
                PanelProjectLocationExtSrc.this.firePropertyChange("projectName", null, PanelProjectLocationExtSrc.this.projectName.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
                PanelProjectLocationExtSrc.this.firePropertyChange("projectName", null, PanelProjectLocationExtSrc.this.projectName.getText());
            }
        });
        this.projectLocation.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.checkBuildScriptName();
                PanelProjectLocationExtSrc.this.dataChanged();
                PanelProjectLocationExtSrc.this.firePropertyChange("projectLocation", null, PanelProjectLocationExtSrc.this.projectLocation.getText());
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.checkBuildScriptName();
                PanelProjectLocationExtSrc.this.dataChanged();
                PanelProjectLocationExtSrc.this.firePropertyChange("projectLocation", null, PanelProjectLocationExtSrc.this.projectLocation.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.checkBuildScriptName();
                PanelProjectLocationExtSrc.this.dataChanged();
                PanelProjectLocationExtSrc.this.firePropertyChange("projectLocation", null, PanelProjectLocationExtSrc.this.projectLocation.getText());
            }
        });
        this.buildScriptName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
    }

    private synchronized void calculateProjectFolder() {
        if (this.calculatePF) {
            File file = ProjectChooser.getProjectsFolder();
            this.projectLocation.setText(file.getAbsolutePath() + File.separator + this.projectName.getText());
            this.calculatePF = true;
        }
    }

    private void checkBuildScriptName() {
        String string;
        File file;
        File file2;
        if (DEFAULT_BUILD_SCRIPT_NAME.equals(this.buildScriptName.getText()) && (file2 = new File(file = new File(string = this.projectLocation.getText()), DEFAULT_BUILD_SCRIPT_NAME)).exists()) {
            this.buildScriptName.setText(NB_BUILD_SCRIPT_NAME);
        }
    }

    private synchronized void setCalculateProjectFolder(boolean bl) {
        this.calculatePF = bl;
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    void read(WizardDescriptor wizardDescriptor) {
        Object object;
        int n;
        this.wizardDescriptor = wizardDescriptor;
        Object var2_2 = null;
        String string = null;
        File file = (File)wizardDescriptor.getProperty("projdir");
        if (file == null) {
            File file2;
            file = ProjectChooser.getProjectsFolder();
            n = FoldersListSettings.getDefault().getNewProjectCount();
            object = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_JavaProject");
            while ((file2 = new File(file, string = MessageFormat.format((String)object, new Integer(++n)))).exists()) {
            }
            wizardDescriptor.putProperty("nameIndex", (Object)new Integer(n));
            this.projectLocation.setText(file.getAbsolutePath());
            this.setCalculateProjectFolder(true);
        } else {
            string = (String)wizardDescriptor.getProperty("name");
            n = this.calculatePF ? 1 : 0;
            this.projectLocation.setText(file.getAbsolutePath());
            this.setCalculateProjectFolder(n != 0);
        }
        this.projectName.setText(string);
        this.projectName.selectAll();
        String string2 = (String)wizardDescriptor.getProperty("buildScriptName");
        if (string2 == null) {
            assert (file != null);
            string2 = DEFAULT_BUILD_SCRIPT_NAME;
            object = new File(file, string2);
            if (((File)object).exists()) {
                string2 = NB_BUILD_SCRIPT_NAME;
            }
        }
        this.buildScriptName.setText(string2);
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("name", (Object)this.projectName.getText());
        File file = new File(this.projectLocation.getText());
        wizardDescriptor.putProperty("projdir", (Object)file);
        String string = this.buildScriptName.getText();
        if (DEFAULT_BUILD_SCRIPT_NAME.equals(string)) {
            string = null;
        }
        wizardDescriptor.putProperty("buildScriptName", (Object)string);
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        String string = PanelProjectLocationExtSrc.checkValidity(this.projectName.getText(), this.projectLocation.getText(), this.buildScriptName.getText());
        if (string == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        return false;
    }

    static String checkValidity(String string, String string2, String string3) {
        int n;
        Object object;
        if (string.length() == 0 || string.indexOf(47) > 0 || string.indexOf(92) > 0 || string.indexOf(58) > 0) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectName");
        }
        File file = new File(string2).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(file) == null) {
            return NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
        }
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        if (file == null || !file.canWrite()) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_ProjectFolderReadOnly");
        }
        if (string3.length() == 0 || string3.indexOf(File.separatorChar) >= 0 || !string3.endsWith(".xml")) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WrongBuildScriptName");
        }
        File file2 = FileUtil.normalizeFile((File)new File(string2));
        File[] fileArray = file2.listFiles();
        if (file2.exists() && fileArray != null && fileArray.length > 0) {
            object = null;
            for (n = 0; n < fileArray.length; ++n) {
                String string4 = fileArray[n].getName();
                if ("nbproject".equals(string4)) {
                    object = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_NetBeansProject");
                } else if ("build".equals(string4)) {
                    object = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_BuildFolder");
                } else if ("dist".equals(string4)) {
                    object = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_DistFolder");
                } else if (string3.equals(string4)) {
                    object = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_BuildXML");
                }
                if (object == null) continue;
                String string5 = NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_ProjectFolderInvalid");
                return MessageFormat.format(string5, object);
            }
        }
        if (file2.isDirectory()) {
            object = FileUtil.toFileObject((File)file2);
            assert (object != null) : "No FileObject for " + file2;
            n = 0;
            try {
                n = ProjectManager.getDefault().findProject(object) == null ? 1 : 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n == 0) {
                return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_ProjectFolderHasDeletedProject");
            }
        }
        return null;
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.projectName = new JTextField();
        this.jLabel6 = new JLabel();
        this.projectLocation = new JTextField();
        this.jButton3 = new JButton();
        this.jLabel1 = new JLabel();
        this.buildScriptName = new JTextField();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel4.setLabelFor(this.jPanel2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_ProjectNameAndLocationLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_jLabel4"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_jLabel4"));
        this.jLabel5.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_ProjectName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_projectNameLabel"));
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_projectNameLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.projectName, gridBagConstraints);
        this.jLabel6.setDisplayedMnemonic(NbBundle.getBundle(PanelProjectLocationExtSrc.class).getString("LBL_NWP1_CreatedProjectFolder_LablelMnemonic").charAt(0));
        this.jLabel6.setLabelFor(this.projectLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel6.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_projectLocationLabel"));
        this.jLabel6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_projectLocationLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.projectLocation, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_BrowseLocation_Button3"));
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelProjectLocationExtSrc.this.browseProjectLocation(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.jButton3, gridBagConstraints);
        this.jButton3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_browseButton"));
        this.jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_browseButton"));
        this.jLabel1.setLabelFor(this.buildScriptName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_BuildScriptName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"AD_BuildScriptName"));
        this.buildScriptName.setText("\n");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.buildScriptName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_jPanel1"));
        this.jPanel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_jPanel1"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_PanelSourceFolders"));
    }

    private void browseProjectLocation(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_NWP1_SelectProjectLocation"));
        jFileChooser.setFileSelectionMode(1);
        String string = this.projectLocation.getText();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.projectLocation.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
    }
}

