/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodPermission;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EjbViewController {
    private final String ejbClass;
    private final EjbJar ejbModule;
    private String displayName;

    public EjbViewController(String string, EjbJar ejbJar) {
        this.ejbClass = string;
        this.ejbModule = ejbJar;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            try {
                this.displayName = (String)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                    public String run(EjbJarMetadata ejbJarMetadata) throws IOException {
                        Ejb ejb = ejbJarMetadata.findByEjbClass(EjbViewController.this.ejbClass);
                        String string = ejb.getDefaultDisplayName();
                        if (string == null) {
                            string = ejb.getEjbName();
                        }
                        return string;
                    }
                });
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this.displayName;
    }

    public void delete(boolean bl) throws IOException {
        boolean bl2 = "1.5".equals(this.ejbModule.getJ2eePlatformVersion());
        if (!bl2) {
            this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                public Void run(EjbJarMetadata ejbJarMetadata) throws Exception {
                    org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = ejbJarMetadata.getRoot();
                    EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
                    return null;
                }
            });
            this.writeDD();
            if (bl) {
                this.deleteClasses();
            }
        } else {
            this.deleteClasses();
        }
    }

    public EjbReference createEjbReference() throws IOException {
        Map map = (Map)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Map<String, String>>(){

            public Map<String, String> run(EjbJarMetadata ejbJarMetadata) throws Exception {
                EntityAndSession entityAndSession = (EntityAndSession)ejbJarMetadata.findByEjbClass(EjbViewController.this.ejbClass);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("EjbName", entityAndSession.getEjbName());
                hashMap.put("EjbRefType", entityAndSession instanceof Entity ? "Entity" : "Session");
                hashMap.put("Local", entityAndSession.getLocal());
                hashMap.put("LocalHome", entityAndSession.getLocalHome());
                hashMap.put("Remote", entityAndSession.getRemote());
                hashMap.put("Home", entityAndSession.getHome());
                return hashMap;
            }
        });
        return EjbReference.create((String)this.ejbClass, (String)((String)map.get("EjbRefType")), (String)((String)map.get("Local")), (String)((String)map.get("LocalHome")), (String)((String)map.get("Remote")), (String)((String)map.get("Home")), (EjbJar)this.ejbModule);
    }

    public DataObject getBeanDo() {
        return this.getDataObject(this.ejbClass);
    }

    public DataObject getDataObject(String string) {
        FileObject fileObject = this.findFileObject(string);
        try {
            if (fileObject != null) {
                return DataObject.find((FileObject)fileObject);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        return null;
    }

    public ElementHandle<TypeElement> getBeanClass() {
        FileObject fileObject = this.findFileObject(this.ejbClass);
        if (fileObject == null) {
            return null;
        }
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            final ArrayList arrayList = new ArrayList(1);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = compilationController.getElements().getTypeElement(EjbViewController.this.ejbClass);
                    arrayList.add(ElementHandle.create((Element)typeElement));
                }
            }, true);
            return (ElementHandle)arrayList.get(0);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    public String getRemoteStringRepresentation(final String string) {
        String string2 = null;
        try {
            string2 = (String)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata ejbJarMetadata) throws IOException {
                    Ejb ejb = ejbJarMetadata.findByEjbClass(EjbViewController.this.ejbClass);
                    assert (ejb instanceof EntityAndSession);
                    EntityAndSession entityAndSession = (EntityAndSession)ejb;
                    return "\t<ejb-ref>\n\t\t<ejb-ref-name>ejb/" + ejb.getEjbName() + "</ejb-ref-name>\n" + "\t\t<ejb-ref-type>" + string + "</ejb-ref-type>\n" + "\t\t<home>" + entityAndSession.getHome() + "</home>\n" + "\t\t<remote>" + entityAndSession.getRemote() + "</remote>\n" + "\t</ejb-ref>\n";
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return string2;
    }

    public String getLocalStringRepresentation(final String string) {
        String string2 = null;
        try {
            string2 = (String)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata ejbJarMetadata) throws IOException {
                    Ejb ejb = ejbJarMetadata.findByEjbClass(EjbViewController.this.ejbClass);
                    assert (ejb instanceof EntityAndSession);
                    EntityAndSession entityAndSession = (EntityAndSession)ejb;
                    return "\t<ejb-local-ref>\n\t\t<ejb-ref-name>ejb/" + ejb.getEjbName() + "</ejb-ref-name>\n" + "\t\t<ejb-ref-type>" + string + "</ejb-ref-type>\n" + "\t\t<local-home>" + entityAndSession.getLocalHome() + "</local-home>\n" + "\t\t<local>" + entityAndSession.getLocal() + "</local>\n" + "\t</ejb-local-ref>\n";
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return string2;
    }

    private void writeDD() throws IOException {
        FileObject fileObject = this.ejbModule.getDeploymentDescriptor();
        DDProvider.getDefault().getDDRoot(fileObject).write(fileObject);
    }

    private boolean isEjbUsed(EjbRelationshipRole ejbRelationshipRole, String string) {
        return ejbRelationshipRole != null && ejbRelationshipRole.getRelationshipRoleSource() != null && string.equals(ejbRelationshipRole.getRelationshipRoleSource().getEjbName());
    }

    private void deleteRelationships(String string, org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar) {
        EjbRelation[] ejbRelationArray;
        Relationships relationships = ejbJar.getSingleRelationships();
        if (relationships != null && (ejbRelationArray = relationships.getEjbRelation()) != null) {
            for (EjbRelation ejbRelation : ejbRelationArray) {
                if (!this.isEjbUsed(ejbRelation.getEjbRelationshipRole(), string) && !this.isEjbUsed(ejbRelation.getEjbRelationshipRole2(), string)) continue;
                relationships.removeEjbRelation(ejbRelation);
            }
            if (relationships.sizeEjbRelation() == 0) {
                ejbJar.setRelationships(null);
            }
        }
    }

    private void deleteTraces(Ejb ejb, org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar) {
        String string = ejb.getEjbName();
        String string2 = string + "";
        this.deleteRelationships(string, ejbJar);
        AssemblyDescriptor assemblyDescriptor = ejbJar.getSingleAssemblyDescriptor();
        if (assemblyDescriptor != null) {
            ContainerTransaction[] containerTransactionArray;
            for (ContainerTransaction containerTransaction : containerTransactionArray = assemblyDescriptor.getContainerTransaction()) {
                Method[] methodArray = containerTransaction.getMethod();
                for (Method method : methodArray = methodArray == null ? new Method[]{} : methodArray) {
                    if (!string2.equals(method.getEjbName())) continue;
                    containerTransaction.removeMethod(method);
                    if (containerTransaction.sizeMethod() != 0) continue;
                    assemblyDescriptor.removeContainerTransaction(containerTransaction);
                }
            }
            ContainerTransaction[] containerTransactionArray2 = assemblyDescriptor.getMethodPermission();
            for (int i = 0; i < containerTransactionArray2.length; ++i) {
                Method[] methodArray = containerTransactionArray2[i].getMethod();
                methodArray = methodArray == null ? new Method[]{} : methodArray;
                for (int j = 0; j < methodArray.length; ++j) {
                    if (!string2.equals(methodArray[j].getEjbName())) continue;
                    containerTransactionArray2[i].removeMethod(methodArray[j]);
                    if (containerTransactionArray2[i].sizeMethod() != 0) continue;
                    assemblyDescriptor.removeMethodPermission((MethodPermission)containerTransactionArray2[i]);
                }
            }
        }
    }

    private FileObject findFileObject(final String string) {
        FileObject fileObject = null;
        try {
            fileObject = (FileObject)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

                public FileObject run(EjbJarMetadata ejbJarMetadata) throws IOException {
                    return ejbJarMetadata.findResource(Utils.toResourceName(string));
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return fileObject;
    }

    private void deleteClasses() {
        final ArrayList arrayList = new ArrayList();
        try {
            this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                public Void run(EjbJarMetadata ejbJarMetadata) throws Exception {
                    arrayList.add(ejbJarMetadata.findResource(EjbViewController.this.ejbClass));
                    Ejb ejb = ejbJarMetadata.findByEjbClass(EjbViewController.this.ejbClass);
                    if (ejb instanceof EntityAndSession) {
                        EntityAndSession entityAndSession = (EntityAndSession)ejb;
                        if (entityAndSession.getLocalHome() != null) {
                            arrayList.add(ejbJarMetadata.findResource(entityAndSession.getLocalHome()));
                            arrayList.add(ejbJarMetadata.findResource(entityAndSession.getLocal()));
                            arrayList.add(ejbJarMetadata.findResource(entityAndSession.getLocal() + "Business"));
                        }
                        if (entityAndSession.getHome() != null) {
                            arrayList.add(ejbJarMetadata.findResource(entityAndSession.getHome()));
                            arrayList.add(ejbJarMetadata.findResource(entityAndSession.getRemote()));
                            arrayList.add(ejbJarMetadata.findResource(entityAndSession.getRemote() + "Business"));
                        }
                    }
                    return null;
                }
            });
            for (FileObject fileObject : arrayList) {
                if (fileObject == null) continue;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                assert (dataObject != null) : "cannot find DataObject for " + fileObject.getPath();
                if (dataObject == null) continue;
                dataObject.delete();
            }
        }
        catch (IOException iOException) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)iOException));
        }
    }
}

