/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputProcessor;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.execution.StopAction;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OutputForwarder
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(OutputForwarder.class.getName());
    static final Pattern RANGE_ERROR_RE = Pattern.compile("#<RangeError: 0x[0-9a-f]+ is recycled object>");
    private StopAction stopAction;
    private InputStream str;
    private OutputWriter writer;
    private FileLocator fileLocator;
    private List<OutputRecognizer> recognizers;

    OutputForwarder(InputStream inputStream, OutputWriter outputWriter, FileLocator fileLocator, List<OutputRecognizer> list, StopAction stopAction) {
        this.str = inputStream;
        this.writer = outputWriter;
        this.fileLocator = fileLocator;
        this.recognizers = list;
        this.stopAction = stopAction;
    }

    void processLine(String string) throws IOException {
        if (RANGE_ERROR_RE.matcher(string).matches()) {
            LOGGER.log(Level.FINE, "Filtering line from Output Window (issue #110763): " + string);
            return;
        }
        if (Util.containsAnsiColors(string)) {
            string = Util.stripAnsiColors(string);
        }
        OutputRecognizer.FileLocation fileLocation = null;
        boolean bl = false;
        for (OutputRecognizer outputRecognizer : this.recognizers) {
            OutputRecognizer.RecognizedOutput recognizedOutput = outputRecognizer.processLine(string);
            if (recognizedOutput instanceof OutputRecognizer.FileLocation) {
                fileLocation = (OutputRecognizer.FileLocation)recognizedOutput;
                continue;
            }
            if (!(recognizedOutput instanceof OutputRecognizer.ActionText)) continue;
            OutputRecognizer.ActionText actionText = (OutputRecognizer.ActionText)recognizedOutput;
            String[] stringArray = actionText.getPlainLinesPre();
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    this.writer.println(string2);
                }
            }
            if ((stringArray = actionText.getActionLines()) != null) {
                Object[] objectArray = actionText.getActions();
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2 = stringArray[i];
                    this.writer.println(string2, (OutputListener)new ActionHandler((Runnable)objectArray[i]));
                }
            }
            if ((stringArray = actionText.getPlainLinesPost()) != null) {
                for (String string3 : stringArray) {
                    this.writer.println(string3);
                }
            }
            bl = true;
        }
        if (!bl) {
            if (fileLocation != null) {
                this.writer.println(string, (OutputListener)new OutputProcessor(fileLocation.file, fileLocation.line, this.fileLocator));
            } else {
                this.writer.println(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        for (OutputRecognizer var2_2 : this.recognizers) {
            var2_2.start();
        }
        var1_1 = new BufferedReader(new InputStreamReader(this.str), 1200);
        var2_3 = new StringBuilder();
        try {
            try {
                block144: {
                    block158: {
                        block155: {
                            block154: {
                                while (true) {
                                    block145: {
                                        if (var1_1.ready()) break block145;
                                        try {
                                            Thread.sleep(50L);
                                        }
                                        catch (InterruptedException var3_4) {
                                            block147: {
                                                var6_10 = null;
                                                try {
                                                    try {
                                                        if (Thread.interrupted()) {
                                                            // empty if block
                                                        }
                                                        if (this.stopAction.process == null) {
                                                            var7_17 = false;
                                                        } else {
                                                            try {
                                                                this.stopAction.process.exitValue();
                                                                var7_17 = false;
                                                            }
                                                            catch (IllegalThreadStateException var8_31) {
                                                                var7_17 = true;
                                                            }
                                                        }
                                                        if (var7_17) {
                                                            if (this.str.available() > 0) {
                                                                var8_31 = var1_1.readLine();
                                                                var2_3.append((String)var8_31);
                                                            }
                                                            if (var2_3.length() > 0) {
                                                                this.processLine(var2_3.toString());
                                                            }
                                                        } else {
                                                            while ((var8_31 = var1_1.readLine()) != null) {
                                                                var2_3.append((String)var8_31);
                                                                this.processLine(var2_3.toString());
                                                                var2_3.setLength(0);
                                                            }
                                                        }
                                                        var10_38 = null;
                                                    }
                                                    catch (IOException var7_18) {
                                                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var7_18.getMessage());
                                                        var10_39 = null;
                                                        try {
                                                            var1_1.close();
                                                        }
                                                        catch (IOException var11_60) {
                                                            OutputForwarder.LOGGER.log(Level.WARNING, var11_60.getMessage(), (Throwable)var11_60);
                                                        }
                                                        this.writer.flush();
                                                        this.writer.close();
                                                        for (OutputRecognizer var12_81 : this.recognizers) {
                                                            var12_81.finish();
                                                        }
                                                        return;
                                                    }
                                                }
                                                catch (Throwable var9_101) {
                                                    block146: {
                                                        var10_40 = null;
                                                        ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl67:
                                                        // 1 sources

                                                        var1_1.close();
                                                        break block146;
lbl69:
                                                        // 1 sources

                                                        catch (IOException var11_61) {
                                                            OutputForwarder.LOGGER.log(Level.WARNING, var11_61.getMessage(), (Throwable)var11_61);
                                                        }
                                                    }
                                                    this.writer.flush();
                                                    this.writer.close();
                                                    var11_61 = this.recognizers.iterator();
                                                    while (true) {
                                                        if (!var11_61.hasNext()) {
                                                            throw var9_101;
                                                        }
                                                        var12_82 = (OutputRecognizer)var11_61.next();
                                                        var12_82.finish();
                                                    }
                                                }
                                                ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl83:
                                                // 1 sources

                                                var1_1.close();
                                                break block147;
lbl85:
                                                // 1 sources

                                                catch (IOException var11_59) {
                                                    OutputForwarder.LOGGER.log(Level.WARNING, var11_59.getMessage(), (Throwable)var11_59);
                                                }
                                            }
                                            this.writer.flush();
                                            this.writer.close();
                                            for (OutputRecognizer var12_80 : this.recognizers) {
                                                var12_80.finish();
                                            }
                                            return;
                                        }
                                        if (this.stopAction.process != null) {
                                            if (var1_1.ready() || var2_3.length() <= 0) continue;
                                            var3_5 = var2_3.toString();
                                            var2_3.setLength(0);
                                            this.writer.print(var3_5);
                                            continue;
                                        }
                                        break block144;
                                    }
                                    while (var1_1.ready()) {
                                        block148: {
                                            block153: {
                                                block150: {
                                                    block149: {
                                                        var3_6 = -1;
                                                        var3_6 = var1_1.read();
                                                        if (var3_6 != -1) break block148;
                                                        var4_9 = var2_3.toString();
                                                        var2_3.setLength(0);
                                                        this.processLine(var4_9);
                                                        var6_12 = null;
                                                        ** try [egrp 3[TRYBLOCK] [18 : 274->447)] { 
lbl112:
                                                        // 1 sources

                                                        ** try [egrp 4[TRYBLOCK] [17 : 274->401)] { 
lbl113:
                                                        // 1 sources

                                                        if (Thread.interrupted()) {
                                                            // empty if block
                                                        }
                                                        if (this.stopAction.process == null) {
                                                            var7_21 = false;
                                                        } else {
                                                            ** try [egrp 5[TRYBLOCK] [16 : 296->313)] { 
lbl119:
                                                            // 1 sources

                                                            this.stopAction.process.exitValue();
                                                            var7_21 = false;
                                                        }
                                                        break block149;
lbl123:
                                                        // 1 sources

                                                        catch (IllegalThreadStateException var8_33) {
                                                            var7_21 = true;
                                                        }
                                                    }
                                                    if (var7_21) {
                                                        if (this.str.available() > 0) {
                                                            var8_33 = var1_1.readLine();
                                                            var2_3.append((String)var8_33);
                                                        }
                                                        if (var2_3.length() > 0) {
                                                            this.processLine(var2_3.toString());
                                                        }
                                                        break block150;
                                                    } else {
                                                        while ((var8_33 = var1_1.readLine()) != null) {
                                                            var2_3.append((String)var8_33);
                                                            this.processLine(var2_3.toString());
                                                            var2_3.setLength(0);
                                                        }
                                                    }
                                                    break block150;
lbl141:
                                                    // 1 sources

                                                    catch (IOException var7_22) {
                                                        block151: {
                                                            OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var7_22.getMessage());
                                                            var10_45 = null;
                                                            ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl146:
                                                            // 1 sources

                                                            var1_1.close();
                                                            break block151;
lbl148:
                                                            // 1 sources

                                                            catch (IOException var11_66) {
                                                                OutputForwarder.LOGGER.log(Level.WARNING, var11_66.getMessage(), (Throwable)var11_66);
                                                            }
                                                        }
                                                        this.writer.flush();
                                                        this.writer.close();
                                                        for (OutputRecognizer var12_87 : this.recognizers) {
                                                            var12_87.finish();
                                                        }
                                                        return;
                                                    }
lbl157:
                                                    // 1 sources

                                                    catch (Throwable var9_103) {
                                                        block152: {
                                                            var10_46 = null;
                                                            ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl161:
                                                            // 1 sources

                                                            var1_1.close();
                                                            break block152;
lbl163:
                                                            // 1 sources

                                                            catch (IOException var11_67) {
                                                                OutputForwarder.LOGGER.log(Level.WARNING, var11_67.getMessage(), (Throwable)var11_67);
                                                            }
                                                        }
                                                        this.writer.flush();
                                                        this.writer.close();
                                                        var11_67 = this.recognizers.iterator();
                                                        while (true) {
                                                            if (!var11_67.hasNext()) {
                                                                throw var9_103;
                                                            }
                                                            var12_88 = (OutputRecognizer)var11_67.next();
                                                            var12_88.finish();
                                                        }
                                                    }
                                                }
                                                var10_44 = null;
                                                ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl178:
                                                // 1 sources

                                                var1_1.close();
                                                break block153;
lbl180:
                                                // 1 sources

                                                catch (IOException var11_65) {
                                                    OutputForwarder.LOGGER.log(Level.WARNING, var11_65.getMessage(), (Throwable)var11_65);
                                                }
                                            }
                                            this.writer.flush();
                                            this.writer.close();
                                            for (OutputRecognizer var12_86 : this.recognizers) {
                                                var12_86.finish();
                                            }
                                            return;
                                        }
                                        var2_3.append((char)var3_6);
                                    }
                                    if (Thread.interrupted()) break;
                                }
                                var6_13 = null;
                                ** try [egrp 3[TRYBLOCK] [18 : 274->447)] { 
lbl198:
                                // 1 sources

                                ** try [egrp 4[TRYBLOCK] [17 : 274->401)] { 
lbl199:
                                // 1 sources

                                if (Thread.interrupted()) {
                                    // empty if block
                                }
                                if (this.stopAction.process == null) {
                                    var7_23 = false;
                                } else {
                                    ** try [egrp 5[TRYBLOCK] [16 : 296->313)] { 
lbl205:
                                    // 1 sources

                                    this.stopAction.process.exitValue();
                                    var7_23 = false;
                                }
                                break block154;
lbl209:
                                // 1 sources

                                catch (IllegalThreadStateException var8_34) {
                                    var7_23 = true;
                                }
                            }
                            if (var7_23) {
                                if (this.str.available() > 0) {
                                    var8_34 = var1_1.readLine();
                                    var2_3.append((String)var8_34);
                                }
                                if (var2_3.length() > 0) {
                                    this.processLine(var2_3.toString());
                                }
                                break block155;
                            } else {
                                while ((var8_34 = var1_1.readLine()) != null) {
                                    var2_3.append((String)var8_34);
                                    this.processLine(var2_3.toString());
                                    var2_3.setLength(0);
                                }
                            }
                            break block155;
lbl227:
                            // 1 sources

                            catch (IOException var7_24) {
                                block156: {
                                    OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var7_24.getMessage());
                                    var10_48 = null;
                                    ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl232:
                                    // 1 sources

                                    var1_1.close();
                                    break block156;
lbl234:
                                    // 1 sources

                                    catch (IOException var11_69) {
                                        OutputForwarder.LOGGER.log(Level.WARNING, var11_69.getMessage(), (Throwable)var11_69);
                                    }
                                }
                                this.writer.flush();
                                this.writer.close();
                                for (OutputRecognizer var12_90 : this.recognizers) {
                                    var12_90.finish();
                                }
                                return;
                            }
lbl243:
                            // 1 sources

                            catch (Throwable var9_104) {
                                block157: {
                                    var10_49 = null;
                                    ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl247:
                                    // 1 sources

                                    var1_1.close();
                                    break block157;
lbl249:
                                    // 1 sources

                                    catch (IOException var11_70) {
                                        OutputForwarder.LOGGER.log(Level.WARNING, var11_70.getMessage(), (Throwable)var11_70);
                                    }
                                }
                                this.writer.flush();
                                this.writer.close();
                                var11_70 = this.recognizers.iterator();
                                while (true) {
                                    if (!var11_70.hasNext()) {
                                        throw var9_104;
                                    }
                                    var12_91 = (OutputRecognizer)var11_70.next();
                                    var12_91.finish();
                                }
                            }
                        }
                        var10_47 = null;
                        ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl264:
                        // 1 sources

                        var1_1.close();
                        break block158;
lbl266:
                        // 1 sources

                        catch (IOException var11_68) {
                            OutputForwarder.LOGGER.log(Level.WARNING, var11_68.getMessage(), (Throwable)var11_68);
                        }
                    }
                    this.writer.flush();
                    this.writer.close();
                    for (OutputRecognizer var12_89 : this.recognizers) {
                        var12_89.finish();
                    }
                    return;
                }
                var6_11 = null;
                ** GOTO lbl428
            }
            catch (IOException var3_7) {
                block163: {
                    block160: {
                        block159: {
                            OutputForwarder.LOGGER.log(Level.INFO, var3_7.getMessage(), var3_7);
                            var6_14 = null;
                            ** try [egrp 3[TRYBLOCK] [18 : 274->447)] { 
lbl283:
                            // 1 sources

                            ** try [egrp 4[TRYBLOCK] [17 : 274->401)] { 
lbl284:
                            // 1 sources

                            if (Thread.interrupted()) {
                                // empty if block
                            }
                            if (this.stopAction.process == null) {
                                var7_25 = false;
                            } else {
                                ** try [egrp 5[TRYBLOCK] [16 : 296->313)] { 
lbl290:
                                // 1 sources

                                this.stopAction.process.exitValue();
                                var7_25 = false;
                            }
                            break block159;
lbl294:
                            // 1 sources

                            catch (IllegalThreadStateException var8_35) {
                                var7_25 = true;
                            }
                        }
                        if (var7_25) {
                            if (this.str.available() > 0) {
                                var8_35 = var1_1.readLine();
                                var2_3.append((String)var8_35);
                            }
                            if (var2_3.length() > 0) {
                                this.processLine(var2_3.toString());
                            }
                            break block160;
                        } else {
                            while ((var8_35 = var1_1.readLine()) != null) {
                                var2_3.append((String)var8_35);
                                this.processLine(var2_3.toString());
                                var2_3.setLength(0);
                            }
                        }
                        break block160;
lbl312:
                        // 1 sources

                        catch (IOException var7_26) {
                            block161: {
                                OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var7_26.getMessage());
                                var10_51 = null;
                                ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl317:
                                // 1 sources

                                var1_1.close();
                                break block161;
lbl319:
                                // 1 sources

                                catch (IOException var11_72) {
                                    OutputForwarder.LOGGER.log(Level.WARNING, var11_72.getMessage(), (Throwable)var11_72);
                                }
                            }
                            this.writer.flush();
                            this.writer.close();
                            for (OutputRecognizer var12_93 : this.recognizers) {
                                var12_93.finish();
                            }
                            return;
                        }
lbl328:
                        // 1 sources

                        catch (Throwable var9_105) {
                            block162: {
                                var10_52 = null;
                                ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl332:
                                // 1 sources

                                var1_1.close();
                                break block162;
lbl334:
                                // 1 sources

                                catch (IOException var11_73) {
                                    OutputForwarder.LOGGER.log(Level.WARNING, var11_73.getMessage(), (Throwable)var11_73);
                                }
                            }
                            this.writer.flush();
                            this.writer.close();
                            var11_73 = this.recognizers.iterator();
                            while (true) {
                                if (!var11_73.hasNext()) {
                                    throw var9_105;
                                }
                                var12_94 = (OutputRecognizer)var11_73.next();
                                var12_94.finish();
                            }
                        }
                    }
                    var10_50 = null;
                    ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl349:
                    // 1 sources

                    var1_1.close();
                    break block163;
lbl351:
                    // 1 sources

                    catch (IOException var11_71) {
                        OutputForwarder.LOGGER.log(Level.WARNING, var11_71.getMessage(), (Throwable)var11_71);
                    }
                }
                this.writer.flush();
                this.writer.close();
                for (OutputRecognizer var12_92 : this.recognizers) {
                    var12_92.finish();
                }
                return;
            }
            catch (Throwable var3_8) {
                block173: {
                    block165: {
                        block172: {
                            block169: {
                                block168: {
                                    block164: {
                                        OutputForwarder.LOGGER.log(Level.INFO, var3_8.getMessage(), var3_8);
                                        var6_15 = null;
                                        ** try [egrp 3[TRYBLOCK] [18 : 274->447)] { 
lbl365:
                                        // 1 sources

                                        ** try [egrp 4[TRYBLOCK] [17 : 274->401)] { 
lbl366:
                                        // 1 sources

                                        if (Thread.interrupted()) {
                                            // empty if block
                                        }
                                        if (this.stopAction.process == null) {
                                            var7_27 = false;
                                        } else {
                                            ** try [egrp 5[TRYBLOCK] [16 : 296->313)] { 
lbl372:
                                            // 1 sources

                                            this.stopAction.process.exitValue();
                                            var7_27 = false;
                                        }
                                        break block164;
lbl376:
                                        // 1 sources

                                        catch (IllegalThreadStateException var8_36) {
                                            var7_27 = true;
                                        }
                                    }
                                    if (var7_27) {
                                        if (this.str.available() > 0) {
                                            var8_36 = var1_1.readLine();
                                            var2_3.append((String)var8_36);
                                        }
                                        if (var2_3.length() > 0) {
                                            this.processLine(var2_3.toString());
                                        }
                                        break block165;
                                    } else {
                                        while ((var8_36 = var1_1.readLine()) != null) {
                                            var2_3.append((String)var8_36);
                                            this.processLine(var2_3.toString());
                                            var2_3.setLength(0);
                                        }
                                    }
                                    break block165;
lbl394:
                                    // 1 sources

                                    catch (IOException var7_28) {
                                        block166: {
                                            OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var7_28.getMessage());
                                            var10_54 = null;
                                            ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl399:
                                            // 1 sources

                                            var1_1.close();
                                            break block166;
lbl401:
                                            // 1 sources

                                            catch (IOException var11_75) {
                                                OutputForwarder.LOGGER.log(Level.WARNING, var11_75.getMessage(), (Throwable)var11_75);
                                            }
                                        }
                                        this.writer.flush();
                                        this.writer.close();
                                        for (OutputRecognizer var12_96 : this.recognizers) {
                                            var12_96.finish();
                                        }
                                        return;
                                    }
lbl410:
                                    // 1 sources

                                    catch (Throwable var9_106) {
                                        block167: {
                                            var10_55 = null;
                                            ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl414:
                                            // 1 sources

                                            var1_1.close();
                                            break block167;
lbl416:
                                            // 1 sources

                                            catch (IOException var11_76) {
                                                OutputForwarder.LOGGER.log(Level.WARNING, var11_76.getMessage(), (Throwable)var11_76);
                                            }
                                        }
                                        this.writer.flush();
                                        this.writer.close();
                                        var11_76 = this.recognizers.iterator();
                                        while (true) {
                                            if (!var11_76.hasNext()) {
                                                throw var9_106;
                                            }
                                            var12_97 = (OutputRecognizer)var11_76.next();
                                            var12_97.finish();
                                        }
                                    }
lbl428:
                                    // 1 sources

                                    ** try [egrp 3[TRYBLOCK] [18 : 274->447)] { 
lbl429:
                                    // 1 sources

                                    ** try [egrp 4[TRYBLOCK] [17 : 274->401)] { 
lbl430:
                                    // 1 sources

                                    if (Thread.interrupted()) {
                                        // empty if block
                                    }
                                    if (this.stopAction.process == null) {
                                        var7_19 = false;
                                    } else {
                                        ** try [egrp 5[TRYBLOCK] [16 : 296->313)] { 
lbl436:
                                        // 1 sources

                                        this.stopAction.process.exitValue();
                                        var7_19 = false;
                                    }
                                    break block168;
lbl440:
                                    // 1 sources

                                    catch (IllegalThreadStateException var8_32) {
                                        var7_19 = true;
                                    }
                                }
                                if (var7_19) {
                                    if (this.str.available() > 0) {
                                        var8_32 = var1_1.readLine();
                                        var2_3.append((String)var8_32);
                                    }
                                    if (var2_3.length() > 0) {
                                        this.processLine(var2_3.toString());
                                    }
                                    break block169;
                                } else {
                                    while ((var8_32 = var1_1.readLine()) != null) {
                                        var2_3.append((String)var8_32);
                                        this.processLine(var2_3.toString());
                                        var2_3.setLength(0);
                                    }
                                }
                                break block169;
lbl458:
                                // 1 sources

                                catch (IOException var7_20) {
                                    block170: {
                                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var7_20.getMessage());
                                        var10_42 = null;
                                        ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl463:
                                        // 1 sources

                                        var1_1.close();
                                        break block170;
lbl465:
                                        // 1 sources

                                        catch (IOException var11_63) {
                                            OutputForwarder.LOGGER.log(Level.WARNING, var11_63.getMessage(), (Throwable)var11_63);
                                        }
                                    }
                                    this.writer.flush();
                                    this.writer.close();
                                    for (OutputRecognizer var12_84 : this.recognizers) {
                                        var12_84.finish();
                                    }
                                    return;
                                }
lbl474:
                                // 1 sources

                                catch (Throwable var9_102) {
                                    block171: {
                                        var10_43 = null;
                                        ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl478:
                                        // 1 sources

                                        var1_1.close();
                                        break block171;
lbl480:
                                        // 1 sources

                                        catch (IOException var11_64) {
                                            OutputForwarder.LOGGER.log(Level.WARNING, var11_64.getMessage(), (Throwable)var11_64);
                                        }
                                    }
                                    this.writer.flush();
                                    this.writer.close();
                                    var11_64 = this.recognizers.iterator();
                                    while (true) {
                                        if (!var11_64.hasNext()) {
                                            throw var9_102;
                                        }
                                        var12_85 = (OutputRecognizer)var11_64.next();
                                        var12_85.finish();
                                    }
                                }
                            }
                            var10_41 = null;
                            ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl495:
                            // 1 sources

                            var1_1.close();
                            break block172;
lbl497:
                            // 1 sources

                            catch (IOException var11_62) {
                                OutputForwarder.LOGGER.log(Level.WARNING, var11_62.getMessage(), (Throwable)var11_62);
                            }
                        }
                        this.writer.flush();
                        this.writer.close();
                        for (OutputRecognizer var12_83 : this.recognizers) {
                            var12_83.finish();
                        }
                        return;
                    }
                    var10_53 = null;
                    ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl509:
                    // 1 sources

                    var1_1.close();
                    break block173;
lbl511:
                    // 1 sources

                    catch (IOException var11_74) {
                        OutputForwarder.LOGGER.log(Level.WARNING, var11_74.getMessage(), (Throwable)var11_74);
                    }
                }
                this.writer.flush();
                this.writer.close();
                for (OutputRecognizer var12_95 : this.recognizers) {
                    var12_95.finish();
                }
                return;
            }
        }
        catch (Throwable var5_108) {
            block178: {
                block175: {
                    block174: {
                        var6_16 = null;
                        ** try [egrp 3[TRYBLOCK] [18 : 274->447)] { 
lbl524:
                        // 1 sources

                        ** try [egrp 4[TRYBLOCK] [17 : 274->401)] { 
lbl525:
                        // 1 sources

                        if (Thread.interrupted()) {
                            // empty if block
                        }
                        if (this.stopAction.process == null) {
                            var7_29 = false;
                        } else {
                            ** try [egrp 5[TRYBLOCK] [16 : 296->313)] { 
lbl531:
                            // 1 sources

                            this.stopAction.process.exitValue();
                            var7_29 = false;
                        }
                        break block174;
lbl535:
                        // 1 sources

                        catch (IllegalThreadStateException var8_37) {
                            var7_29 = true;
                        }
                    }
                    if (var7_29) {
                        if (this.str.available() > 0) {
                            var8_37 = var1_1.readLine();
                            var2_3.append((String)var8_37);
                        }
                        if (var2_3.length() > 0) {
                            this.processLine(var2_3.toString());
                        }
                        break block175;
                    } else {
                        while ((var8_37 = var1_1.readLine()) != null) {
                            var2_3.append((String)var8_37);
                            this.processLine(var2_3.toString());
                            var2_3.setLength(0);
                        }
                    }
                    break block175;
lbl553:
                    // 1 sources

                    catch (IOException var7_30) {
                        block176: {
                            OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var7_30.getMessage());
                            var10_57 = null;
                            ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl558:
                            // 1 sources

                            var1_1.close();
                            break block176;
lbl560:
                            // 1 sources

                            catch (IOException var11_78) {
                                OutputForwarder.LOGGER.log(Level.WARNING, var11_78.getMessage(), (Throwable)var11_78);
                            }
                        }
                        this.writer.flush();
                        this.writer.close();
                        for (OutputRecognizer var12_99 : this.recognizers) {
                            var12_99.finish();
                        }
                        throw var5_108;
                    }
lbl569:
                    // 1 sources

                    catch (Throwable var9_107) {
                        block177: {
                            var10_58 = null;
                            ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl573:
                            // 1 sources

                            var1_1.close();
                            break block177;
lbl575:
                            // 1 sources

                            catch (IOException var11_79) {
                                OutputForwarder.LOGGER.log(Level.WARNING, var11_79.getMessage(), (Throwable)var11_79);
                            }
                        }
                        this.writer.flush();
                        this.writer.close();
                        var11_79 = this.recognizers.iterator();
                        while (true) {
                            if (!var11_79.hasNext()) {
                                throw var9_107;
                            }
                            var12_100 = (OutputRecognizer)var11_79.next();
                            var12_100.finish();
                        }
                    }
                }
                var10_56 = null;
                ** try [egrp 6[TRYBLOCK] [21 : 457->464)] { 
lbl590:
                // 1 sources

                var1_1.close();
                break block178;
lbl592:
                // 1 sources

                catch (IOException var11_77) {
                    OutputForwarder.LOGGER.log(Level.WARNING, var11_77.getMessage(), (Throwable)var11_77);
                }
            }
            this.writer.flush();
            this.writer.close();
            for (OutputRecognizer var12_98 : this.recognizers) {
                var12_98.finish();
            }
            throw var5_108;
        }
    }

    private class ActionHandler
    implements OutputListener {
        private final Runnable runnable;

        private ActionHandler(Runnable runnable) {
            this.runnable = runnable;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.runnable.run();
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }
}

