/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.scene;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.netbeans.modules.vmd.game.dialog.NewSceneDialog;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Position;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneListener;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.model.TiledLayerListener;
import org.netbeans.modules.vmd.game.nbdialog.SpriteDialog;
import org.netbeans.modules.vmd.game.nbdialog.TiledLayerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class ScenePanel
extends JPanel
implements SceneListener,
TiledLayerListener,
PropertyChangeListener,
MouseMotionListener,
MouseListener {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_GRID_X = 20;
    private static final int DEFAULT_GRID_Y = 20;
    private static final int GRID_MINORS_IN_A_MAJOR = 5;
    private static final Color COLOR_BG = Color.WHITE;
    private static final Color COLOR_GRID_MINOR = Color.GRAY;
    private static final Color COLOR_GRID_MAJOR = Color.BLACK;
    private static final Color COLOR_GRID_QUADRANT = Color.LIGHT_GRAY;
    private Scene scene;
    private Ruler horizontalRuler = new Ruler(0);
    private Ruler verticalRuler = new Ruler(1);
    private GridButton gridButton = new GridButton();
    private boolean showGrid = true;
    private boolean snapGrid = false;
    private int gridX = 20;
    private int gridY = 20;
    private boolean animated;
    private static final int DECOR_TOP_W = 0;
    private static final int DECOR_TOP_H = 25;
    private static final int DECOR_SIDE_W = 5;
    private static final int DECOR_BOTTOM_W = 5;
    private static final int DECOR_BOTTOM_H = 5;
    private Layer topHilitedLayer;
    private Map<Layer, Color> hilitedLayers = new HashMap<Layer, Color>();
    private Color colorSelection = new Color(0, 0, 255, 170);
    private Color colorSelectionLocked = new Color(255, 0, 0, 170);
    private Color colorHilitePrimary = new Color(0, 0, 0, 120);
    private Color colorHiliteSecondary = new Color(0, 0, 0, 50);
    private Set<Layer> selectedLayers = new HashSet<Layer>();
    private Map<Layer, Point> dragLayerStartPoints = new HashMap<Layer, Point>();
    private Point startDragPoint = null;
    private Point lastDragPoint = null;
    private Layer snapToGridReferenceLayer = null;
    private String dragDirectionVertical = "North";
    private String dragDirectionHorizontal = "West";
    private boolean mouseDragging;
    private Layer lastAddedLayerByMousePress = null;

    public ScenePanel(Scene scene) {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.scene = scene;
        this.scene.addSceneListener(this);
        this.scene.addPropertyChangeListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.accessible.name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.accessible.description"));
        for (Layer layer : this.scene.getLayers()) {
            this.registerLayerListeners(layer);
        }
        this.putClientProperty(Printable.class, "");
    }

    private void registerLayerListeners(Layer layer) {
        Layer layer2;
        layer.addPropertyChangeListener(this);
        if (layer instanceof TiledLayer) {
            layer2 = (TiledLayer)layer;
            layer2.addTiledLayerListener(this);
        }
        if (layer instanceof Sprite) {
            layer2 = (Sprite)layer;
        }
    }

    private void unregisterLayerListeners(Layer layer) {
        Layer layer2;
        layer.removePropertyChangeListener(this);
        if (layer instanceof TiledLayer) {
            layer2 = (TiledLayer)layer;
            layer2.removeTiledLayerListener(this);
        }
        if (layer instanceof Sprite) {
            layer2 = (Sprite)layer;
        }
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle = this.scene.getAllLayersBounds();
        rectangle.add(0, 0);
        return rectangle.getSize();
    }

    public void paintComponent(Graphics graphics) {
        this.clearBackground(graphics);
        this.drawQuadrants(graphics);
        if (this.isShowGrid()) {
            this.drawGrid(graphics);
        }
        this.drawSceneItems(graphics);
    }

    private void clearBackground(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(COLOR_BG);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void drawGrid(Graphics graphics) {
        Point point = this.adjustFromOriginShift(new Point(0, 0));
        Rectangle rectangle = graphics.getClipBounds();
        int n = (int)(rectangle.getX() / (double)this.gridX);
        int n2 = (int)((rectangle.getX() + rectangle.getWidth()) / (double)this.gridX);
        int n3 = (int)(rectangle.getY() / (double)this.gridY);
        int n4 = (int)((rectangle.getY() + rectangle.getHeight()) / (double)this.gridY);
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                if (0 == j % 5 || 0 == i % 5) {
                    graphics.setColor(COLOR_GRID_MAJOR);
                } else {
                    graphics.setColor(COLOR_GRID_MINOR);
                }
                int n5 = j * this.gridX + point.x % this.gridX;
                int n6 = i * this.gridY + point.y % this.gridY;
                graphics.drawLine(n5, n6, n5, n6);
            }
        }
    }

    private void drawQuadrants(Graphics graphics) {
        Point point = this.adjustFromOriginShift(new Point(0, 0));
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(COLOR_GRID_QUADRANT);
        if (rectangle.intersectsLine(point.x, 2.147483647E9, point.x, -2.147483648E9)) {
            graphics.drawLine(point.x, rectangle.y, point.x, rectangle.y + rectangle.height);
        }
        if (rectangle.intersectsLine(2.147483647E9, point.y, -2.147483648E9, point.y)) {
            graphics.drawLine(rectangle.x, point.y, rectangle.x + rectangle.width, point.y);
        }
    }

    private void drawSceneItems(Graphics graphics) {
        this.drawLayers(graphics);
        for (int i = 0; i < this.scene.getLayerCount(); ++i) {
            Layer layer = this.scene.getLayerAt(i);
            this.drawLayerDecorations((Graphics2D)graphics, layer);
        }
    }

    void drawLayers(Graphics graphics) {
        for (int i = this.scene.getLayerCount() - 1; i >= 0; --i) {
            Layer layer = this.scene.getLayerAt(i);
            if (!this.scene.isLayerVisible(layer)) continue;
            this.drawLayer(graphics, layer);
        }
    }

    private void drawLayer(Graphics graphics, Layer layer) {
        Rectangle rectangle = graphics.getClipBounds();
        Point point = this.scene.getLayerPosition(layer);
        this.adjustFromOriginShift(point);
        Rectangle rectangle2 = new Rectangle(point.x, point.y, layer.getWidth(), layer.getHeight());
        Rectangle rectangle3 = rectangle2.intersection(rectangle);
        if (rectangle3.isEmpty()) {
            return;
        }
        graphics.setClip(rectangle3);
        graphics.translate(point.x, point.y);
        layer.paint((Graphics2D)graphics);
        graphics.translate(-point.x, -point.y);
        graphics.setClip(rectangle);
    }

    private void drawLayerDecorations(Graphics2D graphics2D, Layer layer) {
        if (!this.hilitedLayers.containsKey(layer) && !this.selectedLayers.contains(layer)) {
            return;
        }
        if (this.selectedLayers.contains(layer)) {
            if (this.scene.isLayerLocked(layer)) {
                graphics2D.setColor(this.colorSelectionLocked);
            } else {
                graphics2D.setColor(this.colorSelection);
            }
        } else if (this.hilitedLayers.containsKey(layer)) {
            graphics2D.setColor(this.hilitedLayers.get(layer));
        } else {
            return;
        }
        Rectangle rectangle = null;
        rectangle = this.getDecorationRectangleForLayerBottom(layer);
        rectangle.translate(0, -layer.getHeight() - 5);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        rectangle = this.getDecorationRectangleForLayerBottom(layer);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        rectangle = this.getDecorationRectangleForLayerLeft(layer);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        rectangle = this.getDecorationRectangleForLayerRight(layer);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private Rectangle getDecorationRectangleForLayerTop(Layer layer) {
        Point point = this.adjustFromOriginShift(this.scene.getLayerPosition(layer));
        return this.getDecorationRectangleForLayerTop(point, layer);
    }

    private Rectangle getDecorationRectangleForLayerBottom(Layer layer) {
        Point point = this.adjustFromOriginShift(this.scene.getLayerPosition(layer));
        return this.getDecorationRectangleForLayerBottom(point, layer);
    }

    private Rectangle getDecorationRectangleForLayerLeft(Layer layer) {
        Point point = this.adjustFromOriginShift(this.scene.getLayerPosition(layer));
        return this.getDecorationRectangleForLayerLeft(point, layer);
    }

    private Rectangle getDecorationRectangleForLayerRight(Layer layer) {
        Point point = this.adjustFromOriginShift(this.scene.getLayerPosition(layer));
        return this.getDecorationRectangleForLayerRight(point, layer);
    }

    private Rectangle getDecorationRectangleForLayerTop(Point point, Layer layer) {
        return new Rectangle(point.x - 0, point.y - 25, 0 + layer.getWidth() + 0, 25);
    }

    private Rectangle getDecorationRectangleForLayerBottom(Point point, Layer layer) {
        return new Rectangle(point.x - 5, point.y + layer.getHeight(), 5 + layer.getWidth() + 5, 5);
    }

    private Rectangle getDecorationRectangleForLayerLeft(Point point, Layer layer) {
        return new Rectangle(point.x - 5, point.y, 5, layer.getHeight());
    }

    private Rectangle getDecorationRectangleForLayerRight(Point point, Layer layer) {
        return new Rectangle(point.x + layer.getWidth(), point.y, 5, layer.getHeight());
    }

    private void repaintLayerWithDecorations(Layer layer) {
        Point point = this.scene.getLayerPosition(layer);
        this.repaintLayerWithDecorations(point, layer);
    }

    private void repaintLayerWithDecorations(Point point, Layer layer) {
        Point point2 = this.adjustFromOriginShift(point);
        this.repaintLayer(point2, layer);
        this.repaintLayerDecorations(point2, layer);
    }

    private void repaintLayer(Layer layer) {
        Point point = this.adjustFromOriginShift(this.scene.getLayerPosition(layer));
        this.repaintLayer(point, layer);
    }

    private void repaintLayer(Point point, Layer layer) {
        this.repaint(point.x, point.y, layer.getWidth(), layer.getHeight());
    }

    private void repaintLayerDecorations(Point point, Layer layer) {
        this.repaint(this.getDecorationRectangleForLayerTop(point, layer));
        this.repaint(this.getDecorationRectangleForLayerBottom(point, layer));
        this.repaint(this.getDecorationRectangleForLayerLeft(point, layer));
        this.repaint(this.getDecorationRectangleForLayerRight(point, layer));
    }

    private void repaintLayerDecorations(Layer layer) {
        if (layer == null) {
            return;
        }
        Point point = this.adjustFromOriginShift(this.scene.getLayerPosition(layer));
        this.repaintLayerDecorations(point, layer);
    }

    private void repaintAllLayerDecorations() {
        List<Layer> list = this.scene.getLayers();
        for (Layer layer : list) {
            this.repaintLayerDecorations(layer);
        }
    }

    public void layerAdded(Scene scene, Layer layer, int n) {
        this.registerLayerListeners(layer);
        this.repaintAllLayerDecorations();
    }

    public void layerMoved(Scene scene, Layer layer, int n, int n2) {
        this.repaintAllLayerDecorations();
    }

    public void layerRemoved(Scene scene, Layer layer, Scene.LayerInfo layerInfo, int n) {
        this.unregisterLayerListeners(layer);
        this.repaintAllLayerDecorations();
    }

    public void layerLockChanged(Scene scene, Layer layer, boolean bl) {
        this.repaintAllLayerDecorations();
    }

    public void layerPositionChanged(Scene scene, Layer layer, Point point, Point point2, boolean bl) {
        this.repaintLayerWithDecorations(point, layer);
        this.repaintLayerWithDecorations(point2, layer);
    }

    public void layerVisibilityChanged(Scene scene, Layer layer, boolean bl) {
        this.repaintLayerWithDecorations(layer);
    }

    private Point adjustFromOriginShift(Point point) {
        Rectangle rectangle = this.scene.getAllLayersBounds();
        rectangle.add(0, 0);
        point.translate(-rectangle.x, -rectangle.y);
        return point;
    }

    private Point adjustToOriginShift(Point point) {
        Rectangle rectangle = this.scene.getAllLayersBounds();
        rectangle.add(0, 0);
        point.translate(rectangle.x, rectangle.y);
        return point;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.scene) {
            if (propertyChangeEvent.getPropertyName().equals("prop.layers.bounds")) {
                this.revalidate();
                this.repaint();
                this.horizontalRuler.repaint();
                this.verticalRuler.repaint();
            }
        } else if (propertyChangeEvent.getSource() instanceof TiledLayer) {
            TiledLayer tiledLayer = (TiledLayer)propertyChangeEvent.getSource();
        } else if (propertyChangeEvent.getSource() instanceof Sprite) {
            Sprite sprite = (Sprite)propertyChangeEvent.getSource();
            if (propertyChangeEvent.getPropertyName().equals("sequencecontainer.prop.defaultsequence")) {
                this.repaintLayerWithDecorations(sprite);
            } else if (propertyChangeEvent.getPropertyName().equals("editable.prop.name")) {
                // empty if block
            }
        }
    }

    public void columnsInserted(TiledLayer tiledLayer, int n, int n2) {
        this.repaintLayerWithDecorations(tiledLayer);
    }

    public void columnsRemoved(TiledLayer tiledLayer, int n, int n2) {
        this.repaintLayerWithDecorations(tiledLayer);
    }

    public void rowsInserted(TiledLayer tiledLayer, int n, int n2) {
        this.repaintLayerWithDecorations(tiledLayer);
    }

    public void rowsRemoved(TiledLayer tiledLayer, int n, int n2) {
        this.repaintLayerWithDecorations(tiledLayer);
    }

    public void tilesStructureChanged(TiledLayer tiledLayer) {
        this.repaintLayerWithDecorations(tiledLayer);
    }

    public void tileChanged(TiledLayer tiledLayer, int n, int n2) {
        int n3 = tiledLayer.getTileWidth();
        int n4 = tiledLayer.getTileHeight();
        Point point = this.scene.getLayerPosition(tiledLayer);
        point.translate(n2 * n3, n * n4);
        this.adjustFromOriginShift(point);
        this.repaint(point.x, point.y, n3, n4);
    }

    public void tilesChanged(TiledLayer tiledLayer, Set set) {
        for (Object e : set) {
            Position position = (Position)e;
            this.tileChanged(tiledLayer, position.getRow(), position.getCol());
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        Point point = this.adjustToOriginShift(mouseEvent.getPoint());
        List<Layer> list = this.scene.getLayersAtPoint(point);
        if (list.isEmpty()) {
            return null;
        }
        for (Layer layer : list) {
            stringBuffer.append(layer.getName());
            stringBuffer.append(", ");
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        return stringBuffer.toString();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Layer layer2;
        Point point = this.adjustToOriginShift(mouseEvent.getPoint());
        List<Layer> list = this.scene.getLayersAtPoint(point);
        if (list.size() == 0) {
            return;
        }
        for (Layer layer2 : list) {
            if (this.hilitedLayers.containsKey(layer2)) continue;
            this.hilitedLayers.put(layer2, this.colorHiliteSecondary);
            this.repaintLayerDecorations(layer2);
        }
        Layer layer3 = this.topHilitedLayer;
        layer2 = list.get(0);
        if (layer3 != layer2) {
            this.hilitedLayers.put(layer2, this.colorHilitePrimary);
            this.hilitedLayers.put(layer3, this.colorHiliteSecondary);
            this.topHilitedLayer = layer2;
            this.repaintLayerDecorations(layer3);
            this.repaintLayerDecorations(layer2);
        }
        Iterator<Layer> iterator = this.hilitedLayers.keySet().iterator();
        while (iterator.hasNext()) {
            Layer layer4 = iterator.next();
            if (list.contains(layer4)) continue;
            this.repaintLayerDecorations(layer4);
            iterator.remove();
        }
    }

    private void clearSelectedLayers() {
        Iterator<Layer> iterator = this.selectedLayers.iterator();
        while (iterator.hasNext()) {
            Layer layer = iterator.next();
            iterator.remove();
            this.repaintLayerDecorations(layer);
        }
        this.dragLayerStartPoints.clear();
        this.lastDragPoint = null;
        this.startDragPoint = null;
        this.snapToGridReferenceLayer = null;
        this.dragDirectionHorizontal = "West";
        this.dragDirectionVertical = "North";
    }

    private void addSelectedLayer(Layer layer, boolean bl) {
        if (bl) {
            if (this.selectedLayers.contains(layer)) {
                this.selectedLayers.remove(layer);
            } else {
                this.selectedLayers.add(layer);
            }
        } else {
            this.selectedLayers.add(layer);
        }
        this.repaintLayerDecorations(layer);
        this.horizontalRuler.repaint();
        this.verticalRuler.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.adjustToOriginShift(mouseEvent.getPoint());
        if (!this.mouseDragging) {
            if (this.selectedLayers.isEmpty() || this.scene.getLayersAtPoint(point).isEmpty()) {
                return;
            }
            boolean bl = false;
            for (Layer layer : this.selectedLayers) {
                if (!this.scene.getLayerBounds(layer).contains(point)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            for (Layer layer : this.scene.getLayersAtPoint(point)) {
                if (!this.selectedLayers.contains(layer)) continue;
                this.snapToGridReferenceLayer = layer;
                break;
            }
            for (Layer layer : this.selectedLayers) {
                this.dragLayerStartPoints.put(layer, this.scene.getLayerPosition(layer));
            }
            this.startDragPoint = point;
            this.mouseDragging = true;
            return;
        }
        int n = point.x - this.startDragPoint.x;
        int n2 = point.y - this.startDragPoint.y;
        if (this.lastDragPoint != null) {
            if (point.x < this.lastDragPoint.x) {
                this.dragDirectionHorizontal = "West";
            } else if (point.x > this.lastDragPoint.x) {
                this.dragDirectionHorizontal = "East";
            }
            if (point.y < this.lastDragPoint.y) {
                this.dragDirectionVertical = "North";
            } else if (point.y > this.lastDragPoint.y) {
                this.dragDirectionVertical = "South";
            }
        }
        if (this.isSnapGrid() && this.lastDragPoint != null) {
            Point point2 = this.findSnapToGridDelta(point, n, n2);
            this.translateSelectedLayers(point2.x, point2.y, true);
        } else {
            this.translateSelectedLayers(n, n2, true);
        }
        this.lastDragPoint = point;
        this.horizontalRuler.repaint();
        this.verticalRuler.repaint();
        this.scrollRectToVisible(new Rectangle(mouseEvent.getPoint()));
    }

    private Point findSnapToGridDelta(Point point, int n, int n2) {
        Point point2 = new Point(this.dragLayerStartPoints.get(this.snapToGridReferenceLayer));
        Point point3 = new Point(point2);
        point3.translate(n, n2);
        if (point.x >= this.lastDragPoint.x) {
            if (point.x > this.lastDragPoint.x) {
                point3.translate(this.snapToGridReferenceLayer.getWidth(), 0);
            } else if (this.dragDirectionHorizontal == "East") {
                point3.translate(this.snapToGridReferenceLayer.getWidth(), 0);
            }
        }
        if (point.y >= this.lastDragPoint.y) {
            if (point.y > this.lastDragPoint.y) {
                point3.translate(0, this.snapToGridReferenceLayer.getHeight());
            } else if (this.dragDirectionVertical == "South") {
                point3.translate(0, this.snapToGridReferenceLayer.getHeight());
            }
        }
        Point point4 = this.findNearestGridPoint(point3);
        if (this.dragDirectionHorizontal == "East") {
            point4.translate(-this.snapToGridReferenceLayer.getWidth(), 0);
        }
        if (this.dragDirectionVertical == "South") {
            point4.translate(0, -this.snapToGridReferenceLayer.getHeight());
        }
        n = point4.x - point2.x;
        n2 = point4.y - point2.y;
        return new Point(n, n2);
    }

    private Point findNearestGridPoint(Point point) {
        int n;
        int n2;
        Point point2 = new Point(point);
        int n3 = point.x % this.gridX;
        int n4 = point.y % this.gridY;
        if (n3 == 0 && n4 == 0) {
            return point2;
        }
        if (n3 != 0) {
            n2 = point.x / this.gridX;
            n = point.x >= 0 ? n2 + 1 : n2 - 1;
            point2.x = Math.abs(point.x - (n2 *= this.gridX)) < Math.abs(point.x - (n *= this.gridX)) ? n2 : n;
        }
        if (n4 != 0) {
            n2 = point.y / this.gridY;
            n = point.y >= 0 ? n2 + 1 : n2 - 1;
            point2.y = Math.abs(point.y - (n2 *= this.gridY)) < Math.abs(point.y - (n *= this.gridY)) ? n2 : n;
        }
        return point2;
    }

    private void translateSelectedLayers(int n, int n2, boolean bl) {
        for (Layer layer : this.selectedLayers) {
            Point point = new Point(this.dragLayerStartPoints.get(layer));
            point.translate(n, n2);
            if (this.scene.isLayerLocked(layer)) continue;
            this.scene.setLayerPosition(layer, point, bl);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.handlePopUp(mouseEvent);
            return;
        }
        Point point = this.adjustToOriginShift(mouseEvent.getPoint());
        List<Layer> list = this.scene.getLayersAtPoint(point);
        if (!list.isEmpty()) {
            Layer layer = list.get(0);
            if (!this.mouseDragging && this.lastAddedLayerByMousePress != layer && !this.isMultiSelect(mouseEvent)) {
                this.clearSelectedLayers();
            }
            if (this.mouseDragging && this.lastDragPoint != null && this.startDragPoint != null) {
                int n = this.lastDragPoint.x - this.startDragPoint.x;
                int n2 = this.lastDragPoint.y - this.startDragPoint.y;
                if (this.isSnapGrid()) {
                    Point point2 = this.findSnapToGridDelta(this.lastDragPoint, n, n2);
                    this.translateSelectedLayers(point2.x, point2.y, false);
                } else {
                    this.translateSelectedLayers(n, n2, false);
                }
            }
        }
        this.mouseDragging = false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        this.mouseDragging = false;
        this.lastAddedLayerByMousePress = null;
        if (mouseEvent.isPopupTrigger()) {
            this.handlePopUp(mouseEvent);
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Point point = this.adjustToOriginShift(mouseEvent.getPoint());
        List<Layer> list = this.scene.getLayersAtPoint(point);
        if (!this.isMultiSelect(mouseEvent)) {
            for (Layer layer : list) {
                if (!this.selectedLayers.contains(layer)) continue;
                return;
            }
            this.clearSelectedLayers();
        }
        if (list.isEmpty()) {
            object = this.topHilitedLayer;
            this.topHilitedLayer = null;
            this.hilitedLayers.remove(object);
            this.repaintLayerDecorations((Layer)object);
            return;
        }
        object = list.get(0);
        if (!this.selectedLayers.contains(object)) {
            this.addSelectedLayer((Layer)object, false);
            this.lastAddedLayerByMousePress = object;
            this.repaintLayerDecorations((Layer)object);
        } else if (this.isMultiSelect(mouseEvent)) {
            this.addSelectedLayer((Layer)object, true);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Point point;
        List<Layer> list;
        this.mouseDragging = false;
        if (mouseEvent.getClickCount() >= 2 && !(list = this.scene.getLayersAtPoint(point = this.adjustToOriginShift(mouseEvent.getPoint()))).isEmpty()) {
            this.scene.getGameDesign().getMainView().requestEditing(list.get(0));
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void handlePopUp(MouseEvent mouseEvent) {
        Serializable serializable;
        Object object;
        Serializable i;
        Object object2;
        AbstractAction i2;
        int jMenu4;
        Serializable serializable2;
        Object object32;
        Object object4;
        DuplicateSceneAction duplicateSceneAction = new DuplicateSceneAction();
        Scene.RenameSceneAction renameSceneAction = new Scene.RenameSceneAction(this.scene);
        Scene.RemoveSceneAction removeSceneAction = new Scene.RemoveSceneAction(this.scene);
        Scene.CreateTiledLayerAction createTiledLayerAction = new Scene.CreateTiledLayerAction(this.scene);
        Scene.CreateSpriteAction createSpriteAction = new Scene.CreateSpriteAction(this.scene);
        JMenu jMenu = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuAddTiledLayer.txt"));
        List<TiledLayer> list = this.scene.getGameDesign().getTiledLayers();
        for (TiledLayer object52 : list) {
            if (this.scene.contains(object52)) continue;
            object4 = new AddLayerAction();
            ((AbstractAction)object4).putValue("Name", object52.getName());
            ((AbstractAction)object4).putValue("PROP_LAYER", object52);
            ((AbstractAction)object4).putValue("PROP_POSITION", this.adjustToOriginShift(mouseEvent.getPoint()));
            jMenu.add((Action)object4);
        }
        if (jMenu.getItemCount() == 0) {
            jMenu.setEnabled(false);
        }
        JMenu jMenu2 = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuAddSprite.txt"));
        List<Sprite> list2 = this.scene.getGameDesign().getSprites();
        for (Object object32 : list2) {
            if (this.scene.contains((Layer)object32)) continue;
            serializable2 = new AddLayerAction();
            ((AbstractAction)serializable2).putValue("Name", ((Layer)object32).getName());
            ((AbstractAction)serializable2).putValue("PROP_LAYER", object32);
            ((AbstractAction)serializable2).putValue("PROP_POSITION", this.adjustToOriginShift(mouseEvent.getPoint()));
            jMenu2.add((Action)((Object)serializable2));
        }
        if (jMenu2.getItemCount() == 0) {
            jMenu2.setEnabled(false);
        }
        object4 = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuPushUp.txt"));
        object32 = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuPushDown.txt"));
        serializable2 = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuLayerToTop.txt"));
        JMenu jMenu3 = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuLayerToBottom.txt"));
        Point point = this.adjustToOriginShift(mouseEvent.getPoint());
        List<Layer> list3 = this.scene.getLayersAtPoint(point);
        if (list3.size() < 2) {
            ((JMenuItem)object4).setEnabled(false);
            ((JMenuItem)object32).setEnabled(false);
        } else {
            for (jMenu4 = 0; jMenu4 < list3.size(); ++jMenu4) {
                i2 = new PushUpLayerAction();
                ((JMenu)object4).add(i2);
                i2.putValue("Name", list3.get(jMenu4).getName());
                if (jMenu4 == 0) {
                    i2.setEnabled(false);
                    continue;
                }
                i2.putValue("PROP_LAYER", list3.get(jMenu4));
                i2.putValue("PROP_LAYER_TO_TOP", list3.get(jMenu4 - 1));
            }
            for (jMenu4 = 0; jMenu4 < list3.size(); ++jMenu4) {
                i2 = new PushDownLayerAction();
                ((JMenu)object32).add(i2);
                i2.putValue("Name", list3.get(jMenu4).getName());
                if (jMenu4 == list3.size() - 1) {
                    i2.setEnabled(false);
                    continue;
                }
                i2.putValue("PROP_LAYER", list3.get(jMenu4));
                i2.putValue("PROP_LAYER_TO_BELOW", list3.get(jMenu4 + 1));
            }
        }
        for (jMenu4 = 0; jMenu4 < list3.size(); ++jMenu4) {
            i2 = new LayerToTopAction();
            ((JMenu)serializable2).add(i2);
            i2.putValue("Name", list3.get(jMenu4).getName());
            if (this.scene.getLayerAt(0) == list3.get(jMenu4)) {
                i2.setEnabled(false);
                continue;
            }
            i2.putValue("PROP_LAYER", list3.get(jMenu4));
        }
        if (list3.isEmpty()) {
            ((JMenuItem)serializable2).setEnabled(false);
        }
        for (jMenu4 = 0; jMenu4 < list3.size(); ++jMenu4) {
            i2 = new LayerToBottomAction();
            jMenu3.add(i2);
            i2.putValue("Name", list3.get(jMenu4).getName());
            if (this.scene.getLayerAt(this.scene.getLayerCount() - 1) == list3.get(jMenu4)) {
                i2.setEnabled(false);
                continue;
            }
            i2.putValue("PROP_LAYER", list3.get(jMenu4));
        }
        if (list3.isEmpty()) {
            jMenu3.setEnabled(false);
        }
        JMenu jMenu5 = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuEdit.txt"));
        if (list3.isEmpty()) {
            jMenu5.setEnabled(false);
        } else {
            for (int jMenu52 = 0; jMenu52 < list3.size(); ++jMenu52) {
                EditLayerAction i3 = new EditLayerAction();
                jMenu5.add(i3);
                i3.putValue("PROP_LAYER", list3.get(jMenu52));
                i3.putValue("Name", list3.get(jMenu52).getName());
            }
        }
        JMenu jMenu6 = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuView.txt"));
        if (list3.isEmpty()) {
            jMenu6.setEnabled(false);
        } else {
            for (int jMenu62 = 0; jMenu62 < list3.size(); ++jMenu62) {
                Layer i4 = list3.get(jMenu62);
                object2 = new JCheckBoxMenuItem(i4.getName(), this.scene.isLayerVisible(i4));
                jMenu6.add((JMenuItem)object2);
                ((AbstractButton)object2).addItemListener(new VisibilityListener(i4));
            }
        }
        JMenu jMenu7 = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuLock.txt"));
        if (list3.isEmpty()) {
            jMenu7.setEnabled(false);
        } else {
            for (int jMenu72 = 0; jMenu72 < list3.size(); ++jMenu72) {
                object2 = list3.get(jMenu72);
                i = new JCheckBoxMenuItem(((Layer)object2).getName(), this.scene.isLayerLocked((Layer)object2));
                jMenu7.add((JMenuItem)i);
                ((AbstractButton)i).addItemListener(new LockListener((Layer)object2));
            }
        }
        JMenu jMenu8 = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuAlign.txt"));
        if (this.selectedLayers.size() < 2) {
            jMenu8.setEnabled(false);
        } else {
            object2 = new AlignLayersTopAction();
            ((AbstractAction)object2).putValue("PROP_LAYERS", this.selectedLayers);
            i = new AlignLayersLeftAction();
            ((AbstractAction)i).putValue("PROP_LAYERS", this.selectedLayers);
            object = new AlignLayersBottomAction();
            ((AbstractAction)object).putValue("PROP_LAYERS", this.selectedLayers);
            i5 = new AlignLayersRightAction();
            ((AbstractAction)i5).putValue("PROP_LAYERS", this.selectedLayers);
            jMenu8.add((Action)object2);
            jMenu8.add((Action)((Object)i));
            jMenu8.add((Action)object);
            jMenu8.add((Action)((Object)i5));
        }
        object2 = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuSelect.txt"));
        if (!list3.isEmpty()) {
            for (int j = 0; j < list3.size(); ++j) {
                object = list3.get(j);
                Serializable i5 = new JCheckBoxMenuItem(((Layer)object).getName(), this.selectedLayers.contains(object));
                ((JMenu)object2).add((JMenuItem)i5);
                ((AbstractButton)i5).addItemListener(new SelectListener((Layer)object));
            }
            ((JMenu)object2).addSeparator();
            i = new SelectLayersUnderCursorAction();
            point = this.adjustToOriginShift(mouseEvent.getPoint());
            ((AbstractAction)i).putValue("PROP_POINT", point);
            ((JMenu)object2).add((Action)((Object)i));
        }
        i = new SelectAllLayersAction();
        ((JMenu)object2).add((Action)((Object)i));
        object = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuRemove.txt"));
        if (list3.isEmpty()) {
            ((JMenuItem)object).setEnabled(false);
        } else {
            for (int j = 0; j < list3.size(); ++j) {
                serializable = new RemoveLayerAction();
                ((JMenu)object).add((Action)((Object)serializable));
                ((AbstractAction)serializable).putValue("PROP_LAYER", list3.get(j));
                ((AbstractAction)serializable).putValue("Name", list3.get(j).getName());
            }
        }
        i5 = new RemoveSelectedLayersAction();
        if (this.selectedLayers.isEmpty()) {
            ((AbstractAction)i5).setEnabled(false);
        } else {
            ((AbstractAction)i5).putValue("PROP_LAYERS", this.selectedLayers);
        }
        serializable = new JPopupMenu();
        ((JPopupMenu)serializable).add(duplicateSceneAction);
        ((JPopupMenu)serializable).add(renameSceneAction);
        ((JPopupMenu)serializable).add(removeSceneAction);
        ((JPopupMenu)serializable).addSeparator();
        ((JPopupMenu)serializable).add(createTiledLayerAction);
        ((JPopupMenu)serializable).add(createSpriteAction);
        ((JPopupMenu)serializable).add(jMenu);
        ((JPopupMenu)serializable).add(jMenu2);
        ((JPopupMenu)serializable).addSeparator();
        ((JPopupMenu)serializable).add((JMenuItem)object4);
        ((JPopupMenu)serializable).add((JMenuItem)object32);
        ((JPopupMenu)serializable).add((JMenuItem)serializable2);
        ((JPopupMenu)serializable).add(jMenu3);
        ((JPopupMenu)serializable).addSeparator();
        ((JPopupMenu)serializable).add(jMenu5);
        ((JPopupMenu)serializable).add(jMenu6);
        ((JPopupMenu)serializable).add(jMenu7);
        ((JPopupMenu)serializable).add(jMenu8);
        ((JPopupMenu)serializable).addSeparator();
        ((JPopupMenu)serializable).add((JMenuItem)object2);
        ((JPopupMenu)serializable).addSeparator();
        ((JPopupMenu)serializable).add((JMenuItem)object);
        ((JPopupMenu)serializable).add((Action)((Object)i5));
        ((JPopupMenu)serializable).show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    private boolean isMultiSelect(MouseEvent mouseEvent) {
        return mouseEvent.isControlDown() || mouseEvent.isMetaDown();
    }

    public JComponent getGridButton() {
        return this.gridButton;
    }

    public Ruler getRulerHorizontal() {
        return this.horizontalRuler;
    }

    public Ruler getRulerVertical() {
        return this.verticalRuler;
    }

    public boolean isSnapGrid() {
        return this.snapGrid;
    }

    public void setSnapGrid(boolean bl) {
        if (this.snapGrid == bl) {
            return;
        }
        this.snapGrid = bl;
        this.repaint();
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean bl) {
        if (this.showGrid == bl) {
            return;
        }
        this.showGrid = bl;
        this.repaint();
    }

    public void setGridSizeHorizontal(int n) {
        this.gridX = n;
        this.repaint();
    }

    public void setGridSizeVertical(int n) {
        this.gridY = n;
        this.repaint();
    }

    class Ruler
    extends JComponent {
        public static final int HORIZONTAL = 0;
        public static final int VERTICAL = 1;
        private static final int SIZE_H = 24;
        private static final int SIZE_W = 37;
        private static final int TICK_MAJOR = 6;
        private static final int TICK_MINOR = 3;
        private static final int LOC_INSET = 2;
        private static final int SHADOW_OFF = 3;
        public final Color locFgColor = Color.WHITE;
        public final Color locBgColor = new Color(0, 0, 255, 200);
        public final Color locOutlineColor = Color.WHITE;
        public final Color locShadowColor = new Color(0, 0, 255, 64);
        public final Color locFgColorSecondary = Color.WHITE;
        public final Color locBgColorSecondary = new Color(128, 128, 255, 200);
        public final Color locOutlineColorSecondary = this.locFgColorSecondary;
        public final Color locShadowColorSecondary = new Color(128, 128, 255, 64);
        private final Color COLOR_MAJOR = Color.BLACK;
        private final Color COLOR_MINOR = Color.GRAY;
        private final Font FONT = new Font("SansSerif", 0, 9);
        public final Color RulerColor = UIManager.getColor("Panel.background");
        public int orientation;
        private int increment = 10;
        private int units = 50;

        public Ruler(int n) {
            this.orientation = n;
        }

        public Dimension getPreferredSize() {
            Rectangle rectangle = ScenePanel.this.scene.getAllLayersBounds();
            rectangle.add(0, 0);
            if (this.orientation == 0) {
                return new Dimension(rectangle.width, 24);
            }
            return new Dimension(37, rectangle.height);
        }

        public int getIncrement() {
            return this.increment;
        }

        protected void paintComponent(Graphics graphics) {
            int n;
            int n2;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = graphics2D.getClipBounds();
            Rectangle rectangle2 = ScenePanel.this.scene.getAllLayersBounds();
            rectangle2.add(0, 0);
            int n3 = rectangle2.x;
            int n4 = rectangle2.y;
            graphics2D.setColor(this.RulerColor);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setFont(this.FONT);
            int n5 = 0;
            String string = null;
            if (this.orientation == 0) {
                n2 = (rectangle.x + n3) / this.increment * this.increment;
                n = ((rectangle.x + n3 + rectangle.width) / this.increment + 1) * this.increment;
            } else {
                n2 = (rectangle.y + n4) / this.increment * this.increment;
                n = ((rectangle.y + n4 + rectangle.height) / this.increment + 1) * this.increment;
            }
            for (int i = n2; i < n; i += this.increment) {
                int n6;
                if (i % this.units == 0) {
                    graphics2D.setColor(this.COLOR_MAJOR);
                    n5 = 6;
                    string = i == 0 ? " " + Integer.toString(i) : Integer.toString(i);
                } else {
                    graphics2D.setColor(this.COLOR_MINOR);
                    n5 = 3;
                    string = null;
                }
                if (n5 == 0) continue;
                if (this.orientation == 0) {
                    graphics2D.drawLine(i - n3, 23, i - n3, 24 - n5 - 1);
                    if (string == null) continue;
                    n6 = 24 - n5 - this.FONT.getSize() / 2;
                    int n7 = (int)((double)(i - n3) - this.FONT.getStringBounds(string, graphics2D.getFontRenderContext()).getWidth() / 2.0);
                    graphics2D.drawString(string, n7, n6);
                    continue;
                }
                graphics2D.drawLine(36, i - n4, 37 - n5 - 1, i - n4);
                if (string == null) continue;
                n6 = i - n4 + this.FONT.getSize() / 2;
                graphics2D.drawString(string, 1, n6);
            }
            ArrayList<Layer> arrayList = new ArrayList<Layer>(ScenePanel.this.selectedLayers);
            if (ScenePanel.this.snapToGridReferenceLayer != null) {
                arrayList.remove(ScenePanel.this.snapToGridReferenceLayer);
                arrayList.add(ScenePanel.this.snapToGridReferenceLayer);
            }
            for (Layer layer : arrayList) {
                Rectangle rectangle3;
                float f;
                LineMetrics lineMetrics;
                Rectangle2D rectangle2D;
                String string2;
                int n8;
                int n9;
                Color color = null;
                Color color2 = null;
                Color color3 = null;
                Color color4 = null;
                if (ScenePanel.this.snapToGridReferenceLayer == null || layer == ScenePanel.this.snapToGridReferenceLayer) {
                    color = this.locBgColor;
                    color2 = this.locFgColor;
                    color3 = this.locShadowColor;
                    color4 = this.locOutlineColor;
                } else {
                    color = this.locBgColorSecondary;
                    color2 = this.locFgColorSecondary;
                    color3 = this.locShadowColorSecondary;
                    color4 = this.locOutlineColorSecondary;
                }
                Rectangle rectangle4 = ScenePanel.this.scene.getLayerBounds(layer);
                if (this.orientation == 0) {
                    n9 = rectangle.x + n3;
                    n8 = rectangle.x + n3 + rectangle.width;
                    if (n9 <= rectangle4.x + rectangle4.width && rectangle4.x + rectangle4.width < n8) {
                        graphics2D.setColor(ScenePanel.this.colorSelection);
                        graphics2D.drawLine(rectangle4.x + rectangle4.width - n3, 0, rectangle4.x + rectangle4.width - n3, 24);
                        string2 = Integer.toString(rectangle4.x + rectangle4.width);
                        rectangle2D = this.FONT.getStringBounds(string2, graphics2D.getFontRenderContext());
                        lineMetrics = this.FONT.getLineMetrics(string2, graphics2D.getFontRenderContext());
                        f = lineMetrics.getAscent();
                        rectangle3 = new Rectangle((int)rectangle2D.getX() - 2, (int)rectangle2D.getY() - 2, (int)rectangle2D.getWidth() + 4, (int)rectangle2D.getHeight() + 4);
                        graphics2D.setColor(color);
                        graphics2D.fillRoundRect((int)((double)(rectangle4.x + rectangle4.width - n3) - rectangle3.getWidth() / 2.0), 0, (int)rectangle3.getWidth(), (int)rectangle3.getHeight(), 4, 4);
                        graphics2D.setColor(color3);
                        graphics2D.fillRoundRect((int)((double)(rectangle4.x + rectangle4.width - n3) - rectangle3.getWidth() / 2.0) + 3, 3, (int)rectangle3.getWidth(), (int)rectangle3.getHeight(), 4, 4);
                        graphics2D.setColor(color2);
                        graphics2D.drawString(string2, (float)((int)((double)(rectangle4.x + rectangle4.width - n3) - rectangle2D.getWidth() / 2.0)), 2.0f + f);
                        if (layer == ScenePanel.this.snapToGridReferenceLayer) {
                            graphics2D.setColor(color4);
                            graphics2D.drawRoundRect((int)((double)(rectangle4.x + rectangle4.width - n3 - 1) - rectangle3.getWidth() / 2.0), 0, (int)rectangle3.getWidth() + 1, (int)rectangle3.getHeight(), 4, 4);
                        }
                    }
                    if (n9 > rectangle4.x || rectangle4.x >= n8) continue;
                    graphics2D.setColor(ScenePanel.this.colorSelection);
                    graphics2D.drawLine(rectangle4.x - n3, 0, rectangle4.x - n3, 24);
                    string2 = Integer.toString(rectangle4.x);
                    rectangle2D = this.FONT.getStringBounds(string2, graphics2D.getFontRenderContext());
                    lineMetrics = this.FONT.getLineMetrics(string2, graphics2D.getFontRenderContext());
                    f = lineMetrics.getAscent();
                    rectangle3 = new Rectangle((int)rectangle2D.getX() - 2, (int)rectangle2D.getY() - 2, (int)rectangle2D.getWidth() + 4, (int)rectangle2D.getHeight() + 4);
                    graphics2D.setColor(color);
                    graphics2D.fillRoundRect((int)((double)(rectangle4.x - n3) - rectangle3.getWidth() / 2.0), 0, (int)rectangle3.getWidth(), (int)rectangle3.getHeight(), 4, 4);
                    graphics2D.setColor(color3);
                    graphics2D.fillRoundRect((int)((double)(rectangle4.x - n3) - rectangle3.getWidth() / 2.0) + 3, 3, (int)rectangle3.getWidth(), (int)rectangle3.getHeight(), 4, 4);
                    graphics2D.setColor(color2);
                    graphics2D.drawString(string2, (float)((int)((double)(rectangle4.x - n3) - rectangle2D.getWidth() / 2.0)), 2.0f + f);
                    if (layer != ScenePanel.this.snapToGridReferenceLayer) continue;
                    graphics2D.setColor(color4);
                    graphics2D.drawRoundRect((int)((double)(rectangle4.x - n3 - 1) - rectangle3.getWidth() / 2.0), 0, (int)rectangle3.getWidth() + 1, (int)rectangle3.getHeight(), 4, 4);
                    continue;
                }
                n9 = rectangle.y + n4;
                n8 = rectangle.y + n4 + rectangle.height;
                if (n9 <= rectangle4.y + rectangle4.height && rectangle4.y + rectangle4.height < n8) {
                    graphics2D.setColor(ScenePanel.this.colorSelection);
                    graphics2D.drawLine(0, rectangle4.y + rectangle4.height - n4, 37, rectangle4.y + rectangle4.height - n4);
                    string2 = Integer.toString(rectangle4.y + rectangle4.height);
                    rectangle2D = this.FONT.getStringBounds(string2, graphics2D.getFontRenderContext());
                    lineMetrics = this.FONT.getLineMetrics(string2, graphics2D.getFontRenderContext());
                    f = lineMetrics.getAscent();
                    rectangle3 = new Rectangle((int)rectangle2D.getX() - 2, (int)rectangle2D.getY() - 2, (int)rectangle2D.getWidth() + 4, (int)rectangle2D.getHeight() + 4);
                    graphics2D.setColor(color);
                    graphics2D.fillRoundRect(1, rectangle4.y + rectangle4.height - n4 - rectangle3.height / 2, rectangle3.width, rectangle3.height, 4, 4);
                    graphics2D.setColor(color3);
                    graphics2D.fillRoundRect(4, rectangle4.y + rectangle4.height - n4 - rectangle3.height / 2 + 3, rectangle3.width, rectangle3.height, 4, 4);
                    graphics2D.setColor(color2);
                    graphics2D.drawString(string2, 3.0f, (float)(rectangle4.y + rectangle4.height - n4 - rectangle3.height / 2) + f + 2.0f);
                    if (layer == ScenePanel.this.snapToGridReferenceLayer) {
                        graphics2D.setColor(color4);
                        graphics2D.drawRoundRect(0, rectangle4.y + rectangle4.height - n4 - rectangle3.height / 2, rectangle3.width + 1, rectangle3.height, 4, 4);
                    }
                }
                if (n9 > rectangle4.y || rectangle4.y >= n8) continue;
                graphics2D.setColor(ScenePanel.this.colorSelection);
                graphics2D.drawLine(0, rectangle4.y - n4, 37, rectangle4.y - n4);
                string2 = Integer.toString(rectangle4.y);
                rectangle2D = this.FONT.getStringBounds(string2, graphics2D.getFontRenderContext());
                lineMetrics = this.FONT.getLineMetrics(string2, graphics2D.getFontRenderContext());
                f = lineMetrics.getAscent();
                rectangle3 = new Rectangle((int)rectangle2D.getX() - 2, (int)rectangle2D.getY() - 2, (int)rectangle2D.getWidth() + 4, (int)rectangle2D.getHeight() + 4);
                graphics2D.setColor(color);
                graphics2D.fillRoundRect(1, rectangle4.y - n4 - rectangle3.height / 2, rectangle3.width, rectangle3.height, 4, 4);
                graphics2D.setColor(color3);
                graphics2D.fillRoundRect(4, rectangle4.y - n4 - rectangle3.height / 2 + 3, rectangle3.width, rectangle3.height, 4, 4);
                graphics2D.setColor(color2);
                graphics2D.drawString(string2, 3.0f, (float)(rectangle4.y - n4 - rectangle3.height / 2) + f + 2.0f);
                if (layer != ScenePanel.this.snapToGridReferenceLayer) continue;
                graphics2D.setColor(color4);
                graphics2D.drawRoundRect(0, rectangle4.y - n4 - rectangle3.height / 2, rectangle3.width + 1, rectangle3.height, 4, 4);
            }
        }
    }

    private class GridButton
    extends JComponent
    implements MouseListener {
        private static final int BORDER = 4;

        public GridButton() {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addMouseListener(this);
        }

        public String getToolTipText() {
            return NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.gridButton.tooltip");
        }

        protected void paintComponent(Graphics graphics) {
            graphics.setColor(UIManager.getColor("Panel.background"));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.BLACK);
            int n = 4;
            int n2 = 4;
            int n3 = 4;
            int n4 = 4;
            int n5 = this.getWidth() - 12;
            int n6 = this.getHeight() - 12;
            if (ScenePanel.this.isShowGrid()) {
                if (ScenePanel.this.isSnapGrid()) {
                    graphics.setColor(Color.RED);
                }
                int n7 = n5 / 3;
                int n8 = n6 / 3;
                graphics.drawLine(n3 += n7, n2, n3, n2 + n6);
                graphics.drawLine(n3 += n7, n2, n3, n2 + n6);
                graphics.drawLine(n, n4 += n8, n + n5, n4);
                graphics.drawLine(n, n4 += n8, n + n5, n4);
            }
            graphics.setColor(Color.BLACK);
            graphics.drawRoundRect(n, n2, n5, n6, 4, 4);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (ScenePanel.this.isShowGrid()) {
                if (ScenePanel.this.isSnapGrid()) {
                    ScenePanel.this.setShowGrid(false);
                    ScenePanel.this.setSnapGrid(false);
                } else {
                    ScenePanel.this.setSnapGrid(true);
                }
            } else {
                ScenePanel.this.setShowGrid(true);
                ScenePanel.this.setSnapGrid(false);
            }
            this.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    public class AddLayerAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";
        public static final String PROP_POSITION = "PROP_POSITION";

        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            Point point = (Point)this.getValue(PROP_POSITION);
            ScenePanel.this.scene.insert(layer, 0);
            ScenePanel.this.scene.setLayerPosition(layer, point, false);
        }
    }

    public class AddNewSpriteAction
    extends AbstractAction {
        public AddNewSpriteAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.actionNewSprite.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpriteDialog spriteDialog = new SpriteDialog(ScenePanel.this.scene);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)spriteDialog, NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.actionNewSprite.txt"));
            dialogDescriptor.setButtonListener((ActionListener)spriteDialog);
            dialogDescriptor.setValid(false);
            spriteDialog.setDialogDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
    }

    public class AddNewTiledLayerAction
    extends AbstractAction {
        public AddNewTiledLayerAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.actionNewTiledLayer.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TiledLayerDialog tiledLayerDialog = new TiledLayerDialog(ScenePanel.this.scene);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)tiledLayerDialog, NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.actionNewTiledLayer.txt"));
            dialogDescriptor.setButtonListener((ActionListener)tiledLayerDialog);
            dialogDescriptor.setValid(false);
            tiledLayerDialog.setDialogDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
    }

    public class DuplicateSceneAction
    extends AbstractAction {
        public DuplicateSceneAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.actionDuplicateScene.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewSceneDialog newSceneDialog = new NewSceneDialog(ScenePanel.this.scene);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newSceneDialog, NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.actionDuplicateScene.txt"));
            dialogDescriptor.setButtonListener((ActionListener)newSceneDialog);
            dialogDescriptor.setValid(false);
            newSceneDialog.setDialogDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
    }

    private class LayerToBottomAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";

        private LayerToBottomAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            ScenePanel.this.scene.insert(layer, ScenePanel.this.scene.getLayerCount() - 1);
        }
    }

    private class LayerToTopAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";

        private LayerToTopAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            ScenePanel.this.scene.insert(layer, 0);
        }
    }

    private class PushDownLayerAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";
        public static final String PROP_LAYER_TO_BELOW = "PROP_LAYER_TO_BELOW";

        private PushDownLayerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            Layer layer2 = (Layer)this.getValue(PROP_LAYER_TO_BELOW);
            ScenePanel.this.scene.insert(layer, ScenePanel.this.scene.indexOf(layer2));
        }
    }

    private class PushUpLayerAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";
        public static final String PROP_LAYER_TO_TOP = "PROP_LAYER_TO_TOP";

        private PushUpLayerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            Layer layer2 = (Layer)this.getValue(PROP_LAYER_TO_TOP);
            ScenePanel.this.scene.insert(layer, ScenePanel.this.scene.indexOf(layer2));
        }
    }

    private class SelectAllLayersAction
    extends AbstractAction {
        private SelectAllLayersAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuSelectAll.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List<Layer> list = ScenePanel.this.scene.getLayers();
            for (Layer layer : list) {
                ScenePanel.this.addSelectedLayer(layer, false);
            }
        }
    }

    private class SelectLayersUnderCursorAction
    extends AbstractAction {
        public static final String PROP_POINT = "PROP_POINT";

        private SelectLayersUnderCursorAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuSelectUnder.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Point point = (Point)this.getValue(PROP_POINT);
            List<Layer> list = ScenePanel.this.scene.getLayersAtPoint(point);
            for (Layer layer : list) {
                ScenePanel.this.addSelectedLayer(layer, false);
            }
        }
    }

    private class RemoveSelectedLayersAction
    extends AbstractAction {
        public static final String PROP_LAYERS = "PROP_LAYERS";

        private RemoveSelectedLayersAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuRemoveSelected.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Set set = (Set)this.getValue(PROP_LAYERS);
            for (Layer layer : set) {
                ScenePanel.this.scene.remove(layer);
            }
        }
    }

    private class RemoveLayerAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";

        private RemoveLayerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            ScenePanel.this.scene.remove(layer);
        }
    }

    private class AlignLayersRightAction
    extends AbstractAction {
        public static final String PROP_LAYERS = "PROP_LAYERS";

        private AlignLayersRightAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuRight.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Set set = (Set)this.getValue(PROP_LAYERS);
            int n = Integer.MIN_VALUE;
            for (Layer layer : set) {
                n = ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).x + layer.getWidth() > n ? ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).x + layer.getWidth() : n;
            }
            for (Layer layer : set) {
                ScenePanel.this.scene.setLayerPositionX(layer, n - layer.getWidth(), false);
            }
        }
    }

    private class AlignLayersBottomAction
    extends AbstractAction {
        public static final String PROP_LAYERS = "PROP_LAYERS";

        private AlignLayersBottomAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuBottom.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Set set = (Set)this.getValue(PROP_LAYERS);
            int n = Integer.MIN_VALUE;
            for (Layer layer : set) {
                n = ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).y + layer.getHeight() > n ? ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).y + layer.getHeight() : n;
            }
            for (Layer layer : set) {
                ScenePanel.this.scene.setLayerPositionY(layer, n - layer.getHeight(), false);
            }
        }
    }

    private class AlignLayersLeftAction
    extends AbstractAction {
        public static final String PROP_LAYERS = "PROP_LAYERS";

        private AlignLayersLeftAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuLeft.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Set set = (Set)this.getValue(PROP_LAYERS);
            int n = Integer.MAX_VALUE;
            for (Layer layer : set) {
                n = ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).x < n ? ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).x : n;
            }
            for (Layer layer : set) {
                ScenePanel.this.scene.setLayerPositionX(layer, n, false);
            }
        }
    }

    private class AlignLayersTopAction
    extends AbstractAction {
        public static final String PROP_LAYERS = "PROP_LAYERS";

        private AlignLayersTopAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuTop.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Set set = (Set)this.getValue(PROP_LAYERS);
            int n = Integer.MAX_VALUE;
            for (Layer layer : set) {
                n = ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).y < n ? ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).y : n;
            }
            for (Layer layer : set) {
                ScenePanel.this.scene.setLayerPositionY(layer, n, false);
            }
        }
    }

    private class EditLayerAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";

        private EditLayerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            ScenePanel.this.scene.getGameDesign().getMainView().requestEditing(layer);
        }
    }

    private class SelectListener
    implements ItemListener {
        private Layer layer;

        public SelectListener(Layer layer) {
            this.layer = layer;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ScenePanel.this.addSelectedLayer(this.layer, true);
        }
    }

    private class LockListener
    implements ItemListener {
        private Layer layer;

        public LockListener(Layer layer) {
            this.layer = layer;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = itemEvent.getStateChange() == 1;
            ScenePanel.this.scene.setLayerLocked(this.layer, bl);
        }
    }

    private class VisibilityListener
    implements ItemListener {
        private Layer layer;

        public VisibilityListener(Layer layer) {
            this.layer = layer;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = itemEvent.getStateChange() == 1;
            ScenePanel.this.scene.setLayerVisible(this.layer, bl);
        }
    }
}

