/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.tiledlayer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerPreviewPanel;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.openide.util.NbBundle;

public class TiledLayerNavigator
extends JPanel {
    private TiledLayer tiledLayer;
    private TiledLayerPreviewPanel preview;
    public JButton buttonRefreshNow;
    public JLabel jLabel1;
    public JLabel labelDelay;
    public JLabel labelFrames;
    public JLabel labelSprite;
    public JPanel panelTiledLayer;
    public JTextField textFieldCols;
    public JTextField textFieldImage;
    public JTextField textFieldLayerName;
    public JTextField textFieldRows;
    public JToggleButton toggleButtonAutoRefresh;

    public TiledLayerNavigator(TiledLayer tiledLayer) {
        this.tiledLayer = tiledLayer;
        this.initComponents();
        this.manualInit();
    }

    private void manualInit() {
        this.textFieldLayerName.setText(this.tiledLayer.getName());
        this.textFieldImage.setText(this.tiledLayer.getImageResource().getRelativeResourcePath());
        this.textFieldRows.setText(Integer.toString(this.tiledLayer.getRowCount()));
        this.textFieldCols.setText(Integer.toString(this.tiledLayer.getColumnCount()));
        this.preview = new TiledLayerPreviewPanel(this.tiledLayer, this.toggleButtonAutoRefresh.isSelected());
        this.panelTiledLayer.add(this.preview);
        this.panelTiledLayer.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TiledLayerNavigator.this.preview.refresh();
            }
        });
        this.toggleButtonAutoRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TiledLayerNavigator.this.toggleButtonAutoRefresh.isSelected()) {
                    TiledLayerNavigator.this.preview.setAutoUpdate(true);
                    TiledLayerNavigator.this.buttonRefreshNow.setEnabled(false);
                } else {
                    TiledLayerNavigator.this.preview.setAutoUpdate(false);
                    TiledLayerNavigator.this.buttonRefreshNow.setEnabled(true);
                }
            }
        });
        this.buttonRefreshNow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TiledLayerNavigator.this.preview.refresh();
            }
        });
    }

    private void initComponents() {
        this.labelSprite = new JLabel();
        this.textFieldLayerName = new JTextField();
        this.panelTiledLayer = new JPanel();
        this.labelFrames = new JLabel();
        this.textFieldRows = new JTextField();
        this.labelDelay = new JLabel();
        this.textFieldCols = new JTextField();
        this.jLabel1 = new JLabel();
        this.textFieldImage = new JTextField();
        this.toggleButtonAutoRefresh = new JToggleButton();
        this.buttonRefreshNow = new JButton();
        this.setMinimumSize(new Dimension(10, 180));
        this.labelSprite.setBackground(new Color(255, 255, 255));
        this.labelSprite.setText(NbBundle.getMessage(TiledLayerNavigator.class, (String)"TiledLayerNavigator.tiledLayerLabel.txt"));
        this.textFieldLayerName.setEditable(false);
        this.textFieldLayerName.setText(this.tiledLayer.getName());
        this.textFieldLayerName.setBorder(null);
        this.panelTiledLayer.setBackground(new Color(255, 255, 255));
        this.panelTiledLayer.setBorder(BorderFactory.createLineBorder(new Color(99, 114, 136)));
        this.panelTiledLayer.setToolTipText(NbBundle.getMessage(TiledLayerNavigator.class, (String)"TiledLayerNavigator.preview.tooltip"));
        this.panelTiledLayer.setLayout(new BorderLayout());
        this.labelFrames.setBackground(new Color(255, 255, 255));
        this.labelFrames.setText(NbBundle.getMessage(TiledLayerNavigator.class, (String)"TiledLayerNavigator.rowsLabel.txt"));
        this.textFieldRows.setEditable(false);
        this.textFieldRows.setHorizontalAlignment(2);
        this.textFieldRows.setText(Integer.toString(this.tiledLayer.getRowCount()));
        this.textFieldRows.setBorder(null);
        this.labelDelay.setBackground(new Color(255, 255, 255));
        this.labelDelay.setText(NbBundle.getMessage(TiledLayerNavigator.class, (String)"TiledLayerNavigator.colsLabel.txt"));
        this.textFieldCols.setEditable(false);
        this.textFieldCols.setHorizontalAlignment(2);
        this.textFieldCols.setText(Integer.toString(this.tiledLayer.getColumnCount()));
        this.textFieldCols.setBorder(null);
        this.jLabel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setText(NbBundle.getMessage(TiledLayerNavigator.class, (String)"TiledLayerNavigator.imageLabel.txt"));
        this.textFieldImage.setEditable(false);
        this.textFieldImage.setText(this.tiledLayer.getImageResource().getURL().toString());
        this.textFieldImage.setBorder(null);
        this.toggleButtonAutoRefresh.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/tiledlayer/res/connection_mode.png")));
        this.toggleButtonAutoRefresh.setToolTipText(NbBundle.getMessage(TiledLayerNavigator.class, (String)"TiledLayerNavigator.buttonSync.tooltip"));
        this.toggleButtonAutoRefresh.setBorder(null);
        this.toggleButtonAutoRefresh.setBorderPainted(false);
        this.toggleButtonAutoRefresh.setRolloverEnabled(true);
        this.buttonRefreshNow.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/tiledlayer/res/refresh.png")));
        this.buttonRefreshNow.setToolTipText(NbBundle.getMessage(TiledLayerNavigator.class, (String)"TiledLayerNavigator.buttonRefresh.tooltip"));
        this.buttonRefreshNow.setBorder(null);
        this.buttonRefreshNow.setBorderPainted(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.labelFrames).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.textFieldRows, -1, 186, Short.MAX_VALUE).add((Component)this.textFieldCols, -1, 186, Short.MAX_VALUE).add((Component)this.textFieldImage, -1, 186, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.labelDelay, -2, 31, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.labelSprite).addPreferredGap(0).add((Component)this.textFieldLayerName, -1, 98, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.buttonRefreshNow).addPreferredGap(0).add((Component)this.toggleButtonAutoRefresh, -2, 20, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.panelTiledLayer, -1, 239, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.buttonRefreshNow, this.toggleButtonAutoRefresh}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelSprite).add((Component)this.toggleButtonAutoRefresh, -2, 20, -2).add((Component)this.buttonRefreshNow).add((Component)this.textFieldLayerName, -2, -1, -2)).addPreferredGap(0).add((Component)this.panelTiledLayer, -1, 68, Short.MAX_VALUE).add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelFrames).add((Component)this.textFieldRows, -2, -1, -2)).add(3, 3, 3).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelDelay).add((Component)this.textFieldCols, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.textFieldImage, -2, -1, -2).add((Component)this.jLabel1)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.buttonRefreshNow, this.toggleButtonAutoRefresh}, 2);
    }
}

