/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.net.MalformedURLException;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryFile {
    public static final String[] ROOT_FOLDER_PATH = new String[0];
    private final SVNUrl repositoryUrl;
    private final SVNRevision revision;
    private SVNUrl fileUrl;
    private String[] pathSegments;
    private String path;
    private String toString = null;
    private boolean repositoryRoot;
    private String name;

    public RepositoryFile(SVNUrl sVNUrl, SVNRevision sVNRevision) {
        assert (sVNUrl != null);
        assert (sVNRevision != null);
        this.repositoryUrl = sVNUrl;
        this.revision = sVNRevision;
        this.repositoryRoot = true;
    }

    public RepositoryFile(SVNUrl sVNUrl, SVNUrl sVNUrl2, SVNRevision sVNRevision) {
        this(sVNUrl, sVNRevision);
        this.fileUrl = sVNUrl2;
        boolean bl = this.repositoryRoot = sVNUrl2 == null;
        if (!this.repositoryRoot) {
            String[] stringArray = sVNUrl2.getPathSegments();
            int n = stringArray.length;
            int n2 = sVNUrl.getPathSegments().length;
            this.pathSegments = new String[n - n2];
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n2; i < n; ++i) {
                this.pathSegments[i - n2] = stringArray[i];
                stringBuffer.append(stringArray[i]);
                if (i - n2 >= this.pathSegments.length - 1) continue;
                stringBuffer.append("/");
            }
            this.path = stringBuffer.toString();
        }
    }

    public RepositoryFile(SVNUrl sVNUrl, String[] stringArray, SVNRevision sVNRevision) throws MalformedURLException {
        this(sVNUrl, sVNRevision);
        this.pathSegments = stringArray;
        boolean bl = this.repositoryRoot = stringArray == null;
        if (!this.repositoryRoot) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append("/");
            }
            this.path = stringBuffer.toString();
            this.fileUrl = sVNUrl.appendPath(this.path);
        }
    }

    public RepositoryFile(SVNUrl sVNUrl, String string, SVNRevision sVNRevision) throws MalformedURLException {
        this(sVNUrl, sVNRevision);
        this.path = string;
        boolean bl = this.repositoryRoot = string == null;
        if (!this.repositoryRoot) {
            this.fileUrl = sVNUrl.appendPath(string);
            this.pathSegments = string.split("/");
        }
    }

    public SVNUrl getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public SVNUrl getFileUrl() {
        if (this.isRepositoryRoot()) {
            return this.getRepositoryUrl();
        }
        return this.fileUrl;
    }

    public String[] getPathSegments() {
        if (this.isRepositoryRoot()) {
            return ROOT_FOLDER_PATH;
        }
        return this.pathSegments;
    }

    public String getPath() {
        if (this.isRepositoryRoot()) {
            return "";
        }
        return this.path;
    }

    public boolean isRepositoryRoot() {
        return this.repositoryRoot;
    }

    public String getName() {
        if (this.name == null) {
            if (this.isRepositoryRoot()) {
                String string = this.getRepositoryUrl().toString();
                int n = string.indexOf("://");
                if (n >= 0) {
                    string = string.substring(n + 3);
                }
                return string;
            }
            return this.getFileUrl().getLastPathSegment();
        }
        return this.name;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.fileUrl);
            stringBuffer.append("@");
            stringBuffer.append(this.revision);
            this.toString = stringBuffer.toString();
        }
        return this.toString;
    }

    public RepositoryFile appendPath(String string) {
        return new RepositoryFile(this.repositoryUrl, this.getFileUrl().appendPath(string), this.revision);
    }

    public RepositoryFile replaceLastSegment(String string, int n) {
        assert (string != null && !string.equals(""));
        assert (n > -1 && n < this.fileUrl.getPathSegments().length);
        assert (!this.isRepositoryRoot());
        String string2 = this.fileUrl.toString();
        int n2 = string2.lastIndexOf(47);
        int n3 = string2.length() - 1;
        for (int i = 0; i < n; ++i) {
            n3 = n2 - 1;
            n2 = string2.lastIndexOf(47, n2 - 1);
        }
        assert (n2 >= this.repositoryUrl.toString().length());
        assert (n3 >= n2 && n3 < string2.length());
        SVNUrl sVNUrl = null;
        try {
            sVNUrl = new SVNUrl(string2.substring(0, n2 + 1) + string + string2.substring(n3 + 1));
        }
        catch (MalformedURLException malformedURLException) {
            Subversion.LOG.log(Level.INFO, malformedURLException.getMessage(), malformedURLException);
        }
        return new RepositoryFile(this.repositoryUrl, sVNUrl, this.revision);
    }

    public RepositoryFile removeLastSegment() {
        assert (!this.isRepositoryRoot());
        String string = this.fileUrl.toString();
        int n = string.lastIndexOf(47);
        assert (n >= this.repositoryUrl.toString().length());
        SVNUrl sVNUrl = null;
        try {
            sVNUrl = new SVNUrl(string.substring(0, n));
        }
        catch (MalformedURLException malformedURLException) {
            Subversion.LOG.log(Level.INFO, malformedURLException.getMessage(), malformedURLException);
        }
        return new RepositoryFile(this.repositoryUrl, sVNUrl, this.revision);
    }
}

