/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.FileStatusProvider;
import org.netbeans.modules.subversion.FilesystemHandler;
import org.netbeans.modules.subversion.OutputLogger;
import org.netbeans.modules.subversion.SubversionVCS;
import org.netbeans.modules.subversion.SubversionVisibilityQuery;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.netbeans.modules.subversion.ui.ignore.IgnoreAction;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subversion {
    static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    static final String INVALID_METADATA_MARKER = "invalid-metadata";
    private static final int STATUS_DIFFABLE = 1272;
    private static Subversion instance;
    private FileStatusCache fileStatusCache;
    private FilesystemHandler filesystemHandler;
    private FileStatusProvider fileStatusProvider;
    private Annotator annotator;
    private HashMap<String, RequestProcessor> processorsToUrl;
    private SvnClient noUrlClientWithoutListeners;
    private SvnClient noUrlClientWithListeners;
    private List<ISVNNotifyListener> svnNotifyListeners;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final Logger LOG;

    public static synchronized Subversion getInstance() {
        if (instance == null) {
            instance = new Subversion();
            instance.init();
        }
        return instance;
    }

    private Subversion() {
    }

    private void init() {
        this.loadIniParserClassesWorkaround();
        SvnClientFactory.init();
        this.fileStatusCache = new FileStatusCache();
        this.annotator = new Annotator(this);
        this.fileStatusProvider = new FileStatusProvider();
        this.filesystemHandler = new FilesystemHandler(this);
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIniParserClassesWorkaround() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            SvnConfigFiles.getInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private void cleanup() {
        this.getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    LOG.fine("Cleaning up cache");
                    Subversion.this.fileStatusCache.cleanUp();
                }
                finally {
                    LOG.fine("END Cleaning up cache");
                }
            }
        }, 3000);
    }

    public void shutdown() {
        this.fileStatusProvider.shutdown();
    }

    public SvnFileNode[] getNodes(Context context, int n) {
        File[] fileArray = this.fileStatusCache.listFiles(context, n);
        SvnFileNode[] svnFileNodeArray = new SvnFileNode[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            svnFileNodeArray[i] = new SvnFileNode(fileArray[i]);
        }
        return svnFileNodeArray;
    }

    public boolean isAdministrative(File file) {
        String string = file.getName();
        boolean bl = this.isAdministrative(string);
        return bl && !file.exists() || bl && file.exists() && file.isDirectory();
    }

    public boolean isAdministrative(String string) {
        return string.equals(".svn") || string.equals("_svn");
    }

    public FileStatusCache getStatusCache() {
        return this.fileStatusCache;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    public boolean checkClientAvailable() {
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return false;
        }
        return true;
    }

    public SvnClient getClient(SVNUrl sVNUrl, String string, String string2) throws SVNClientException {
        return this.getClient(sVNUrl, string, string2, 44);
    }

    public SvnClient getClient(SVNUrl sVNUrl, String string, String string2, int n) throws SVNClientException {
        SvnClient svnClient = SvnClientFactory.getInstance().createSvnClient(sVNUrl, null, string, string2, n);
        this.attachListeners(svnClient);
        return svnClient;
    }

    public SvnClient getClient(SVNUrl sVNUrl, SvnProgressSupport svnProgressSupport) throws SVNClientException {
        String string = "";
        String string2 = "";
        RepositoryConnection repositoryConnection = SvnModuleConfig.getDefault().getRepositoryConnection(sVNUrl.toString());
        if (repositoryConnection != null) {
            string = repositoryConnection.getUsername();
            string2 = repositoryConnection.getPassword();
        }
        SvnClient svnClient = SvnClientFactory.getInstance().createSvnClient(sVNUrl, svnProgressSupport, string, string2, 44);
        this.attachListeners(svnClient);
        return svnClient;
    }

    public SvnClient getClient(File file) throws SVNClientException {
        return this.getClient(file, null);
    }

    public SvnClient getClient(File file, SvnProgressSupport svnProgressSupport) throws SVNClientException {
        SVNUrl sVNUrl = SvnUtils.getRepositoryRootUrl(file);
        assert (sVNUrl != null) : "Unable to get repository: " + file.getAbsolutePath() + " is probably unmanaged.";
        return this.getClient(sVNUrl, svnProgressSupport);
    }

    public SvnClient getClient(Context context, SvnProgressSupport svnProgressSupport) throws SVNClientException {
        File[] fileArray = context.getRootFiles();
        SVNUrl sVNUrl = null;
        for (int i = 0; i < fileArray.length && (sVNUrl = SvnUtils.getRepositoryRootUrl(fileArray[0])) == null; ++i) {
        }
        assert (sVNUrl != null) : "Unable to get repository, context contains only unmanaged files!";
        return this.getClient(sVNUrl, svnProgressSupport);
    }

    public SvnClient getClient(SVNUrl sVNUrl) throws SVNClientException {
        return this.getClient(sVNUrl, null);
    }

    public SvnClient getClient(boolean bl) throws SVNClientException {
        this.cleanupFilesystem();
        if (bl) {
            if (this.noUrlClientWithListeners == null) {
                this.noUrlClientWithListeners = SvnClientFactory.getInstance().createSvnClient();
                this.attachListeners(this.noUrlClientWithListeners);
            }
            return this.noUrlClientWithListeners;
        }
        if (this.noUrlClientWithoutListeners == null) {
            this.noUrlClientWithoutListeners = SvnClientFactory.getInstance().createSvnClient();
        }
        return this.noUrlClientWithoutListeners;
    }

    public FilesystemHandler getFileSystemHandler() {
        return this.filesystemHandler;
    }

    public boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof SubversionVCS && !SvnUtils.isPartOfSubversionMetadata(file);
    }

    public void versionedFilesChanged() {
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    File getTopmostManagedParent(File file) {
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException sVNClientException) {
            return null;
        }
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            while (file != null) {
                if (this.isAdministrative(file)) {
                    file = file.getParentFile();
                    break;
                }
                file = file.getParentFile();
            }
        }
        File file2 = null;
        while (file != null && !Utils.isScanForbidden((File)file)) {
            if (new File(file, ".svn/entries").canRead() || new File(file, "_svn/entries").canRead()) {
                file2 = file;
            }
            file = file.getParentFile();
        }
        return file2;
    }

    public void cleanupFilesystem() {
        this.filesystemHandler.removeInvalidMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachListeners(SvnClient svnClient) {
        svnClient.addNotifyListener(this.getLogger(svnClient.getSvnUrl()));
        svnClient.addNotifyListener(this.fileStatusCache);
        ISVNNotifyListener[] iSVNNotifyListenerArray = this.getSVNNotifyListeners();
        ISVNNotifyListener[] iSVNNotifyListenerArray2 = null;
        ISVNNotifyListener[] iSVNNotifyListenerArray3 = iSVNNotifyListenerArray;
        synchronized (iSVNNotifyListenerArray) {
            iSVNNotifyListenerArray2 = iSVNNotifyListenerArray.toArray(new ISVNNotifyListener[iSVNNotifyListenerArray.size()]);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (ISVNNotifyListener iSVNNotifyListener : iSVNNotifyListenerArray2) {
                svnClient.addNotifyListener(iSVNNotifyListener);
            }
            return;
        }
    }

    public OutputLogger getLogger(SVNUrl sVNUrl) {
        return OutputLogger.getLogger(sVNUrl);
    }

    boolean isIgnored(File file) {
        int n;
        String string = file.getName();
        File file2 = file.getParentFile();
        if (file2 != null && ((n = this.fileStatusCache.getStatus(file2).getStatus()) & 0x1DF8) != 0) {
            try {
                SvnClient svnClient = this.getClient(false);
                List<String> list = SvnConfigFiles.getInstance().getGlobalIgnores();
                if (SvnUtils.getMatchinIgnoreParterns(list, string, true).size() > 0) {
                    return true;
                }
                List list2 = svnClient.getIgnoredPatterns(file2);
                if (SvnUtils.getMatchinIgnoreParterns(list2, string, true).size() > 0) {
                    return true;
                }
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
        }
        if (SharabilityQuery.getSharability((File)file) == 2) {
            try {
                FileInformation fileInformation = this.fileStatusCache.getCachedStatus(file);
                if (SubversionVisibilityQuery.isHiddenFolder(fileInformation, file)) {
                    return false;
                }
                if (SharabilityQuery.getSharability((File)file2) != 2 && (this.fileStatusCache.getStatus(file2).getStatus() & 0x1DF8) != 0) {
                    IgnoreAction.ignore(file);
                }
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
            return true;
        }
        return ".nbintdb".equals(string);
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor(null);
    }

    public RequestProcessor getRequestProcessor(SVNUrl sVNUrl) {
        String string;
        RequestProcessor requestProcessor;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((requestProcessor = this.processorsToUrl.get(string = sVNUrl != null ? sVNUrl.toString() : "ANY_URL")) == null) {
            requestProcessor = new RequestProcessor("Subversion - " + string, 1, true);
            this.processorsToUrl.put(string, requestProcessor);
        }
        return requestProcessor;
    }

    FileStatusProvider getVCSAnnotator() {
        return this.fileStatusProvider;
    }

    VCSInterceptor getVCSInterceptor() {
        return this.filesystemHandler;
    }

    private List<ISVNNotifyListener> getSVNNotifyListeners() {
        if (this.svnNotifyListeners == null) {
            this.svnNotifyListeners = new ArrayList<ISVNNotifyListener>();
        }
        return this.svnNotifyListeners;
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSVNNotifyListener(ISVNNotifyListener iSVNNotifyListener) {
        List<ISVNNotifyListener> list;
        List<ISVNNotifyListener> list2 = list = this.getSVNNotifyListeners();
        synchronized (list2) {
            list.add(iSVNNotifyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSVNNotifyListener(ISVNNotifyListener iSVNNotifyListener) {
        List<ISVNNotifyListener> list;
        List<ISVNNotifyListener> list2 = list = this.getSVNNotifyListeners();
        synchronized (list2) {
            list.remove(iSVNNotifyListener);
        }
    }

    public void getOriginalFile(File file, File file2) {
        FileInformation fileInformation = this.fileStatusCache.getStatus(file);
        if ((fileInformation.getStatus() & 0x4F8) == 0) {
            return;
        }
        try {
            File file3 = VersionsCache.getInstance().getFileRevision(file, "BASE");
            if (file3 == null) {
                throw new IOException("Unable to get BASE revision of " + file);
            }
            Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(file2), (InputStream)new FileInputStream(file3));
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Unable to get original file", iOException);
        }
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.subversion");
    }
}

