/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.queries.CollocationQueryImplementation;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SubversionVCS
extends VersioningSystem
implements VersioningListener,
PreferenceChangeListener,
PropertyChangeListener,
CollocationQueryImplementation {
    public SubversionVCS() {
        this.putProperty("String VCS.DisplayName", NbBundle.getMessage(SubversionVCS.class, (String)"CTL_Subversion_DisplayName"));
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(SubversionVCS.class, (String)"CTL_Subversion_MainMenu"));
        Subversion.getInstance().getStatusCache().addVersioningListener(this);
        Subversion.getInstance().addPropertyChangeListener(this);
        SvnModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public File getTopmostManagedAncestor(File file) {
        return Subversion.getInstance().getTopmostManagedParent(file);
    }

    public VCSAnnotator getVCSAnnotator() {
        return Subversion.getInstance().getVCSAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return Subversion.getInstance().getVCSInterceptor();
    }

    public void getOriginalFile(File file, File file2) {
        Subversion.getInstance().getOriginalFile(file, file2);
    }

    public boolean areCollocated(File file, File file2) {
        File file3 = this.getTopmostManagedAncestor(file);
        File file4 = this.getTopmostManagedAncestor(file2);
        if (file3 == null || !file3.equals(file4)) {
            return false;
        }
        try {
            SVNUrl sVNUrl = SvnUtils.getRepositoryRootUrl(file);
            SVNUrl sVNUrl2 = SvnUtils.getRepositoryRootUrl(file2);
            SVNUrl sVNUrl3 = SvnUtils.getRepositoryRootUrl(file3);
            return sVNUrl.equals((Object)sVNUrl2) && sVNUrl.equals((Object)sVNUrl3);
        }
        catch (SVNClientException sVNClientException) {
            return false;
        }
    }

    public File findRoot(File file) {
        return this.getTopmostManagedAncestor(file);
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)versioningEvent.getParams()[0];
            this.fireStatusChanged(file);
        }
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("annotationsChanged")) {
            this.fireAnnotationsChanged((Set)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("versionedFilesChanged")) {
            this.fireVersionedFilesChanged();
        }
    }
}

